/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/session/xplat/SemaphoreService.java $
  $Revision: 4 $
  $Modtime: 12/06/00 3:36p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.session.xplat;

import java.rmi.*;
import com.novell.service.session.*;
import com.novell.java.lang.IntegerBuffer;
import com.novell.java.lang.BooleanBuffer;
import com.novell.service.file.nw.*;
import com.novell.service.server.*;
import com.novell.service.ncpext.*;
import com.novell.service.file.nw.calls.*;
import com.novell.service.qms.*;
import com.novell.service.jncp.NSIException;

/** @internal
 * Object returned by Session.getService()
 */
public interface SemaphoreService extends SessionService
{
   /**
    * The key used to generate an object of this type via the
    * Session.getService() interface.
    */
// Please leave OLD versions here but commented out for the purpose of
// tracking unique identifiers.
//   public static final String KEY =
//"com.novell.service.session.xplat.SemaphoreService.4655434B01";
   public static final String KEY =
"com.novell.service.session.xplat.SemaphoreService.991456662A";

   public void openSemaphore(
      String semaphoreName,
      int resourceAccessCount,
      int[] semaphoreHandle,
      int[] semaphoreOpenCount)
      throws SessionException, RemoteException;

   public void examineSemaphore(
      int semaphoreHandle,
      int[] semaphoreValue,
      int[] semaphoreOpenCount)
      throws SessionException, RemoteException;

   public void waitOnSemaphore(int semaphoreHandle, int timeOutValue)
   throws SessionException, RemoteException;

   public void signalSemaphore(int semaphoreHandle)
   throws SessionException, RemoteException;

   public void closeSemaphore(int semaphoreHandle)
   throws SessionException, RemoteException;
}
