/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/session/xplat/SemaphoreServiceImpl.java $
  $Revision: 5 $
  $Modtime: 1/12/01 4:53p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.session.xplat;

import java.rmi.*;
import java.rmi.server.UnicastRemoteObject;

import com.novell.service.jncpv2r.cal.*;
import com.novell.service.session.*;
import com.novell.service.session.spi.*;
import com.novell.service.session.util.Debug;
import com.novell.service.jncp.NSIException;
import com.novell.service.jncp.NSIExceptionBuilder;
import com.novell.java.lang.IntegerBuffer;
import com.novell.java.lang.BooleanBuffer;
import com.novell.service.file.nw.*;
import com.novell.service.server.*;
import com.novell.service.ncpext.*;
import com.novell.service.file.nw.calls.*;
import com.novell.service.qms.*;
import com.novell.service.session.xplat.SemaphoreServiceRemote.*;

/** @internal
 * Object returned by Session.getService() that wraps all NWCALLS
 * native services (via CalJNI).
 */
public class SemaphoreServiceImpl extends UnicastRemoteObject
implements SemaphoreServiceRemote
{
   // Always access debug via final static...hopefully a final static of
   // false will be optimized out by the compiler
   final static private boolean DEBUG = false;
   final static private boolean S_DEBUG = false; // May have side effects

   Connection conn;
   int connection;

   public SemaphoreServiceImpl
   (
      Connection connection,
      RMISocketFactories x
   )
   throws SessionException, RemoteException
   {
      super(x.getPort(), x.getClientSocketFactory(), x.getServerSocketFactory());
      conn = connection;
      this.connection = conn.getHandle(); //NOTE:this needs to be fixed
   }

   public SemaphoreServiceImpl
   (
      Connection connection
   )
   throws SessionException, RemoteException
   {
      conn = connection;
      this.connection = conn.getHandle(); //NOTE:this needs to be fixed
   }

   public OpenSemStruct openSemaphore
   (
      String semaphoreName,
      int resourceAccessCount
   )
   throws SessionException, RemoteException
   {
      OpenSemStruct reply = new OpenSemStruct();
      int ccode = CalJNI.NWOpenSemaphore(connection, semaphoreName,
         resourceAccessCount, reply.semaphoreHandle, reply.semaphoreOpenCount);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
      return reply;
   }

   public ExamineSemStruct examineSemaphore
   (
      int semaphoreHandle
   )
   throws SessionException, RemoteException
   {
      ExamineSemStruct reply = new ExamineSemStruct();
      int ccode = CalJNI.NWExamineSemaphore(connection, semaphoreHandle,
         reply.semaphoreValue, reply.semaphoreOpenCount);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
      return reply;
   }

   public void waitOnSemaphore(int semaphoreHandle, int timeOutValue)
   throws SessionException, RemoteException
   {
      int ccode = CalJNI.NWWaitOnSemaphore(
         connection,
         semaphoreHandle,
         timeOutValue);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void signalSemaphore(int semaphoreHandle)
   throws SessionException, RemoteException
   {
      int ccode = CalJNI.NWSignalSemaphore(connection, semaphoreHandle);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void closeSemaphore(int semaphoreHandle)
   throws SessionException, RemoteException
   {
      int ccode = CalJNI.NWCloseSemaphore(connection, semaphoreHandle);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }
}
