/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/session/xplat/SemaphoreServiceRemote.java $
  $Revision: 2 $
  $Modtime: 12/06/00 4:41p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.session.xplat;

import java.rmi.*;
import com.novell.service.session.*;
import com.novell.java.lang.IntegerBuffer;
import com.novell.java.lang.BooleanBuffer;
import com.novell.service.file.nw.*;
import com.novell.service.server.*;
import com.novell.service.ncpext.*;
import com.novell.service.file.nw.calls.*;
import com.novell.service.qms.*;
import com.novell.service.jncp.NSIException;

/** @internal
 */
public interface SemaphoreServiceRemote extends Remote
{
   public OpenSemStruct openSemaphore
   (
      String semaphoreName,
      int resourceAccessCount
   )
   throws SessionException, RemoteException;

   public ExamineSemStruct examineSemaphore
   (
      int semaphoreHandle
   )
   throws SessionException, RemoteException;

   public void waitOnSemaphore(int semaphoreHandle, int timeOutValue)
   throws SessionException, RemoteException;

   public void signalSemaphore(int semaphoreHandle)
   throws SessionException, RemoteException;

   public void closeSemaphore(int semaphoreHandle)
   throws SessionException, RemoteException;
   
   class OpenSemStruct
   {
      int[] semaphoreHandle;
      int[] semaphoreOpenCount;
   }

   class ExamineSemStruct
   {
      int[] semaphoreValue;
      int[] semaphoreOpenCount;
   }
}
