/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/session/xplat/SemaphoreServiceWrapper.java $
  $Revision: 2 $
  $Modtime: 1/05/01 4:03p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.session.xplat;

import java.rmi.*;
import com.novell.service.jncpv2r.cal.*;
import com.novell.service.session.*;
import com.novell.service.session.util.Debug;
import com.novell.service.jncp.NSIException;
import com.novell.service.jncp.NSIExceptionBuilder;
import com.novell.java.lang.IntegerBuffer;
import com.novell.java.lang.BooleanBuffer;
import com.novell.service.file.nw.*;
import com.novell.service.server.*;
import com.novell.service.ncpext.*;
import com.novell.service.file.nw.calls.*;
import com.novell.service.qms.*;
import com.novell.service.session.xplat.SemaphoreServiceRemote.*;

/** @internal
 * Object returned by Session.getService() that wraps all NWCALLS
 * native services (via CalJNI).
 */
public class SemaphoreServiceWrapper
implements SemaphoreService, java.io.Serializable
{
   // Always access debug via final static...hopefully a final static of
   // false will be optimized out by the compiler
   final static private boolean DEBUG = false;
   final static private boolean S_DEBUG = false; // May have side effects

   SemaphoreServiceRemote remote;
   
   public SemaphoreServiceWrapper(SemaphoreServiceRemote rem)
   throws SessionException
   {
      remote = rem;
   }

   public void openSemaphore(
      String semaphoreName,
      int resourceAccessCount,
      int[] semaphoreHandle,
      int[] semaphoreOpenCount)
      throws SessionException, RemoteException
   {
      OpenSemStruct reply = remote.openSemaphore(semaphoreName, resourceAccessCount);
      semaphoreHandle[0] = reply.semaphoreHandle[0];
      semaphoreOpenCount[0] = reply.semaphoreOpenCount[0];
   }

   public void examineSemaphore(
      int semaphoreHandle,
      int[] semaphoreValue,
      int[] semaphoreOpenCount)
      throws SessionException, RemoteException
   {
      ExamineSemStruct reply = remote.examineSemaphore(semaphoreHandle);
      semaphoreValue[0] = reply.semaphoreValue[0];
      semaphoreOpenCount[0] = reply.semaphoreOpenCount[0];
   }

   public void waitOnSemaphore(int semaphoreHandle, int timeOutValue)
   throws SessionException, RemoteException
   {
      remote.waitOnSemaphore(semaphoreHandle, timeOutValue);
   }

   public void signalSemaphore(int semaphoreHandle)
   throws SessionException, RemoteException
   {
      remote.signalSemaphore(semaphoreHandle);
   }

   public void closeSemaphore(int semaphoreHandle)
   throws SessionException, RemoteException
   {
      remote.closeSemaphore(semaphoreHandle);
   }
}
