/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/session/xplat/ShibbolethRemote.java $
  $Revision: 6 $
  $Modtime: 5/15/03 5:31p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.session.xplat;

import java.security.*;
import java.rmi.*;
import java.io.Serializable;
//import com.novell.service.security.NdsIdentity;
import com.novell.service.session.SessionService;
import com.novell.service.session.SessionException;

public interface ShibbolethRemote extends Remote
{
   public byte[] swapEncodedPublicKeys(byte[] publicKeyEncoded)
   throws GeneralSecurityException, RemoteException;

   public void sendIV(byte[] initVect)
   throws GeneralSecurityException, RemoteException;
   
   public void changePassword
   (
      String userName,
      String oldPassword,
      String newPassword,
      boolean extendedCharPasswordFlag
   )
   throws SessionException, RemoteException;

   public void changePassword  //matches changePassword above but with encrypted input
   (
      String userName,
      byte[] oldPassword,
      byte[] newPassword,
      boolean extendedCharPasswordFlag
   )
   throws SessionException, RemoteException;

   public void setPassword
   (
      String objName,
      String password,
      boolean extendedCharPasswordFlag
   )
   throws SessionException, RemoteException;

   public void setPassword  //matches setPassword above but with encrypted input
   (
      String objName,
      byte[] password,
      boolean extendedCharPasswordFlag
   )
   throws SessionException, RemoteException;

   public void verifyPassword
   (
      String objName,
      String password,
      boolean extendedCharPasswordFlag
   )
   throws SessionException, RemoteException;

   public void verifyPassword  //matches verifyPassword above but with encrypted input
   (
      String objName,
      byte[] password,
      boolean extendedCharPasswordFlag
   )
   throws SessionException, RemoteException;

   public void authenticate
   (
      String userName,
      String password,
      boolean extendedCharPasswordFlag
   )
   throws SessionException, RemoteException;

   public void authenticate  //matches authenticate above but with encrypted input
   (
      String userName,
      byte[] password,
      boolean extendedCharPasswordFlag
   )
   throws SessionException, RemoteException;

   public NMASAndFDN authenticateNAS
   (
      String userName,
      String password,
      boolean extendedCharPasswordFlag
   )
   throws SessionException, RemoteException;

   public NMASAndFDN authenticateNAS  //matches authenticateNAS above but with encrypted input
   (
      String userName,
      byte[] password,
      boolean extendedCharPasswordFlag
   )
   throws SessionException, RemoteException;

   public void authenticateService
   (
      String serviceName
   )
   throws SessionException, RemoteException;

   public void unauthenticate
   (
   )
   throws SessionException, RemoteException;

   public void unauthenticateNAS
   (
      int nmasID
   )
   throws SessionException, RemoteException;
   
   public class NMASAndFDN implements Serializable
   {
      public int nmasID;
      public String authenticatedFDN;
   }
}
