/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/session/xplat/ShibbolethWrapper.java $
  $Revision: 7 $
  $Modtime: 5/15/03 5:38p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.session.xplat;

import java.rmi.*;
import java.math.*;
import java.security.*;
import javax.crypto.*;
import javax.crypto.spec.*;
import com.novell.service.session.xplat.ShibbolethRemote.NMASAndFDN;
import com.novell.service.security.NdsIdentity;
import com.novell.service.session.SessionException;
import com.novell.service.session.util.Debug;

public class ShibbolethWrapper implements Shibboleth, java.io.Serializable
{
   private static final boolean debugTimer = false; //Debug only member
   
   private boolean initialized;
   private ShibbolethRemote remObj;
   private Cipher localCipher;
   
   public ShibbolethWrapper(ShibbolethRemote obj)
   {
      initialized = false;
      remObj = obj;
   }

   private void init() throws SessionException, RemoteException
   {
      try
      {
         if(debugTimer)
            Debug.println("Enter init");
         JCEHelper.loadProvider(); //This must be called first before any JCE calls
         KeyPair localKeyPair = JCEHelper.genDHKeyPair();
         byte[] localPublicKeyEncoded = localKeyPair.getPublic().getEncoded();
         byte[] remotePubKeyEncoded = remObj.swapEncodedPublicKeys(localPublicKeyEncoded);

         PublicKey remotePubKey = JCEHelper.unencodePublicKey(remotePubKeyEncoded);
         KeyAgreement localKeyAgree = KeyAgreement.getInstance("DiffieHellman");
         localKeyAgree.init(localKeyPair.getPrivate());
         localKeyAgree.doPhase(remotePubKey, true);
         SecretKey localsecretKey = localKeyAgree.generateSecret("DESede");
         localCipher = Cipher.getInstance(JCEHelper.transformationType);
         localCipher.init(Cipher.ENCRYPT_MODE, localsecretKey);
         byte[] initVect = localCipher.getIV();
         remObj.sendIV(initVect);
         initialized = true;
         if(debugTimer)
            Debug.println("Done init");
      }
      catch(GeneralSecurityException e)
      {
         throw new SessionException("Check root cause", e);
      }
   }
   
   public byte[] encrypt(byte[] cleartext) throws SessionException
   {
      try
      {
         return localCipher.doFinal(cleartext);
      }
      catch(GeneralSecurityException e)
      {
         throw new SessionException("Check root cause", e);
      }
   }
   
   public void changePassword
   (
      String userName,
      String oldPassword,
      String newPassword,
      boolean extendedCharPasswordFlag
   )
   throws SessionException, RemoteException
   {
      if(!initialized)
         init();
      remObj.changePassword(userName, encrypt(oldPassword.getBytes()),
         encrypt(newPassword.getBytes()), extendedCharPasswordFlag);
   }

   public void setPassword
   (
      String objName,
      String password,
      boolean extendedCharPasswordFlag
   )
   throws SessionException, RemoteException
   {
      if(!initialized)
         init();
      remObj.setPassword(objName, encrypt(password.getBytes()), extendedCharPasswordFlag);
   }

   public void verifyPassword
   (
      String objName,
      String password,
      boolean extendedCharPasswordFlag
   )
   throws SessionException, RemoteException
   {
      if(!initialized)
         init();
      remObj.verifyPassword(objName, encrypt(password.getBytes()), extendedCharPasswordFlag);
   }

   public void authenticate
   (
      String userName,
      String password,
      boolean extendedCharPasswordFlag
   )
   throws SessionException, RemoteException
   {
      if(debugTimer)
         Debug.println("Enter authenticate");
      if(!initialized)
         init();
      byte[] pass = encrypt(password.getBytes());
      remObj.authenticate(userName, pass, extendedCharPasswordFlag);
      if(debugTimer)
         Debug.println("Done authenticate");
   }

   public void authenticateNAS
   (
      NdsIdentity ident,
      String userName,
      String password,
      boolean extendedCharPasswordFlag
   )
   throws SessionException, RemoteException
   {
      if(!initialized)
         init();
      NMASAndFDN temp = remObj.authenticateNAS(userName, encrypt(password.getBytes()), extendedCharPasswordFlag);
      ident.setNMASID(temp.nmasID);
      ident.setAuthenticatedFDN(temp.authenticatedFDN);
   }

   public void authenticateService
   (
      String serviceName
   )
   throws SessionException, RemoteException
   {
      if(!initialized)
         init();
      remObj.authenticateService(serviceName);
   }

   public void unauthenticate
   (
   )
   throws SessionException, RemoteException
   {
      if(!initialized)
         init();
      remObj.unauthenticate();
   }

   public void unauthenticateNAS
   (
      NdsIdentity ident
   )
   throws SessionException, RemoteException
   {
      if(!initialized)
         init();
      remObj.unauthenticateNAS(ident.getNMASID());
   }
}
