/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/session/xplat/Version.java $
  $Revision: 7 $
  $Modtime: 11/15/00 3:43p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.session.xplat;

import java.util.StringTokenizer;
/** @internal
 * <p>Is a place holder for version numbers.
 *
 * <p>The format of these versions is <i>xxx</i>.<i>yyy</i>.<i>zzz</i>
 * as follows:
 * <ul>
 * <li><i>xxx</i> is the major version.
 * <li><i>yyy</i> is the minor version.
 * <li><i>zzz</i> is the revision.
 * </ul>
 *
 */

 /*
 * Public Method List (in order of their apperance in the file).
 *
 * CTD   Method name - Description
 * ---   --------------------------------------------------------------------
 * c d   Version - Constructor which takes no parameters.
 * c d   Version - Constructor which takes a major, minor and revision number.
 * c d   toString - Returns a string representing the version.
 */

public class Version implements java.io.Serializable
{
   /**
    * The major version number.
    */
   public int majorVersion;

   /**
    * The minor version number.
    */
   public int minorVersion;

   /**
    * The revision number.
    */
   public int revision;

   /**
    * Constructs a Version set to "0.0.0".
    */
   public Version()
   {
      majorVersion = minorVersion = revision = 0;
   }

   /**
    * Constructs a Version using a major, minor, and revision number.
    *
    * @param <i>major</i>        (in) Major version number.
    * @param <i>minor</i>        (in) Minor version number.
    * @param <i>rev</i>          (in) Revision number.
    */
   public Version(int major, int minor, int rev)
   {
      majorVersion = major;
      minorVersion = minor;
      revision     = rev;
   }

   /**
    * Constructs a Version from a String of dot-separated numbers
    * (i.e. "major.minor.revision").
    *
    */
   public Version(String versionString)
   {
      this();
      StringTokenizer st = new StringTokenizer(versionString, ".");
      majorVersion = Integer.valueOf(st.nextToken()).intValue();
      minorVersion = Integer.valueOf(st.nextToken()).intValue();
      revision     = Integer.valueOf(st.nextToken()).intValue();
   }

   /**
    * Returns a String representing the version.
    *
    * @return                    String form of the version.
    */
   public String toString ()
   {
      return (getClass().getName() + ":" +
              Long.toString (majorVersion) + "." +
              Long.toString (minorVersion) + "." +
              Long.toString (revision));
   }

   /**
    * Returns an integer representing the version.
    *
    * Assumes each component of the version is less than 256.
    * </p>
    *
    * @return                    int form of the version.
    */
   public int intValue()
   {
      // Note: this algorithm relies on the fact that the underlying
      // api returns unsigned byte values

      // trim to unsigned byte values
      int major = (majorVersion < 0xFF) ? majorVersion : 0xFF;
      int minor = (minorVersion < 0xFF) ? minorVersion : 0xFF;
      int rev   = (revision     < 0xFF) ? revision     : 0xFF;

      // put each value in byte slot
      return (major * 0x10000 + minor * 0x100 + rev);
   }
}

