/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/session/xplat/XplatSessionState.java $
  $Revision: 19 $
  $Modtime: 1/12/01 4:44p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.session.xplat;

import java.rmi.RemoteException;
import com.novell.service.session.*;
import com.novell.service.session.spi.*;
import com.novell.service.jncp.NSIException;
import com.novell.service.session.util.Debug;
import com.novell.java.security.Authenticator;
import com.novell.java.security.Identity;
import com.novell.java.security.KeyManagementException;
import com.novell.service.security.BinderyIdentity;
import com.novell.service.security.BinderyIdentityScope;

/** @internal
 */
public abstract class XplatSessionState extends SessionState
{
   // Always access debug via final static...hopefully a final static of
   // false will be optimized out by the compiler
   final static private boolean DEBUG = false;
   final static private boolean I_DEBUG = false; // Ignore exception
   final static private boolean S_DEBUG = false; // May have side effects
   protected XplatUtil xplatUtil;

   public XplatSessionState
   (
      SessionImpl attachedSession
   )
   throws SessionException, RemoteException
   {
      super(attachedSession);

      xplatUtil = XplatUtil.getInstance(sessionManager);
   }

   /**
    * Inherited from Session
    *
    * @see Session#getAttributes()
    */
   public SessionAttrs getAttributes
   (
   )
   throws SessionException, RemoteException
   {
      try
      {
         // Get inherited attributes
         SessionAttrs attributes = super.getAttributes();

         // Override with this session's

         String attrIds[] =
         {
            Session.DOMAIN_NAME_ATTR_ID
         };
         attributes.modify(
            getStateAttrs(attrIds));
         return attributes;
      }
      catch (NSIException e)
      {
         throw InvalidSessionState.makeInvalid(this.attachedSession, e);
      }
   }

   /**
    * Inherited from Session
    *
    * @see Session#getAttributes(String[])
    */
   public SessionAttrs getAttributes
   (
      String attrIds[]
   )
   throws SessionException, RemoteException
   {
      try
      {
         // Get this session's attributes
         SessionAttrs attributes = new SessionAttrs();

         if (attributes.count() != attrIds.length)
         {
            // Get this state's attributes
            attributes.merge(
               getStateAttrs(attrIds));

            if (attributes.count() != attrIds.length)
            {
               // Get inherited attributes
               attributes.merge(
                  super.getAttributes(attrIds));
            }
         }

         return attributes;
      }
      catch (NSIException e)
      {
         throw InvalidSessionState.makeInvalid(this.attachedSession, e);
      }
   }

   private SessionAttrs getStateAttrs
   (
      String attrIds[]
   )
   throws SessionException, RemoteException  //this method is not a remote method, but calls one, so must throw RemoteException
   {
      // Get inherited attributes
      SessionAttrs attributes = new SessionAttrs();

      // Override with this session's
      for (int i = 0; i < attrIds.length; i++)
      {
         if (Session.DOMAIN_NAME_ATTR_ID.equals(attrIds[i]))
         {
            SessionAttr sa = new SessionAttr(
               Session.DOMAIN_NAME_ATTR_ID,
               getDomainName(),
               true);  // ignore case
            attributes.add(sa);
         }
         if (Xplat.PREFERRED_TREE_NAME_ATTR_ID.equals(attrIds[i]))
         {
            attributes.add(
               Xplat.PREFERRED_TREE_NAME_ATTR_ID,
               Natives.getPreferredTree());
         }
         if (Xplat.PREFERRED_SERVER_NAME_ATTR_ID.equals(attrIds[i]))
         {
            attributes.add(
               Xplat.PREFERRED_SERVER_NAME_ATTR_ID,
               Natives.getPreferredServer());
         }
      }
      return attributes;
   }

   /**
    * Inherited from Session
    */
   public Session findSession(String domainName)
   throws SessionException, RemoteException
   {
      return super.findSession(domainName.toUpperCase());
   }

   protected boolean forceOperationalAttributes(SessionEnv env)
   {
      boolean force = false;
      Object value = env.get(Xplat.FORCE_OPERATIONAL_ATTRIBUTES);
      if (null != value)
      {
         if (value instanceof Boolean)
            force = ((Boolean)value).booleanValue();
         if (value instanceof String)
            force = new Boolean((String)value).booleanValue();
      }
      return force;
   }

   /**
    * Inherited from Session
    *
    * @see Session#getService
    */
   public SessionService getService
   (
      String serviceKey
   )
   throws SessionException, RemoteException
   {
      if (DEBUG)
      {
         Debug.println("XSS.getService(): " + getDomainName() + ":" + this);
      }

      if (serviceKey.equals(DeviceAccessService.KEY))
      {
         if(sessionManager.useCustomSockets())
            return (new DeviceAccessServiceImpl(sessionManager.getCustomSocketFactories()));
         else
            return (new DeviceAccessServiceImpl());
      }

      return super.getService(serviceKey);
   }

}


