/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/toolkit/jcl/NWInteger.java $
  $Revision: 4 $
  $Modtime: 1/17/01 12:04p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.toolkit.jcl;

/**
 * Provides a changeable int value that can be passed by
 * reference.
 *
 * <p>NWInteger helps avoid the problem with Java int base types
 * being passed by value, and Java Integer objects not having a set
 * function.
 *
 * <p>The intended use for NWInteger is passing it to a native
 * routine that will set the value. The value can then be retrieved
 * and stored in a int base type value.
 * </p>
 */

/*
 * Public Method List (in order of their apperance in the file).
 *
 * CTD   Method name - Description
 * ---   --------------------------------------------------------------------
 * c d   NWInteger - Constructor that takes an int for the new value.
 * c d   getValue - Retrieves the current value as an integer.
 * c d   setValue - Sets/overwrites the current value using an integer.
 * c d   setValue - Sets/overwrites the current value using a java.lang.Integer.
 * c d   toString - Returns a string representing the NWInteger object.
 * c d   byteToInteger - Converts a byte to int (unsigned).
 *
 */

public final class NWInteger implements java.io.Serializable
{
   private int _value;


   /**
    * Constructs an NWInteger with a value of zero.
    * </p>
    */
   public NWInteger ()
   {
      _value = 0;
   }

   /**
    * Constructs an NWInteger with a specified value.
    * </p>
    *
    * @param <i>i</i>            (in) Initial value.
    */
   public NWInteger (int i)
   {
      _value = i;
   }

   /**
    * Retruns the current value as an int.
    * </p>
    *
    * @return                    The current value as an int.
    */
   public int getValue ()
   {
      return (_value);
   }

   /**
    * Sets the current value using an int.
    * </p>
    *
    * @param <i>i</i>            (in) New value.
    */
   public void setValue (
         int i)
   {
      _value = i;
   }

   /**
    * Sets the current value using a java.lang.Integer.
    *
    * <p>If <i>i</i> is <tt>null</tt>, the
    * value is not changed.
    * </p>
    *
    * @param <i>i</i>            (in) New value.
    */
   public void setValue (
         java.lang.Integer i)
   {
      if (null != i)
         _value = i.intValue ();
   }

   /**
    * Returns a String representing the NWInteger.
    * </p>
    *
    * @return                    String form of the NWInteger.
    */
   public String toString ()
   {
      String s;

      s = ":" + (Integer.toString (_value) + " or 0x" + Integer.toString (_value, 16));
      return (getClass().getName() + s);
   }

   /**
    * Converts a byte to an int (unsigned).
    *
    * <p>Simply casting the value does not work, because byte is signed.
    * If the sign bit is set, a negative number is produced.
    * </p>
    *
    * @param   <i>b</i>          (in) Byte to be converted.
    *
    * @return                    An int set to the value of <i>b</i>.
    */
   public static int byteToInteger (
         byte b)
   {
      int uValue;

      if (b < 0)
      {
         b &= 0x7f;
         uValue = b;
         uValue += 0x7f;
         uValue++;
      }
      else
         uValue = b;

      return (uValue);
   } /* byteToInteger () */
}


