/* **************************************************************************

  $Archive: /njcl/src/com/novell/service/toolkit/jcl/NWVersion.java $
  $Revision: 2 $
  $Modtime: 2/19/99 6:06p $

  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.toolkit.jcl;

import java.util.StringTokenizer;
/**
 * <p>Is a place holder for version numbers.
 *
 * <p>The format of these versions is <i>xxx</i>.<i>yyy</i>.<i>zzz</i>
 * as follows:
 * <ul>
 * <li><i>xxx</i> is the major version.
 * <li><i>yyy</i> is the minor version.
 * <li><i>zzz</i> is the revision.
 * </ul>
 * </p>
 *
 * @see com.novell.service.client.NWConnection#getAllConnectionInfo
 * @see com.novell.service.client.NWClient#getRequesterVersion
 */

 /*
 * Public Method List (in order of their apperance in the file).
 *
 * CTD   Method name - Description
 * ---   --------------------------------------------------------------------
 * c d   NWVersion - Constructor which takes no parameters.
 * c d   NWVersion - Constructor which takes a major, minor and revision number.
 * c d   toString - Returns a string representing the version.
 */

public class NWVersion
{
   /**
    * The major version number.
    * </p>
    */
   public int majorVersion;

   /**
    * The minor version number.
    * </p>
    */
   public int minorVersion;

   /**
    * The revision number.
    * </p>
    */
   public int revision;

   /**
    * Constructs an NWVersion set to "0.0.0".
    * </p>
    */
   public NWVersion()
   {
      majorVersion = minorVersion = revision = 0;
   }

   /**
    * Constructs an NWVersion using a major, minor, and revision number.
    * </p>
    *
    * @param <i>major</i>        (in) Major version number.
    * @param <i>minor</i>        (in) Minor version number.
    * @param <i>rev</i>          (in) Revision number.
    */
   public NWVersion(int major, int minor, int rev)
   {
      setMajor(major);
      setMinor(minor);
      setRevision(rev);
   }

   /**
    * Constructs a Version from a String of dot-separated numbers
    * (i.e. "major.minor.revision").
    *
    */
   public NWVersion(String versionString)
   {
      this();
      StringTokenizer st = new StringTokenizer(versionString, ".");
      majorVersion = Integer.valueOf(st.nextToken()).intValue();
      minorVersion = Integer.valueOf(st.nextToken()).intValue();
      revision     = Integer.valueOf(st.nextToken()).intValue();
   }

   /**
    * Returns major version
    */
   public int getMajor()
   {
      return majorVersion;
   }

   /**
    * Returns minor version
    */
   public int getMinor()
   {
      return minorVersion;
   }

   /**
    * Returns revision
    */
   public int getRevision()
   {
      return revision;
   }

   /**
    * Sets major version
    */
   public void setMajor(int major)
   {
      majorVersion = major;
   }

   /**
    * Sets minor version
    */
   public void setMinor(int minor)
   {
      minorVersion = minor;
   }

   /**
    * Sets revision
    */
   public void setRevision(int rev)
   {
      revision     = rev;
   }

   /**
    * Returns a String representing the version.
    * </p>
    *
    * @return                    String form of the version.
    */
   public String toString ()
   {
      return (getClass().getName() + ":" +
              Long.toString (majorVersion) + "." +
              Long.toString (minorVersion) + "." +
              Long.toString (revision));
   }

   /**
    * Returns an integer representing the version.
    * </p>
    *
    * @return                    int form of the version.
    */
   public int intValue()
   {
      // Note: this algorithm relies on the fact that the underlying
      // api returns unsigned byte values

      // trim to unsigned byte values
      int major = (majorVersion < 0xFF) ? majorVersion : 0xFF;
      int minor = (minorVersion < 0xFF) ? minorVersion : 0xFF;
      int rev   = (revision     < 0xFF) ? revision     : 0xFF;

      // put each value in byte slot
      return (major * 0x10000 + minor * 0x100 + rev);
   }
}

