/*
 * @(#)ArrayType.java        1.13 98/09/21
 *
 * Copyright 1994-1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 * 
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

package com.novell.utility.java;

/**
 * This class represents an Java array type.
 * It overrides the relevant methods in class Type.
 *
 * @author         Arthur van Hoff
 * @version         1.13, 09/21/98
 */
public final
class ArrayType extends Type {
    /**
     * The type of the element.
     */
    Type elemType;

    /**
     * Construct an array type. Use Type.tArray to create
     * a new array type.
     */
    ArrayType(String typeSig, Type elemType) {
        super(TC_ARRAY, typeSig);
        this.elemType = elemType;
    }
    
    public Type getElementType() {
        return elemType;
    }

    public int getArrayDimension() {
        return elemType.getArrayDimension() + 1;
    }
    
    public String typeString(String id, boolean abbrev, boolean ret) {
        return getElementType().typeString(id, abbrev, ret) + "[]";
    }
}
