
/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/utility/naming/CompositeNamingEnumerator.java $
  $Revision: 4 $
  $Modtime: 8/10/99 6:01p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.utility.naming;


import java.util.Enumeration;

import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

import com.novell.java.util.CompositeEnumerator;


/** @internal
 * Links two or more Enumerations so that they can be accessed as
 * one Enumeration.  When the last item of one enumeration is reached,
 * the next enumeration is started.  This is a specialized version of
 * the CompositeEnumerator class.
 */
public class CompositeNamingEnumerator
   extends CompositeEnumerator
   implements NamingEnumeration
{
   /**
    * Constructs a composite enumeration from two Enumeration instances.
    *
    * @param      enum1          (in) first enumeration.
    * @param      enum2          (in) second enumeration.
    */
   public CompositeNamingEnumerator (
         Enumeration enum1, 
         Enumeration enum2)
   {
      super (enum1, enum2);
   }

   /**
    * Constructs a composite enumeration from an array of Enumeration
    * instances.
    *
    * @param      list           (in) array of enumeratios to link together.
    */
   public CompositeNamingEnumerator (
         Enumeration[] list)
   {
      super (list);
   }

   /**
    * Tell whether or not the end of the composite enumeration has been
    * reached.
    *
    */

   public boolean hasMore ()
      throws NamingException
   {
      return (hasMoreElements ());
   }

   /**
    * Return the next element of the composite enumeration, typecasted to be
    * a NameClassPair instance.
    *
    * @return                    the next element of the composite
    *                            enumeration
    */
   public Object next ()
      throws NamingException
   {
      return (nextElement ());
   }

   /**
    *
    */
   public void close ()
      throws NamingException
   {
   }

} /* CompositeNamingEnumerator */


