
/* **************************************************************************

  $Archive: /njcl/src/com/novell/utility/naming/FlatNameParser.java $
  $Revision: 1 $
  $Modtime: 4/22/98 9:08a $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.utility.naming;


import java.util.Properties;

import javax.naming.Name;
import javax.naming.CompoundName;
import javax.naming.NameParser;
import javax.naming.NamingException;


/** @internal
 * This is a plain, flat name parser, that can be used for multiple naming
 * systems.
 *
 * <p>This name parser has the following naming conventions:
 *
 * <p>Comparing one instance of this name parser, set up for one naming
 * system to another instance, set up for another naming system, results
 * in a false comparison.
 * </p>
 */
public class FlatNameParser implements NameParser
{
   private static Properties flatSyntax = new Properties ();
   protected static Properties syntax = flatSyntax;

   static
   {
      flatSyntax.put( Syntax.DIRECTION,     "flat" );
      flatSyntax.put( Syntax.SEPARATOR,     "/"    );
      flatSyntax.put( Syntax.ESCAPE,        "\\"   );
      flatSyntax.put( Syntax.BEGIN_QUOTE,   "\""   );
      flatSyntax.put( Syntax.BEGIN_QUOTE2,  "'"    );
   }

   String nameSpace;

   /**
    * Constructs a name-space-independant name parser.
    */
   public FlatNameParser ()
   {
      this (null);
   }

   /**
    * Constructs a name-space-dependant name parser.
    */
   public FlatNameParser (String nameSpace)
   {
      this.nameSpace = nameSpace;
   }

   public Name parse (String name)
      throws NamingException
   {
      return (new CompoundName (name, syntax));
   }

   /**
    * Tests whether the object passed in is equal to this name parser.
    *
    * <p>For two name parsers to be equal, they must both be FlatNameParser
    * instances.  They must both be either name-space-independant, or
    * name-space-dependant.  If the parsers are name-space-dependant, then
    * the name space specifiers that were used to create each name parser
    * must be the same -- case is ignored.
    * </p>
    */
   public boolean equals (Object obj)
   {
      if (obj instanceof FlatNameParser)
      {
         FlatNameParser p = (FlatNameParser) obj;

         if (this.nameSpace == p.nameSpace ||
             this.nameSpace != null &&
             this.nameSpace.equalsIgnoreCase (p.nameSpace))
         {
            return (true);
         }
      }
      return (false);
   }

} /* FlatNameParser */
