
/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/utility/naming/NamingEnumerator.java $
  $Revision: 3 $
  $Modtime: 8/10/99 12:35p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.utility.naming;


import java.util.Enumeration;
import java.util.Vector;
import java.util.NoSuchElementException;

import javax.naming.NamingEnumeration;
import javax.naming.NamingException;


/** @internal
 * This is the enumerator class for enumerating a vector.
 *
 * <p>Detailed.
 * </p>
 */
public class NamingEnumerator implements NamingEnumeration
{
   protected Enumeration enum;

   /**
    * enumerate an empty vector.
    */
   public NamingEnumerator ()
   {
      enum = new Vector (5).elements ();
   }

   /**
    *
    */
   public NamingEnumerator (
         Vector vector)
   {
      enum = vector.elements ();
   }

   /**
    *
    */
   public boolean hasMoreElements()
   {
      return (enum.hasMoreElements ());
   }

   /**
    *
    */
   public boolean hasMore ()
      throws NamingException
   {
      return hasMoreElements ();
   }

   /**
    *
    */
   public Object nextElement ()
   {
      return (enum.nextElement ());
   }

   /**
    *
    */
   public Object next ()
      throws NamingException
   {
      try
      {
         return nextElement ();
      }
      catch (NoSuchElementException e)
      {
         NamingException ne = new NamingException ();

         ne.setRootCause (e);
         throw (ne);
      }

   } /* next() */

   /**
    *
    */
   public void close ()
      throws NamingException
   {
   }

} /* NamingEnumerator */


