/*************************************************************************

  Copyright (c) 1995, 1997 Novell, Inc.  All Rights Reserved.

  With respect to this file, Novell hereby grants to Developer a 
  royalty-free, non-exclusive license to include this sample code 
  and derivative binaries in its product. Novell grants to Developer 
  worldwide distribution rights to market, distribute or sell this 
  sample code file and derivative binaries as a component of 
  Developer's product(s).  Novell shall have no obligations to 
  Developer or Developer's customers with respect to this code.
  
  DISCLAIMER:
  
  Novell disclaims and excludes any and all express, implied, and 
  statutory warranties, including, without limitation, warranties 
  of good title, warranties against infringement, and the implied 
  warranties of merchantibility and fitness for a particular purpose.  
  Novell does not warrant that the software will satisfy customer's 
  requirements or that the licensed works are without defect or error 
  or that the operation of the software will be uninterrupted.  
  Novell makes no warranties respecting any technical services or 
  support tools provided under the agreement, and disclaims all other 
  warranties, including the implied warranties of merchantability and 
  fitness for a particular purpose. */

/**************************************************************************
   DELUSER.C
***************************************************************************

  READUSER.C prompts the user for a login name then deletes the
  corresponding user object from the current context in the Directory
  Services tree.  If necessary, the program will prompt the user to
  authenticate to NDS.

**************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ntypes.h>
#include <nwnet.h>
#include <nwcalls.h>
#include <nwlocale.h>

/* Globals */

NWDSContextHandle context;
nbool8            bbDoLogout;

/* Prototypes */

void Proc(void);
void InitDS(void);
void UninitDS(void);

/***************************************************************************
**   Main Program
*/
int main(void)
{
   InitDS();
   Proc();
   UninitDS();

   return(0);
}

/***************************************************************************
**   Prompt user for login names to remove
*/
void Proc(void)
{
   NWDSCCODE   ccode;
   nstr8       strObjectName[MAX_DN_CHARS + 1];

   printf("\nEnter login name of object to remove: ");
   gets(strObjectName);
   strcat(strObjectName,"\x0");

   ccode = NWDSRemoveObject(context, strObjectName);
   if(ccode)
   {
      printf("NWDSRemoveObject returned %04X\n", ccode);
      exit(1);
   }
   else
   {
      printf("Object \"%s\" successfully removed\n", strObjectName);
   }
}

/***************************************************************************
**   Establish context, standard initializations for DS calls
*/
void InitDS(void)
{
   NWDSCCODE   ccode;
   LCONV       lconvInfo;
   nstr8       strUserName[NW_MAX_USER_NAME_LEN];
   nstr8       strUserPassword[50];

   /* Initialize libraries */
   ccode=NWCallsInit(NULL,NULL);
   if(ccode)       
   {
      printf("\nNWCallsInit returned %04X", ccode);
      exit(1);
   }

   NWLlocaleconv(&lconvInfo);

   ccode = NWInitUnicodeTables(lconvInfo.country_id, lconvInfo.code_page);
   if(ccode)
   {
      printf("\nNWInitUnicodeTables returned %04X", ccode);
      exit(1);
   }

   ccode = NWDSCreateContextHandle(&context);
   if(ccode)
   {
      printf("\nNWDSCreateContextHandle returned %04X", ccode);
      exit(1);
   }

   /*  Must authenticate if not already authenticated to NDS
       (which will always be the case if this example is 
       compiled and run as an NLM).  */
   if(!NWIsDSAuthenticated())
   {
      printf("\nMust authenticate to NDS");
      printf("\nEnter User Name: ");
      gets(strUserName);
      printf("Enter User Password: ");
      gets(strUserPassword);

      ccode = NWDSLogin(context, 0, strUserName, strUserPassword, 0);
      if(ccode)
      {
         printf("\nNWDSLogin returned %X", ccode);
         exit(1);
      }
      else
      {  /* If example logs in, it will also log out */
         bbDoLogout = N_TRUE;
      }
   }
}

/***************************************************************************
**   Release context and clean up.
*/
void UninitDS(void)
{
   NWDSCCODE   ccode;

   if(bbDoLogout)
   {
      ccode = NWDSLogout(context);
      if(ccode)
      {
         printf("\nNWDSLogout returned %04X", ccode);
         exit(1);
      }
   }

   ccode=NWDSFreeContext(context);
   if(ccode)
   {
      printf("\nNWDSFreeContext returned %04X", ccode);
      exit(1);
   }

   ccode=NWFreeUnicodeTables();
   if(ccode)
   {
      printf("\nNWFreeUnicodeTables returned %04X", ccode);
      exit(1);
   }
} 
