/********************************************************************

   Copyright (c) 1996 Novell, Inc.  All Rights Reserved.

   With respect to this file, Novell hereby grants to Developer a 
   royalty-free, non-exclusive license to include this sample code 
   and derivative binaries in its product. Novell grants to Developer 
   worldwide distribution rights to market, distribute or sell this 
   sample code file and derivative binaries as a component of 
   Developer's product(s).  Novell shall have no obligations to 
   Developer or Developer's customers with respect to this code.

   DISCLAIMER:

   Novell disclaims and excludes any and all express, implied, and 
   statutory warranties, including, without limitation, warranties 
   of good title, warranties against infringement, and the implied 
   warranties of merchantability and fitness for a particular purpose.  
   Novell does not warrant that the software will satisfy customer's 
   requirements or that the licensed works are without defect or error 
   or that the operation of the software will be uninterrupted.  
   Novell makes no warranties respecting any technical services or 
   support tools provided under the agreement, and disclaims all other 
   warranties, including the implied warranties of merchantability and 
   fitness for a particular purpose. */

/*********************************************************************
   RDCLSDEF.C
**********************************************************************

   Description:

   Reading class definitions:  This example uses NWDSReadClassDef
   to list all existing classes.  DS_CLASS_DEF_NAMES is used
   to specify that only class names are returned. The results are
   obtained by using NWDSGetClassDefCount and NWDSGetClassItem. 

   This examples requires a valid server name.

*********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <nwnet.h>
#include <nwcalls.h>
#include <nwlocale.h>

#define NWC_SERVICE_NCP_SERVER "NCP_SERVER"

/* cleanup functions */
void FreeBuf(pBuf_T pBuf, NWDSContextHandle context);
void FreeContext(NWDSContextHandle context);     
void FreeUnicodeTables();                        

void main(void)
{

   nint32              lIterHandle = NO_MORE_ITERATIONS;
   NWDSContextHandle   context;
   pBuf_T              pOutBuf;
   NWDSCCODE           ccode;
   nuint32             luClassNameCount;
   nstr8               strClassName[MAX_SCHEMA_NAME_CHARS+1];
   nuint32             luCounter;
   LCONV               lConvInfo;

   /*  Initialize NWCalls and unicode tables */
   ccode = NWCallsInit(NULL,NULL);
   if(ccode)
   {
      printf("\nNWCallsInit returned %X", ccode);
      exit(1);
   }

   NWLlocaleconv(&lConvInfo);

   ccode = NWInitUnicodeTables(lConvInfo.country_id,
                               lConvInfo.code_page);
   if(ccode)
   {
      printf("\nNWInitUnicodeTables error %X \n", ccode);
      exit(1);
   }

   /* Create an NDS Context */
   ccode = NWDSCreateContextHandle(&context);
   if(ccode)
   {
      printf("\nNWDSCreateContextHandle failed");
      FreeUnicodeTables();
   }

   ccode = NWDSAllocBuf(DEFAULT_MESSAGE_LEN, &pOutBuf);
   if(ccode)
   {
      printf("\nNWDSAllocBuf returned %X", ccode);
      FreeContext(context);
   }

   /* lIterHandle controls retrieval of results larger than the
      result buffer.  If the result buffer holds the complete results
      after the read call, then lIterHandle gets set to
      NO_MORE_ITERATIONS */
        
   /* Loop while there is data in the buffer */
   do
   {   
      ccode = NWDSReadClassDef(context, DS_CLASS_DEF_NAMES, TRUE, NULL, 
                               &lIterHandle, pOutBuf);
      if (ccode)
      {
         printf("\nNWDSReadClassDef returned %X", ccode);
         FreeBuf(pOutBuf, context);
      }

      /* Get and print number of classnames found in the buffer */
      ccode = NWDSGetClassDefCount(context, pOutBuf, &luClassNameCount);
      if(ccode)
      {
         printf("\nNWDSGetClassDefCount returned %X", ccode);
         FreeBuf(pOutBuf, context);
      }

      printf("\nNumber of classes: %ld", luClassNameCount);

      /* Loop for each class name found */
      for (luCounter = 0; luCounter < luClassNameCount; luCounter++)
      {   

         /* Get and print the classname from the buffer */
         ccode = NWDSGetClassItem(context, pOutBuf, strClassName);
         if(ccode)
         {   
             printf("\nNWDSGetClassItem returned %X", ccode);
             FreeBuf(pOutBuf, context);
         }
         printf("\n\tClass Name:  %s", strClassName);

      } /* end class name loop */

   } while (lIterHandle != NO_MORE_ITERATIONS);  /* read loop */

   /* Clean up, normal termination */
   NWDSFreeBuf(pOutBuf);
   NWDSFreeContext(context);
   NWFreeUnicodeTables();
}

/* Clean up and exit, called on error condition only */
void FreeBuf(pBuf_T pBuf, NWDSContextHandle context)
{
   NWDSFreeBuf(pBuf);
   FreeContext(context);
}

void FreeContext(NWDSContextHandle context)
{
   NWDSFreeContext(context);
   FreeUnicodeTables();
}

void FreeUnicodeTables()
{
   NWFreeUnicodeTables();
   exit(1);
}  

