/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps;

import com.novell.emframe.dev.D;
import com.novell.emframe.dev.config.ConfigException;
import com.novell.emframe.dev.config.SystemConfig;
import com.novell.emframe.fw.AuditLog;
import com.novell.emframe.fw.DebugLogging;
import com.novell.emframe.fw.FwAppUtils;
import com.novell.emframe.fw.FwAttr;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.config.ConfigRecordManager;
import com.novell.emframe.fw.iManager;
import com.novell.emframe.fw.security.Provider_IM;
import com.novell.emframe.fw.servlet.AuthenticatorServlet;
import com.novell.emframe.fw.servlet.FwRequest;
import com.novell.nps.WebappUtil;
import com.novell.nps.authentication.AuthenticationManager;
import com.novell.nps.configManager.ConfigManager;
import com.novell.nps.event.PortalEventManager;
import com.novell.nps.event.PortalRequestBeginEvent;
import com.novell.nps.event.PortalRequestEndEvent;
import com.novell.nps.event.PortalStartupEvent;
import com.novell.nps.gadgetManager.GadgetInstance;
import com.novell.nps.gadgetManager.GadgetManager;
import com.novell.nps.i18n.ResourceFileManager;
import com.novell.nps.sessionManager.PortalSession;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PortalServlet
extends AuthenticatorServlet {
    public static final String PORTAL_PROPERTIES = "PortalServlet.properties";
    private static final int BUFFER_SIZE = 10000;
    protected static GadgetManager gadgetMan;
    protected static ResourceFileManager m_resourceFileMan;
    private static PortalServlet sm_portalServlet;
    private static Boolean sm_initialized;
    private static Boolean sm_bDestroyed;
    private static Throwable sm_initException;
    protected static boolean m_thisEnabled;

    public void init() throws ServletException {
        try {
            super.init();
            this.initCatchException(this.getServletConfig());
        }
        catch (Throwable e) {
            sm_initException = e;
            sm_initException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCatchException(ServletConfig config) {
        Boolean bl = sm_initialized;
        synchronized (bl) {
            boolean developerMode = false;
            if (!sm_initialized.booleanValue()) {
                WebappUtil.init((HttpServlet)this);
                ConfigRecordManager.init();
                SystemConfig systemConfig = new SystemConfig();
                if (systemConfig.getSetting("Security.Provider.Initialize", "true").equalsIgnoreCase("true")) {
                    Provider_IM.init();
                }
                AuditLog.logSystemStartup();
                if (sm_portalServlet != null) {
                    this.log("Error:  multiple portal servlets instanciated!");
                } else {
                    sm_portalServlet = this;
                }
                ServletContext sc = config.getServletContext();
                gadgetMan = new GadgetManager();
                m_resourceFileMan = new ResourceFileManager();
                developerMode = new Boolean(ConfigManager.getPortalSetting("DEVELOPERMODE", "false"));
                DebugLogging.init();
                ConfigManager.init();
                System.gc();
                PortalEventManager.postEvent(new PortalStartupEvent());
                gadgetMan.init();
                System.gc();
                m_resourceFileMan.init();
                AuthenticationManager.init();
                FwUtils.init();
                iManager.init((ServletConfig)config);
                FwAppUtils.setXSLTParser();
                sm_initialized = new Boolean(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        AuditLog.logSystemShutdown();
        super.destroy();
        Boolean bl = sm_bDestroyed;
        synchronized (bl) {
            if (!sm_bDestroyed.booleanValue()) {
                DebugLogging.stop();
                sm_bDestroyed = Boolean.TRUE;
            }
        }
    }

    public static boolean isThisEnabled() {
        return iManager.isThisEnabled();
    }

    public static void setThisEnabled(boolean bool) {
        SystemConfig sc = new SystemConfig();
        try {
            sc.setSetting("Provider.eMFrame.This.enable", String.valueOf(bool));
        }
        catch (ConfigException e) {
            D.log((Throwable)e);
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (sm_initException == null) {
            this.processRequest(req, resp);
        } else {
            String sProblemTitle = null;
            String sDescription = null;
            try {
                Locale loc = req.getLocale();
                ResourceBundle res = ResourceBundle.getBundle("com.novell.nps.configManager.ConfigManagerRes", loc);
                sProblemTitle = res.getString("ProblemStartingServlet");
                sDescription = res.getString("ProblemStartupServletDescription");
            }
            catch (Exception e) {
                sProblemTitle = "There was a problem starting the servlet:";
                sDescription = "Most problems starting up are related to missing information in the PortalServlet.properties file.  If this is the second server you are installing into the same eDirectory tree, please copy the PortalServlet.properties file from another server to remedy the problem (making sure to update IP addresses of settings to match the new server such as the Custom_Backend_Renderer_Portal_Location setting).  The PortalServlet.properties file is generally found in webapps/nps/WEB-INF of your web servlet directory.";
            }
            resp.setContentType("text/html; charset=UTF-8");
            BufferedWriter out = new BufferedWriter(resp.getWriter());
            PrintWriter pout = new PrintWriter(out);
            pout.write("<html><body><table border=\"0\" cellpadding=\"3\" cellspacing=\"0\"><tr valign=\"bottom\"><td valign=\"bottom\"><img border=\"0\" alt=\"");
            sm_initException.printStackTrace(pout);
            pout.write("\"src=\"" + WebappUtil.getContext() + "/portal/stylesheets/skins/default/images/Error32.gif\"/></td><td valign=\"bottom\" width=\"100%\"><b>" + sProblemTitle + "</b></td></tr><tr><td colspan=\"2\"><b>" + sm_initException.getLocalizedMessage() + "</b></td></tr><tr><td colspan=\"2\">" + sDescription + "</td></tr></table></body></html>");
            pout.close();
            out.close();
        }
    }

    void processRequest(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String sServletPath = this.getServletPath(req);
        FwRequest reqWrapper = null;
        D.assrt((boolean)(req instanceof FwRequest), (String)"Request not a framework request. Creating framework request.");
        reqWrapper = (FwRequest)req;
        PortalSession session = (PortalSession)reqWrapper.getSession();
        PortalEventManager.postEvent(new PortalRequestBeginEvent(session));
        if (sServletPath.endsWith("/frameservice") || sServletPath.endsWith("/jspincludeservice") || sServletPath.endsWith("/mtaskservice") || sServletPath.endsWith("/xmlframeservice")) {
            this.handleFrameService(reqWrapper, resp, session, sServletPath);
        } else if (sServletPath.endsWith("/imanagerservice")) {
            this.handleiManagerService(reqWrapper, resp, session, false);
        } else if (sServletPath.endsWith("/imanauthentication")) {
            resp.sendRedirect(req.getRequestURI().substring(0, req.getRequestURI().indexOf("/imanauth")) + "/webacc");
        } else if (sServletPath.endsWith("/jslogservice")) {
            this.handleJSLogService((HttpServletRequest)reqWrapper, resp);
        } else if (sServletPath.endsWith("/xmlimanagerservice")) {
            this.handleiManagerService(reqWrapper, resp, session, true);
        } else if (sServletPath.endsWith("/customcontentservice")) {
            gadgetMan.processCustomContentServiceRequest((HttpServletRequest)reqWrapper, resp, session);
        } else if (sServletPath.endsWith("/fullpageservice")) {
            gadgetMan.processFullpageServiceRequest((HttpServletRequest)reqWrapper, resp, session);
        } else if (sServletPath.endsWith("/xmlfullpageservice")) {
            reqWrapper.setAttribute("NPFullpage", (Object)Boolean.TRUE);
            gadgetMan.processXMLFullpageServiceRequest((HttpServletRequest)reqWrapper, resp, session);
        } else if (sServletPath.endsWith("/normalfullpageservice")) {
            gadgetMan.processNormalFullpageServiceRequest((HttpServletRequest)reqWrapper, resp, session);
        } else if (sServletPath.endsWith("/xmlnormalfullpageservice")) {
            reqWrapper.setAttribute("NPFullpage", (Object)Boolean.TRUE);
            gadgetMan.processXMLNormalFullpageServiceRequest((HttpServletRequest)reqWrapper, resp, session);
        } else if (sServletPath.endsWith("/locatorservice")) {
            this.handleLocatorService(req, reqWrapper, resp, session);
        } else if (sServletPath.endsWith("/pageservice")) {
            gadgetMan.processPageServiceRequest((HttpServletRequest)reqWrapper, resp, session);
        } else if (sServletPath.endsWith("/xmlpageservice")) {
            FwAttr.setFwRequestAttribute((String)"NPService", (Object)Boolean.TRUE, (HttpServletRequest)reqWrapper);
            gadgetMan.processXMLPageServiceRequest((HttpServletRequest)reqWrapper, resp, session);
        } else if (sServletPath.endsWith("/portalservice")) {
            gadgetMan.processPortalServiceRequest((HttpServletRequest)reqWrapper, resp, session);
        } else if (sServletPath.endsWith("/xmlportalservice")) {
            gadgetMan.processXMLPortalServiceRequest((HttpServletRequest)reqWrapper, resp, session);
        } else if (sServletPath.endsWith("/service")) {
            FwAttr.setFwRequestAttribute((String)"NPService", (Object)Boolean.TRUE, (HttpServletRequest)reqWrapper);
            gadgetMan.processServiceRequest((HttpServletRequest)reqWrapper, resp, session, true);
        } else if (sServletPath.endsWith("/xmlservice")) {
            FwAttr.setFwRequestAttribute((String)"NPService", (Object)Boolean.TRUE, (HttpServletRequest)reqWrapper);
            gadgetMan.processXMLServiceRequest((HttpServletRequest)reqWrapper, resp, session);
        } else if (sServletPath.endsWith("/xmldataservice")) {
            gadgetMan.processXMLDataServiceRequest((HttpServletRequest)reqWrapper, resp, session);
        } else {
            gadgetMan.processRequest((HttpServletRequest)reqWrapper, resp, session);
        }
        PortalEventManager.postEvent(new PortalRequestEndEvent(session));
    }

    private String getServletPath(HttpServletRequest req) {
        String sServletPath = req.getServletPath();
        if (sServletPath.endsWith("/webacc")) {
            String taskId = req.getParameter("taskId");
            sServletPath = taskId != null && taskId.equals("fw.DownloadFile") ? "/servlet/customcontentservice" : "/servlet/frameservice";
        }
        return sServletPath;
    }

    private void handleFrameService(FwRequest reqWrapper, HttpServletResponse resp, PortalSession session, String sServletPath) throws ServletException {
        FwAttr.setFwRequestAttribute((String)"NPService", (Object)Boolean.TRUE, (HttpServletRequest)reqWrapper);
        FwAttr.setFwRequestAttribute((String)"System.DontUseSystemStylesheets", (Object)Boolean.TRUE, (HttpServletRequest)reqWrapper);
        FwAttr.setFwRequestAttribute((String)"System.IncludeGlobalVariables", (Object)Boolean.TRUE, (HttpServletRequest)reqWrapper);
        FwAttr.setFwRequestAttribute((String)"FrameServiceRequest", (Object)Boolean.TRUE, (HttpServletRequest)reqWrapper);
        if (sServletPath.endsWith("/mtaskservice")) {
            gadgetMan.processMTaskRequest((HttpServletRequest)reqWrapper, resp, session);
        } else if (sServletPath.endsWith("/xmlframeservice")) {
            gadgetMan.processXMLServiceRequest((HttpServletRequest)reqWrapper, resp, session);
        } else {
            gadgetMan.processServiceRequest((HttpServletRequest)reqWrapper, resp, session, true);
        }
    }

    private void handleLocatorService(HttpServletRequest req, FwRequest reqWrapper, HttpServletResponse resp, PortalSession session) {
        String path = req.getPathInfo();
        String resourceURI = ResourceFileManager.getModuleResourceFile((HttpServletRequest)reqWrapper, path.substring(1));
        if (resourceURI != null && resourceURI.toLowerCase().endsWith("jsp")) {
            this.dispatchJSP(req, resp, resourceURI);
            return;
        }
        String sUseBrowserCache = req.getHeader("If-Modified-Since");
        if (sUseBrowserCache != null && sUseBrowserCache.length() > 0) {
            resp.setStatus(304);
            return;
        }
        try {
            String resourcePath = WebappUtil.getRealPath(resourceURI);
            File file = new File(resourcePath);
            FileInputStream is = new FileInputStream(file);
            resp.setHeader("Last-Modified", String.valueOf(file.lastModified()));
            resp.setContentLength((int)file.length());
            String sMimeType = WebappUtil.getStaticServletContext().getMimeType(resourceURI);
            if (sMimeType == null) {
                sMimeType = "application/octet-stream";
            }
            resp.setContentType(sMimeType);
            ServletOutputStream os = resp.getOutputStream();
            byte[] buffer = new byte[10000];
            int bytesRead = 0;
            while (bytesRead != -1) {
                bytesRead = ((InputStream)is).read(buffer);
                if (bytesRead == -1) continue;
                os.write(buffer, 0, bytesRead);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void handleiManagerService(FwRequest reqWrapper, HttpServletResponse resp, PortalSession session, boolean bIsXml) throws ServletException {
        GadgetInstance requestedInstance;
        FwAttr.setFwRequestAttribute((String)"NPService", (Object)Boolean.TRUE, (HttpServletRequest)reqWrapper);
        FwAttr.setFwRequestAttribute((String)"System.DontUseSystemStylesheets", (Object)Boolean.TRUE, (HttpServletRequest)reqWrapper);
        FwAttr.setFwRequestAttribute((String)"System.IncludeGlobalVariables", (Object)Boolean.TRUE, (HttpServletRequest)reqWrapper);
        FwAttr.setFwRequestAttribute((String)"FrameServiceRequest", (Object)Boolean.TRUE, (HttpServletRequest)reqWrapper);
        FwAttr.setFwRequestAttribute((String)"iManagerServiceRequest", (Object)Boolean.TRUE, (HttpServletRequest)reqWrapper);
        String sID = FwUtils.getTaskInstanceId((HttpServletRequest)reqWrapper);
        if (sID != null && !sID.equalsIgnoreCase("fw.LaunchService") && (requestedInstance = GadgetManager.getGadgetInstance(sID, session)) != null && requestedInstance.getPrimary() == null) {
            reqWrapper.setParameter("NPService", "fw.LaunchService");
            reqWrapper.setParameter("NPAction", "Launch");
            reqWrapper.setParameter("launch", sID);
            reqWrapper.setParameter("launcher", "fw.CloseWindow");
            reqWrapper.setParameter("lifecycle", "Recreate");
            reqWrapper.setParameter("repeatable", "true");
        }
        if (bIsXml) {
            gadgetMan.processXMLServiceRequest((HttpServletRequest)reqWrapper, resp, session);
        } else {
            gadgetMan.processServiceRequest((HttpServletRequest)reqWrapper, resp, session, true);
        }
    }

    private void dispatchJSP(HttpServletRequest req, HttpServletResponse resp, String sJSPPage) {
        try {
            RequestDispatcher rd = sJSPPage.startsWith("/") ? req.getRequestDispatcher(sJSPPage) : req.getRequestDispatcher("/" + sJSPPage);
            try {
                rd.forward((ServletRequest)req, (ServletResponse)resp);
                resp.flushBuffer();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static boolean isDisconnected() {
        return false;
    }

    public static String getRealPath(String relativeURI) {
        if (relativeURI != null && relativeURI.length() > 0 && relativeURI.charAt(relativeURI.length() - 1) != '/') {
            return PortalServlet.getStaticServletContext().getRealPath(relativeURI);
        }
        String path = PortalServlet.getStaticServletContext().getRealPath(relativeURI);
        if (path != null && path.length() > 0 && path.charAt(path.length() - 1) != File.separatorChar) {
            path = path + File.separator;
        }
        return path;
    }

    public static HttpServlet getPortalServlet() {
        return sm_portalServlet;
    }

    public static String getStaticServletName() {
        return sm_portalServlet.getServletName();
    }

    public static String getContext() {
        return ConfigManager.getPortalSetting("WebApp", "/nps");
    }

    public static ServletContext getStaticServletContext() {
        return sm_portalServlet.getServletContext();
    }

    public static ServletConfig getStaticServletConfig() {
        return sm_portalServlet.getServletConfig();
    }

    public static boolean isInitialized() {
        return sm_initialized;
    }

    static {
        sm_initialized = new Boolean(false);
        sm_bDestroyed = new Boolean(false);
        sm_initException = null;
        m_thisEnabled = false;
    }
}

