/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps;

import com.novell.emframe.dev.D;
import com.novell.emframe.fw.FwUtils;
import com.novell.nps.configManager.ConfigManager;
import com.novell.nps.sessionManager.PortalSession;
import java.io.File;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;

public class WebappUtil {
    private static HttpServlet portalServlet;
    private static String m_sServletPath;

    public static void init(HttpServlet currentServlet) {
        portalServlet = currentServlet;
    }

    public static void init(String sServletPath) {
        m_sServletPath = sServletPath;
    }

    public static String getRealPath(String relativeURI) {
        String finalPath = null;
        if (portalServlet != null) {
            if (relativeURI == null || 0 == relativeURI.length()) {
                finalPath = WebappUtil.getStaticServletContext().getRealPath("/");
            } else {
                if (!relativeURI.startsWith("/", 0)) {
                    relativeURI = "/".concat(relativeURI);
                }
                String path = WebappUtil.getStaticServletContext().getRealPath(relativeURI);
                if (relativeURI.charAt(relativeURI.length() - 1) == '/' && path != null && path.length() > 0 && path.charAt(path.length() - 1) != File.separatorChar) {
                    path = path + File.separator;
                }
                finalPath = path;
            }
        } else if (m_sServletPath != null) {
            if (relativeURI == null || 0 == relativeURI.length()) {
                finalPath = m_sServletPath;
            } else {
                String path = m_sServletPath;
                if (path.charAt(path.length() - 1) != File.separatorChar) {
                    path = path + File.separator;
                }
                path = path + relativeURI;
                if (relativeURI.charAt(relativeURI.length() - 1) == '/' && path != null && path.length() > 0 && path.charAt(path.length() - 1) != File.separatorChar) {
                    path = path + File.separator;
                }
                finalPath = path;
            }
        } else {
            D.log((Throwable)new Exception("WebappUtil not correctly initialized - WebappUtil.init must be called first"));
        }
        return finalPath;
    }

    public static HttpServlet getPortalServlet() {
        return portalServlet;
    }

    public static String getStaticServletName() {
        return portalServlet.getServletName();
    }

    public static ServletContext getStaticServletContext() {
        return portalServlet.getServletContext();
    }

    public static ServletConfig getStaticServletConfig() {
        return portalServlet.getServletConfig();
    }

    public static String getContext() {
        return ConfigManager.getPortalSetting("WebApp", "/nps");
    }

    public static String getResourceSetPath() {
        return WebappUtil.getResourceSetFile().getAbsolutePath();
    }

    public static File getResourceSetFile() {
        return new File(WebappUtil.getRealPath("/"));
    }

    public static boolean isCompressedWar() {
        return WebappUtil.isCompressedWar(WebappUtil.getStaticServletContext());
    }

    public static boolean isCompressedWar(ServletContext context) {
        return null == context.getRealPath("/");
    }

    public static void saveOSRequest(HttpServletRequest req, PortalSession session) {
        FwUtils.saveOSRequest((HttpServletRequest)req);
    }

    static {
        m_sServletPath = null;
    }
}

