/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.authentication;

import com.novell.emframe.dev.D;
import com.novell.emframe.dev.PluginException;
import com.novell.emframe.fw.ldap.JndiLdapUtil;
import com.novell.nps.authentication.AuthenticationManager;
import com.novell.nps.authentication.PortalCommunicationException;
import com.novell.nps.authentication.PortalDirectory;
import com.novell.nps.authentication.PortalDirectoryException;
import com.novell.nps.authentication.PortalObjectAttribute;
import com.novell.nps.authentication.PortalSearchResult;
import com.novell.nps.authentication.PortalVirtualSearch;
import com.novell.service.ndssdk.jndi.ldap.ext.GetEffectiveRightsRequest;
import com.novell.service.ndssdk.jndi.ldap.ext.GetEffectiveRightsResponse;
import com.sun.jndi.ldap.ctl.SortControl;
import com.sun.jndi.ldap.ctl.VirtualListViewControl;
import com.sun.jndi.ldap.ctl.VirtualListViewResponseControl;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.naming.AuthenticationException;
import javax.naming.AuthenticationNotSupportedException;
import javax.naming.CommunicationException;
import javax.naming.ContextNotEmptyException;
import javax.naming.InvalidNameException;
import javax.naming.LimitExceededException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.OperationNotSupportedException;
import javax.naming.ServiceUnavailableException;
import javax.naming.SizeLimitExceededException;
import javax.naming.TimeLimitExceededException;
import javax.naming.directory.Attribute;
import javax.naming.directory.AttributeInUseException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InvalidAttributeIdentifierException;
import javax.naming.directory.InvalidAttributeValueException;
import javax.naming.directory.InvalidSearchFilterException;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.NoSuchAttributeException;
import javax.naming.directory.SchemaViolationException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.ExtendedRequest;
import javax.naming.ldap.LdapContext;

public class JNDIPortalDirectory
implements PortalDirectory,
Serializable {
    private static final int MAX_WRITE_SIZE = 64512;
    private boolean m_bAuthenticated = false;
    private boolean m_bDisconnected = false;
    private String m_sUsername = null;
    private transient DirContext m_cx = null;
    private transient DirContext m_cxSchema = null;
    private Hashtable m_htBinaryAttrs = new Hashtable();
    private String m_sSchemaDN = null;
    private static final String ENV_BINARY_ATTRS = "java.naming.ldap.attributes.binary";

    @Override
    public void authenticate(String sDirectory, String sUsername, String sPassword, boolean bUseSSL) throws PortalDirectoryException {
        try {
            Properties additionalProps = new Properties();
            additionalProps.put("java.naming.ldap.derefAliases", "never");
            JndiLdapUtil jlUtil = new JndiLdapUtil();
            this.m_cx = jlUtil.createJNDILDAPContext(sUsername, sPassword, sDirectory, "389", "636", bUseSSL, additionalProps, Locale.getDefault());
            this.m_sUsername = sUsername;
            this.m_bAuthenticated = true;
            this.m_bDisconnected = false;
            this.setBinaryAttributes();
        }
        catch (PluginException pex) {
            String errMsg;
            String sClass;
            int nsErrorCode = 0;
            Throwable rootCause = pex.getCause();
            if (rootCause != null && rootCause instanceof NamingException) {
                nsErrorCode = this.mapExceptionErrorCodes((NamingException)rootCause);
                sClass = rootCause.getClass().getName();
                errMsg = rootCause.getLocalizedMessage();
            } else {
                sClass = ((Object)((Object)pex)).getClass().getName();
                errMsg = pex.getLocalizedMessage();
            }
            ResourceBundle res = AuthenticationManager.getResourceBundle();
            MessageFormat mf = new MessageFormat(res.getString("authenticate_0_1_2_"));
            String sMsg = mf.format(new Object[]{sUsername, sClass, errMsg});
            D.log((String)sMsg, (int)1);
            throw new PortalCommunicationException(sMsg, nsErrorCode);
        }
    }

    @Override
    public void unauthenticate() throws PortalDirectoryException {
        try {
            if (this.m_cx != null) {
                this.m_cx.close();
            }
            this.m_sUsername = null;
            this.m_bAuthenticated = false;
            this.m_bDisconnected = false;
            this.m_htBinaryAttrs.clear();
            this.m_cx = null;
            this.m_cxSchema = null;
            this.m_sSchemaDN = null;
        }
        catch (NamingException e) {
            ResourceBundle res = AuthenticationManager.getResourceBundle();
            String sClass = e.getClass().getName();
            MessageFormat mf = new MessageFormat(res.getString("unauthenticate_0_1_2_"));
            String sMsg = mf.format(new Object[]{this.m_sUsername, sClass, e.getLocalizedMessage()});
            D.log((String)sMsg, (int)1);
            throw new PortalDirectoryException(sMsg, this.mapExceptionErrorCodes(e));
        }
    }

    @Override
    public void disconnect() throws PortalDirectoryException {
        try {
            if (this.m_cx != null) {
                this.m_cx.close();
            }
            this.m_cx = null;
            this.m_bDisconnected = true;
        }
        catch (NamingException e) {
            ResourceBundle res = AuthenticationManager.getResourceBundle();
            String sClass = e.getClass().getName();
            MessageFormat mf = new MessageFormat(res.getString("unauthenticate_0_1_2_"));
            String sMsg = mf.format(new Object[]{this.m_sUsername, sClass, e.getLocalizedMessage()});
            D.log((String)sMsg, (int)1);
            throw new PortalDirectoryException(sMsg, this.mapExceptionErrorCodes(e));
        }
    }

    @Override
    public boolean isAuthenticated() {
        return this.m_bAuthenticated;
    }

    @Override
    public boolean isDisconnected() {
        return this.m_bDisconnected;
    }

    @Override
    public boolean isValid() throws PortalDirectoryException {
        boolean bValid = false;
        if (this.m_bAuthenticated && this.m_sUsername != null) {
            try {
                Vector vOC = this.readMultiStringAttribute(this.m_sUsername, "objectClass");
                if (vOC != null && vOC.size() > 0) {
                    bValid = true;
                }
            }
            catch (PortalDirectoryException portalDirectoryException) {
                // empty catch block
            }
        }
        return bValid;
    }

    @Override
    public String readStringAttribute(String sObject, String sAttribute) throws PortalDirectoryException {
        String sValue = null;
        try {
            Attributes attrs = this.m_cx.getAttributes(sObject, new String[]{sAttribute});
            Attribute attr = attrs.get(sAttribute);
            if (attr != null) {
                try {
                    sValue = (String)attr.get();
                }
                catch (ClassCastException ex) {
                    byte[] ba = (byte[])attr.get();
                    sValue = new String(ba);
                }
            }
        }
        catch (CommunicationException commex) {
            String soClass = commex.getClass().getName();
            String errMsg = commex.getLocalizedMessage();
            throw new PortalCommunicationException(soClass + "::" + errMsg, this.mapExceptionErrorCodes(commex));
        }
        catch (ServiceUnavailableException suex) {
            String sClass = suex.getClass().getName();
            String errMsg = suex.getLocalizedMessage();
            throw new PortalCommunicationException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(suex));
        }
        catch (NamingException e) {
            String sClass = e.getClass().getName();
            String errMsg = e.getLocalizedMessage();
            throw new PortalDirectoryException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(e));
        }
        catch (NoSuchElementException f) {
            String errMsg = f.getLocalizedMessage();
            throw new PortalDirectoryException(errMsg, this.mapExceptionErrorCodes(f));
        }
        return sValue;
    }

    @Override
    public Vector readMultiStringAttribute(String sObject, String sAttribute) throws PortalDirectoryException {
        Vector<String> vValues;
        block8: {
            vValues = new Vector<String>();
            try {
                Attributes attrs = this.m_cx.getAttributes(sObject, new String[]{sAttribute});
                Attribute attr = attrs.get(sAttribute);
                if (attr == null) break block8;
                NamingEnumeration<?> en = attr.getAll();
                String sTemp = null;
                byte[] baTemp = null;
                while (en.hasMoreElements()) {
                    try {
                        sTemp = (String)en.nextElement();
                    }
                    catch (ClassCastException ex) {
                        baTemp = (byte[])en.nextElement();
                        sTemp = new String(baTemp);
                    }
                    vValues.add(sTemp);
                }
            }
            catch (CommunicationException commex) {
                String soClass = commex.getClass().getName();
                String errMsg = commex.getLocalizedMessage();
                throw new PortalCommunicationException(soClass + "::" + errMsg, this.mapExceptionErrorCodes(commex));
            }
            catch (ServiceUnavailableException suex) {
                String sClass = suex.getClass().getName();
                String errMsg = suex.getLocalizedMessage();
                throw new PortalCommunicationException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(suex));
            }
            catch (NamingException e) {
                String sClass = e.getClass().getName();
                String errMsg = e.getLocalizedMessage();
                throw new PortalDirectoryException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(e));
            }
            catch (NoSuchElementException f) {
                String sClass = f.getClass().getName();
                String errMsg = f.getLocalizedMessage();
                throw new PortalDirectoryException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(f));
            }
        }
        return vValues;
    }

    @Override
    public byte[] readByteArrayAttribute(String sObject, String sAttribute) throws PortalDirectoryException {
        byte[] baValue = null;
        this.addBinaryAttr(sAttribute);
        try {
            Attributes attrs = this.m_cx.getAttributes(sObject, new String[]{sAttribute});
            Attribute attr = attrs.get(sAttribute);
            if (attr != null) {
                try {
                    baValue = (byte[])attr.get();
                }
                catch (ClassCastException ex) {
                    String sTemp = (String)attr.get();
                    baValue = sTemp.getBytes();
                }
            }
        }
        catch (CommunicationException commex) {
            String soClass = commex.getClass().getName();
            String errMsg = commex.getLocalizedMessage();
            throw new PortalCommunicationException(soClass + "::" + errMsg, this.mapExceptionErrorCodes(commex));
        }
        catch (ServiceUnavailableException suex) {
            String sClass = suex.getClass().getName();
            String errMsg = suex.getLocalizedMessage();
            throw new PortalCommunicationException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(suex));
        }
        catch (NamingException e) {
            String sClass = e.getClass().getName();
            String errMsg = e.getLocalizedMessage();
            throw new PortalDirectoryException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(e));
        }
        catch (NoSuchElementException f) {
            String sClass = f.getClass().getName();
            String errMsg = f.getLocalizedMessage();
            throw new PortalDirectoryException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(f));
        }
        return baValue;
    }

    @Override
    public Vector readMultiByteArrayAttribute(String sObject, String sAttribute) throws PortalDirectoryException {
        Vector<byte[]> vValues;
        block8: {
            vValues = new Vector<byte[]>();
            this.addBinaryAttr(sAttribute);
            try {
                Attributes attrs = this.m_cx.getAttributes(sObject, new String[]{sAttribute});
                Attribute attr = attrs.get(sAttribute);
                if (attr == null) break block8;
                NamingEnumeration<?> en = attr.getAll();
                String sTemp = null;
                byte[] baTemp = null;
                while (en.hasMoreElements()) {
                    try {
                        baTemp = (byte[])en.nextElement();
                    }
                    catch (ClassCastException ex) {
                        sTemp = (String)en.nextElement();
                        baTemp = sTemp.getBytes();
                    }
                    vValues.add(baTemp);
                }
            }
            catch (CommunicationException commex) {
                String soClass = commex.getClass().getName();
                String errMsg = commex.getLocalizedMessage();
                throw new PortalCommunicationException(soClass + "::" + errMsg, this.mapExceptionErrorCodes(commex));
            }
            catch (ServiceUnavailableException suex) {
                String sClass = suex.getClass().getName();
                String errMsg = suex.getLocalizedMessage();
                throw new PortalCommunicationException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(suex));
            }
            catch (NamingException e) {
                String sClass = e.getClass().getName();
                String errMsg = e.getLocalizedMessage();
                throw new PortalDirectoryException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(e));
            }
            catch (NoSuchElementException f) {
                String sClass = f.getClass().getName();
                String errMsg = f.getLocalizedMessage();
                throw new PortalDirectoryException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(f));
            }
        }
        return vValues;
    }

    @Override
    public void readAttributes(String sObject, Vector vAttributes) throws PortalDirectoryException {
        Vector vValues = null;
        PortalObjectAttribute poa = null;
        Enumeration myenum = vAttributes.elements();
        while (myenum.hasMoreElements()) {
            poa = (PortalObjectAttribute)myenum.nextElement();
            int iType = poa.getType();
            if (iType != 3 && iType != 4) continue;
            this.addBinaryAttr(poa.getName());
        }
        String[] saAttrs = new String[vAttributes.size()];
        for (int i = 0; i < saAttrs.length; ++i) {
            poa = (PortalObjectAttribute)vAttributes.elementAt(i);
            saAttrs[i] = poa.getName();
        }
        try {
            Attributes attrs = this.m_cx.getAttributes(sObject, saAttrs);
            Attribute attr = null;
            myenum = vAttributes.elements();
            while (myenum.hasMoreElements()) {
                poa = (PortalObjectAttribute)myenum.nextElement();
                attr = attrs.get(poa.getName());
                if (attr == null) continue;
                NamingEnumeration<?> en = attr.getAll();
                vValues = new Vector();
                while (en.hasMoreElements()) {
                    vValues.add(en.nextElement());
                }
                poa.setData(vValues);
            }
        }
        catch (CommunicationException commex) {
            String soClass = commex.getClass().getName();
            String errMsg = commex.getLocalizedMessage();
            throw new PortalCommunicationException(soClass + "::" + errMsg, this.mapExceptionErrorCodes(commex));
        }
        catch (ServiceUnavailableException suex) {
            String sClass = suex.getClass().getName();
            String errMsg = suex.getLocalizedMessage();
            throw new PortalCommunicationException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(suex));
        }
        catch (NamingException e) {
            String sClass = e.getClass().getName();
            String errMsg = e.getLocalizedMessage();
            throw new PortalDirectoryException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(e));
        }
        catch (NoSuchElementException f) {
            String sClass = f.getClass().getName();
            String errMsg = f.getLocalizedMessage();
            throw new PortalDirectoryException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(f));
        }
    }

    @Override
    public void readAttributes(String sObject, Hashtable htAttributes) throws PortalDirectoryException {
        Vector vValues = null;
        PortalObjectAttribute poa = null;
        String[] saAttrs = new String[htAttributes.size()];
        Enumeration myenum = htAttributes.elements();
        int i = 0;
        while (myenum.hasMoreElements()) {
            poa = (PortalObjectAttribute)myenum.nextElement();
            saAttrs[i++] = poa.getName();
            int iType = poa.getType();
            if (iType != 3 && iType != 4) continue;
            this.addBinaryAttr(poa.getName());
        }
        try {
            Attributes attrs = this.m_cx.getAttributes(sObject, saAttrs);
            Attribute attr = null;
            String sName = null;
            NamingEnumeration<?> enAttr = null;
            NamingEnumeration<? extends Attribute> ne = attrs.getAll();
            while (ne.hasMoreElements()) {
                attr = (Attribute)ne.nextElement();
                sName = attr.getID();
                poa = (PortalObjectAttribute)htAttributes.get(sName);
                if (poa == null) continue;
                enAttr = attr.getAll();
                vValues = new Vector();
                while (enAttr.hasMoreElements()) {
                    vValues.add(enAttr.nextElement());
                }
                poa.setData(vValues);
            }
        }
        catch (CommunicationException commex) {
            String soClass = commex.getClass().getName();
            String errMsg = commex.getLocalizedMessage();
            throw new PortalCommunicationException(soClass + "::" + errMsg, this.mapExceptionErrorCodes(commex));
        }
        catch (ServiceUnavailableException suex) {
            String sClass = suex.getClass().getName();
            String errMsg = suex.getLocalizedMessage();
            throw new PortalCommunicationException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(suex));
        }
        catch (NamingException e) {
            String sClass = e.getClass().getName();
            String errMsg = e.getLocalizedMessage();
            throw new PortalDirectoryException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(e));
        }
        catch (NoSuchElementException f) {
            String sClass = f.getClass().getName();
            String errMsg = f.getLocalizedMessage();
            throw new PortalDirectoryException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(f));
        }
    }

    @Override
    public Hashtable readAttributes(String sObject) throws PortalDirectoryException {
        Hashtable htRetAttributes = new Hashtable();
        try {
            Attributes attrs = this.m_cx.getAttributes(sObject);
            htRetAttributes = this.extractAttributeInfo(attrs);
        }
        catch (CommunicationException commex) {
            String soClass = commex.getClass().getName();
            String errMsg = commex.getLocalizedMessage();
            throw new PortalCommunicationException(soClass + "::" + errMsg, this.mapExceptionErrorCodes(commex));
        }
        catch (ServiceUnavailableException suex) {
            String sClass = suex.getClass().getName();
            String errMsg = suex.getLocalizedMessage();
            throw new PortalCommunicationException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(suex));
        }
        catch (NamingException e) {
            String sClass = e.getClass().getName();
            String errMsg = e.getLocalizedMessage();
            throw new PortalDirectoryException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(e));
        }
        catch (NoSuchElementException f) {
            String sClass = f.getClass().getName();
            String errMsg = f.getLocalizedMessage();
            throw new PortalDirectoryException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(f));
        }
        return htRetAttributes;
    }

    @Override
    public void writeStringAttribute(String sObject, String sAttribute, String sValue) throws PortalDirectoryException {
        ModificationItem[] mods = new ModificationItem[]{new ModificationItem(2, new BasicAttribute(sAttribute, sValue))};
        try {
            this.m_cx.modifyAttributes(sObject, mods);
        }
        catch (CommunicationException commex) {
            String soClass = commex.getClass().getName();
            String errMsg = commex.getLocalizedMessage();
            throw new PortalCommunicationException(soClass + "::" + errMsg, this.mapExceptionErrorCodes(commex));
        }
        catch (ServiceUnavailableException suex) {
            String sClass = suex.getClass().getName();
            String errMsg = suex.getLocalizedMessage();
            throw new PortalCommunicationException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(suex));
        }
        catch (NamingException e) {
            String sClass = e.getClass().getName();
            String errMsg = e.getLocalizedMessage();
            throw new PortalDirectoryException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(e));
        }
    }

    @Override
    public void writeMultiStringAttribute(String sObject, String sAttribute, String[] saValues, boolean bClear) throws PortalDirectoryException {
        int iStartIndex = 0;
        int iLength = 0;
        if (saValues != null) {
            iLength = saValues.length;
        }
        ModificationItem[] mods = new ModificationItem[1];
        BasicAttribute ba = new BasicAttribute(sAttribute);
        int iWriteSize = 0;
        String sTemp = null;
        int iOperation = bClear ? 2 : 1;
        boolean bWriteMore = true;
        while (bWriteMore) {
            bWriteMore = false;
            ba.clear();
            for (int i = iStartIndex; i < iLength; ++i) {
                sTemp = saValues[i];
                if (sTemp.length() + iWriteSize > 64512) {
                    if (iWriteSize == 0) {
                        iStartIndex = i + 1;
                        ba.add(sTemp);
                    } else {
                        iStartIndex = i;
                        iWriteSize = 0;
                    }
                    bWriteMore = true;
                    break;
                }
                iWriteSize += sTemp.length();
                ba.add(sTemp);
            }
            mods[0] = new ModificationItem(iOperation, ba);
            if (iOperation == 2) {
                iOperation = 1;
            }
            try {
                this.m_cx.modifyAttributes(sObject, mods);
            }
            catch (CommunicationException commex) {
                String soClass = commex.getClass().getName();
                String errMsg = commex.getLocalizedMessage();
                throw new PortalCommunicationException(soClass + "::" + errMsg, this.mapExceptionErrorCodes(commex));
            }
            catch (ServiceUnavailableException suex) {
                String sClass = suex.getClass().getName();
                String errMsg = suex.getLocalizedMessage();
                throw new PortalCommunicationException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(suex));
            }
            catch (NamingException e) {
                String sClass = e.getClass().getName();
                String errMsg = e.getLocalizedMessage();
                throw new PortalDirectoryException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(e));
            }
        }
    }

    @Override
    public void writeByteArrayAttribute(String sObject, String sAttribute, byte[] baValue) throws PortalDirectoryException {
        this.addBinaryAttr(sAttribute);
        ModificationItem[] mods = new ModificationItem[]{new ModificationItem(2, new BasicAttribute(sAttribute, baValue))};
        try {
            this.m_cx.modifyAttributes(sObject, mods);
        }
        catch (CommunicationException commex) {
            String soClass = commex.getClass().getName();
            String errMsg = commex.getLocalizedMessage();
            throw new PortalCommunicationException(soClass + "::" + errMsg, this.mapExceptionErrorCodes(commex));
        }
        catch (ServiceUnavailableException suex) {
            String sClass = suex.getClass().getName();
            String errMsg = suex.getLocalizedMessage();
            throw new PortalCommunicationException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(suex));
        }
        catch (NamingException e) {
            String sClass = e.getClass().getName();
            String errMsg = e.getLocalizedMessage();
            throw new PortalDirectoryException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(e));
        }
    }

    @Override
    public void writeMultiByteArrayAttribute(String sObject, String sAttribute, Vector vbaValues, boolean bClear) throws PortalDirectoryException {
        this.addBinaryAttr(sAttribute);
        int iStartIndex = 0;
        int iLength = 0;
        if (vbaValues != null) {
            iLength = vbaValues.size();
        }
        ModificationItem[] mods = new ModificationItem[1];
        BasicAttribute ba = new BasicAttribute(sAttribute);
        int iWriteSize = 0;
        byte[] baTemp = null;
        int iOperation = bClear ? 2 : 1;
        boolean bWriteMore = true;
        while (bWriteMore) {
            bWriteMore = false;
            ba.clear();
            for (int i = iStartIndex; i < iLength; ++i) {
                baTemp = (byte[])vbaValues.elementAt(i);
                if (baTemp.length + iWriteSize > 64512) {
                    if (iWriteSize == 0) {
                        iStartIndex = i + 1;
                        ba.add(baTemp);
                    } else {
                        iStartIndex = i;
                        iWriteSize = 0;
                    }
                    bWriteMore = true;
                    break;
                }
                iWriteSize += baTemp.length;
                ba.add(baTemp);
            }
            mods[0] = new ModificationItem(iOperation, ba);
            if (iOperation == 2) {
                iOperation = 1;
            }
            try {
                this.m_cx.modifyAttributes(sObject, mods);
            }
            catch (CommunicationException commex) {
                String soClass = commex.getClass().getName();
                String errMsg = commex.getLocalizedMessage();
                throw new PortalCommunicationException(soClass + "::" + errMsg, this.mapExceptionErrorCodes(commex));
            }
            catch (ServiceUnavailableException suex) {
                String sClass = suex.getClass().getName();
                String errMsg = suex.getLocalizedMessage();
                throw new PortalCommunicationException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(suex));
            }
            catch (NamingException e) {
                String sClass = e.getClass().getName();
                String errMsg = e.getLocalizedMessage();
                throw new PortalDirectoryException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(e));
            }
        }
    }

    @Override
    public void writeAttributes(String sObject, Vector vAttributes) throws PortalDirectoryException {
        BasicAttribute basicAttr = null;
        PortalObjectAttribute poa = null;
        String sName = null;
        Vector vData = null;
        Vector<ModificationItem> vMods = new Vector<ModificationItem>();
        for (int i = 0; i < vAttributes.size(); ++i) {
            poa = (PortalObjectAttribute)vAttributes.elementAt(i);
            sName = poa.getName();
            int iType = poa.getType();
            vData = poa.getData();
            if (vData == null || vData.size() <= 0) continue;
            basicAttr = new BasicAttribute(sName);
            if (iType == 3) {
                this.addBinaryAttr(sName);
            } else if (iType == 4) {
                this.addBinaryAttr(sName);
            } else if (iType == 1 || iType == 2) {
                // empty if block
            }
            for (int j = 0; j < vData.size(); ++j) {
                basicAttr.add(vData.elementAt(j));
            }
            int iOperation = iType == 2 || iType == 4 ? (poa.getClearFlag() ? 2 : 1) : 2;
            vMods.add(new ModificationItem(iOperation, basicAttr));
        }
        try {
            ModificationItem[] mods = new ModificationItem[vMods.size()];
            vMods.toArray(mods);
            this.m_cx.modifyAttributes(sObject, mods);
        }
        catch (CommunicationException commex) {
            String soClass = commex.getClass().getName();
            String errMsg = commex.getLocalizedMessage();
            throw new PortalCommunicationException(soClass + "::" + errMsg, this.mapExceptionErrorCodes(commex));
        }
        catch (ServiceUnavailableException suex) {
            String sClass = suex.getClass().getName();
            String errMsg = suex.getLocalizedMessage();
            throw new PortalCommunicationException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(suex));
        }
        catch (NamingException e) {
            String sClass = e.getClass().getName();
            String errMsg = e.getLocalizedMessage();
            throw new PortalDirectoryException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(e));
        }
    }

    @Override
    public void deleteStringAttributeValue(String sObject, String sAttribute, String sValue) throws PortalDirectoryException {
        ModificationItem[] mods = new ModificationItem[]{new ModificationItem(3, new BasicAttribute(sAttribute, sValue))};
        try {
            this.m_cx.modifyAttributes(sObject, mods);
        }
        catch (CommunicationException commex) {
            String soClass = commex.getClass().getName();
            String errMsg = commex.getLocalizedMessage();
            throw new PortalCommunicationException(soClass + "::" + errMsg, this.mapExceptionErrorCodes(commex));
        }
        catch (ServiceUnavailableException suex) {
            String sClass = suex.getClass().getName();
            String errMsg = suex.getLocalizedMessage();
            throw new PortalCommunicationException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(suex));
        }
        catch (NamingException e) {
            String sClass = e.getClass().getName();
            String errMsg = e.getLocalizedMessage();
            throw new PortalDirectoryException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(e));
        }
    }

    @Override
    public void deleteByteArrayAttributeValue(String sObject, String sAttribute, byte[] baValue) throws PortalDirectoryException {
        this.addBinaryAttr(sAttribute);
        ModificationItem[] mods = new ModificationItem[]{new ModificationItem(3, new BasicAttribute(sAttribute, baValue))};
        try {
            this.m_cx.modifyAttributes(sObject, mods);
        }
        catch (CommunicationException commex) {
            String soClass = commex.getClass().getName();
            String errMsg = commex.getLocalizedMessage();
            throw new PortalCommunicationException(soClass + "::" + errMsg, this.mapExceptionErrorCodes(commex));
        }
        catch (ServiceUnavailableException suex) {
            String sClass = suex.getClass().getName();
            String errMsg = suex.getLocalizedMessage();
            throw new PortalCommunicationException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(suex));
        }
        catch (NamingException e) {
            String sClass = e.getClass().getName();
            String errMsg = e.getLocalizedMessage();
            throw new PortalDirectoryException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(e));
        }
    }

    @Override
    public void replaceStringAttributeValue(String sObject, String sAttribute, String sValue, String sNewValue) throws PortalDirectoryException {
        try {
            if (sValue.length() + sNewValue.length() > 64512) {
                ModificationItem[] mods = new ModificationItem[]{new ModificationItem(3, new BasicAttribute(sAttribute, sValue))};
                this.m_cx.modifyAttributes(sObject, mods);
                mods[0] = new ModificationItem(1, new BasicAttribute(sAttribute, sNewValue));
                this.m_cx.modifyAttributes(sObject, mods);
            } else {
                ModificationItem[] mods = new ModificationItem[]{new ModificationItem(3, new BasicAttribute(sAttribute, sValue)), new ModificationItem(1, new BasicAttribute(sAttribute, sNewValue))};
                this.m_cx.modifyAttributes(sObject, mods);
            }
        }
        catch (CommunicationException commex) {
            String soClass = commex.getClass().getName();
            String errMsg = commex.getLocalizedMessage();
            throw new PortalCommunicationException(soClass + "::" + errMsg, this.mapExceptionErrorCodes(commex));
        }
        catch (ServiceUnavailableException suex) {
            String sClass = suex.getClass().getName();
            String errMsg = suex.getLocalizedMessage();
            throw new PortalCommunicationException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(suex));
        }
        catch (NamingException e) {
            String sClass = e.getClass().getName();
            String errMsg = e.getLocalizedMessage();
            throw new PortalDirectoryException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(e));
        }
    }

    @Override
    public void replaceByteArrayAttributeValue(String sObject, String sAttribute, byte[] baValue, byte[] baNewValue) throws PortalDirectoryException {
        this.addBinaryAttr(sAttribute);
        try {
            if (baValue.length + baNewValue.length > 64512) {
                ModificationItem[] mods = new ModificationItem[]{new ModificationItem(3, new BasicAttribute(sAttribute, baValue))};
                this.m_cx.modifyAttributes(sObject, mods);
                mods[0] = new ModificationItem(1, new BasicAttribute(sAttribute, baNewValue));
                this.m_cx.modifyAttributes(sObject, mods);
            } else {
                ModificationItem[] mods = new ModificationItem[]{new ModificationItem(3, new BasicAttribute(sAttribute, baValue)), new ModificationItem(1, new BasicAttribute(sAttribute, baNewValue))};
                this.m_cx.modifyAttributes(sObject, mods);
            }
        }
        catch (CommunicationException commex) {
            String soClass = commex.getClass().getName();
            String errMsg = commex.getLocalizedMessage();
            throw new PortalCommunicationException(soClass + "::" + errMsg, this.mapExceptionErrorCodes(commex));
        }
        catch (ServiceUnavailableException suex) {
            String sClass = suex.getClass().getName();
            String errMsg = suex.getLocalizedMessage();
            throw new PortalCommunicationException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(suex));
        }
        catch (NamingException e) {
            String sClass = e.getClass().getName();
            String errMsg = e.getLocalizedMessage();
            throw new PortalDirectoryException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(e));
        }
    }

    @Override
    public Vector searchDirectory(String sBase, String sFilter, int iScope) throws PortalDirectoryException {
        Vector<String> vRet = new Vector<String>();
        try {
            SearchControls sc = new SearchControls();
            sc.setReturningAttributes(new String[0]);
            if (iScope == 0) {
                sc.setSearchScope(0);
            } else if (iScope == 2) {
                sc.setSearchScope(2);
            } else if (iScope == 1) {
                sc.setSearchScope(1);
            }
            NamingEnumeration<SearchResult> ne = this.m_cx.search(sBase, sFilter, sc);
            String sDN = null;
            while (ne.hasMoreElements()) {
                SearchResult sr = (SearchResult)ne.nextElement();
                sDN = sr.getName();
                if (sBase.length() > 0) {
                    StringBuffer sb = new StringBuffer();
                    if (sDN.length() > 0) {
                        sb.append(sDN);
                        sb.append(",");
                    }
                    sb.append(sBase);
                    vRet.add(sb.toString());
                    continue;
                }
                vRet.add(sDN);
            }
        }
        catch (CommunicationException commex) {
            String soClass = commex.getClass().getName();
            String errMsg = commex.getLocalizedMessage();
            throw new PortalCommunicationException(soClass + "::" + errMsg, this.mapExceptionErrorCodes(commex));
        }
        catch (ServiceUnavailableException suex) {
            String sClass = suex.getClass().getName();
            String errMsg = suex.getLocalizedMessage();
            throw new PortalCommunicationException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(suex));
        }
        catch (NamingException e) {
            String sClass = e.getClass().getName();
            String errMsg = e.getLocalizedMessage();
            throw new PortalDirectoryException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(e));
        }
        catch (IllegalStateException ise) {
            String sClass = ise.getClass().getName();
            String errMsg = ise.getLocalizedMessage();
            throw new PortalDirectoryException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(ise));
        }
        return vRet;
    }

    @Override
    public Hashtable searchDirectory(String sBase, String sFilter, int iScope, Vector vAttributes, int iCountLimit, int iTimeLimit) throws PortalDirectoryException {
        Hashtable<String, Hashtable> htRet = new Hashtable<String, Hashtable>();
        PortalObjectAttribute poa = null;
        try {
            SearchControls sc = new SearchControls();
            String[] saAttrs = null;
            if (vAttributes != null) {
                saAttrs = new String[vAttributes.size()];
                for (int i = 0; i < vAttributes.size(); ++i) {
                    poa = (PortalObjectAttribute)vAttributes.elementAt(i);
                    saAttrs[i] = poa.getName();
                    int iType = poa.getType();
                    if (iType != 3 && iType != 4) continue;
                    this.addBinaryAttr(poa.getName());
                }
                sc.setReturningAttributes(saAttrs);
            }
            sc.setCountLimit(iCountLimit);
            sc.setTimeLimit(iTimeLimit);
            if (iScope == 0) {
                sc.setSearchScope(0);
            } else if (iScope == 2) {
                sc.setSearchScope(2);
            } else if (iScope == 1) {
                sc.setSearchScope(1);
            }
            NamingEnumeration<SearchResult> ne = this.m_cx.search(sBase, sFilter, sc);
            String sDN = null;
            String sFDN = null;
            Hashtable htAttrs = null;
            Attributes attrs = null;
            while (ne.hasMoreElements()) {
                SearchResult sr = (SearchResult)ne.nextElement();
                sDN = sr.getName();
                if (sBase.length() > 0) {
                    StringBuffer sb = new StringBuffer();
                    if (sDN.length() > 0) {
                        sb.append(sDN);
                        sb.append(",");
                    }
                    sb.append(sBase);
                    sFDN = sb.toString();
                } else {
                    sFDN = sDN;
                }
                attrs = sr.getAttributes();
                htAttrs = this.extractAttributeInfo(attrs);
                htRet.put(sFDN, htAttrs);
            }
        }
        catch (CommunicationException commex) {
            String soClass = commex.getClass().getName();
            String errMsg = commex.getLocalizedMessage();
            throw new PortalCommunicationException(soClass + "::" + errMsg, this.mapExceptionErrorCodes(commex));
        }
        catch (ServiceUnavailableException suex) {
            String sClass = suex.getClass().getName();
            String errMsg = suex.getLocalizedMessage();
            throw new PortalCommunicationException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(suex));
        }
        catch (NamingException e) {
            String sClass = e.getClass().getName();
            String errMsg = e.getLocalizedMessage();
            throw new PortalDirectoryException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(e));
        }
        catch (IllegalStateException ise) {
            String sClass = ise.getClass().getName();
            String errMsg = ise.getLocalizedMessage();
            throw new PortalDirectoryException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(ise));
        }
        return htRet;
    }

    @Override
    public Vector searchDirectory(String sBase, String sFilter, int iScope, int iTimeLimit, Vector vSortAttributes, Vector vReturnAttributes, PortalVirtualSearch pvs) throws PortalDirectoryException {
        Vector<PortalSearchResult> vRet = new Vector<PortalSearchResult>();
        PortalObjectAttribute poa = null;
        try {
            SearchControls sc = new SearchControls();
            String[] saAttrs = null;
            if (vReturnAttributes != null) {
                saAttrs = new String[vReturnAttributes.size()];
                for (int i = 0; i < vReturnAttributes.size(); ++i) {
                    poa = (PortalObjectAttribute)vReturnAttributes.elementAt(i);
                    saAttrs[i] = poa.getName();
                    int iType = poa.getType();
                    if (iType != 3 && iType != 4) continue;
                    this.addBinaryAttr(poa.getName());
                }
                sc.setReturningAttributes(saAttrs);
            }
            sc.setTimeLimit(iTimeLimit);
            if (iScope == 0) {
                sc.setSearchScope(0);
            } else if (iScope == 2) {
                sc.setSearchScope(2);
            } else if (iScope == 1) {
                sc.setSearchScope(1);
            }
            int ctrlCnt = 0;
            SortControl ctrlSort = null;
            if (vSortAttributes != null) {
                ++ctrlCnt;
                String[] saSort = new String[vSortAttributes.size()];
                vSortAttributes.toArray(saSort);
                ctrlSort = new SortControl(saSort, true);
            }
            VirtualListViewControl ctrlVlv = null;
            if (pvs != null) {
                ++ctrlCnt;
                ctrlVlv = new VirtualListViewControl(pvs.getTargetOffset(), pvs.getListSize(), pvs.getBeforeCount(), pvs.getAfterCount(), true);
            }
            LdapContext ldapCx = ((LdapContext)this.m_cx).newInstance(null);
            if (ctrlCnt > 0) {
                Control[] ctrls = new Control[ctrlCnt];
                int i = 0;
                if (ctrlSort != null) {
                    ctrls[i] = ctrlSort;
                    ++i;
                }
                if (ctrlVlv != null) {
                    ctrls[i] = ctrlVlv;
                    ++i;
                }
                ldapCx.setRequestControls(ctrls);
            }
            NamingEnumeration<SearchResult> ne = ldapCx.search(sBase, sFilter, sc);
            String sDN = null;
            String sFDN = null;
            Hashtable htAttrs = null;
            Attributes attrs = null;
            while (ne.hasMoreElements()) {
                SearchResult sr = (SearchResult)ne.nextElement();
                sDN = sr.getName();
                if (sBase.length() > 0) {
                    StringBuffer sb = new StringBuffer();
                    if (sDN.length() > 0) {
                        sb.append(sDN);
                        sb.append(",");
                    }
                    sb.append(sBase);
                    sFDN = sb.toString();
                } else {
                    sFDN = sDN;
                }
                attrs = sr.getAttributes();
                htAttrs = this.extractAttributeInfo(attrs);
                vRet.add(new PortalSearchResult(sFDN, htAttrs));
            }
            Control[] ctrlResp = ldapCx.getResponseControls();
            Control ctrl = null;
            if (ctrlResp != null) {
                for (int i = 0; i < ctrlResp.length; ++i) {
                    ctrl = ctrlResp[i];
                    if (!(ctrl instanceof VirtualListViewResponseControl) || pvs == null) continue;
                    VirtualListViewResponseControl ctrlVlvr = (VirtualListViewResponseControl)ctrl;
                    pvs.setResultCode(ctrlVlvr.getResultCode());
                    pvs.setContextID(ctrlVlvr.getContextID());
                    pvs.setTargetOffset(ctrlVlvr.getTargetOffset());
                    pvs.setListSize(ctrlVlvr.getListSize());
                }
            }
        }
        catch (IOException ioex) {
            String soClass = ioex.getClass().getName();
            String errMsg = ioex.getLocalizedMessage();
            throw new PortalCommunicationException(soClass + "::" + errMsg, this.mapExceptionErrorCodes(ioex));
        }
        catch (CommunicationException commex) {
            String soClass = commex.getClass().getName();
            String errMsg = commex.getLocalizedMessage();
            throw new PortalCommunicationException(soClass + "::" + errMsg, this.mapExceptionErrorCodes(commex));
        }
        catch (ServiceUnavailableException suex) {
            String sClass = suex.getClass().getName();
            String errMsg = suex.getLocalizedMessage();
            throw new PortalCommunicationException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(suex));
        }
        catch (NamingException e) {
            String sClass = e.getClass().getName();
            String errMsg = e.getLocalizedMessage();
            throw new PortalDirectoryException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(e));
        }
        catch (IllegalStateException ise) {
            String sClass = ise.getClass().getName();
            String errMsg = ise.getLocalizedMessage();
            throw new PortalDirectoryException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(ise));
        }
        return vRet;
    }

    @Override
    public void removeStringAttribute(String sObject, String sAttribute, String sValue) throws PortalDirectoryException {
        ModificationItem[] mods = new ModificationItem[]{new ModificationItem(3, new BasicAttribute(sAttribute, sValue))};
        try {
            this.m_cx.modifyAttributes(sObject, mods);
        }
        catch (NoSuchAttributeException noSuchAttributeException) {
        }
        catch (CommunicationException commex) {
            String soClass = commex.getClass().getName();
            String errMsg = commex.getLocalizedMessage();
            throw new PortalCommunicationException(soClass + "::" + errMsg, this.mapExceptionErrorCodes(commex));
        }
        catch (ServiceUnavailableException suex) {
            String sClass = suex.getClass().getName();
            String errMsg = suex.getLocalizedMessage();
            throw new PortalCommunicationException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(suex));
        }
        catch (NamingException e) {
            String sClass = e.getClass().getName();
            String errMsg = e.getLocalizedMessage();
            throw new PortalDirectoryException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(e));
        }
    }

    @Override
    public void createObject(String sObject, String sClass, Vector vAttrs) throws PortalDirectoryException {
        try {
            BasicAttributes attrs = new BasicAttributes(true);
            BasicAttribute ocAttr = new BasicAttribute("objectClass");
            ocAttr.add(sClass);
            attrs.put(ocAttr);
            BasicAttribute attr = null;
            Enumeration en = null;
            PortalObjectAttribute poa = null;
            String sName = null;
            int iType = 0;
            Vector vAttrData = null;
            String sTemp = null;
            byte[] baTemp = null;
            en = vAttrs != null ? vAttrs.elements() : new Vector().elements();
            block10: while (en.hasMoreElements()) {
                poa = (PortalObjectAttribute)en.nextElement();
                sName = poa.getName();
                iType = poa.getType();
                vAttrData = poa.getData();
                switch (iType) {
                    case 1: {
                        sTemp = (String)vAttrData.elementAt(0);
                        attr = new BasicAttribute(sName, sTemp);
                        attrs.put(attr);
                        continue block10;
                    }
                    case 2: {
                        Enumeration enumStr = vAttrData.elements();
                        if (sName.equalsIgnoreCase("objectClass")) {
                            while (enumStr.hasMoreElements()) {
                                sTemp = (String)enumStr.nextElement();
                                ocAttr.add(sTemp);
                            }
                            continue block10;
                        }
                        attr = new BasicAttribute(sName);
                        while (enumStr.hasMoreElements()) {
                            sTemp = (String)enumStr.nextElement();
                            attr.add(sTemp);
                        }
                        attrs.put(attr);
                        continue block10;
                    }
                    case 3: {
                        baTemp = (byte[])vAttrData.elementAt(0);
                        attr = new BasicAttribute(sName, baTemp);
                        attrs.put(attr);
                        continue block10;
                    }
                    case 4: {
                        Enumeration enumByte = vAttrData.elements();
                        attr = new BasicAttribute(sName);
                        while (enumByte.hasMoreElements()) {
                            baTemp = (byte[])enumByte.nextElement();
                            attr.add(sTemp);
                        }
                        attrs.put(attr);
                        continue block10;
                    }
                }
                ResourceBundle res = AuthenticationManager.getResourceBundle();
                MessageFormat mf = new MessageFormat(res.getString("Invalid_type_0_"));
                String sMsg = mf.format(new Object[]{new Integer(iType)});
                throw new PortalDirectoryException(sMsg);
            }
            this.m_cx.createSubcontext(sObject, (Attributes)attrs);
        }
        catch (CommunicationException commex) {
            String soClass = commex.getClass().getName();
            String errMsg = commex.getLocalizedMessage();
            throw new PortalCommunicationException(soClass + "::" + errMsg, this.mapExceptionErrorCodes(commex));
        }
        catch (ServiceUnavailableException suex) {
            String soClass = suex.getClass().getName();
            String errMsg = suex.getLocalizedMessage();
            throw new PortalCommunicationException(soClass + "::" + errMsg, this.mapExceptionErrorCodes(suex));
        }
        catch (NamingException e) {
            String soClass = e.getClass().getName();
            String errMsg = e.getLocalizedMessage();
            throw new PortalDirectoryException(soClass + "::" + errMsg, this.mapExceptionErrorCodes(e));
        }
    }

    @Override
    public void deleteObject(String sObject) throws PortalDirectoryException {
        try {
            this.m_cx.destroySubcontext(sObject);
        }
        catch (CommunicationException commex) {
            String soClass = commex.getClass().getName();
            String errMsg = commex.getLocalizedMessage();
            throw new PortalCommunicationException(soClass + "::" + errMsg, this.mapExceptionErrorCodes(commex));
        }
        catch (ServiceUnavailableException suex) {
            String sClass = suex.getClass().getName();
            String errMsg = suex.getLocalizedMessage();
            throw new PortalCommunicationException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(suex));
        }
        catch (NamingException e) {
            String sClass = e.getClass().getName();
            String errMsg = e.getLocalizedMessage();
            throw new PortalDirectoryException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(e));
        }
    }

    @Override
    public void renameObject(String sObjectDN, String sNewObjectDN) throws PortalDirectoryException {
        try {
            this.m_cx.rename(sObjectDN, sNewObjectDN);
        }
        catch (CommunicationException commex) {
            String soClass = commex.getClass().getName();
            String errMsg = commex.getLocalizedMessage();
            throw new PortalCommunicationException(soClass + "::" + errMsg, this.mapExceptionErrorCodes(commex));
        }
        catch (ServiceUnavailableException suex) {
            String sClass = suex.getClass().getName();
            String errMsg = suex.getLocalizedMessage();
            throw new PortalCommunicationException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(suex));
        }
        catch (NamingException e) {
            String sClass = e.getClass().getName();
            String errMsg = e.getLocalizedMessage();
            throw new PortalDirectoryException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(e));
        }
    }

    @Override
    public String normalizeObjectDN(String sObjectDN) throws PortalDirectoryException {
        String sRet = null;
        if (sObjectDN == null || sObjectDN.length() == 0) {
            return sObjectDN;
        }
        try {
            NameParser parser = this.m_cx.getNameParser("");
            Name dnName = parser.parse(sObjectDN);
            StringBuffer sb = new StringBuffer();
            for (int i = dnName.size() - 1; i >= 0; --i) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(dnName.get(i));
            }
            sRet = sb.toString();
        }
        catch (CommunicationException commex) {
            String soClass = commex.getClass().getName();
            String errMsg = commex.getLocalizedMessage();
            throw new PortalCommunicationException(soClass + "::" + errMsg, this.mapExceptionErrorCodes(commex));
        }
        catch (ServiceUnavailableException suex) {
            String sClass = suex.getClass().getName();
            String errMsg = suex.getLocalizedMessage();
            throw new PortalCommunicationException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(suex));
        }
        catch (NamingException e) {
            String sClass = e.getClass().getName();
            String errMsg = e.getLocalizedMessage();
            throw new PortalDirectoryException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(e));
        }
        return sRet;
    }

    @Override
    public boolean compareStringAttribute(String sObjectDN, String sAttribute, String sValue) throws PortalDirectoryException {
        boolean bRet = false;
        try {
            SearchControls sc = new SearchControls();
            sc.setSearchScope(0);
            sc.setReturningAttributes(new String[0]);
            StringBuffer sb = new StringBuffer("(");
            sb.append(sAttribute);
            sb.append("=");
            sb.append(sValue);
            sb.append(")");
            String sFilter = sb.toString();
            NamingEnumeration<SearchResult> ne = this.m_cx.search(sObjectDN, sFilter, sc);
            if (ne.hasMoreElements()) {
                bRet = true;
            }
        }
        catch (NamingException e) {
            Vector vObjList = this.readMultiStringAttribute(sObjectDN, sAttribute);
            if (vObjList != null && vObjList.size() != 0) {
                bRet = JNDIPortalDirectory.containsString(vObjList, sValue = this.normalizeObjectDN(sValue)) != null;
            }
            bRet = false;
        }
        return bRet;
    }

    @Override
    public boolean compareMultiStringAttribute(String sObjectDN, String sAttribute, Vector vValues) throws PortalDirectoryException {
        boolean bRet = false;
        try {
            SearchControls sc = new SearchControls();
            sc.setSearchScope(0);
            sc.setReturningAttributes(new String[0]);
            StringBuffer sb = new StringBuffer("(&");
            String sValue = null;
            for (int i = 0; i < vValues.size(); ++i) {
                sValue = (String)vValues.elementAt(i);
                sb.append("(");
                sb.append(sAttribute);
                sb.append("=");
                sb.append(sValue);
                sb.append(")");
            }
            sb.append(")");
            String sFilter = sb.toString();
            NamingEnumeration<SearchResult> ne = this.m_cx.search(sObjectDN, sFilter, sc);
            if (ne.hasMoreElements()) {
                bRet = true;
            }
        }
        catch (NamingException e) {
            bRet = false;
        }
        return bRet;
    }

    @Override
    public void setObjectPassword(String sObjectDN, String sOldPassword, String sNewPassword) throws PortalDirectoryException {
        ModificationItem[] mods = null;
        mods = sOldPassword != null ? new ModificationItem[]{new ModificationItem(3, new BasicAttribute("userPassword", sOldPassword)), new ModificationItem(1, new BasicAttribute("userPassword", sNewPassword))} : new ModificationItem[]{new ModificationItem(1, new BasicAttribute("userPassword", sNewPassword))};
        try {
            this.m_cx.modifyAttributes(sObjectDN, mods);
        }
        catch (CommunicationException commex) {
            String soClass = commex.getClass().getName();
            String errMsg = commex.getLocalizedMessage();
            throw new PortalCommunicationException(soClass + "::" + errMsg, this.mapExceptionErrorCodes(commex));
        }
        catch (ServiceUnavailableException suex) {
            String sClass = suex.getClass().getName();
            String errMsg = suex.getLocalizedMessage();
            throw new PortalCommunicationException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(suex));
        }
        catch (NamingException e) {
            String sClass = e.getClass().getName();
            String errMsg = e.getLocalizedMessage();
            throw new PortalDirectoryException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(e));
        }
    }

    @Override
    public Object getBaseConnection() throws PortalDirectoryException {
        return this.m_cx;
    }

    @Override
    public Hashtable getSchemaClassDefinition(String sClassname) throws PortalDirectoryException {
        Hashtable ht = null;
        try {
            if (this.m_cxSchema == null) {
                this.m_cxSchema = this.m_cx.getSchema("");
            }
            DirContext cxClass = null;
            if (sClassname.equals("*")) {
                ht = new Hashtable();
                NamingEnumeration<NameClassPair> bds = this.m_cxSchema.list("ClassDefinition");
                Vector<String> vValue = new Vector<String>();
                while (bds.hasMore()) {
                    vValue.add(bds.next().getName());
                }
                ht.put("SUP", vValue);
            } else {
                cxClass = (DirContext)this.m_cxSchema.lookup("ClassDefinition/" + sClassname);
                ht = this.buildSchemaAttributesTable(cxClass);
            }
        }
        catch (CommunicationException commex) {
            String soClass = commex.getClass().getName();
            String errMsg = commex.getLocalizedMessage();
            throw new PortalCommunicationException(soClass + "::" + errMsg, this.mapExceptionErrorCodes(commex));
        }
        catch (ServiceUnavailableException suex) {
            String sClass = suex.getClass().getName();
            String errMsg = suex.getLocalizedMessage();
            throw new PortalCommunicationException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(suex));
        }
        catch (NamingException ex) {
            String sClass = ex.getClass().getName();
            String errMsg = ex.getLocalizedMessage();
            throw new PortalDirectoryException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(ex));
        }
        return ht;
    }

    @Override
    public Hashtable getSchemaAttributeDefinition(String sAttrname) throws PortalDirectoryException {
        Hashtable ht = null;
        try {
            if (this.m_cxSchema == null) {
                this.m_cxSchema = this.m_cx.getSchema("");
            }
            DirContext cxClass = (DirContext)this.m_cxSchema.lookup("AttributeDefinition/" + sAttrname);
            ht = this.buildSchemaAttributesTable(cxClass);
        }
        catch (CommunicationException commex) {
            String soClass = commex.getClass().getName();
            String errMsg = commex.getLocalizedMessage();
            throw new PortalCommunicationException(soClass + "::" + errMsg, this.mapExceptionErrorCodes(commex));
        }
        catch (ServiceUnavailableException suex) {
            String sClass = suex.getClass().getName();
            String errMsg = suex.getLocalizedMessage();
            throw new PortalCommunicationException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(suex));
        }
        catch (NamingException ex) {
            String sClass = ex.getClass().getName();
            String errMsg = ex.getLocalizedMessage();
            throw new PortalDirectoryException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(ex));
        }
        return ht;
    }

    @Override
    public void setSchemaAttributeDefinition(String sAttrname, Hashtable htValues) throws PortalDirectoryException {
        String sAttrSchemaName = "AttributeDefinition/" + sAttrname;
        try {
            if (this.m_cxSchema == null) {
                this.m_cxSchema = this.m_cx.getSchema("");
            }
            try {
                this.m_cxSchema.lookup(sAttrSchemaName);
            }
            catch (NameNotFoundException nnfex) {
                BasicAttributes attrs = new BasicAttributes(true);
                String sName = null;
                Vector vValue = null;
                BasicAttribute baValue = null;
                Enumeration en = htValues.keys();
                while (en.hasMoreElements()) {
                    sName = (String)en.nextElement();
                    vValue = (Vector)htValues.get(sName);
                    if (vValue == null) continue;
                    baValue = new BasicAttribute(sName);
                    for (int i = 0; i < vValue.size(); ++i) {
                        baValue.add(vValue.elementAt(i));
                    }
                    attrs.put(baValue);
                }
                this.m_cxSchema.createSubcontext(sAttrSchemaName, (Attributes)attrs);
            }
        }
        catch (CommunicationException commex) {
            String soClass = commex.getClass().getName();
            String errMsg = commex.getLocalizedMessage();
            throw new PortalCommunicationException(soClass + "::" + errMsg, this.mapExceptionErrorCodes(commex));
        }
        catch (ServiceUnavailableException suex) {
            String sClass = suex.getClass().getName();
            String errMsg = suex.getLocalizedMessage();
            throw new PortalCommunicationException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(suex));
        }
        catch (NamingException ex) {
            String sClass = ex.getClass().getName();
            String errMsg = ex.getLocalizedMessage();
            throw new PortalDirectoryException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(ex));
        }
    }

    @Override
    public void setSchemaClassDefinition(String sClassname, Hashtable htValues) throws PortalDirectoryException {
        String sClassSchemaName = "ClassDefinition/" + sClassname;
        try {
            if (this.m_cxSchema == null) {
                this.m_cxSchema = this.m_cx.getSchema("");
            }
            try {
                DirContext cxClassDef = (DirContext)this.m_cxSchema.lookup(sClassSchemaName);
                Hashtable htCurrentValues = this.buildSchemaAttributesTable(cxClassDef);
                Hashtable htDesiredValues = this.mergeSchemaClass(htCurrentValues, htValues);
                if (!this.isEqualSchema(htCurrentValues, htDesiredValues)) {
                    String sCurrentSchema = this.buildSchemaClassString(htCurrentValues);
                    String sNewSchema = this.buildSchemaClassString(htDesiredValues);
                    String sSchemaDN = this.getSchemaDN();
                    this.replaceStringAttributeValue(sSchemaDN, "objectClasses", sCurrentSchema, sNewSchema);
                }
            }
            catch (NameNotFoundException nnfex) {
                String sNewSchema = this.buildSchemaClassString(htValues);
                String sSchemaDN = this.getSchemaDN();
                String[] saTemp = new String[]{sNewSchema};
                this.writeMultiStringAttribute(sSchemaDN, "objectClasses", saTemp, false);
            }
        }
        catch (CommunicationException commex) {
            String soClass = commex.getClass().getName();
            String errMsg = commex.getLocalizedMessage();
            throw new PortalCommunicationException(soClass + "::" + errMsg, this.mapExceptionErrorCodes(commex));
        }
        catch (ServiceUnavailableException suex) {
            String sClass = suex.getClass().getName();
            String errMsg = suex.getLocalizedMessage();
            throw new PortalCommunicationException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(suex));
        }
        catch (NamingException ex) {
            String sClass = ex.getClass().getName();
            String errMsg = ex.getLocalizedMessage();
            throw new PortalDirectoryException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(ex));
        }
    }

    @Override
    public int getEffectiveRights(String sObjectDN, String sTrusteeDN, String sAttribute) throws PortalDirectoryException {
        int iRet = 0;
        try {
            GetEffectiveRightsRequest req = new GetEffectiveRightsRequest(sObjectDN, sTrusteeDN, sAttribute);
            LdapContext ldapCx = (LdapContext)this.m_cx;
            GetEffectiveRightsResponse resp = (GetEffectiveRightsResponse)ldapCx.extendedOperation((ExtendedRequest)req);
            iRet = resp.getRights().getRights();
        }
        catch (IOException ioex) {
            String soClass = ioex.getClass().getName();
            String errMsg = ioex.getLocalizedMessage();
            throw new PortalCommunicationException(soClass + "::" + errMsg, this.mapExceptionErrorCodes(ioex));
        }
        catch (CommunicationException commex) {
            String soClass = commex.getClass().getName();
            String errMsg = commex.getLocalizedMessage();
            throw new PortalCommunicationException(soClass + "::" + errMsg, this.mapExceptionErrorCodes(commex));
        }
        catch (ServiceUnavailableException suex) {
            String sClass = suex.getClass().getName();
            String errMsg = suex.getLocalizedMessage();
            throw new PortalCommunicationException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(suex));
        }
        catch (NamingException ex) {
            String sClass = ex.getClass().getName();
            String errMsg = ex.getLocalizedMessage();
            throw new PortalDirectoryException(sClass + "::" + errMsg, this.mapExceptionErrorCodes(ex));
        }
        return iRet;
    }

    @Override
    public void addBinaryAttributes(Vector vAttrs) {
        if (vAttrs != null) {
            for (int i = 0; i < vAttrs.size(); ++i) {
                this.addBinaryAttr((String)vAttrs.elementAt(i));
            }
        }
    }

    private void addBinaryAttr(String sAttribute) {
        if (this.m_htBinaryAttrs.get(sAttribute) == null) {
            try {
                if (this.m_cx != null) {
                    Hashtable<?, ?> env = this.m_cx.getEnvironment();
                    String sBinaryAttrs = (String)env.get(ENV_BINARY_ATTRS);
                    if (sBinaryAttrs == null) {
                        sBinaryAttrs = "";
                    }
                    StringBuffer sb = new StringBuffer(sBinaryAttrs);
                    sb.append(" ");
                    sb.append(sAttribute);
                    sBinaryAttrs = sb.toString();
                    this.m_cx.addToEnvironment(ENV_BINARY_ATTRS, sBinaryAttrs);
                }
                this.m_htBinaryAttrs.put(sAttribute, sAttribute);
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
    }

    private void setBinaryAttributes() {
        try {
            if (this.m_cx != null) {
                StringBuffer sb = new StringBuffer();
                Enumeration en = this.m_htBinaryAttrs.keys();
                while (en.hasMoreElements()) {
                    sb.append(" ");
                    sb.append((String)en.nextElement());
                }
                this.m_cx.addToEnvironment(ENV_BINARY_ATTRS, sb.toString());
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    private Hashtable buildSchemaAttributesTable(DirContext cxItemSchema) throws NamingException {
        Hashtable ht = new Hashtable();
        Attributes attrs = cxItemSchema.getAttributes("");
        Attribute attr = null;
        String sName = null;
        Vector<String> vValue = null;
        String sTemp = null;
        NamingEnumeration<? extends Attribute> en = attrs.getAll();
        while (en.hasMore()) {
            attr = en.next();
            sName = attr.getID();
            vValue = new Vector<String>();
            for (int i = 0; i < attr.size(); ++i) {
                sTemp = (String)attr.get(i);
                if (sTemp == null) continue;
                vValue.add(sTemp);
            }
            ht.put(sName, vValue);
        }
        return ht;
    }

    private boolean isEqualSchema(Hashtable ht1, Hashtable ht2) {
        boolean bRet = true;
        if (ht1.size() == ht2.size()) {
            String sKey1 = null;
            Vector v1 = null;
            Vector v2 = null;
            Enumeration en1 = ht1.keys();
            while (en1.hasMoreElements()) {
                sKey1 = (String)en1.nextElement();
                v1 = (Vector)ht1.get(sKey1);
                v2 = (Vector)ht2.get(sKey1);
                if (v1 == null || v2 == null) {
                    bRet = false;
                } else if (v1.size() != v2.size()) {
                    bRet = false;
                } else {
                    if (sKey1.equals("DESC") || v1.containsAll(v2)) continue;
                    bRet = false;
                }
                break;
            }
        } else {
            bRet = false;
        }
        return bRet;
    }

    private String buildSchemaClassString(Hashtable htValues) {
        int i;
        StringBuffer sb = new StringBuffer();
        Vector vTemp = null;
        String sTemp = null;
        sb.append("( ");
        vTemp = (Vector)htValues.get("NUMERICOID");
        if (vTemp != null) {
            sb.append((String)vTemp.elementAt(0));
            sb.append(" ");
        }
        if ((vTemp = (Vector)htValues.get("NAME")) != null) {
            if (vTemp.size() == 1) {
                sb.append("NAME '");
                sb.append((String)vTemp.elementAt(0));
                sb.append("' ");
            } else {
                sb.append("NAME (");
                for (i = 0; i < vTemp.size(); ++i) {
                    sb.append(" '");
                    sb.append((String)vTemp.elementAt(i));
                    sb.append("'");
                }
                sb.append(" ) ");
            }
        }
        if ((vTemp = (Vector)htValues.get("DESC")) != null) {
            sb.append("DESC '");
            sb.append((String)vTemp.elementAt(0));
            sb.append("' ");
        }
        if ((vTemp = (Vector)htValues.get("OBSOLETE")) != null) {
            sb.append("OBSOLETE ");
        }
        if ((vTemp = (Vector)htValues.get("SUP")) != null) {
            if (vTemp.size() == 1) {
                sb.append("SUP ");
                sb.append((String)vTemp.elementAt(0));
                sb.append(" ");
            } else {
                sb.append("SUP (");
                for (i = 0; i < vTemp.size(); ++i) {
                    if (i == 0) {
                        sb.append(" ");
                    } else {
                        sb.append(" $ ");
                    }
                    sb.append((String)vTemp.elementAt(i));
                }
                sb.append(" ) ");
            }
        }
        if ((vTemp = (Vector)htValues.get("ABSTRACT")) != null) {
            sb.append("ABSTRACT ");
        }
        if ((vTemp = (Vector)htValues.get("STRUCTURAL")) != null) {
            sb.append("STRUCTURAL ");
        }
        if ((vTemp = (Vector)htValues.get("AUXILIARY")) != null) {
            sb.append("AUXILIARY ");
        }
        if ((vTemp = (Vector)htValues.get("MUST")) != null) {
            if (vTemp.size() == 1) {
                sb.append("MUST ");
                sb.append((String)vTemp.elementAt(0));
                sb.append(" ");
            } else {
                sb.append("MUST (");
                for (i = 0; i < vTemp.size(); ++i) {
                    if (i == 0) {
                        sb.append(" ");
                    } else {
                        sb.append(" $ ");
                    }
                    sb.append((String)vTemp.elementAt(i));
                }
                sb.append(" ) ");
            }
        }
        if ((vTemp = (Vector)htValues.get("MAY")) != null) {
            if (vTemp.size() == 1) {
                sb.append("MAY ");
                sb.append((String)vTemp.elementAt(0));
                sb.append(" ");
            } else {
                sb.append("MAY (");
                for (i = 0; i < vTemp.size(); ++i) {
                    if (i == 0) {
                        sb.append(" ");
                    } else {
                        sb.append(" $ ");
                    }
                    sb.append((String)vTemp.elementAt(i));
                }
                sb.append(" ) ");
            }
        }
        Enumeration en = htValues.keys();
        while (en.hasMoreElements()) {
            sTemp = (String)en.nextElement();
            if (!sTemp.startsWith("X-") || (vTemp = (Vector)htValues.get(sTemp)) == null) continue;
            if (vTemp.size() == 1) {
                sb.append(sTemp);
                sb.append(" '");
                sb.append((String)vTemp.elementAt(0));
                sb.append("' ");
                continue;
            }
            sb.append(sTemp);
            sb.append(" (");
            for (int i2 = 0; i2 < vTemp.size(); ++i2) {
                sb.append(" '");
                sb.append((String)vTemp.elementAt(i2));
                sb.append("'");
            }
            sb.append(" ) ");
        }
        sb.append(")");
        return sb.toString();
    }

    private Hashtable mergeSchemaClass(Hashtable htCurrentValues, Hashtable htNewValues) {
        int i;
        Hashtable<String, Object> htValues = new Hashtable<String, Object>();
        Vector vTemp = null;
        Vector vTempNew = null;
        String sTemp = null;
        String sAttr = null;
        Enumeration en = htCurrentValues.keys();
        while (en.hasMoreElements()) {
            sAttr = (String)en.nextElement();
            vTemp = (Vector)htCurrentValues.get(sAttr);
            htValues.put(sAttr, vTemp.clone());
        }
        String[] saSvAttrs = new String[]{"NUMERICOID", "DESC", "OBSOLETE", "ABSTRACT", "STRUCTURAL", "AUXILIARY"};
        for (int iAttr = 0; iAttr < saSvAttrs.length; ++iAttr) {
            sAttr = saSvAttrs[iAttr];
            vTemp = (Vector)htValues.get(sAttr);
            if (vTemp != null || (vTemp = (Vector)htNewValues.get(sAttr)) == null) continue;
            htValues.put(sAttr, vTemp);
        }
        String[] saMvAttrs = new String[]{"NAME", "SUP", "MUST", "MAY"};
        for (int iAttr = 0; iAttr < saMvAttrs.length; ++iAttr) {
            sAttr = saMvAttrs[iAttr];
            vTemp = (Vector)htValues.get(sAttr);
            if (vTemp == null) {
                vTemp = (Vector)htNewValues.get(sAttr);
                if (vTemp == null) continue;
                htValues.put(sAttr, vTemp);
                continue;
            }
            vTempNew = (Vector)htNewValues.get(sAttr);
            if (vTempNew == null) continue;
            for (i = 0; i < vTempNew.size(); ++i) {
                sTemp = (String)vTempNew.elementAt(i);
                if (JNDIPortalDirectory.containsString(vTemp, sTemp) != null) continue;
                vTemp.add(sTemp);
            }
        }
        Enumeration en2 = htValues.keys();
        while (en2.hasMoreElements()) {
            sAttr = (String)en2.nextElement();
            if (!sAttr.startsWith("X-")) continue;
            vTemp = (Vector)htValues.get(sAttr);
            if (vTemp == null) {
                vTemp = (Vector)htNewValues.get(sAttr);
                if (vTemp == null) continue;
                htValues.put(sAttr, vTemp);
                continue;
            }
            vTempNew = (Vector)htNewValues.get(sAttr);
            if (vTempNew == null) continue;
            for (i = 0; i < vTempNew.size(); ++i) {
                sTemp = (String)vTempNew.elementAt(i);
                if (JNDIPortalDirectory.containsString(vTemp, sTemp) != null) continue;
                vTemp.add(sTemp);
            }
        }
        return htValues;
    }

    private String getSchemaDN() throws PortalDirectoryException {
        if (this.m_sSchemaDN == null) {
            this.m_sSchemaDN = this.readStringAttribute("", "subschemaSubentry");
        }
        return this.m_sSchemaDN;
    }

    private Hashtable extractAttributeInfo(Attributes attrs) throws NamingException {
        Hashtable<String, PortalObjectAttribute> htRetAttributes = new Hashtable<String, PortalObjectAttribute>();
        if (attrs != null) {
            NamingEnumeration<? extends Attribute> ne = attrs.getAll();
            Attribute attr = null;
            String sName = null;
            Vector vData = null;
            PortalObjectAttribute poa = null;
            while (ne.hasMoreElements()) {
                attr = (Attribute)ne.nextElement();
                sName = attr.getID();
                NamingEnumeration<?> en = attr.getAll();
                vData = new Vector();
                while (en.hasMoreElements()) {
                    vData.add(en.nextElement());
                }
                int iType = 1;
                if (vData.size() > 0) {
                    boolean bString = vData.elementAt(0) instanceof String;
                    iType = vData.size() > 1 ? (bString ? 2 : 4) : (bString ? 1 : 3);
                }
                poa = new PortalObjectAttribute(sName, iType, vData);
                htRetAttributes.put(poa.getName(), poa);
            }
        }
        return htRetAttributes;
    }

    private int mapExceptionErrorCodes(Exception ex) {
        int iRet = 0;
        if (ex instanceof AttributeInUseException) {
            iRet = 20;
        } else if (ex instanceof AuthenticationNotSupportedException) {
            iRet = 7;
        } else if (ex instanceof NameAlreadyBoundException) {
            iRet = 68;
        } else if (ex instanceof AuthenticationException) {
            iRet = 8;
        } else if (ex instanceof InvalidSearchFilterException) {
            iRet = 18;
        } else if (ex instanceof NoPermissionException) {
            iRet = 50;
        } else if (ex instanceof InvalidAttributeValueException) {
            iRet = 19;
        } else if (ex instanceof NoSuchAttributeException) {
            iRet = 16;
        } else if (ex instanceof NameNotFoundException) {
            iRet = 32;
        } else if (ex instanceof SchemaViolationException) {
            iRet = 65;
        } else if (ex instanceof ContextNotEmptyException) {
            iRet = 66;
        } else if (ex instanceof CommunicationException) {
            iRet = 2;
        } else if (ex instanceof SizeLimitExceededException) {
            iRet = 4;
        } else if (ex instanceof TimeLimitExceededException) {
            iRet = 3;
        } else if (ex instanceof OperationNotSupportedException) {
            iRet = 12;
        } else if (ex instanceof ServiceUnavailableException) {
            iRet = 51;
        } else if (ex instanceof InvalidAttributeIdentifierException) {
            iRet = 17;
        } else if (ex instanceof LimitExceededException) {
            iRet = 11;
        } else if (ex instanceof InvalidNameException) {
            iRet = 34;
        }
        return iRet;
    }

    private static String containsString(Vector vStrings, String sString) {
        String sRet = null;
        String sTemp = null;
        Enumeration e = vStrings.elements();
        if (e != null) {
            while (e.hasMoreElements()) {
                sTemp = (String)e.nextElement();
                if (!sTemp.equals(sString)) continue;
                sRet = sTemp;
                break;
            }
        }
        return sRet;
    }

    private void readObject(ObjectInputStream s) throws IOException {
        try {
            s.defaultReadObject();
        }
        catch (ClassNotFoundException e) {
            D.log((Throwable)e);
        }
        this.m_bDisconnected = false;
    }
}

