/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.authentication;

import com.novell.emframe.dev.D;
import com.novell.emframe.dev.config.SystemConfig;
import com.novell.emframe.fw.AuditLog;
import com.novell.nps.authentication.AuthenticationManager;
import com.novell.nps.authentication.JNDIPortalDirectory;
import com.novell.nps.authentication.LoginException;
import com.novell.nps.authentication.LogoutException;
import com.novell.nps.authentication.PortalACL;
import com.novell.nps.authentication.PortalCommunicationException;
import com.novell.nps.authentication.PortalDirectory;
import com.novell.nps.authentication.PortalDirectoryException;
import com.novell.nps.authentication.PortalObjectAttribute;
import com.novell.nps.authentication.PortalVirtualSearch;
import com.novell.nps.configManager.AttrMapper;
import com.novell.nps.configManager.GUID;
import java.io.Serializable;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.Vector;

public class PortalConnection
implements PortalDirectory,
Serializable {
    public static final String CONFIG_RO_ATTRIBUTE = "bhConfig";
    public static final String CONFIG_RW_ATTRIBUTE = "bhConfigRW";
    public static final String CONFIG_SS_ATTRIBUTE = "bhConfigSecretStore";
    public static final String GUID_ATTRIBUTE = "bhObjectGUID";
    public static final String OBJECT_LIST_ATTRIBUTE = "bhObjectList";
    public static final String CLASS_NAME_ATTRIBUTE = "bhClassName";
    public static final String ARGUMENTS_ATTRIBUTE = "bhArguments";
    public static final String INSTANCE_CLASS_NAME_ATTRIBUTE = "bhInstanceClassName";
    public static final String INSTANCE_ARGUMENTS_ATTRIBUTE = "bhInstanceArguments";
    public static final String GADGET_NAME_ATTRIBUTE = "cn";
    public static final String VERSION_ATTRIBUTE = "bhVersion";
    public static final String PACKAGE_NAME_ATTRIBUTE = "bhPackageName";
    public static final String PORTAL_DN_ATTRIBUTE = "bhPortalDN";
    public static final String MODULE_LIST_ATTRIBUTE = "bhModuleList";
    public static final String GADGET_LIST_ATTRIBUTE = "bhGadgetList";
    public static final String PARENT_MODULE_LIST_ATTRIBUTE = "bhParentModuleList";
    public static final String CHILD_MODULE_LIST_ATTRIBUTE = "bhChildModuleList";
    public static final String TASK_LIST_ATTRIBUTE = "bhTaskList";
    public static final String COLLECTION_LIST_ATTRIBUTE = "bhCollectionList";
    public static final String PORTAL_DIRECTORY_CLASS = "bhPortal";
    public static final String GADGET_DIRECTORY_CLASS = "bhGadget";
    public static final String PORTAL_CONFIG_DIRECTORY_CLASS = "bhPortalConfig";
    public static final String MODULE_DIRECTORY_CLASS = "bhModule";
    public static final String COUNTRY_DIRECTORY_CLASS = "country";
    public static final String LOCALITY_DIRECTORY_CLASS = "locality";
    public static final String ORGANIZATION_DIRECTORY_CLASS = "organization";
    public static final String ORGANIZATIONAL_UNIT_DIRECTORY_CLASS = "organizationalUnit";
    public static final String USER_DIRECTORY_CLASS = "inetOrgPerson";
    public static final String DOMAIN_DIRECTORY_CLASS = "domain";
    public static final int RIGHTS_COMPARE = 1;
    public static final int RIGHTS_READ = 2;
    public static final int RIGHTS_WRITE = 4;
    public static final int RIGHTS_SELF = 8;
    public static final int RIGHTS_ATTR_SUPERVISOR = 32;
    public static final int RIGHTS_ATTR_INHERIT = 64;
    public static final int ENTRY_RIGHTS_BROWSE = 1;
    public static final int ENTRY_RIGHTS_ADD = 2;
    public static final int ENTRY_RIGHTS_CREATE = 2;
    public static final int ENTRY_RIGHTS_DELETE = 4;
    public static final int ENTRY_RIGHTS_RENAME = 8;
    public static final int ENTRY_RIGHTS_SUPERVISOR = 16;
    public static final String ALL_ATTRIBUTES_RIGHTS = "[All Attributes Rights]";
    public static final String ENTRY_RIGHTS = "[Entry Rights]";
    public static final int SEARCH_SCOPE_BASE = 0;
    public static final int SEARCH_SCOPE_ONE = 1;
    public static final int SEARCH_SCOPE_SUB = 2;
    public static final String CONNECTION_TIMEOUT = "Connection Timeout";
    public static final long DEFAULT_CONNECTION_TIMEOUT = 5000L;
    private static long m_lConnectionTimeout = 5000L;
    private String m_sUsername = null;
    private String m_sPassword = null;
    private String m_sDirectory = null;
    private boolean m_bUseSSL = false;
    private long m_lLastValid = 0L;
    private long m_lLastUsed = 0L;
    private long m_lValidateThreshold = 120000L;
    private boolean m_bPasswordExpired = false;
    private String m_sGraceRemaining = null;
    private int m_iRetryCount = 3;
    private PortalDirectory m_pd = new JNDIPortalDirectory();
    private transient ResourceBundle m_res = null;
    private static String m_sUserClass = "inetOrgPerson";

    public PortalConnection() {
        this.initConnectionTimeout();
    }

    public PortalConnection(String sDirectory, String sUsername, String sPassword) {
        this(sDirectory, sUsername, sPassword, false);
    }

    public PortalConnection(String sDirectory, String sUsername, String sPassword, boolean bUseSSL) {
        this.m_sUsername = sUsername;
        this.m_sPassword = sPassword;
        this.m_sDirectory = sDirectory;
        this.m_bUseSSL = bUseSSL;
        this.initConnectionTimeout();
    }

    protected void finalize() throws Throwable {
        D.log((String)("finalize::" + this.m_sUsername), (int)1);
        try {
            this.logout();
        }
        catch (LogoutException logoutException) {
            // empty catch block
        }
        super.finalize();
    }

    private void initConnectionTimeout() {
        SystemConfig sc = new SystemConfig();
        String sTemp = sc.getSetting(CONNECTION_TIMEOUT);
        if (sTemp != null) {
            try {
                m_lConnectionTimeout = Long.parseLong(sTemp);
                m_lConnectionTimeout *= 1000L;
            }
            catch (NumberFormatException ex) {
                m_lConnectionTimeout = 5000L;
            }
        }
    }

    public void login() throws LoginException {
        block13: {
            if (this.isAuthenticated()) {
                try {
                    this.unauthenticate();
                }
                catch (PortalDirectoryException portalDirectoryException) {
                    // empty catch block
                }
            }
            if (this.m_sDirectory == null || this.m_sDirectory.length() == 0) {
                ResourceBundle res = this.getResourceBundle();
                throw new LoginException(res.getString("No_directory"));
            }
            if (this.m_sUsername == null || this.m_sUsername.length() == 0) {
                ResourceBundle res = this.getResourceBundle();
                throw new LoginException(res.getString("No_user_name"));
            }
            if (this.m_sPassword == null || this.m_sPassword.length() == 0) {
                ResourceBundle res = this.getResourceBundle();
                throw new LoginException(res.getString("No_password_specified"));
            }
            try {
                this.authenticate(this.m_sDirectory, this.m_sUsername, this.m_sPassword, this.m_bUseSSL);
                this.m_lLastUsed = this.m_lLastValid = System.currentTimeMillis();
                if (this.m_sUsername == null || this.m_sPassword == null) break block13;
                try {
                    PortalObjectAttribute poa = null;
                    Vector<PortalObjectAttribute> vPOA = new Vector<PortalObjectAttribute>();
                    poa = new PortalObjectAttribute("loginGraceRemaining", 1, null);
                    vPOA.add(poa);
                    poa = new PortalObjectAttribute("loginGraceLimit", 1, null);
                    vPOA.add(poa);
                    this.readAttributes(this.m_sUsername, vPOA);
                    String sAttr = null;
                    Vector vData = null;
                    String sRemaining = null;
                    String sLimit = null;
                    for (int i = 0; i < vPOA.size(); ++i) {
                        poa = (PortalObjectAttribute)vPOA.elementAt(i);
                        vData = poa.getData();
                        if (vData == null) continue;
                        sAttr = poa.getName();
                        if (sAttr.equalsIgnoreCase("loginGraceRemaining")) {
                            if (vData.size() <= 0) continue;
                            sRemaining = (String)vData.elementAt(0);
                            continue;
                        }
                        if (!sAttr.equalsIgnoreCase("loginGraceLimit") || vData.size() <= 0) continue;
                        sLimit = (String)vData.elementAt(0);
                    }
                    if (sRemaining != null && sLimit != null && !sRemaining.equalsIgnoreCase(sLimit)) {
                        this.m_bPasswordExpired = true;
                        this.m_sGraceRemaining = sRemaining;
                    }
                }
                catch (PortalDirectoryException poa) {}
            }
            catch (PortalDirectoryException e) {
                String errMsg = e.getLocalizedMessage();
                LoginException lex = new LoginException(errMsg);
                lex.setErrorCode(e.getErrorCode());
                AuditLog.logFailedLogin((String)this.m_sUsername, (String)this.m_sDirectory, (boolean)true);
                throw lex;
            }
        }
        AuditLog.logSuccessfulLogin((String)this.m_sUsername, (String)this.m_sDirectory, (boolean)true);
    }

    public void logout() throws LogoutException {
        if (this.isAuthenticated()) {
            AuditLog.logLogout((String)this.m_sUsername, (String)this.m_sDirectory, (boolean)true);
            try {
                this.unauthenticate();
                this.m_sPassword = null;
                this.m_sDirectory = null;
                this.m_bUseSSL = false;
                this.m_lLastValid = 0L;
                this.m_lLastUsed = 0L;
                this.m_bPasswordExpired = false;
                this.m_sGraceRemaining = null;
            }
            catch (PortalDirectoryException e) {
                String errMsg = e.getLocalizedMessage();
                LogoutException lex = new LogoutException(errMsg);
                lex.setErrorCode(e.getErrorCode());
                throw lex;
            }
        }
    }

    public Properties getProperties() {
        Properties props = new Properties();
        if (null != this.m_sUsername) {
            props.setProperty("Username", this.m_sUsername);
        }
        if (null != this.m_sPassword) {
            props.setProperty("Password", this.m_sPassword);
        }
        if (this.m_bUseSSL) {
            props.setProperty("UseSSL", "true");
        }
        props.setProperty("Directory", this.m_sDirectory);
        return props;
    }

    public void setProperties(Properties properties) {
        String sTemp;
        this.m_sDirectory = properties.getProperty("Directory");
        this.m_sUsername = properties.getProperty("Username");
        this.m_sPassword = properties.getProperty("Password");
        String sGUID = properties.getProperty("GUID");
        if (sGUID != null) {
            GUID guidObject = new GUID(sGUID);
            this.m_sPassword = this.encodePassword(this.m_sPassword, guidObject);
        }
        if ((sTemp = properties.getProperty("UseSSL")) != null && sTemp.equalsIgnoreCase("true")) {
            this.m_bUseSSL = true;
        }
    }

    private PortalDirectory getDirectory() throws PortalDirectoryException {
        if (this.isAuthenticated()) {
            long lCurTime;
            if (this.isDisconnected()) {
                if (D.isDebugEnabled((int)1)) {
                    MessageFormat mf = new MessageFormat("Re-connecting: [{0}] to directory [{1}]");
                    D.log((String)mf.format(new Object[]{this.m_sUsername, this.m_sDirectory}), (int)1);
                }
                this.authenticate(this.m_sDirectory, this.m_sUsername, this.m_sPassword, this.m_bUseSSL);
                this.m_lLastValid = System.currentTimeMillis();
            }
            if ((lCurTime = System.currentTimeMillis()) - this.m_lLastValid > this.m_lValidateThreshold) {
                if (this.m_pd.isValid()) {
                    this.m_lLastValid = lCurTime;
                } else {
                    if (D.isDebugEnabled((int)1)) {
                        MessageFormat mf = new MessageFormat("Re-authenticating: [{0}] to directory [{1}]");
                        D.log((String)mf.format(new Object[]{this.m_sUsername, this.m_sDirectory}), (int)1);
                    }
                    this.authenticate(this.m_sDirectory, this.m_sUsername, this.m_sPassword, this.m_bUseSSL);
                    this.m_lLastValid = System.currentTimeMillis();
                }
            }
        } else {
            ResourceBundle res = this.getResourceBundle();
            throw new PortalDirectoryException(res.getString("Connection_is_not"));
        }
        this.m_lLastUsed = System.currentTimeMillis();
        return this.m_pd;
    }

    public void checkTimeout() throws PortalDirectoryException {
        long lCurTime;
        if (!this.isDisconnected() && !this.isPasswordExpired() && (lCurTime = System.currentTimeMillis()) - this.m_lLastUsed > m_lConnectionTimeout) {
            this.disconnect();
        }
    }

    public void setLastUsed(long lLastUsed) {
        this.m_lLastUsed = lLastUsed;
    }

    public String getObjectGUID(String sObject) throws PortalDirectoryException {
        byte[] baGUID = this.readByteArrayAttribute(sObject, GUID_ATTRIBUTE);
        String sObjectGUID = null;
        if (baGUID != null) {
            sObjectGUID = new String(baGUID);
        }
        return sObjectGUID;
    }

    public String getObjectType(String sObject) throws PortalDirectoryException {
        String sClass = this.readStringAttribute(sObject, "structuralObjectClass");
        return sClass;
    }

    public static String getObjectParent(String sObject) {
        String sParent = null;
        int index = -1;
        index = sObject.indexOf(44);
        sParent = index == -1 ? "" : sObject.substring(index + 1);
        return sParent;
    }

    public static String containsString(Vector vStrings, String sString) {
        String sRet = null;
        String sTemp = null;
        Enumeration e = vStrings.elements();
        if (e != null) {
            while (e.hasMoreElements()) {
                sTemp = (String)e.nextElement();
                if (!sTemp.equalsIgnoreCase(sString)) continue;
                sRet = sTemp;
                break;
            }
        }
        return sRet;
    }

    public void addAuxClass(String sObject, String sAttr) throws PortalDirectoryException {
        AttrMapper am = new AttrMapper();
        String sClass = am.findClass(sAttr);
        if (sClass != null && !this.compareStringAttribute(sObject, "objectClass", sClass)) {
            String[] sa = new String[]{sClass};
            this.writeMultiStringAttribute(sObject, "objectClass", sa, false);
        }
    }

    public void addAuxClasses(String sObject, String[] saAttrs) throws PortalDirectoryException {
        AttrMapper am = new AttrMapper();
        String sClass = null;
        Vector vClasses = new Vector();
        for (int i = 0; i < saAttrs.length; ++i) {
            sClass = am.findClass(saAttrs[i]);
            vClasses.add(sClass);
        }
        if (!this.compareMultiStringAttribute(sObject, "objectClass", vClasses)) {
            vClasses = this.readMultiStringAttribute(sObject, "objectClass");
            if (vClasses == null) {
                ResourceBundle res = this.getResourceBundle();
                throw new PortalDirectoryException(res.getString("Unable_to_read"));
            }
            boolean bWrite = false;
            Vector<String> vNewClasses = new Vector<String>();
            for (int i = 0; i < saAttrs.length; ++i) {
                sClass = am.findClass(saAttrs[i]);
                if (PortalConnection.containsString(vClasses, sClass) != null || PortalConnection.containsString(vNewClasses, sClass) != null) continue;
                vNewClasses.add(sClass);
                bWrite = true;
            }
            if (bWrite) {
                String[] sa = new String[vNewClasses.size()];
                for (int i = 0; i < vNewClasses.size(); ++i) {
                    sa[i] = (String)vNewClasses.elementAt(i);
                }
                this.writeMultiStringAttribute(sObject, "objectClass", sa, false);
            }
        }
    }

    public String setObjectGUID(String sObject) throws PortalDirectoryException {
        String sRetGUID = null;
        sRetGUID = this.getObjectGUID(sObject);
        if (sRetGUID == null) {
            D.log((String)("Set GUID for: " + sObject));
            String sClass = this.getObjectType(sObject);
            if (!(sClass == null || sClass.equals(PORTAL_DIRECTORY_CLASS) || sClass.equals(GADGET_DIRECTORY_CLASS) || sClass.equals(MODULE_DIRECTORY_CLASS))) {
                this.addAuxClass(sObject, GUID_ATTRIBUTE);
            }
            GUID guid = new GUID();
            String sGUID = guid.toString();
            byte[] baGUID = sGUID.getBytes();
            this.writeByteArrayAttribute(sObject, GUID_ATTRIBUTE, baGUID);
            sRetGUID = sGUID;
        }
        return sRetGUID;
    }

    public int readTrustee(String sObject, String sTrusteeObject, String sAttr, boolean bSubtree) throws PortalDirectoryException {
        int iCurRights = 0;
        Vector vACLs = this.readMultiStringAttribute(sObject, "ACL");
        if (vACLs == null) {
            vACLs = new Vector();
        }
        String sTemp = null;
        String sScope = null;
        sScope = bSubtree ? "subtree" : "entry";
        StringBuffer sb = new StringBuffer();
        sb.append("#");
        sb.append(sScope);
        sb.append("#");
        sb.append(sTrusteeObject);
        sb.append("#");
        sb.append(sAttr);
        String sSearch = sb.toString().toLowerCase();
        String sStr = null;
        Enumeration e = vACLs.elements();
        while (e.hasMoreElements()) {
            int i;
            sTemp = (String)e.nextElement();
            sStr = sTemp.toLowerCase();
            if (!sStr.endsWith(sSearch) || (i = sStr.indexOf(35)) == -1) continue;
            iCurRights = Integer.valueOf(sStr.substring(0, i));
            break;
        }
        return iCurRights;
    }

    public void addTrustee(String sObject, String sTrusteeObject, String sAttr, int iRights, boolean bSubtree, boolean bOverwrite) throws PortalDirectoryException {
        StringBuffer sb;
        Vector vACLs = this.readMultiStringAttribute(sObject, "ACL");
        if (vACLs == null) {
            vACLs = new Vector();
        }
        String sTemp = null;
        String sScope = null;
        String sReplaceACL = null;
        sScope = bSubtree ? "subtree" : "entry";
        if (!bOverwrite) {
            sb = new StringBuffer();
            sb.append("#");
            sb.append(sScope);
            sb.append("#");
            sb.append(sTrusteeObject);
            sb.append("#");
            sb.append(sAttr);
            String sSearch = sb.toString().toLowerCase();
            String sStr = null;
            Enumeration e = vACLs.elements();
            while (e.hasMoreElements()) {
                int i;
                sTemp = (String)e.nextElement();
                sStr = sTemp.toLowerCase();
                if (!sStr.endsWith(sSearch) || (i = sStr.indexOf(35)) == -1) continue;
                int iCurRights = Integer.valueOf(sStr.substring(0, i));
                iRights |= iCurRights;
                sReplaceACL = sStr;
                break;
            }
        }
        sb = new StringBuffer();
        sb.append(iRights);
        sb.append("#");
        sb.append(sScope);
        sb.append("#");
        sb.append(sTrusteeObject);
        sb.append("#");
        sb.append(sAttr);
        String sACL = sb.toString();
        if (PortalConnection.containsString(vACLs, sACL) == null) {
            if (sReplaceACL != null) {
                this.replaceStringAttributeValue(sObject, "ACL", sReplaceACL, sACL);
            } else {
                String[] sa = new String[]{sACL};
                this.writeMultiStringAttribute(sObject, "ACL", sa, false);
            }
        }
    }

    public void addTrustees(String sObject, String[] saTrusteeObject, String[] saAttr, int[] iaRights, boolean[] baSubtree, boolean[] baOverwrite) throws PortalDirectoryException {
        int iSize = saTrusteeObject.length;
        Vector vACLs = this.readMultiStringAttribute(sObject, "ACL");
        if (vACLs == null) {
            vACLs = new Vector();
        }
        boolean bWriteIt = false;
        String sScope = null;
        String sTemp = null;
        Vector<String> vAddACLs = new Vector<String>();
        StringBuffer sb = null;
        String sSearch = null;
        String sStr = null;
        for (int i = 0; i < iSize; ++i) {
            sScope = baSubtree[i] ? "subtree" : "entry";
            if (!baOverwrite[i]) {
                sb = new StringBuffer();
                sb.append("#");
                sb.append(sScope);
                sb.append("#");
                sb.append(saTrusteeObject[i]);
                sb.append("#");
                sb.append(saAttr[i]);
                sSearch = sb.toString().toLowerCase();
                Enumeration e = vACLs.elements();
                while (e.hasMoreElements()) {
                    int index;
                    sTemp = (String)e.nextElement();
                    sStr = sTemp.toLowerCase();
                    if (!sStr.endsWith(sSearch) || (index = sStr.indexOf(35)) == -1) continue;
                    int iCurRights = Integer.valueOf(sStr.substring(0, index));
                    int n = i;
                    iaRights[n] = iaRights[n] | iCurRights;
                    break;
                }
            }
            sb = new StringBuffer();
            sb.append(iaRights[i]);
            sb.append("#");
            sb.append(sScope);
            sb.append("#");
            sb.append(saTrusteeObject[i]);
            sb.append("#");
            sb.append(saAttr[i]);
            String sACL = sb.toString();
            if (PortalConnection.containsString(vACLs, sACL) != null) continue;
            sb = new StringBuffer();
            sb.append("Add Trustee to: ");
            sb.append(sObject);
            sb.append(" for: ");
            sb.append(sACL);
            D.log((String)sb.toString());
            if (PortalConnection.containsString(vAddACLs, sACL) != null) continue;
            vAddACLs.add(sACL);
            bWriteIt = true;
        }
        if (bWriteIt) {
            String[] sa = new String[vAddACLs.size()];
            for (int i = 0; i < vAddACLs.size(); ++i) {
                sa[i] = (String)vAddACLs.elementAt(i);
            }
            this.writeMultiStringAttribute(sObject, "ACL", sa, false);
        }
    }

    public void addTrustees(String sObject, PortalACL[] pa) throws PortalDirectoryException {
        int iSize = pa.length;
        Vector vACLs = this.readMultiStringAttribute(sObject, "ACL");
        if (vACLs == null) {
            vACLs = new Vector();
        }
        boolean bWriteIt = false;
        String sScope = null;
        String sTemp = null;
        Vector<String> vAddACLs = new Vector<String>();
        StringBuffer sb = null;
        String sSearch = null;
        String sStr = null;
        for (int i = 0; i < iSize; ++i) {
            sScope = pa[i].getSubtree() ? "subtree" : "entry";
            int iDesiredRights = pa[i].getRights();
            if (!pa[i].getOverwrite()) {
                sb = new StringBuffer();
                sb.append("#");
                sb.append(sScope);
                sb.append("#");
                sb.append(pa[i].getObject());
                sb.append("#");
                sb.append(pa[i].getAttribute());
                sSearch = sb.toString().toLowerCase();
                Enumeration e = vACLs.elements();
                while (e.hasMoreElements()) {
                    int index;
                    sTemp = (String)e.nextElement();
                    sStr = sTemp.toLowerCase();
                    if (!sStr.endsWith(sSearch) || (index = sStr.indexOf(35)) == -1) continue;
                    int iCurRights = Integer.valueOf(sStr.substring(0, index));
                    iDesiredRights |= iCurRights;
                    break;
                }
            }
            sb = new StringBuffer();
            sb.append(iDesiredRights);
            sb.append("#");
            sb.append(sScope);
            sb.append("#");
            sb.append(pa[i].getObject());
            sb.append("#");
            sb.append(pa[i].getAttribute());
            String sACL = sb.toString();
            if (PortalConnection.containsString(vACLs, sACL) != null) continue;
            sb = new StringBuffer();
            sb.append("Add Trustee to: ");
            sb.append(sObject);
            sb.append(" for: ");
            sb.append(sACL);
            D.log((String)sb.toString());
            if (PortalConnection.containsString(vAddACLs, sACL) != null) continue;
            vAddACLs.add(sACL);
            bWriteIt = true;
        }
        if (bWriteIt) {
            String[] sa = new String[vAddACLs.size()];
            for (int i = 0; i < vAddACLs.size(); ++i) {
                sa[i] = (String)vAddACLs.elementAt(i);
            }
            this.writeMultiStringAttribute(sObject, "ACL", sa, false);
        }
    }

    public void removeTrustee(String sObject, String sTrusteeObject, String sAttr, boolean bSubtree) throws PortalDirectoryException {
        Vector vACLs = this.readMultiStringAttribute(sObject, "ACL");
        if (vACLs != null && vACLs.size() > 0) {
            String sScope = null;
            sScope = bSubtree ? "subtree" : "entry";
            StringBuffer sb = new StringBuffer();
            sb.append("#");
            sb.append(sScope);
            sb.append("#");
            sb.append(sTrusteeObject);
            sb.append("#");
            sb.append(sAttr);
            String sSearch = sb.toString().toLowerCase();
            String sTemp = null;
            String sStr = null;
            Enumeration e = vACLs.elements();
            while (e.hasMoreElements()) {
                sTemp = (String)e.nextElement();
                sStr = sTemp.toLowerCase();
                if (!sStr.endsWith(sSearch)) continue;
                this.removeStringAttribute(sObject, "ACL", sTemp);
                break;
            }
        }
    }

    public void removeTrustee(String sObject, String sTrusteeObject, boolean bSubtree) throws PortalDirectoryException {
        Vector vACLs = this.readMultiStringAttribute(sObject, "ACL");
        if (vACLs != null && vACLs.size() > 0) {
            String sScope = null;
            sScope = bSubtree ? "subtree" : "entry";
            StringBuffer sb = new StringBuffer();
            sb.append("#");
            sb.append(sScope);
            sb.append("#");
            sb.append(sTrusteeObject);
            sb.append("#");
            String sSearch = sb.toString().toLowerCase();
            String sTemp = null;
            String sStr = null;
            Enumeration e = vACLs.elements();
            while (e.hasMoreElements()) {
                sTemp = (String)e.nextElement();
                sStr = sTemp.toLowerCase();
                if (sStr.indexOf(sSearch) == -1) continue;
                this.removeStringAttribute(sObject, "ACL", sTemp);
            }
        }
    }

    public boolean verifyObjectClass(String sObject, String sClass) throws PortalDirectoryException {
        boolean bRet = false;
        Vector vClasses = this.readMultiStringAttribute(sObject, "objectClass");
        if (PortalConnection.containsString(vClasses, sClass) != null) {
            bRet = true;
        }
        return bRet;
    }

    public void linkObjects(String sObject1, String sObject2) throws PortalDirectoryException {
        this.linkObjects(sObject1, OBJECT_LIST_ATTRIBUTE, sObject2, OBJECT_LIST_ATTRIBUTE, true);
    }

    public void linkObjects(String sObject1, String sAttr1, String sObject2, String sAttr2, boolean bGrantRights) throws PortalDirectoryException {
        String[] sa;
        String sClass;
        if (!this.compareStringAttribute(sObject1, sAttr1, sObject2)) {
            sClass = this.getObjectType(sObject1);
            if (!(sClass == null || sClass.equals(PORTAL_DIRECTORY_CLASS) || sClass.equals(GADGET_DIRECTORY_CLASS) || sClass.equals(MODULE_DIRECTORY_CLASS))) {
                this.addAuxClass(sObject1, sAttr1);
            }
            sa = new String[]{sObject2};
            this.writeMultiStringAttribute(sObject1, sAttr1, sa, false);
        }
        if (!this.compareStringAttribute(sObject2, sAttr2, sObject1)) {
            sClass = this.getObjectType(sObject2);
            if (!(sClass == null || sClass.equals(PORTAL_DIRECTORY_CLASS) || sClass.equals(GADGET_DIRECTORY_CLASS) || sClass.equals(MODULE_DIRECTORY_CLASS))) {
                this.addAuxClass(sObject2, sAttr2);
            }
            sa = new String[]{sObject1};
            this.writeMultiStringAttribute(sObject2, sAttr2, sa, false);
        }
        if (bGrantRights) {
            this.addTrustee(sObject2, sObject1, ALL_ATTRIBUTES_RIGHTS, 2, false, false);
        }
    }

    public void linkObjects(String sObject1, String sAttr1, String[] saObjects, String sAttr2, boolean bGrantRights) throws PortalDirectoryException {
        String sClass = this.getObjectType(sObject1);
        if (!(sClass == null || sClass.equals(PORTAL_DIRECTORY_CLASS) || sClass.equals(GADGET_DIRECTORY_CLASS) || sClass.equals(MODULE_DIRECTORY_CLASS))) {
            this.addAuxClass(sObject1, sAttr1);
        }
        Vector<String> vAdd = new Vector<String>();
        for (int i = 0; i < saObjects.length; ++i) {
            if (!this.compareStringAttribute(sObject1, sAttr1, saObjects[i])) {
                vAdd.add(saObjects[i]);
            }
            if (!this.compareStringAttribute(saObjects[i], sAttr2, sObject1)) {
                sClass = this.getObjectType(saObjects[i]);
                if (!(sClass == null || sClass.equals(PORTAL_DIRECTORY_CLASS) || sClass.equals(GADGET_DIRECTORY_CLASS) || sClass.equals(MODULE_DIRECTORY_CLASS))) {
                    this.addAuxClass(saObjects[i], sAttr2);
                }
                String[] sa = new String[]{sObject1};
                this.writeMultiStringAttribute(saObjects[i], sAttr2, sa, false);
            }
            if (!bGrantRights) continue;
            this.addTrustee(saObjects[i], sObject1, ALL_ATTRIBUTES_RIGHTS, 2, false, false);
        }
        if (vAdd.size() > 0) {
            String[] sa = new String[vAdd.size()];
            vAdd.toArray(sa);
            this.writeMultiStringAttribute(sObject1, sAttr1, sa, false);
        }
    }

    public void unlinkObjects(String sObject1, String sObject2) throws PortalDirectoryException {
        this.unlinkObjects(sObject1, OBJECT_LIST_ATTRIBUTE, sObject2, OBJECT_LIST_ATTRIBUTE);
    }

    public void unlinkObjects(String sObject1, String sAttr1, String sObject2, String sAttr2) throws PortalDirectoryException {
        Vector vObjList1 = this.readMultiStringAttribute(sObject1, sAttr1);
        Vector vObjList2 = this.readMultiStringAttribute(sObject2, sAttr2);
        if (PortalConnection.containsString(vObjList1, sObject2 = this.normalizeObjectDN(sObject2)) != null) {
            this.removeStringAttribute(sObject1, sAttr1, sObject2);
        }
        if (PortalConnection.containsString(vObjList2, sObject1 = this.normalizeObjectDN(sObject1)) != null) {
            this.removeStringAttribute(sObject2, sAttr2, sObject1);
        }
        this.removeTrustee(sObject2, sObject1, ALL_ATTRIBUTES_RIGHTS, false);
    }

    public boolean isPasswordExpired() {
        return this.m_bPasswordExpired;
    }

    public void setPasswordExpired(boolean bPasswordExpired) {
        this.m_bPasswordExpired = bPasswordExpired;
    }

    public String getGraceRemaining() {
        return this.m_sGraceRemaining;
    }

    private String encodePassword(String sPassword, GUID guid) {
        byte[] baPassword = sPassword.getBytes();
        byte[] baGUID = guid.bytes();
        for (int i = 0; i < 8; ++i) {
            int n = i;
            baGUID[n] = (byte)(baGUID[n] ^ baGUID[i + 8]);
        }
        int iLen = baPassword.length;
        for (int i = 0; i < iLen; ++i) {
            int n = i;
            baPassword[n] = (byte)(baPassword[n] ^ baGUID[i % 8]);
        }
        String sEncodedPassword = "";
        for (int i = 0; i < iLen; ++i) {
            sEncodedPassword = sEncodedPassword + GUID.byteAsHexString(baPassword[i]);
        }
        return sEncodedPassword.toUpperCase();
    }

    public boolean verifyPassword(String sObjectDN, String sPassword) throws PortalDirectoryException {
        return this.verifyPassword(sObjectDN, sPassword, null);
    }

    public boolean verifyPassword(String sObjectDN, String sPassword, String sGUID) throws PortalDirectoryException {
        if (sGUID != null) {
            GUID guidObject = new GUID(sGUID);
            sPassword = this.encodePassword(sPassword, guidObject);
        }
        return this.compareStringAttribute(sObjectDN, "userPassword", sPassword);
    }

    public void setPassword(String sObjectDN, String sOldPassword, String sNewPassword) throws PortalDirectoryException {
        this.setPassword(sObjectDN, sOldPassword, sNewPassword, null);
    }

    public void setPassword(String sObjectDN, String sOldPassword, String sNewPassword, String sGUID) throws PortalDirectoryException {
        if (sGUID != null) {
            GUID guidObject = new GUID(sGUID);
            if (sOldPassword != null) {
                sOldPassword = this.encodePassword(sOldPassword, guidObject);
            }
            sNewPassword = this.encodePassword(sNewPassword, guidObject);
        }
        this.setObjectPassword(sObjectDN, sOldPassword, sNewPassword);
    }

    public void setEncryptedAttribute(String sObjectDN, String sAttribute, String sValue) throws PortalDirectoryException {
        String sGUID = this.getObjectGUID(sObjectDN);
        GUID guidObject = new GUID(sGUID);
        String sEncryptedValue = this.encodePassword(sValue, guidObject);
        this.writeStringAttribute(sObjectDN, sAttribute, sEncryptedValue);
    }

    public boolean verifyEncryptedAttribute(String sObjectDN, String sAttribute, String sValue) throws PortalDirectoryException {
        boolean bRet = false;
        String sGUID = this.getObjectGUID(sObjectDN);
        GUID guidObject = new GUID(sGUID);
        String sEncryptedValue = this.encodePassword(sValue, guidObject);
        bRet = this.compareStringAttribute(sObjectDN, sAttribute, sEncryptedValue);
        return bRet;
    }

    public static void initSSLProvider() {
    }

    public String getUsername() {
        return this.m_sUsername;
    }

    public String getDirectoryAddress() {
        return this.m_sDirectory;
    }

    public void setConnectionPassword(String sPassword) {
        this.m_sPassword = sPassword;
    }

    public static String escapeFilterStringValue(String sValue) {
        StringBuffer sb = new StringBuffer();
        char[] ca = sValue.toCharArray();
        String sTemp = null;
        for (int i = 0; i < ca.length; ++i) {
            if (ca[i] == '*' || ca[i] == '(' || ca[i] == ')' || ca[i] == '\\' || ca[i] == '#' || ca[i] == '/' || ca[i] == '\"') {
                char iVal = ca[i];
                sb.append("\\");
                sTemp = Integer.toHexString(iVal);
                sb.append(sTemp);
                continue;
            }
            sb.append(ca[i]);
        }
        return sb.toString();
    }

    public void validateDirectoryVersion() throws PortalDirectoryException {
        String sVendor = null;
        String sVersion = null;
        boolean bThrow = true;
        try {
            sVendor = this.readStringAttribute("", "vendorName");
            sVersion = this.readStringAttribute("", "vendorVersion");
        }
        catch (PortalDirectoryException portalDirectoryException) {
            // empty catch block
        }
        if (sVendor != null && sVersion != null && sVendor.indexOf("Novell") != -1) {
            int indexEnd = -1;
            int indexStart = sVersion.indexOf(40);
            if (indexStart != -1) {
                if ((indexEnd = sVersion.indexOf(41, ++indexStart)) == -1) {
                    indexEnd = sVersion.length();
                }
            } else {
                indexStart = 0;
                indexEnd = sVersion.length();
            }
            String sBuildVersion = sVersion.substring(indexStart, indexEnd);
            int index = sBuildVersion.indexOf(46);
            if (index != -1) {
                String sTemp = sBuildVersion.substring(0, index);
                try {
                    int iVer = Integer.parseInt(sTemp);
                    if (iVer >= 85 && iVer < 100) {
                        bThrow = false;
                    } else if (iVer >= 10300) {
                        bThrow = false;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if (bThrow) {
            ResourceBundle res = this.getResourceBundle();
            MessageFormat mf = new MessageFormat(res.getString("Invalid_version_0_1_"));
            String sMsg = mf.format(new Object[]{sVendor, sVersion});
            throw new PortalDirectoryException(sMsg);
        }
    }

    public void extendSchema() throws PortalDirectoryException {
        Hashtable htValues = null;
        Vector<String> vValues = null;
        String sAttrName = null;
        String sClassName = null;
        htValues = new Hashtable();
        sAttrName = CONFIG_RO_ATTRIBUTE;
        vValues = new Vector<String>();
        vValues.add("2.16.840.1.113719.1.200.4.1");
        htValues.put("NUMERICOID", vValues);
        vValues = new Vector();
        vValues.add(sAttrName);
        htValues.put("NAME", vValues);
        vValues = new Vector();
        vValues.add("NPS Attribute: Generic configuration store");
        htValues.put("DESC", vValues);
        vValues = new Vector();
        vValues.add("1.3.6.1.4.1.1466.115.121.1.40");
        htValues.put("SYNTAX", vValues);
        vValues = new Vector();
        vValues.add("1");
        htValues.put("X-NDS_NOT_SCHED_SYNC_IMMEDIATE", vValues);
        this.setSchemaAttributeDefinition(sAttrName, htValues);
        htValues = new Hashtable();
        sAttrName = CONFIG_RW_ATTRIBUTE;
        vValues = new Vector();
        vValues.add("2.16.840.1.113719.1.200.4.2");
        htValues.put("NUMERICOID", vValues);
        vValues = new Vector();
        vValues.add(sAttrName);
        htValues.put("NAME", vValues);
        vValues = new Vector();
        vValues.add("NPS Attribute: Read/write configuration store");
        htValues.put("DESC", vValues);
        vValues = new Vector();
        vValues.add("1.3.6.1.4.1.1466.115.121.1.40");
        htValues.put("SYNTAX", vValues);
        vValues = new Vector();
        vValues.add("1");
        htValues.put("X-NDS_NOT_SCHED_SYNC_IMMEDIATE", vValues);
        this.setSchemaAttributeDefinition(sAttrName, htValues);
        htValues = new Hashtable();
        sAttrName = CONFIG_SS_ATTRIBUTE;
        vValues = new Vector();
        vValues.add("2.16.840.1.113719.1.200.4.3");
        htValues.put("NUMERICOID", vValues);
        vValues = new Vector();
        vValues.add(sAttrName);
        htValues.put("NAME", vValues);
        vValues = new Vector();
        vValues.add("NPS Attribute: Secret configuration store");
        htValues.put("DESC", vValues);
        vValues = new Vector();
        vValues.add("1.3.6.1.4.1.1466.115.121.1.40");
        htValues.put("SYNTAX", vValues);
        vValues = new Vector();
        vValues.add("1");
        htValues.put("X-NDS_NOT_SCHED_SYNC_IMMEDIATE", vValues);
        this.setSchemaAttributeDefinition(sAttrName, htValues);
        htValues = new Hashtable();
        sAttrName = GUID_ATTRIBUTE;
        vValues = new Vector();
        vValues.add("2.16.840.1.113719.1.200.4.4");
        htValues.put("NUMERICOID", vValues);
        vValues = new Vector();
        vValues.add(sAttrName);
        htValues.put("NAME", vValues);
        vValues = new Vector();
        vValues.add("NPS Attribute: Object GUID");
        htValues.put("DESC", vValues);
        vValues = new Vector();
        vValues.add("1.3.6.1.4.1.1466.115.121.1.40");
        htValues.put("SYNTAX", vValues);
        vValues = new Vector();
        vValues.add("true");
        htValues.put("SINGLE-VALUE", vValues);
        vValues = new Vector();
        vValues.add("1");
        htValues.put("X-NDS_NOT_SCHED_SYNC_IMMEDIATE", vValues);
        this.setSchemaAttributeDefinition(sAttrName, htValues);
        htValues = new Hashtable();
        sAttrName = OBJECT_LIST_ATTRIBUTE;
        vValues = new Vector();
        vValues.add("2.16.840.1.113719.1.200.4.5");
        htValues.put("NUMERICOID", vValues);
        vValues = new Vector();
        vValues.add(sAttrName);
        htValues.put("NAME", vValues);
        vValues = new Vector();
        vValues.add("NPS Attribute: Object list");
        htValues.put("DESC", vValues);
        vValues = new Vector();
        vValues.add("1.3.6.1.4.1.1466.115.121.1.12");
        htValues.put("SYNTAX", vValues);
        vValues = new Vector();
        vValues.add("1");
        htValues.put("X-NDS_NOT_SCHED_SYNC_IMMEDIATE", vValues);
        this.setSchemaAttributeDefinition(sAttrName, htValues);
        htValues = new Hashtable();
        sAttrName = CLASS_NAME_ATTRIBUTE;
        vValues = new Vector();
        vValues.add("2.16.840.1.113719.1.200.4.6");
        htValues.put("NUMERICOID", vValues);
        vValues = new Vector();
        vValues.add(sAttrName);
        htValues.put("NAME", vValues);
        vValues = new Vector();
        vValues.add("NPS Attribute: Initial Java class name");
        htValues.put("DESC", vValues);
        vValues = new Vector();
        vValues.add("1.3.6.1.4.1.1466.115.121.1.15");
        htValues.put("SYNTAX", vValues);
        vValues = new Vector();
        vValues.add("true");
        htValues.put("SINGLE-VALUE", vValues);
        vValues = new Vector();
        vValues.add("1");
        htValues.put("X-NDS_NOT_SCHED_SYNC_IMMEDIATE", vValues);
        this.setSchemaAttributeDefinition(sAttrName, htValues);
        htValues = new Hashtable();
        sAttrName = ARGUMENTS_ATTRIBUTE;
        vValues = new Vector();
        vValues.add("2.16.840.1.113719.1.200.4.7");
        htValues.put("NUMERICOID", vValues);
        vValues = new Vector();
        vValues.add(sAttrName);
        htValues.put("NAME", vValues);
        vValues = new Vector();
        vValues.add("NPS Attribute: Arguments for initial Java class");
        htValues.put("DESC", vValues);
        vValues = new Vector();
        vValues.add("1.3.6.1.4.1.1466.115.121.1.15");
        htValues.put("SYNTAX", vValues);
        vValues = new Vector();
        vValues.add("1");
        htValues.put("X-NDS_NOT_SCHED_SYNC_IMMEDIATE", vValues);
        this.setSchemaAttributeDefinition(sAttrName, htValues);
        htValues = new Hashtable();
        sAttrName = INSTANCE_CLASS_NAME_ATTRIBUTE;
        vValues = new Vector();
        vValues.add("2.16.840.1.113719.1.200.4.8");
        htValues.put("NUMERICOID", vValues);
        vValues = new Vector();
        vValues.add(sAttrName);
        htValues.put("NAME", vValues);
        vValues = new Vector();
        vValues.add("NPS Attribute: Instance Java class name");
        htValues.put("DESC", vValues);
        vValues = new Vector();
        vValues.add("1.3.6.1.4.1.1466.115.121.1.15");
        htValues.put("SYNTAX", vValues);
        vValues = new Vector();
        vValues.add("true");
        htValues.put("SINGLE-VALUE", vValues);
        vValues = new Vector();
        vValues.add("1");
        htValues.put("X-NDS_NOT_SCHED_SYNC_IMMEDIATE", vValues);
        this.setSchemaAttributeDefinition(sAttrName, htValues);
        htValues = new Hashtable();
        sAttrName = INSTANCE_ARGUMENTS_ATTRIBUTE;
        vValues = new Vector();
        vValues.add("2.16.840.1.113719.1.200.4.9");
        htValues.put("NUMERICOID", vValues);
        vValues = new Vector();
        vValues.add(sAttrName);
        htValues.put("NAME", vValues);
        vValues = new Vector();
        vValues.add("NPS Attribute: Arguments for instance Java class");
        htValues.put("DESC", vValues);
        vValues = new Vector();
        vValues.add("1.3.6.1.4.1.1466.115.121.1.15");
        htValues.put("SYNTAX", vValues);
        vValues = new Vector();
        vValues.add("1");
        htValues.put("X-NDS_NOT_SCHED_SYNC_IMMEDIATE", vValues);
        this.setSchemaAttributeDefinition(sAttrName, htValues);
        htValues = new Hashtable();
        sAttrName = VERSION_ATTRIBUTE;
        vValues = new Vector();
        vValues.add("2.16.840.1.113719.1.200.4.10");
        htValues.put("NUMERICOID", vValues);
        vValues = new Vector();
        vValues.add(sAttrName);
        htValues.put("NAME", vValues);
        vValues = new Vector();
        vValues.add("NPS Attribute: Version string for NPS component");
        htValues.put("DESC", vValues);
        vValues = new Vector();
        vValues.add("1.3.6.1.4.1.1466.115.121.1.15");
        htValues.put("SYNTAX", vValues);
        vValues = new Vector();
        vValues.add("true");
        htValues.put("SINGLE-VALUE", vValues);
        vValues = new Vector();
        vValues.add("1");
        htValues.put("X-NDS_NOT_SCHED_SYNC_IMMEDIATE", vValues);
        this.setSchemaAttributeDefinition(sAttrName, htValues);
        htValues = new Hashtable();
        sAttrName = PACKAGE_NAME_ATTRIBUTE;
        vValues = new Vector();
        vValues.add("2.16.840.1.113719.1.200.4.12");
        htValues.put("NUMERICOID", vValues);
        vValues = new Vector();
        vValues.add(sAttrName);
        htValues.put("NAME", vValues);
        vValues = new Vector();
        vValues.add("NPS Attribute: Package file name");
        htValues.put("DESC", vValues);
        vValues = new Vector();
        vValues.add("1.3.6.1.4.1.1466.115.121.1.15");
        htValues.put("SYNTAX", vValues);
        vValues = new Vector();
        vValues.add("true");
        htValues.put("SINGLE-VALUE", vValues);
        vValues = new Vector();
        vValues.add("1");
        htValues.put("X-NDS_NOT_SCHED_SYNC_IMMEDIATE", vValues);
        this.setSchemaAttributeDefinition(sAttrName, htValues);
        htValues = new Hashtable();
        sAttrName = PORTAL_DN_ATTRIBUTE;
        vValues = new Vector();
        vValues.add("2.16.840.1.113719.1.200.4.15");
        htValues.put("NUMERICOID", vValues);
        vValues = new Vector();
        vValues.add(sAttrName);
        htValues.put("NAME", vValues);
        vValues = new Vector();
        vValues.add("NPS Attribute: Distinguished name of the portal this object is registered in.");
        htValues.put("DESC", vValues);
        vValues = new Vector();
        vValues.add("1.3.6.1.4.1.1466.115.121.1.12");
        htValues.put("SYNTAX", vValues);
        vValues = new Vector();
        vValues.add("true");
        htValues.put("SINGLE-VALUE", vValues);
        vValues = new Vector();
        vValues.add("1");
        htValues.put("X-NDS_NOT_SCHED_SYNC_IMMEDIATE", vValues);
        this.setSchemaAttributeDefinition(sAttrName, htValues);
        htValues = new Hashtable();
        sAttrName = MODULE_LIST_ATTRIBUTE;
        vValues = new Vector();
        vValues.add("2.16.840.1.113719.1.200.4.31");
        htValues.put("NUMERICOID", vValues);
        vValues = new Vector();
        vValues.add(sAttrName);
        htValues.put("NAME", vValues);
        vValues = new Vector();
        vValues.add("NPS Attribute: List of NPS modules linked to a module/gadget/portal");
        htValues.put("DESC", vValues);
        vValues = new Vector();
        vValues.add("1.3.6.1.4.1.1466.115.121.1.12");
        htValues.put("SYNTAX", vValues);
        vValues = new Vector();
        vValues.add("1");
        htValues.put("X-NDS_NOT_SCHED_SYNC_IMMEDIATE", vValues);
        this.setSchemaAttributeDefinition(sAttrName, htValues);
        htValues = new Hashtable();
        sAttrName = GADGET_LIST_ATTRIBUTE;
        vValues = new Vector();
        vValues.add("2.16.840.1.113719.1.200.4.32");
        htValues.put("NUMERICOID", vValues);
        vValues = new Vector();
        vValues.add(sAttrName);
        htValues.put("NAME", vValues);
        vValues = new Vector();
        vValues.add("NPS Attribute: List of NPS gadgets linked to a module/gadget/portal");
        htValues.put("DESC", vValues);
        vValues = new Vector();
        vValues.add("1.3.6.1.4.1.1466.115.121.1.12");
        htValues.put("SYNTAX", vValues);
        vValues = new Vector();
        vValues.add("1");
        htValues.put("X-NDS_NOT_SCHED_SYNC_IMMEDIATE", vValues);
        this.setSchemaAttributeDefinition(sAttrName, htValues);
        htValues = new Hashtable();
        sAttrName = PARENT_MODULE_LIST_ATTRIBUTE;
        vValues = new Vector();
        vValues.add("2.16.840.1.113719.1.200.4.33");
        htValues.put("NUMERICOID", vValues);
        vValues = new Vector();
        vValues.add(sAttrName);
        htValues.put("NAME", vValues);
        vValues = new Vector();
        vValues.add("NPS Attribute: List of parent NPS modules");
        htValues.put("DESC", vValues);
        vValues = new Vector();
        vValues.add("1.3.6.1.4.1.1466.115.121.1.12");
        htValues.put("SYNTAX", vValues);
        vValues = new Vector();
        vValues.add("1");
        htValues.put("X-NDS_NOT_SCHED_SYNC_IMMEDIATE", vValues);
        this.setSchemaAttributeDefinition(sAttrName, htValues);
        htValues = new Hashtable();
        sAttrName = CHILD_MODULE_LIST_ATTRIBUTE;
        vValues = new Vector();
        vValues.add("2.16.840.1.113719.1.200.4.34");
        htValues.put("NUMERICOID", vValues);
        vValues = new Vector();
        vValues.add(sAttrName);
        htValues.put("NAME", vValues);
        vValues = new Vector();
        vValues.add("NPS Attribute: List of child NPS modules");
        htValues.put("DESC", vValues);
        vValues = new Vector();
        vValues.add("1.3.6.1.4.1.1466.115.121.1.12");
        htValues.put("SYNTAX", vValues);
        vValues = new Vector();
        vValues.add("1");
        htValues.put("X-NDS_NOT_SCHED_SYNC_IMMEDIATE", vValues);
        this.setSchemaAttributeDefinition(sAttrName, htValues);
        htValues = new Hashtable();
        sAttrName = TASK_LIST_ATTRIBUTE;
        vValues = new Vector();
        vValues.add("2.16.840.1.113719.1.200.4.35");
        htValues.put("NUMERICOID", vValues);
        vValues = new Vector();
        vValues.add(sAttrName);
        htValues.put("NAME", vValues);
        vValues = new Vector();
        vValues.add("NPS Attribute: List of RBS Tasks");
        htValues.put("DESC", vValues);
        vValues = new Vector();
        vValues.add("1.3.6.1.4.1.1466.115.121.1.12");
        htValues.put("SYNTAX", vValues);
        vValues = new Vector();
        vValues.add("1");
        htValues.put("X-NDS_NOT_SCHED_SYNC_IMMEDIATE", vValues);
        this.setSchemaAttributeDefinition(sAttrName, htValues);
        htValues = new Hashtable();
        sAttrName = COLLECTION_LIST_ATTRIBUTE;
        vValues = new Vector();
        vValues.add("2.16.840.1.113719.1.200.4.36");
        htValues.put("NUMERICOID", vValues);
        vValues = new Vector();
        vValues.add(sAttrName);
        htValues.put("NAME", vValues);
        vValues = new Vector();
        vValues.add("NPS Attribute: List of RBS Collections");
        htValues.put("DESC", vValues);
        vValues = new Vector();
        vValues.add("1.3.6.1.4.1.1466.115.121.1.12");
        htValues.put("SYNTAX", vValues);
        vValues = new Vector();
        vValues.add("1");
        htValues.put("X-NDS_NOT_SCHED_SYNC_IMMEDIATE", vValues);
        this.setSchemaAttributeDefinition(sAttrName, htValues);
        htValues = new Hashtable();
        sClassName = PORTAL_CONFIG_DIRECTORY_CLASS;
        vValues = new Vector();
        vValues.add("2.16.840.1.113719.1.200.6.1");
        htValues.put("NUMERICOID", vValues);
        vValues = new Vector();
        vValues.add(sClassName);
        htValues.put("NAME", vValues);
        vValues = new Vector();
        vValues.add("NPS Object Class: Configuration store");
        htValues.put("DESC", vValues);
        vValues = new Vector();
        vValues.add("true");
        htValues.put("AUXILIARY", vValues);
        vValues = new Vector();
        vValues.add(CONFIG_RO_ATTRIBUTE);
        vValues.add(GUID_ATTRIBUTE);
        vValues.add(OBJECT_LIST_ATTRIBUTE);
        htValues.put("MAY", vValues);
        vValues = new Vector();
        vValues.add("1");
        htValues.put("X-NDS_NOT_CONTAINER", vValues);
        this.setSchemaClassDefinition(sClassName, htValues);
        htValues = new Hashtable();
        sClassName = "bhPortalConfigRW";
        vValues = new Vector();
        vValues.add("2.16.840.1.113719.1.200.6.2");
        htValues.put("NUMERICOID", vValues);
        vValues = new Vector();
        vValues.add(sClassName);
        htValues.put("NAME", vValues);
        vValues = new Vector();
        vValues.add("NPS Object Class: Read/write configuration store");
        htValues.put("DESC", vValues);
        vValues = new Vector();
        vValues.add("true");
        htValues.put("AUXILIARY", vValues);
        vValues = new Vector();
        vValues.add(CONFIG_RW_ATTRIBUTE);
        htValues.put("MAY", vValues);
        vValues = new Vector();
        vValues.add("1");
        htValues.put("X-NDS_NOT_CONTAINER", vValues);
        this.setSchemaClassDefinition(sClassName, htValues);
        htValues = new Hashtable();
        sClassName = "bhPortalConfigSecretStore";
        vValues = new Vector();
        vValues.add("2.16.840.1.113719.1.200.6.3");
        htValues.put("NUMERICOID", vValues);
        vValues = new Vector();
        vValues.add(sClassName);
        htValues.put("NAME", vValues);
        vValues = new Vector();
        vValues.add("NPS Object Class: Secret configuration store");
        htValues.put("DESC", vValues);
        vValues = new Vector();
        vValues.add("true");
        htValues.put("AUXILIARY", vValues);
        vValues = new Vector();
        vValues.add(CONFIG_SS_ATTRIBUTE);
        htValues.put("MAY", vValues);
        vValues = new Vector();
        vValues.add("1");
        htValues.put("X-NDS_NOT_CONTAINER", vValues);
        this.setSchemaClassDefinition(sClassName, htValues);
        htValues = new Hashtable();
        sClassName = PORTAL_DIRECTORY_CLASS;
        vValues = new Vector();
        vValues.add("2.16.840.1.113719.1.200.6.4");
        htValues.put("NUMERICOID", vValues);
        vValues = new Vector();
        vValues.add(sClassName);
        htValues.put("NAME", vValues);
        vValues = new Vector();
        vValues.add("NPS Object Class: Portal object");
        htValues.put("DESC", vValues);
        vValues = new Vector();
        vValues.add("top");
        vValues.add("ndsLoginProperties");
        htValues.put("SUP", vValues);
        vValues = new Vector();
        vValues.add("true");
        htValues.put("STRUCTURAL", vValues);
        vValues = new Vector();
        vValues.add(GADGET_NAME_ATTRIBUTE);
        vValues.add(CONFIG_RO_ATTRIBUTE);
        vValues.add(GUID_ATTRIBUTE);
        vValues.add(OBJECT_LIST_ATTRIBUTE);
        vValues.add(VERSION_ATTRIBUTE);
        vValues.add(MODULE_LIST_ATTRIBUTE);
        vValues.add(COLLECTION_LIST_ATTRIBUTE);
        htValues.put("MAY", vValues);
        vValues = new Vector();
        vValues.add("1");
        htValues.put("X-NDS_NOT_CONTAINER", vValues);
        vValues = new Vector();
        vValues.add(ORGANIZATION_DIRECTORY_CLASS);
        vValues.add(ORGANIZATIONAL_UNIT_DIRECTORY_CLASS);
        vValues.add(COUNTRY_DIRECTORY_CLASS);
        vValues.add(LOCALITY_DIRECTORY_CLASS);
        vValues.add(DOMAIN_DIRECTORY_CLASS);
        htValues.put("X-NDS_CONTAINMENT", vValues);
        vValues = new Vector();
        vValues.add(GADGET_NAME_ATTRIBUTE);
        htValues.put("X-NDS_NAMING", vValues);
        this.setSchemaClassDefinition(sClassName, htValues);
        htValues = new Hashtable();
        sClassName = GADGET_DIRECTORY_CLASS;
        vValues = new Vector();
        vValues.add("2.16.840.1.113719.1.200.6.5");
        htValues.put("NUMERICOID", vValues);
        vValues = new Vector();
        vValues.add(sClassName);
        htValues.put("NAME", vValues);
        vValues = new Vector();
        vValues.add("NPS Object Class: Gadget object");
        htValues.put("DESC", vValues);
        vValues = new Vector();
        vValues.add("top");
        htValues.put("SUP", vValues);
        vValues = new Vector();
        vValues.add("true");
        htValues.put("STRUCTURAL", vValues);
        vValues = new Vector();
        vValues.add(INSTANCE_CLASS_NAME_ATTRIBUTE);
        htValues.put("MUST", vValues);
        vValues = new Vector();
        vValues.add(GADGET_NAME_ATTRIBUTE);
        vValues.add(CONFIG_RO_ATTRIBUTE);
        vValues.add(GUID_ATTRIBUTE);
        vValues.add(OBJECT_LIST_ATTRIBUTE);
        vValues.add(CLASS_NAME_ATTRIBUTE);
        vValues.add(ARGUMENTS_ATTRIBUTE);
        vValues.add(INSTANCE_ARGUMENTS_ATTRIBUTE);
        vValues.add(VERSION_ATTRIBUTE);
        vValues.add(PACKAGE_NAME_ATTRIBUTE);
        vValues.add(PARENT_MODULE_LIST_ATTRIBUTE);
        vValues.add(TASK_LIST_ATTRIBUTE);
        htValues.put("MAY", vValues);
        vValues = new Vector();
        vValues.add("1");
        htValues.put("X-NDS_NOT_CONTAINER", vValues);
        vValues = new Vector();
        vValues.add(ORGANIZATION_DIRECTORY_CLASS);
        vValues.add(ORGANIZATIONAL_UNIT_DIRECTORY_CLASS);
        vValues.add(COUNTRY_DIRECTORY_CLASS);
        vValues.add(LOCALITY_DIRECTORY_CLASS);
        vValues.add(DOMAIN_DIRECTORY_CLASS);
        htValues.put("X-NDS_CONTAINMENT", vValues);
        vValues = new Vector();
        vValues.add(GADGET_NAME_ATTRIBUTE);
        htValues.put("X-NDS_NAMING", vValues);
        try {
            this.setSchemaClassDefinition(sClassName, htValues);
        }
        catch (Exception exception) {
            // empty catch block
        }
        htValues = new Hashtable();
        sClassName = MODULE_DIRECTORY_CLASS;
        vValues = new Vector();
        vValues.add("2.16.840.1.113719.1.200.6.14");
        htValues.put("NUMERICOID", vValues);
        vValues = new Vector();
        vValues.add(sClassName);
        htValues.put("NAME", vValues);
        vValues = new Vector();
        vValues.add("NPS Object Class: Module object");
        htValues.put("DESC", vValues);
        vValues = new Vector();
        vValues.add("top");
        htValues.put("SUP", vValues);
        vValues = new Vector();
        vValues.add("true");
        htValues.put("STRUCTURAL", vValues);
        vValues = new Vector();
        vValues.add(GADGET_NAME_ATTRIBUTE);
        vValues.add(CONFIG_RO_ATTRIBUTE);
        vValues.add(GUID_ATTRIBUTE);
        vValues.add(GADGET_LIST_ATTRIBUTE);
        vValues.add(PARENT_MODULE_LIST_ATTRIBUTE);
        vValues.add(CHILD_MODULE_LIST_ATTRIBUTE);
        vValues.add(VERSION_ATTRIBUTE);
        vValues.add(PORTAL_DN_ATTRIBUTE);
        htValues.put("MAY", vValues);
        vValues = new Vector();
        vValues.add("1");
        htValues.put("X-NDS_NOT_CONTAINER", vValues);
        vValues = new Vector();
        vValues.add(ORGANIZATION_DIRECTORY_CLASS);
        vValues.add(ORGANIZATIONAL_UNIT_DIRECTORY_CLASS);
        vValues.add(COUNTRY_DIRECTORY_CLASS);
        vValues.add(LOCALITY_DIRECTORY_CLASS);
        vValues.add(DOMAIN_DIRECTORY_CLASS);
        htValues.put("X-NDS_CONTAINMENT", vValues);
        vValues = new Vector();
        vValues.add(GADGET_NAME_ATTRIBUTE);
        htValues.put("X-NDS_NAMING", vValues);
        this.setSchemaClassDefinition(sClassName, htValues);
    }

    public String getUniqueDN(String sName, String sContainer) throws PortalDirectoryException {
        StringBuffer sbName = new StringBuffer();
        if (sName == null) {
            sName = "";
        }
        for (int i = 0; i < sName.length(); ++i) {
            char ch = sName.charAt(i);
            if (!Character.isLetterOrDigit(ch)) continue;
            sbName.append(ch);
        }
        if (sbName.length() == 0) {
            Date dt = new Date();
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
            sbName.append(df.format(dt));
        }
        if (sbName.length() > 50) {
            sbName.delete(50, sbName.length());
        }
        Vector vFound = null;
        String sExt = null;
        Random randomNumber = new Random();
        int iExt = randomNumber.nextInt() % 1000;
        while (true) {
            StringBuffer sbFilter = new StringBuffer("(name=");
            sbFilter.append(sbName.toString());
            if (sExt != null) {
                sbFilter.append(sExt);
            }
            sbFilter.append(")");
            vFound = this.searchDirectory(sContainer, sbFilter.toString(), 1);
            if (vFound.size() == 0) break;
            sExt = Integer.toString(iExt++);
        }
        StringBuffer sbFullName = new StringBuffer("cn=");
        sbFullName.append(sbName.toString());
        if (sExt != null) {
            sbFullName.append(sExt);
        }
        sbFullName.append(",");
        sbFullName.append(sContainer);
        return sbFullName.toString();
    }

    public void addStringAttributeValue(String sObject, String sAttribute, String sValue) throws PortalDirectoryException {
        if (!this.compareStringAttribute(sObject, sAttribute, sValue)) {
            String[] sa = new String[]{sValue};
            this.writeMultiStringAttribute(sObject, sAttribute, sa, false);
        }
    }

    public static PortalObjectAttribute lookupAttribute(Vector vPOAs, String sAttrName) {
        PortalObjectAttribute poaRet = null;
        PortalObjectAttribute poa = null;
        if (vPOAs != null) {
            for (int i = 0; i < vPOAs.size(); ++i) {
                poa = (PortalObjectAttribute)vPOAs.elementAt(i);
                if (!sAttrName.equalsIgnoreCase(poa.getName())) continue;
                poaRet = poa;
                break;
            }
        }
        return poaRet;
    }

    @Override
    public void authenticate(String sDirectory, String sUsername, String sPassword, boolean bUseSSL) throws PortalDirectoryException {
        this.m_sUsername = sUsername;
        this.m_sPassword = sPassword;
        this.m_sDirectory = sDirectory;
        this.m_bUseSSL = bUseSSL;
        for (int i = 0; i < this.m_iRetryCount; ++i) {
            try {
                this.m_pd.authenticate(this.m_sDirectory, this.m_sUsername, this.m_sPassword, this.m_bUseSSL);
                break;
            }
            catch (PortalCommunicationException ex) {
                this.m_lLastValid = 0L;
                if (i < this.m_iRetryCount - 1) continue;
                throw ex;
            }
        }
        this.m_lLastUsed = System.currentTimeMillis();
    }

    public void rawAuthenticate() throws PortalDirectoryException {
        this.m_pd.authenticate(this.m_sDirectory, this.m_sUsername, this.m_sPassword, this.m_bUseSSL);
        this.m_lLastUsed = System.currentTimeMillis();
    }

    @Override
    public void unauthenticate() throws PortalDirectoryException {
        this.m_pd.unauthenticate();
    }

    @Override
    public void disconnect() throws PortalDirectoryException {
        this.m_pd.disconnect();
    }

    @Override
    public boolean isAuthenticated() {
        return this.m_pd.isAuthenticated();
    }

    @Override
    public boolean isDisconnected() {
        return this.m_pd.isDisconnected();
    }

    @Override
    public boolean isValid() throws PortalDirectoryException {
        return this.m_pd.isValid();
    }

    @Override
    public String readStringAttribute(String sObject, String sAttribute) throws PortalDirectoryException {
        for (int i = 0; i < this.m_iRetryCount; ++i) {
            try {
                PortalDirectory pd = this.getDirectory();
                return pd.readStringAttribute(sObject, sAttribute);
            }
            catch (PortalCommunicationException ex) {
                this.m_lLastValid = 0L;
                if (i < this.m_iRetryCount - 1) continue;
                throw ex;
            }
        }
        return null;
    }

    @Override
    public Vector readMultiStringAttribute(String sObject, String sAttribute) throws PortalDirectoryException {
        for (int i = 0; i < this.m_iRetryCount; ++i) {
            try {
                PortalDirectory pd = this.getDirectory();
                return pd.readMultiStringAttribute(sObject, sAttribute);
            }
            catch (PortalCommunicationException ex) {
                this.m_lLastValid = 0L;
                if (i < this.m_iRetryCount - 1) continue;
                throw ex;
            }
        }
        return null;
    }

    @Override
    public byte[] readByteArrayAttribute(String sObject, String sAttribute) throws PortalDirectoryException {
        for (int i = 0; i < this.m_iRetryCount; ++i) {
            try {
                PortalDirectory pd = this.getDirectory();
                return pd.readByteArrayAttribute(sObject, sAttribute);
            }
            catch (PortalCommunicationException ex) {
                this.m_lLastValid = 0L;
                if (i < this.m_iRetryCount - 1) continue;
                throw ex;
            }
        }
        return null;
    }

    @Override
    public Vector readMultiByteArrayAttribute(String sObject, String sAttribute) throws PortalDirectoryException {
        for (int i = 0; i < this.m_iRetryCount; ++i) {
            try {
                PortalDirectory pd = this.getDirectory();
                return pd.readMultiByteArrayAttribute(sObject, sAttribute);
            }
            catch (PortalCommunicationException ex) {
                this.m_lLastValid = 0L;
                if (i < this.m_iRetryCount - 1) continue;
                throw ex;
            }
        }
        return null;
    }

    @Override
    public void readAttributes(String sObject, Vector vAttributes) throws PortalDirectoryException {
        for (int i = 0; i < this.m_iRetryCount; ++i) {
            try {
                PortalDirectory pd = this.getDirectory();
                pd.readAttributes(sObject, vAttributes);
                return;
            }
            catch (PortalCommunicationException ex) {
                this.m_lLastValid = 0L;
                if (i < this.m_iRetryCount - 1) continue;
                throw ex;
            }
        }
    }

    @Override
    public void readAttributes(String sObject, Hashtable htAttributes) throws PortalDirectoryException {
        for (int i = 0; i < this.m_iRetryCount; ++i) {
            try {
                PortalDirectory pd = this.getDirectory();
                pd.readAttributes(sObject, htAttributes);
                return;
            }
            catch (PortalCommunicationException ex) {
                this.m_lLastValid = 0L;
                if (i < this.m_iRetryCount - 1) continue;
                throw ex;
            }
        }
    }

    @Override
    public Hashtable readAttributes(String sObject) throws PortalDirectoryException {
        for (int i = 0; i < this.m_iRetryCount; ++i) {
            try {
                PortalDirectory pd = this.getDirectory();
                return pd.readAttributes(sObject);
            }
            catch (PortalCommunicationException ex) {
                this.m_lLastValid = 0L;
                if (i < this.m_iRetryCount - 1) continue;
                throw ex;
            }
        }
        return null;
    }

    @Override
    public void writeStringAttribute(String sObject, String sAttribute, String sValue) throws PortalDirectoryException {
        for (int i = 0; i < this.m_iRetryCount; ++i) {
            try {
                PortalDirectory pd = this.getDirectory();
                pd.writeStringAttribute(sObject, sAttribute, sValue);
                return;
            }
            catch (PortalCommunicationException ex) {
                this.m_lLastValid = 0L;
                if (i < this.m_iRetryCount - 1) continue;
                throw ex;
            }
        }
    }

    @Override
    public void writeMultiStringAttribute(String sObject, String sAttribute, String[] saValues, boolean bClear) throws PortalDirectoryException {
        for (int i = 0; i < this.m_iRetryCount; ++i) {
            try {
                PortalDirectory pd = this.getDirectory();
                pd.writeMultiStringAttribute(sObject, sAttribute, saValues, bClear);
                return;
            }
            catch (PortalCommunicationException ex) {
                this.m_lLastValid = 0L;
                if (i < this.m_iRetryCount - 1) continue;
                throw ex;
            }
        }
    }

    @Override
    public void writeByteArrayAttribute(String sObject, String sAttribute, byte[] baValue) throws PortalDirectoryException {
        for (int i = 0; i < this.m_iRetryCount; ++i) {
            try {
                PortalDirectory pd = this.getDirectory();
                pd.writeByteArrayAttribute(sObject, sAttribute, baValue);
                return;
            }
            catch (PortalCommunicationException ex) {
                this.m_lLastValid = 0L;
                if (i < this.m_iRetryCount - 1) continue;
                throw ex;
            }
        }
    }

    @Override
    public void writeMultiByteArrayAttribute(String sObject, String sAttribute, Vector vbaValues, boolean bClear) throws PortalDirectoryException {
        for (int i = 0; i < this.m_iRetryCount; ++i) {
            try {
                PortalDirectory pd = this.getDirectory();
                pd.writeMultiByteArrayAttribute(sObject, sAttribute, vbaValues, bClear);
                return;
            }
            catch (PortalCommunicationException ex) {
                this.m_lLastValid = 0L;
                if (i < this.m_iRetryCount - 1) continue;
                throw ex;
            }
        }
    }

    @Override
    public void writeAttributes(String sObject, Vector vAttributes) throws PortalDirectoryException {
        for (int i = 0; i < this.m_iRetryCount; ++i) {
            try {
                PortalDirectory pd = this.getDirectory();
                pd.writeAttributes(sObject, vAttributes);
                return;
            }
            catch (PortalCommunicationException ex) {
                this.m_lLastValid = 0L;
                if (i < this.m_iRetryCount - 1) continue;
                throw ex;
            }
        }
    }

    @Override
    public void deleteStringAttributeValue(String sObject, String sAttribute, String sValue) throws PortalDirectoryException {
        for (int i = 0; i < this.m_iRetryCount; ++i) {
            try {
                PortalDirectory pd = this.getDirectory();
                pd.deleteStringAttributeValue(sObject, sAttribute, sValue);
                return;
            }
            catch (PortalCommunicationException ex) {
                this.m_lLastValid = 0L;
                if (i < this.m_iRetryCount - 1) continue;
                throw ex;
            }
        }
    }

    @Override
    public void deleteByteArrayAttributeValue(String sObject, String sAttribute, byte[] baValue) throws PortalDirectoryException {
        for (int i = 0; i < this.m_iRetryCount; ++i) {
            try {
                PortalDirectory pd = this.getDirectory();
                pd.deleteByteArrayAttributeValue(sObject, sAttribute, baValue);
                return;
            }
            catch (PortalCommunicationException ex) {
                this.m_lLastValid = 0L;
                if (i < this.m_iRetryCount - 1) continue;
                throw ex;
            }
        }
    }

    @Override
    public void replaceStringAttributeValue(String sObject, String sAttribute, String sValue, String sNewValue) throws PortalDirectoryException {
        for (int i = 0; i < this.m_iRetryCount; ++i) {
            try {
                PortalDirectory pd = this.getDirectory();
                pd.replaceStringAttributeValue(sObject, sAttribute, sValue, sNewValue);
                return;
            }
            catch (PortalCommunicationException ex) {
                this.m_lLastValid = 0L;
                if (i < this.m_iRetryCount - 1) continue;
                throw ex;
            }
        }
    }

    @Override
    public void replaceByteArrayAttributeValue(String sObject, String sAttribute, byte[] baValue, byte[] baNewValue) throws PortalDirectoryException {
        for (int i = 0; i < this.m_iRetryCount; ++i) {
            try {
                PortalDirectory pd = this.getDirectory();
                pd.replaceByteArrayAttributeValue(sObject, sAttribute, baValue, baNewValue);
                return;
            }
            catch (PortalCommunicationException ex) {
                this.m_lLastValid = 0L;
                if (i < this.m_iRetryCount - 1) continue;
                throw ex;
            }
        }
    }

    public Vector searchDirectory(String sBase, String sFilter, boolean bSubtree) throws PortalDirectoryException {
        int iScope = bSubtree ? 2 : 1;
        return this.searchDirectory(sBase, sFilter, iScope);
    }

    @Override
    public Vector searchDirectory(String sBase, String sFilter, int iScope) throws PortalDirectoryException {
        for (int i = 0; i < this.m_iRetryCount; ++i) {
            try {
                PortalDirectory pd = this.getDirectory();
                return pd.searchDirectory(sBase, sFilter, iScope);
            }
            catch (PortalCommunicationException ex) {
                this.m_lLastValid = 0L;
                if (i < this.m_iRetryCount - 1) continue;
                throw ex;
            }
        }
        return null;
    }

    @Override
    public Hashtable searchDirectory(String sBase, String sFilter, int iScope, Vector vAttributes, int iCountLimit, int iTimeLimit) throws PortalDirectoryException {
        for (int i = 0; i < this.m_iRetryCount; ++i) {
            try {
                PortalDirectory pd = this.getDirectory();
                return pd.searchDirectory(sBase, sFilter, iScope, vAttributes, iCountLimit, iTimeLimit);
            }
            catch (PortalCommunicationException ex) {
                this.m_lLastValid = 0L;
                if (i < this.m_iRetryCount - 1) continue;
                throw ex;
            }
        }
        return null;
    }

    @Override
    public void removeStringAttribute(String sObject, String sAttribute, String sValue) throws PortalDirectoryException {
        for (int i = 0; i < this.m_iRetryCount; ++i) {
            try {
                PortalDirectory pd = this.getDirectory();
                pd.removeStringAttribute(sObject, sAttribute, sValue);
                return;
            }
            catch (PortalCommunicationException ex) {
                this.m_lLastValid = 0L;
                if (i < this.m_iRetryCount - 1) continue;
                throw ex;
            }
        }
    }

    @Override
    public void createObject(String sObject, String sClass, Vector vAttrs) throws PortalDirectoryException {
        for (int i = 0; i < this.m_iRetryCount; ++i) {
            try {
                PortalDirectory pd = this.getDirectory();
                pd.createObject(sObject, sClass, vAttrs);
                return;
            }
            catch (PortalCommunicationException ex) {
                this.m_lLastValid = 0L;
                if (i < this.m_iRetryCount - 1) continue;
                throw ex;
            }
        }
    }

    @Override
    public void deleteObject(String sObject) throws PortalDirectoryException {
        for (int i = 0; i < this.m_iRetryCount; ++i) {
            try {
                PortalDirectory pd = this.getDirectory();
                pd.deleteObject(sObject);
                return;
            }
            catch (PortalCommunicationException ex) {
                this.m_lLastValid = 0L;
                if (i < this.m_iRetryCount - 1) continue;
                throw ex;
            }
        }
    }

    @Override
    public void renameObject(String sObjectDN, String sNewObjectDN) throws PortalDirectoryException {
        for (int i = 0; i < this.m_iRetryCount; ++i) {
            try {
                PortalDirectory pd = this.getDirectory();
                pd.renameObject(sObjectDN, sNewObjectDN);
                return;
            }
            catch (PortalCommunicationException ex) {
                this.m_lLastValid = 0L;
                if (i < this.m_iRetryCount - 1) continue;
                throw ex;
            }
        }
    }

    @Override
    public String normalizeObjectDN(String sObjectDN) throws PortalDirectoryException {
        for (int i = 0; i < this.m_iRetryCount; ++i) {
            try {
                PortalDirectory pd = this.getDirectory();
                return pd.normalizeObjectDN(sObjectDN);
            }
            catch (PortalCommunicationException ex) {
                this.m_lLastValid = 0L;
                if (i < this.m_iRetryCount - 1) continue;
                throw ex;
            }
        }
        return null;
    }

    @Override
    public boolean compareStringAttribute(String sObjectDN, String sAttribute, String sValue) throws PortalDirectoryException {
        for (int i = 0; i < this.m_iRetryCount; ++i) {
            try {
                PortalDirectory pd = this.getDirectory();
                return pd.compareStringAttribute(sObjectDN, sAttribute, sValue);
            }
            catch (PortalCommunicationException ex) {
                this.m_lLastValid = 0L;
                if (i < this.m_iRetryCount - 1) continue;
                throw ex;
            }
        }
        return false;
    }

    @Override
    public boolean compareMultiStringAttribute(String sObjectDN, String sAttribute, Vector vValues) throws PortalDirectoryException {
        for (int i = 0; i < this.m_iRetryCount; ++i) {
            try {
                PortalDirectory pd = this.getDirectory();
                return pd.compareMultiStringAttribute(sObjectDN, sAttribute, vValues);
            }
            catch (PortalCommunicationException ex) {
                this.m_lLastValid = 0L;
                if (i < this.m_iRetryCount - 1) continue;
                throw ex;
            }
        }
        return false;
    }

    @Override
    public void setObjectPassword(String sObjectDN, String sOldPassword, String sNewPassword) throws PortalDirectoryException {
        for (int i = 0; i < this.m_iRetryCount; ++i) {
            try {
                PortalDirectory pd = this.getDirectory();
                pd.setObjectPassword(sObjectDN, sOldPassword, sNewPassword);
                return;
            }
            catch (PortalCommunicationException ex) {
                this.m_lLastValid = 0L;
                if (i < this.m_iRetryCount - 1) continue;
                throw ex;
            }
        }
    }

    @Override
    public Object getBaseConnection() throws PortalDirectoryException {
        for (int i = 0; i < this.m_iRetryCount; ++i) {
            try {
                PortalDirectory pd = this.getDirectory();
                return pd.getBaseConnection();
            }
            catch (PortalCommunicationException ex) {
                this.m_lLastValid = 0L;
                if (i < this.m_iRetryCount - 1) continue;
                throw ex;
            }
        }
        return null;
    }

    @Override
    public Hashtable getSchemaClassDefinition(String sClassname) throws PortalDirectoryException {
        for (int i = 0; i < this.m_iRetryCount; ++i) {
            try {
                PortalDirectory pd = this.getDirectory();
                return pd.getSchemaClassDefinition(sClassname);
            }
            catch (PortalCommunicationException ex) {
                this.m_lLastValid = 0L;
                if (i < this.m_iRetryCount - 1) continue;
                throw ex;
            }
        }
        return null;
    }

    @Override
    public Hashtable getSchemaAttributeDefinition(String sAttrname) throws PortalDirectoryException {
        for (int i = 0; i < this.m_iRetryCount; ++i) {
            try {
                PortalDirectory pd = this.getDirectory();
                return pd.getSchemaAttributeDefinition(sAttrname);
            }
            catch (PortalCommunicationException ex) {
                this.m_lLastValid = 0L;
                if (i < this.m_iRetryCount - 1) continue;
                throw ex;
            }
        }
        return null;
    }

    @Override
    public void setSchemaAttributeDefinition(String sAttrname, Hashtable htValues) throws PortalDirectoryException {
        for (int i = 0; i < this.m_iRetryCount; ++i) {
            try {
                PortalDirectory pd = this.getDirectory();
                pd.setSchemaAttributeDefinition(sAttrname, htValues);
                return;
            }
            catch (PortalCommunicationException ex) {
                this.m_lLastValid = 0L;
                if (i < this.m_iRetryCount - 1) continue;
                throw ex;
            }
        }
    }

    @Override
    public void setSchemaClassDefinition(String sClassname, Hashtable htValues) throws PortalDirectoryException {
        for (int i = 0; i < this.m_iRetryCount; ++i) {
            try {
                PortalDirectory pd = this.getDirectory();
                pd.setSchemaClassDefinition(sClassname, htValues);
                return;
            }
            catch (PortalCommunicationException ex) {
                this.m_lLastValid = 0L;
                if (i < this.m_iRetryCount - 1) continue;
                throw ex;
            }
        }
    }

    @Override
    public int getEffectiveRights(String sObjectDN, String sTrusteeDN, String sAttribute) throws PortalDirectoryException {
        int iRet = 0;
        for (int i = 0; i < this.m_iRetryCount; ++i) {
            try {
                PortalDirectory pd = this.getDirectory();
                iRet = pd.getEffectiveRights(sObjectDN, sTrusteeDN, sAttribute);
                return iRet;
            }
            catch (PortalCommunicationException ex) {
                this.m_lLastValid = 0L;
                if (i < this.m_iRetryCount - 1) continue;
                throw ex;
            }
        }
        return iRet;
    }

    @Override
    public Vector searchDirectory(String sBase, String sFilter, int iScope, int iTimeLimit, Vector vSortAttributes, Vector vReturnAttributes, PortalVirtualSearch pvs) throws PortalDirectoryException {
        for (int i = 0; i < this.m_iRetryCount; ++i) {
            try {
                PortalDirectory pd = this.getDirectory();
                return pd.searchDirectory(sBase, sFilter, iScope, iTimeLimit, vSortAttributes, vReturnAttributes, pvs);
            }
            catch (PortalCommunicationException ex) {
                this.m_lLastValid = 0L;
                if (i < this.m_iRetryCount - 1) continue;
                throw ex;
            }
        }
        return null;
    }

    @Override
    public void addBinaryAttributes(Vector vAttrs) {
        this.m_pd.addBinaryAttributes(vAttrs);
    }

    public static String getUserClass() {
        return m_sUserClass;
    }

    public static void setUserClass(String sUserClass) {
        m_sUserClass = sUserClass == null ? USER_DIRECTORY_CLASS : sUserClass;
    }

    private ResourceBundle getResourceBundle() {
        if (this.m_res == null) {
            this.m_res = AuthenticationManager.getResourceBundle();
        }
        return this.m_res;
    }

    public boolean isContainer(String sClass) {
        boolean bRet = false;
        if (sClass.equalsIgnoreCase(COUNTRY_DIRECTORY_CLASS) || sClass.equalsIgnoreCase(LOCALITY_DIRECTORY_CLASS) || sClass.equalsIgnoreCase(ORGANIZATION_DIRECTORY_CLASS) || sClass.equalsIgnoreCase(ORGANIZATIONAL_UNIT_DIRECTORY_CLASS) || sClass.equalsIgnoreCase(DOMAIN_DIRECTORY_CLASS)) {
            bRet = true;
        }
        return bRet;
    }
}

