/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.authentication.sso;

import com.novell.emframe.dev.D;
import com.novell.nps.authentication.AuthenticationManager;
import com.novell.nps.authentication.MultipleLdapObjectsException;
import com.novell.nps.authentication.PortalConnection;
import com.novell.nps.authentication.PortalDirectoryException;
import com.novell.nps.authentication.sso.CMStoreEnum;
import com.novell.nps.authentication.sso.StoreEnumObject;
import com.novell.nps.authentication.sso.StoreSS;
import com.novell.nps.configManager.ConfigManager;
import com.novell.nps.configManager.ObjectConfig;
import com.novell.nps.configManager.ObjectConfigRecord;
import com.novell.nps.sessionManager.PortalSession;
import java.util.Vector;

public class CMStore
implements StoreSS {
    public static ObjectConfig m_publicConfigMgr = null;
    private static final String ssAttr = "bhConfigSecretStore";
    private static final String ssID = new String("SecretStore");
    private ObjectConfig configMgr = null;
    private Vector theRecords = null;
    private int enumCount = 0;

    @Override
    public void putCredentials(PortalSession session, String gadgetID, String tag, byte[] data) {
        this.configMgr = this.getConfigMgr(session);
        ObjectConfigRecord ocr = new ObjectConfigRecord(ssID, gadgetID.hashCode(), tag.hashCode(), 0);
        ocr.setRecordData(data);
        PortalConnection pc = AuthenticationManager.getConnection(session);
        try {
            this.configMgr.writeRecord(pc, ocr);
            this.configMgr.read(pc);
        }
        catch (PortalDirectoryException portalDirectoryException) {
            // empty catch block
        }
    }

    @Override
    public void putCredentials(PortalConnection pc, String sObjectDN, String gadgetID, String tag, byte[] data) throws PortalDirectoryException {
        ObjectConfigRecord ocr = new ObjectConfigRecord(ssID, gadgetID.hashCode(), tag.hashCode(), 0);
        ocr.setRecordData(data);
        ObjectConfig oc = new ObjectConfig(ConfigManager.getPCOID(), sObjectDN, ssAttr);
        pc.addAuxClass(sObjectDN, ssAttr);
        oc.writeRecord(pc, ocr);
    }

    @Override
    public byte[] getCredentials(PortalSession session, String gadgetID, String tag) {
        this.configMgr = this.getConfigMgr(session);
        ObjectConfigRecord ocr = new ObjectConfigRecord(ssID, gadgetID.hashCode(), tag.hashCode(), 0);
        ObjectConfigRecord result = this.configMgr.getRecord(ocr);
        if (result != null) {
            return result.getRecordData();
        }
        return null;
    }

    @Override
    public byte[] getCredentials(PortalConnection pc, String sObjectDN, String gadgetID, String tag) throws PortalDirectoryException {
        ObjectConfigRecord ocr = new ObjectConfigRecord(ssID, gadgetID.hashCode(), tag.hashCode(), 0);
        ObjectConfig oc = new ObjectConfig(ConfigManager.getPCOID(), sObjectDN, ssAttr);
        oc.read(pc);
        ObjectConfigRecord result = oc.getRecord(ocr);
        if (result != null) {
            return result.getRecordData();
        }
        return null;
    }

    @Override
    public void removeCredentials(PortalSession session, String gadgetID, String tag) {
        PortalConnection pc = AuthenticationManager.getConnection(session);
        this.configMgr = this.getConfigMgr(session);
        ObjectConfigRecord ocr = new ObjectConfigRecord(ssID, gadgetID.hashCode(), tag.hashCode(), 0);
        try {
            this.configMgr.deleteRecord(pc, ocr);
            this.configMgr.read(pc);
        }
        catch (PortalDirectoryException portalDirectoryException) {
            // empty catch block
        }
    }

    @Override
    public void removeCredentials(PortalConnection pc, String sObjectDN, String gadgetID, String tag) throws PortalDirectoryException {
        ObjectConfigRecord ocr = new ObjectConfigRecord(ssID, gadgetID.hashCode(), tag.hashCode(), 0);
        ObjectConfig oc = new ObjectConfig(ConfigManager.getPCOID(), sObjectDN, ssAttr);
        oc.deleteRecord(pc, ocr);
    }

    @Override
    public void startEnumeration(PortalSession session) {
        this.configMgr = this.getConfigMgr(session);
        this.theRecords = this.configMgr.getRecords();
        this.enumCount = 0;
    }

    @Override
    public StoreEnumObject getNextElement(PortalSession session) {
        if (this.theRecords != null && this.enumCount < this.theRecords.size()) {
            ObjectConfigRecord ocr = (ObjectConfigRecord)this.theRecords.get(this.enumCount);
            ++this.enumCount;
            return new CMStoreEnum(ocr);
        }
        return null;
    }

    @Override
    public void updateElement(PortalSession session, StoreEnumObject newObject) {
        CMStoreEnum theData = (CMStoreEnum)newObject;
        PortalConnection pc = AuthenticationManager.getConnection(session);
        this.configMgr = this.getConfigMgr(session);
        try {
            this.configMgr.writeRecord(pc, theData.theRecord);
        }
        catch (PortalDirectoryException portalDirectoryException) {
            // empty catch block
        }
    }

    @Override
    public void removeElement(PortalSession session, StoreEnumObject newObject) {
        CMStoreEnum theData = (CMStoreEnum)newObject;
        PortalConnection pc = AuthenticationManager.getConnection(session);
        this.configMgr = this.getConfigMgr(session);
        try {
            this.configMgr.deleteRecord(pc, theData.theRecord);
        }
        catch (PortalDirectoryException portalDirectoryException) {
            // empty catch block
        }
    }

    @Override
    public int getMaxSupportedSize() {
        return 64000;
    }

    @Override
    public void logout(PortalSession session) {
        session.removeAttribute(ssID);
    }

    public ObjectConfig getConfigMgr(PortalSession session) {
        ObjectConfig configMgr = null;
        configMgr = (ObjectConfig)session.getAttribute(ssID);
        if (configMgr == null) {
            PortalConnection pc = AuthenticationManager.getConnection(session);
            try {
                configMgr = new ObjectConfig(ConfigManager.getPCOID(), AuthenticationManager.getFullLdapDN(null, session), ssAttr);
            }
            catch (MultipleLdapObjectsException e1) {
                D.log((Throwable)e1);
            }
            try {
                configMgr.read(pc);
            }
            catch (PortalDirectoryException portalDirectoryException) {
                // empty catch block
            }
            session.setAttribute(ssID, configMgr);
        }
        return configMgr;
    }
}

