/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.authentication.sso;

import com.novell.nps.authentication.BasicCredentials;
import com.novell.nps.authentication.PortalConnection;
import com.novell.nps.authentication.PortalDirectoryException;
import com.novell.nps.authentication.sso.AuthSSProvider;
import com.novell.nps.authentication.sso.CMStore;
import com.novell.nps.authentication.sso.CryptSS;
import com.novell.nps.authentication.sso.SSException;
import com.novell.nps.authentication.sso.StoreEnumObject;
import com.novell.nps.authentication.sso.StoreSS;
import com.novell.nps.authentication.sso.XORCrypt;
import com.novell.nps.configManager.ConfigManager;
import com.novell.nps.debug.Debug;
import com.novell.nps.sessionManager.PortalSession;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class PortalSecretStoreImpl
implements AuthSSProvider {
    private CryptSS cryptSS = new XORCrypt();
    private StoreSS storeSS = new CMStore();
    private static final String flagsTag = new String("SSFlags");
    private static final String validity = new String("SSValidity");
    private static final String ssID = new String("ssID");
    private static final String ssURL = new String("ssURL");
    private static int MAXSIZE = 0;

    public PortalSecretStoreImpl() {
        MAXSIZE = this.storeSS.getMaxSupportedSize();
    }

    @Override
    public void initializeAuthMgr(PortalSession session, Object data, int authFlags) throws SSException {
        String dataString = (String)data;
        dataString = dataString.toLowerCase();
        String isValid = null;
        this.cryptSS.insertPass(session, dataString);
        this.setAuthFlags(session, authFlags);
        try {
            isValid = (String)this.getCredentials(session, ssID, ssURL);
        }
        catch (SSException ss) {
            if (ss.getMessage().equals(SSException.SS_CREDENTIAL_NOT_FOUND)) {
                this.setCredentials(session, ssID, ssURL, validity);
                try {
                    isValid = (String)this.getCredentials(session, ssID, ssURL);
                }
                catch (SSException ss2) {
                    if (ss2.getMessage().equals(SSException.SS_CREDENTIAL_NOT_FOUND)) {
                        Debug.log("PortalSecretStoreImpl", 1, "The PCO object needs rights to the user object");
                        throw new SSException(SSException.SS_ERROR_UNKNOWN);
                    }
                    throw ss2;
                }
            }
            throw new SSException(SSException.SS_ERROR_UNKNOWN);
        }
        if (!validity.equals(isValid)) {
            throw new SSException(SSException.SS_STORE_OUT_OF_SYNC);
        }
    }

    @Override
    public void logoutAuthMgr(PortalSession session) {
        this.storeSS.logout(session);
    }

    @Override
    public Object getCredentials(PortalSession session, String gadgetID, String URL2, Object key) throws SSException {
        byte[] byteCredentials = null;
        byte[] newCredentials = null;
        Object newObject = null;
        newCredentials = this.storeSS.getCredentials(session, gadgetID, URL2);
        if (newCredentials != null) {
            byteCredentials = (byte[])newCredentials.clone();
            this.cryptSS.decryptCredentials(session, byteCredentials);
            if (key != null) {
                this.cryptSS.decryptCredentials(key, byteCredentials);
            }
            try {
                ByteArrayInputStream istream = new ByteArrayInputStream(byteCredentials);
                ObjectInputStream p = new ObjectInputStream(istream);
                newObject = p.readObject();
                p.close();
                istream.close();
            }
            catch (Exception e) {
                if (Debug.isLoggable(1)) {
                    Debug.log("PortalSecretStoreImpl", 1, e.getLocalizedMessage());
                }
            }
        } else {
            throw new SSException(SSException.SS_CREDENTIAL_NOT_FOUND);
        }
        if (newObject != null) {
            return newObject;
        }
        return null;
    }

    @Override
    public Object getCredentials(PortalSession session, String gadgetID, String URL2) throws SSException {
        return this.getCredentials(session, gadgetID, URL2, null);
    }

    @Override
    public Object getCredentials(PortalConnection pc, String sObjectDN, String gadgetID, String URL2, Object key) throws SSException, PortalDirectoryException {
        byte[] byteCredentials = null;
        byte[] newCredentials = null;
        Object newObject = null;
        newCredentials = this.storeSS.getCredentials(pc, sObjectDN, gadgetID, URL2);
        if (newCredentials != null) {
            byteCredentials = (byte[])newCredentials.clone();
            if (key != null) {
                this.cryptSS.decryptCredentials(key, byteCredentials);
            }
            try {
                ByteArrayInputStream istream = new ByteArrayInputStream(byteCredentials);
                ObjectInputStream p = new ObjectInputStream(istream);
                newObject = p.readObject();
                p.close();
                istream.close();
            }
            catch (Exception e) {
                Debug.log("PortalSecretStoreImpl", 1, e);
            }
        } else {
            throw new SSException(SSException.SS_CREDENTIAL_NOT_FOUND);
        }
        return newObject;
    }

    @Override
    public BasicCredentials getSharedCredentials(PortalSession session, String secretName, String key) throws SSException {
        return (BasicCredentials)this.getCredentials(session, "", secretName, key);
    }

    @Override
    public BasicCredentials getSharedCredentials(PortalSession session, String secretName) throws SSException {
        return (BasicCredentials)this.getCredentials(session, "", secretName, null);
    }

    @Override
    public BasicCredentials getSharedCredentials(PortalConnection pc, String sObjectDN, String secretName, String key) throws SSException, PortalDirectoryException {
        return (BasicCredentials)this.getCredentials(pc, sObjectDN, "", secretName, key);
    }

    @Override
    public void setCredentials(PortalSession session, String gadgetID, String URL2, Object credentials) throws SSException {
        this.setCredentials(session, gadgetID, URL2, credentials, null);
    }

    @Override
    public void setCredentials(PortalSession session, String gadgetID, String URL2, Object credentials, Object key) throws SSException {
        byte[] byteCredentials = null;
        try {
            ByteArrayOutputStream ostream = new ByteArrayOutputStream();
            ObjectOutputStream p = new ObjectOutputStream(ostream);
            p.writeObject(credentials);
            byteCredentials = ostream.toByteArray();
            p.flush();
            ostream.close();
            if (byteCredentials.length > MAXSIZE) {
                throw new SSException(SSException.SS_OBJECT_TOO_BIG);
            }
        }
        catch (IOException e) {
            throw new SSException(SSException.SS_OBJECT_NOT_SERIALIZABLE);
        }
        if (key != null) {
            this.cryptSS.encryptCredentials(key, byteCredentials);
        }
        this.cryptSS.encryptCredentials(session, byteCredentials);
        this.storeSS.putCredentials(session, gadgetID, URL2, byteCredentials);
    }

    @Override
    public void setCredentials(PortalConnection pc, String sObjectDN, String gadgetID, String URL2, Object credentials, Object key) throws SSException, PortalDirectoryException {
        byte[] byteCredentials = null;
        try {
            ByteArrayOutputStream ostream = new ByteArrayOutputStream();
            ObjectOutputStream p = new ObjectOutputStream(ostream);
            p.writeObject(credentials);
            byteCredentials = ostream.toByteArray();
            p.flush();
            ostream.close();
            if (byteCredentials.length > MAXSIZE) {
                throw new SSException(SSException.SS_OBJECT_TOO_BIG);
            }
        }
        catch (IOException e) {
            throw new SSException(SSException.SS_OBJECT_NOT_SERIALIZABLE);
        }
        if (key != null) {
            this.cryptSS.encryptCredentials(key, byteCredentials);
        }
        this.storeSS.putCredentials(pc, sObjectDN, gadgetID, URL2, byteCredentials);
    }

    @Override
    public void setSharedCredentials(PortalSession session, String secretName, BasicCredentials credentials) throws SSException {
        this.setCredentials(session, "", secretName, credentials, null);
    }

    @Override
    public void setSharedCredentials(PortalSession session, String secretName, BasicCredentials credentials, String key) throws SSException {
        this.setCredentials(session, "", secretName, credentials, key);
    }

    @Override
    public void setSharedCredentials(PortalConnection pc, String sObjectDN, String secretName, BasicCredentials credentials, String key) throws SSException, PortalDirectoryException {
        this.setCredentials(pc, sObjectDN, "", secretName, credentials, key);
    }

    @Override
    public void removeSecretStore(PortalSession session, String gadgetID, String URL2) {
        this.storeSS.removeCredentials(session, gadgetID, URL2);
    }

    @Override
    public void removeCredentials(PortalConnection pc, String sObjectDN, String gadgetID, String URL2) throws PortalDirectoryException {
        this.storeSS.removeCredentials(pc, sObjectDN, gadgetID, URL2);
    }

    @Override
    public void removeSharedSecretStore(PortalSession session, String secretName) throws SSException {
        this.removeSecretStore(session, "", secretName);
    }

    @Override
    public void removeSharedCredentials(PortalConnection pc, String sObjectDN, String secretName) throws SSException, PortalDirectoryException {
        this.removeCredentials(pc, sObjectDN, "", secretName);
    }

    @Override
    public void deleteSS(PortalSession session) {
        this.storeSS.startEnumeration(session);
        StoreEnumObject currentObject = this.storeSS.getNextElement(session);
        while (currentObject != null) {
            this.storeSS.removeElement(session, currentObject);
            currentObject = this.storeSS.getNextElement(session);
        }
    }

    @Override
    public void syncStorage(PortalSession session, String oldPassword, String newPassword) {
        this.cryptSS.insertPass(session, oldPassword.toLowerCase());
        String newPassLower = newPassword.toLowerCase();
        this.unlockSecrets(session, newPassLower);
        this.cryptSS.insertPass(session, newPassLower);
    }

    @Override
    public int getAuthFlags(PortalSession session) {
        Integer flags = (Integer)session.getAttribute(flagsTag);
        return flags;
    }

    @Override
    public void setAuthFlags(PortalSession session, int authFlags) {
        Integer flags = new Integer(authFlags);
        session.setAttribute(flagsTag, flags);
    }

    @Override
    public void unlockSecrets(PortalSession session, Object key) {
        String sEncryptString = ConfigManager.getPortalSetting("System.PortalSSEncryptString");
        if (sEncryptString != null) {
            return;
        }
        this.storeSS.startEnumeration(session);
        StoreEnumObject currentObject = this.storeSS.getNextElement(session);
        while (currentObject != null) {
            byte[] theObject = currentObject.getStoreObject();
            this.cryptSS.decryptCredentials(session, theObject);
            this.cryptSS.encryptCredentials(key, theObject);
            currentObject.setData(theObject);
            this.storeSS.updateElement(session, currentObject);
            currentObject = this.storeSS.getNextElement(session);
        }
    }
}

