/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.authentication.sso;

import com.novell.nps.authentication.sso.CryptSS;
import com.novell.nps.configManager.ConfigManager;
import com.novell.nps.serviceProviders.NPSMacroParser;
import com.novell.nps.sessionManager.PortalSession;

public class XORCrypt
implements CryptSS {
    private static final String sessionTag = new String("SSKey");

    public void XORProtectData(int index, byte[] data, long key) {
        int length = data.length;
        int i = 0;
        while (i < length) {
            if (index > 63) {
                index = 1;
            }
            int position = index / 8;
            int offset = index % 8;
            long mask = key >>> offset * 8 + position;
            int n = i++;
            data[n] = (byte)((long)data[n] ^ mask);
            ++index;
        }
    }

    @Override
    public void encryptCredentials(PortalSession session, byte[] data) {
        this.XORProtectData(0, data, this.getPass(session));
    }

    @Override
    public void decryptCredentials(PortalSession session, byte[] data) {
        this.XORProtectData(0, data, this.getPass(session));
    }

    @Override
    public void encryptCredentials(Object key, byte[] data) {
        Long pass = new Long((long)key.hashCode() * (long)key.hashCode());
        this.XORProtectData(0, data, pass);
    }

    @Override
    public void decryptCredentials(Object key, byte[] data) {
        Long pass = new Long((long)key.hashCode() * (long)key.hashCode());
        this.XORProtectData(0, data, pass);
    }

    @Override
    public void insertPass(PortalSession session, String key) {
        Long pass;
        String sEncryptString = ConfigManager.getPortalSetting("System.PortalSSEncryptString");
        if (sEncryptString != null) {
            if (sEncryptString.startsWith("%")) {
                String sMacroValue = NPSMacroParser.parseMacroString(sEncryptString, session, true);
                pass = new Long((long)sMacroValue.hashCode() * (long)sMacroValue.hashCode());
            } else {
                pass = new Long((long)sEncryptString.hashCode() * (long)sEncryptString.hashCode());
            }
        } else {
            pass = new Long((long)key.hashCode() * (long)key.hashCode());
        }
        session.setAttribute(sessionTag, pass);
    }

    private long getPass(PortalSession session) {
        Long pass = (Long)session.getAttribute(sessionTag);
        if (pass != null) {
            return pass;
        }
        return -1L;
    }
}

