/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.configManager;

import com.novell.emframe.dev.D;
import com.novell.emframe.dev.config.SystemConfig;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.Registry;
import com.novell.emframe.fw.config.ModuleManager;
import com.novell.nps.authentication.PortalConnection;
import com.novell.nps.configManager.GUID;
import com.novell.nps.configManager.Setting;
import com.novell.nps.configManager.SettingValue;
import com.novell.nps.serviceProviders.ServiceManager;
import com.novell.nps.sessionManager.PortalSession;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpSession;

public class ConfigManager
implements Serializable {
    public static final String GADGET_HAS_HELP = "Has Help";
    public static final String ALLOW_COPYING_IN_PREFERENCES = "Allow Copying In Preferences";
    public static final long DEFAULT_CACHE_TIMEOUT = 82800000L;
    private static final String DISABLE_SCHEME_CACHE = "System.DisableSchemeCache";
    public static String SYSTEM_DECODE_REQUEST = "System.DecodeRequest";
    public static String SYSTEM_DECODE_CHARSET = "System.DecodeCharset";
    public static String SYSTEM_USER_CLASS = "System.UserClass";
    private static long m_lInheritCacheTimeout = 82800000L;
    static ResourceBundle m_res = ResourceBundle.getBundle("com.novell.nps.configManager.ConfigManagerRes");
    static Object m_syncPublic = new Object();
    private static Locale m_locPortal = Locale.getDefault();
    private static HashMap m_hmUserResourceBundle = new HashMap();
    private static SystemConfig m_syscfg = new SystemConfig();

    public static void init() {
        String sTemp = null;
        m_res = ResourceBundle.getBundle("com.novell.nps.configManager.ConfigManagerRes", ConfigManager.getSystemLocale());
        sTemp = ConfigManager.getProperty(DISABLE_SCHEME_CACHE);
        sTemp = ConfigManager.getProperty(SYSTEM_USER_CLASS);
        if (sTemp != null && sTemp.length() > 0) {
            D.log((String)("*** Using [" + sTemp + "] as the user class ***"));
            PortalConnection.setUserClass(sTemp);
        }
        m_res = ResourceBundle.getBundle("com.novell.nps.configManager.ConfigManagerRes", ConfigManager.getSystemLocale());
        ConfigManager.readInheritCacheTimeout();
        ServiceManager.init();
        Registry.refreshGlobalRegistry();
        Registry.refreshInstallRegistry();
        Registry.checkOES();
        ModuleManager.readModules();
    }

    public static String getPortalSetting(String sSetting) {
        String sRet = null;
        String sTemp = null;
        sTemp = sSetting.replace(' ', '_');
        sRet = ConfigManager.getProperty(sTemp);
        if (sRet == null) {
            sRet = ConfigManager.getSingleSetting(sSetting);
        }
        return sRet;
    }

    public static String getPortalSetting(String sSetting, String sDefaultValue) {
        String sRet = null;
        String sTemp = null;
        sTemp = sSetting.replace(' ', '_');
        sRet = ConfigManager.getProperty(sTemp);
        if (sRet == null) {
            sRet = ConfigManager.getSingleSetting(sSetting);
        }
        if (sRet == null) {
            sRet = sDefaultValue;
        }
        return sRet;
    }

    public static String[] getPortalSettings(String sSetting) {
        String[] sRet = null;
        String sTemp = null;
        sTemp = sSetting.replace(' ', '_');
        sRet = ConfigManager.getProperties(sTemp);
        if (sRet == null) {
            sRet = ConfigManager.getSetting(sSetting);
        }
        return sRet;
    }

    public static int getIntPortalSetting(String property, int defaultValue) {
        String sTemp = null;
        sTemp = property.replace(' ', '_');
        int value = ConfigManager.getIntProperty(sTemp);
        if (value < 0) {
            value = ConfigManager.getSingleIntSetting(property, defaultValue);
        }
        return value;
    }

    public static String getProperty(String property) {
        return ConfigManager.getSingleSetting(property);
    }

    public static String getProperty(String property, String defaultValue) {
        String sRet = ConfigManager.getProperty(property);
        if (sRet == null) {
            sRet = defaultValue;
        }
        return sRet;
    }

    public static int getIntProperty(String property) {
        int iValue = -1;
        String value = ConfigManager.getProperty(property);
        if (null != value && value != null) {
            try {
                iValue = Integer.parseInt(value);
            }
            catch (NumberFormatException nfe) {
                iValue = -1;
            }
        }
        return iValue;
    }

    public static int getIntProperty(String property, int defaultValue) {
        int iValue = defaultValue;
        String value = ConfigManager.getProperty(property);
        if (null != value) {
            try {
                iValue = Integer.parseInt(value);
            }
            catch (NumberFormatException nfe) {
                iValue = -1;
            }
        }
        return iValue;
    }

    public static String[] getProperties(String property) {
        Vector<String> values = new Vector<String>();
        String value = ConfigManager.getProperty(property);
        if (value != null) {
            StringTokenizer parser = new StringTokenizer(value, ",");
            while (parser.hasMoreTokens()) {
                values.addElement(parser.nextToken());
            }
        }
        String[] valuesArray = null;
        if (values.size() > 0) {
            valuesArray = new String[values.size()];
            values.toArray(valuesArray);
        }
        return valuesArray;
    }

    private static void readInheritCacheTimeout() {
        long lTimeout;
        String sTemp = null;
        sTemp = ConfigManager.getPortalSetting("Scheme Cache Timeout");
        if (sTemp != null) {
            try {
                lTimeout = Long.parseLong(sTemp);
            }
            catch (NumberFormatException ex) {
                lTimeout = 82800000L;
            }
        } else {
            sTemp = ConfigManager.getPortalSetting("Scheme Cache Timeout Minutes");
            if (sTemp != null) {
                try {
                    lTimeout = Long.parseLong(sTemp) * 60L * 1000L;
                }
                catch (NumberFormatException ex) {
                    lTimeout = 82800000L;
                }
            } else {
                lTimeout = 82800000L;
            }
        }
        if (lTimeout < 0L) {
            lTimeout = 82800000L;
        }
        m_lInheritCacheTimeout = lTimeout;
        D.log((String)("Scheme Cache Timeout is set to: [" + m_lInheritCacheTimeout + "]"));
    }

    public static String[] getSetting(String setting) {
        if (m_syscfg != null) {
            return m_syscfg.getSettings(setting);
        }
        return null;
    }

    public static String getSingleSetting(String setting) {
        if (m_syscfg != null) {
            return m_syscfg.getSetting(setting);
        }
        return null;
    }

    public static String getSingleSettingDisplayValue(String setting, PortalSession session) {
        if (m_syscfg != null) {
            return m_syscfg.getSetting(setting);
        }
        return null;
    }

    public static String getSettingValueDisplayValue(String setting, String value, PortalSession session) {
        if (m_syscfg != null) {
            return m_syscfg.getSetting(setting);
        }
        return null;
    }

    public static int getSingleIntSetting(String setting) {
        String sRet;
        int iRet = 0;
        if (m_syscfg != null && (sRet = m_syscfg.getSetting(setting)) != null) {
            try {
                iRet = Integer.parseInt(sRet);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return iRet;
    }

    public static int getSingleIntSetting(String setting, int defaultValue) {
        String sRet;
        int iRet = defaultValue;
        if (m_syscfg != null && (sRet = m_syscfg.getSetting(setting)) != null) {
            try {
                iRet = Integer.parseInt(sRet);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return iRet;
    }

    public static String getSingleSetting(String setting, String defaultValue) {
        if (m_syscfg != null) {
            return m_syscfg.getSetting(setting, defaultValue);
        }
        return defaultValue;
    }

    public static Setting getSingleSettingObject(String setting) {
        if (m_syscfg != null) {
            String[] saRet = m_syscfg.getSettings(setting);
            Setting s = new Setting();
            s.setName(setting);
            Vector<SettingValue> v = new Vector<SettingValue>();
            if (saRet != null) {
                for (int i = 0; i < saRet.length; ++i) {
                    SettingValue sv = new SettingValue(saRet[i]);
                    v.add(sv);
                }
            }
            s.setValues(v);
            return s;
        }
        return null;
    }

    public static String getPCOID() {
        return "{E5BAE001-0000-00F1-1D4E-C6AB89419537}";
    }

    public static String getPCOFDN() {
        return "cn=portal,o=nps";
    }

    public static String getPortalDirectory() {
        String sDirectory = "";
        return sDirectory;
    }

    public static Vector getDirectoryAddresses() {
        return null;
    }

    public static int getGUIDAsInt() {
        GUID guid = new GUID();
        String sGUID = guid.toString();
        int iGUID = sGUID.hashCode();
        return iGUID;
    }

    public static boolean useDirectorySSL(String sDirectory) {
        boolean bRet = false;
        return bRet;
    }

    public static Locale getSystemLocale() {
        String sLang = ConfigManager.getPortalSetting("Portal Language", "en");
        String sCountry = ConfigManager.getPortalSetting("Portal Country", "");
        if (!sLang.equals(m_locPortal.getLanguage()) || !sCountry.equals(m_locPortal.getCountry())) {
            m_locPortal = new Locale(sLang, sCountry);
        }
        return m_locPortal;
    }

    public static ResourceBundle getResourceBundle() {
        return m_res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceBundle getUserResourceBundle(PortalSession session) {
        ResourceBundle res = null;
        Locale[] locUser = FwUtils.getLocales((HttpSession)session);
        if (locUser != null && locUser.length > 0 && (res = (ResourceBundle)m_hmUserResourceBundle.get(locUser[0])) == null) {
            HashMap hashMap = m_hmUserResourceBundle;
            synchronized (hashMap) {
                res = (ResourceBundle)m_hmUserResourceBundle.get(locUser[0]);
                if (res == null && (res = ResourceBundle.getBundle("com.novell.nps.configManager.ConfigManagerRes", locUser[0])) != null) {
                    m_hmUserResourceBundle.put(locUser[0], res);
                }
            }
        }
        if (res == null) {
            res = m_res;
        }
        return res;
    }

    public static String getLanguageCode(Locale loc) {
        if (loc == null) {
            return null;
        }
        String sLanguageCode = "";
        String sLanguage = loc.getLanguage();
        if (sLanguage != null) {
            List<String> allLanguages;
            String possibleLang = sLanguage;
            if (sLanguage.length() > 2) {
                possibleLang = sLanguage.substring(0, 2);
            }
            if ((allLanguages = Arrays.asList(Locale.getISOLanguages())).contains(possibleLang)) {
                sLanguageCode = possibleLang;
            }
        }
        return sLanguageCode;
    }

    public static String getPortalTree() {
        return null;
    }

    public static Properties getPortalProperties() {
        Properties allProps = new Properties();
        if (m_syscfg != null) {
            HashMap<String, String> hmProps = new HashMap<String, String>();
            String[] saNames = m_syscfg.getSettingNames();
            if (saNames != null) {
                String sTemp = null;
                for (int i = 0; i < saNames.length; ++i) {
                    sTemp = m_syscfg.getSetting(saNames[i]);
                    if (sTemp == null) continue;
                    hmProps.put(saNames[i], sTemp);
                }
            }
            allProps.putAll((Map<?, ?>)hmProps);
        }
        return allProps;
    }
}

