/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.configManager;

import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.servlet.FwSession;
import com.novell.nps.authentication.AuthenticationManager;
import com.novell.nps.authentication.PortalConnection;
import com.novell.nps.authentication.PortalDirectoryException;
import com.novell.nps.configManager.ConfigData;
import com.novell.nps.configManager.GUID;
import com.novell.nps.configManager.GadgetAssignment;
import com.novell.nps.configManager.GadgetConfig;
import com.novell.nps.configManager.ObjectConfigRecord;
import com.novell.nps.configManager.Setting;
import com.novell.nps.configManager.SettingValue;
import com.novell.nps.debug.Debug;
import com.novell.nps.gadgetManager.XmlUtil;
import com.novell.nps.sessionManager.PortalSession;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ConfigSettings
implements ConfigData,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String CONFIG = "config";
    public static final String DIRECTORY_CONFIG = "directory_config";
    public static final String SETTING = "setting";
    public static final String OBJECT_STRING_START = "ACED00057372";
    public static final String DT = "ConfigSettings";
    public static final String EXT_PROPERTIES = ".properties";
    private HashMap m_hmSettings = null;
    private ObjectConfigRecord m_ocr = null;
    private String m_searchElement = null;
    private String m_creationElement = null;
    private String m_sPath = null;

    public ConfigSettings() {
        this.m_hmSettings = new HashMap();
        this.m_ocr = null;
        StringBuffer sb = new StringBuffer(17);
        sb.append(CONFIG);
        sb.append("\\");
        sb.append(SETTING);
        this.m_searchElement = sb.toString();
        this.m_creationElement = CONFIG;
    }

    public ConfigSettings(Hashtable ht) {
        this();
        this.m_hmSettings = new HashMap(ht);
    }

    public ConfigSettings(ObjectConfigRecord ocr) {
        this.m_hmSettings = new HashMap();
        this.m_ocr = ocr;
        StringBuffer sb = new StringBuffer(17);
        sb.append(CONFIG);
        sb.append("\\");
        sb.append(SETTING);
        this.m_searchElement = sb.toString();
        this.m_creationElement = CONFIG;
    }

    public ConfigSettings(ObjectConfigRecord ocr, String sSearchElement) {
        StringBuffer sb = new StringBuffer(30);
        this.m_hmSettings = new HashMap();
        this.m_ocr = ocr;
        if (sSearchElement != null && sSearchElement.length() != 0) {
            sb.append(CONFIG);
            sb.append("\\");
            sb.append(sSearchElement);
            sb.append("\\");
            sb.append(SETTING);
            this.m_searchElement = sb.toString();
            this.m_creationElement = sSearchElement;
        } else {
            sb.append(CONFIG);
            sb.append("\\");
            sb.append(SETTING);
            this.m_searchElement = sb.toString();
            this.m_creationElement = CONFIG;
        }
    }

    @Override
    public void setFileSystemPath(String sPath) {
        this.m_sPath = sPath;
    }

    @Override
    public String getFileSystemPath() {
        return this.m_sPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getSettingNames() {
        if (this.m_hmSettings == null) {
            return null;
        }
        String[] keyNames = null;
        HashMap hashMap = this.m_hmSettings;
        synchronized (hashMap) {
            Set s = this.m_hmSettings.keySet();
            if (s != null) {
                keyNames = new String[s.size()];
                s.toArray(keyNames);
            }
        }
        return keyNames;
    }

    @Override
    public String[] getSetting(String setting) {
        Vector values;
        if (setting == null) {
            return null;
        }
        Setting tempSetting = (Setting)this.m_hmSettings.get(setting);
        if (tempSetting != null && (values = tempSetting.getValues()) != null && values.size() != 0) {
            String[] tempStringArray = new String[values.size()];
            SettingValue tempSV = null;
            Enumeration e = values.elements();
            int i = 0;
            while (e.hasMoreElements()) {
                tempSV = (SettingValue)e.nextElement();
                tempStringArray[i] = tempSV.getValue();
                ++i;
            }
            return tempStringArray;
        }
        return null;
    }

    @Override
    public Object[] getObjectSetting(String setting) {
        Vector values;
        Object[] objValues = null;
        Object tempObj = null;
        if (setting == null) {
            return null;
        }
        Setting tempSetting = (Setting)this.m_hmSettings.get(setting);
        if (tempSetting != null && (values = tempSetting.getValues()) != null && values.size() != 0) {
            objValues = new Object[values.size()];
            SettingValue tempSV = null;
            String tempString = null;
            int readvalcount = 0;
            for (int valcount = 0; valcount < values.size(); ++valcount) {
                tempSV = (SettingValue)values.elementAt(valcount);
                tempObj = tempSV.getObjectValue();
                if (tempObj == null) {
                    byte[] ba;
                    if (Debug.isLoggable(3)) {
                        Debug.log(3, DT, "Deserialized Object not found in cache.");
                    }
                    if ((tempString = tempSV.getValue()) == null || (ba = GUID.HexStringAsByte(tempString)) == null || ba.length == 0) continue;
                    ByteArrayInputStream bais = new ByteArrayInputStream(ba);
                    try {
                        ObjectInputStream ois = new ObjectInputStream(bais);
                        objValues[readvalcount] = ois.readObject();
                        tempSV.setObjectValue(objValues[readvalcount]);
                        ++readvalcount;
                    }
                    catch (IOException ioe) {
                        if (!Debug.isLoggable(3)) continue;
                        Debug.log(DT, 3, ioe);
                    }
                    catch (ClassNotFoundException cnfe) {
                        if (!Debug.isLoggable(3)) continue;
                        Debug.log(DT, 3, cnfe);
                    }
                    continue;
                }
                objValues[readvalcount] = tempObj;
                ++readvalcount;
            }
            return objValues;
        }
        return objValues;
    }

    @Override
    public String getSingleSetting(String setting) {
        return this.getSingleSetting(setting, null);
    }

    @Override
    public String getSingleSetting(String setting, String defaultValue) {
        Vector values;
        if (setting == null) {
            return defaultValue;
        }
        Setting tempSetting = (Setting)this.m_hmSettings.get(setting);
        if (tempSetting != null && (values = tempSetting.getValues()) != null && values.size() != 0) {
            SettingValue tempSV = (SettingValue)values.elementAt(0);
            String tempString = tempSV.getValue();
            return tempString;
        }
        return defaultValue;
    }

    @Override
    public String getSingleSettingDisplayValue(String setting, PortalSession session) {
        SettingValue tempSV;
        Vector values;
        String sDisplayValue = null;
        if (setting == null || setting.length() == 0) {
            return null;
        }
        Setting tempSetting = (Setting)this.m_hmSettings.get(setting);
        if (tempSetting != null && (values = tempSetting.getValues()) != null && values.size() != 0 && ((sDisplayValue = (tempSV = (SettingValue)values.elementAt(0)).getDisplayValue(session)) == null || sDisplayValue.length() == 0)) {
            sDisplayValue = tempSV.getValue();
        }
        return sDisplayValue;
    }

    public String getSettingValueDisplayValue(String setting, String value, PortalSession session) {
        String sDisplayValue = value;
        if (setting == null || setting.length() == 0 || value == null || value.length() == 0) {
            return sDisplayValue;
        }
        Setting tempSetting = (Setting)this.m_hmSettings.get(setting);
        if (tempSetting != null) {
            sDisplayValue = tempSetting.getSettingValueDisplayValue(value, session);
        }
        return sDisplayValue;
    }

    public Vector getSettingValues(String setting) {
        if (setting == null) {
            return null;
        }
        Setting tempSetting = (Setting)this.m_hmSettings.get(setting);
        if (tempSetting != null) {
            return tempSetting.getValues();
        }
        return null;
    }

    @Override
    public int getSingleIntSetting(String setting) {
        return this.getSingleIntSetting(setting, 0);
    }

    @Override
    public int getSingleIntSetting(String setting, int defaultValue) {
        Vector values;
        int value = defaultValue;
        if (setting == null) {
            return defaultValue;
        }
        Setting tempSetting = (Setting)this.m_hmSettings.get(setting);
        if (tempSetting != null && (values = tempSetting.getValues()) != null && values.size() != 0) {
            SettingValue tempSV = (SettingValue)values.elementAt(0);
            String tempString = tempSV.getValue();
            if (tempString != null) {
                try {
                    value = Integer.parseInt(tempString);
                }
                catch (NumberFormatException nfe) {
                    value = defaultValue;
                }
            }
            return value;
        }
        return defaultValue;
    }

    @Override
    public Object getSingleObjectSetting(String setting) {
        return this.getSingleObjectSetting(setting, null);
    }

    @Override
    public Object getSingleObjectSetting(String setting, Object defaultValue) {
        Vector values;
        Object value = defaultValue;
        Object tempObj = null;
        if (setting == null) {
            return defaultValue;
        }
        Setting tempSetting = (Setting)this.m_hmSettings.get(setting);
        if (tempSetting != null && (values = tempSetting.getValues()) != null && values.size() != 0) {
            SettingValue tempSV = (SettingValue)values.elementAt(0);
            tempObj = tempSV.getObjectValue();
            if (tempObj == null) {
                byte[] ba;
                String tempString;
                if (Debug.isLoggable(3)) {
                    Debug.log(3, DT, "Deserialized Object not found in cache.");
                }
                if ((tempString = tempSV.getValue()) != null && (ba = GUID.HexStringAsByte(tempString)) != null && ba.length != 0) {
                    ByteArrayInputStream bais = new ByteArrayInputStream(ba);
                    try {
                        ObjectInputStream ois = new ObjectInputStream(bais);
                        value = ois.readObject();
                    }
                    catch (IOException ioe) {
                        if (Debug.isLoggable(3)) {
                            Debug.log(DT, 3, ioe);
                        }
                        return defaultValue;
                    }
                    catch (ClassNotFoundException cnfe) {
                        if (Debug.isLoggable(3)) {
                            Debug.log(DT, 3, cnfe);
                        }
                        return defaultValue;
                    }
                }
            } else {
                value = tempSV.getObjectValue();
            }
            return value;
        }
        return defaultValue;
    }

    @Override
    public void emptySetting(String setting) {
        if (setting == null) {
            return;
        }
        Setting tempSetting = (Setting)this.m_hmSettings.get(setting);
        if (tempSetting != null) {
            Vector valuesVector = new Vector();
            tempSetting.setValues(valuesVector);
        }
    }

    @Override
    public void setSetting(String setting, String[] values) {
        if (setting == null || values == null) {
            return;
        }
        SettingValue tempSV = null;
        Setting tempSetting = (Setting)this.m_hmSettings.get(setting);
        HashMap<String, SettingValue> hm = new HashMap<String, SettingValue>();
        if (tempSetting != null) {
            Vector vExistingValues = tempSetting.getValues();
            if (vExistingValues != null && vExistingValues.size() != 0) {
                Enumeration eExistingValues = vExistingValues.elements();
                while (eExistingValues.hasMoreElements()) {
                    tempSV = (SettingValue)eExistingValues.nextElement();
                    hm.put(tempSV.getValue(), tempSV);
                }
            }
            Vector<SettingValue> valuesVector = new Vector<SettingValue>();
            for (int i = 0; i < values.length; ++i) {
                tempSV = (SettingValue)hm.get(values[i]);
                if (tempSV == null) {
                    tempSV = new SettingValue(values[i]);
                    hm.put(values[i], tempSV);
                }
                valuesVector.addElement(tempSV);
            }
            tempSetting.setValues(valuesVector);
        } else {
            Vector<SettingValue> valuesVector = new Vector<SettingValue>();
            for (int i = 0; i < values.length; ++i) {
                tempSV = (SettingValue)hm.get(values[i]);
                if (tempSV == null) {
                    tempSV = new SettingValue(values[i]);
                    hm.put(values[i], tempSV);
                }
                valuesVector.addElement(tempSV);
            }
            this.addNewSetting(setting, valuesVector, true, false);
        }
    }

    @Override
    public void setSetting(String setting, String value) {
        if (setting == null) {
            return;
        }
        String[] saValues = new String[]{value};
        this.setSetting(setting, saValues);
    }

    @Override
    public void setIntSetting(String setting, int[] values) {
        if (setting == null || values == null) {
            return;
        }
        String[] saValues = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            saValues[i] = String.valueOf(values[i]);
        }
        this.setSetting(setting, saValues);
    }

    @Override
    public void setIntSetting(String setting, int value) {
        if (setting == null) {
            return;
        }
        String[] saValues = new String[]{String.valueOf(value)};
        this.setSetting(setting, saValues);
    }

    @Override
    public void setObjectSetting(String setting, Object value) {
        if (setting == null) {
            return;
        }
        Object[] saValues = new Object[]{value};
        this.setObjectSetting(setting, saValues);
    }

    @Override
    public void setObjectSetting(String setting, Object[] values) {
        Vector vExistingValues;
        if (setting == null || values == null) {
            return;
        }
        HashMap<String, SettingValue> hm = new HashMap<String, SettingValue>();
        SettingValue tempSV = null;
        Setting tempSetting = (Setting)this.m_hmSettings.get(setting);
        if (tempSetting != null && (vExistingValues = tempSetting.getValues()) != null && vExistingValues.size() != 0) {
            Enumeration eExistingValues = vExistingValues.elements();
            while (eExistingValues.hasMoreElements()) {
                tempSV = (SettingValue)eExistingValues.nextElement();
                hm.put(tempSV.getValue(), tempSV);
            }
        }
        Vector<SettingValue> valuesVector = new Vector<SettingValue>();
        for (int valcounter = 0; valcounter < values.length; ++valcounter) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(values[valcounter]);
                oos.flush();
            }
            catch (IOException ioe) {
                if (!Debug.isLoggable(3)) continue;
                Debug.log(DT, 3, ioe);
                continue;
            }
            byte[] ba = baos.toByteArray();
            StringBuffer sb = new StringBuffer(ba.length * 2 + 1);
            for (int i = 0; i < ba.length; ++i) {
                sb.append(GUID.byteAsHexString(ba[i]));
            }
            tempSV = (SettingValue)hm.get(sb.toString());
            if (tempSV == null) {
                tempSV = new SettingValue(sb.toString());
                tempSV.setObjectValue(values[valcounter]);
                hm.put(tempSV.getValue(), tempSV);
            }
            valuesVector.addElement(tempSV);
        }
        if (tempSetting != null) {
            tempSetting.setValues(valuesVector);
        } else {
            this.addNewSetting(setting, valuesVector, true, false);
        }
    }

    @Override
    public void addSettingValue(String setting, String value) {
        if (setting == null || value == null) {
            return;
        }
        Setting tempSetting = (Setting)this.m_hmSettings.get(setting);
        if (tempSetting != null) {
            Vector valuesVector = tempSetting.getValues();
            if (valuesVector != null) {
                Enumeration e = valuesVector.elements();
                SettingValue tempSV = null;
                while (e.hasMoreElements()) {
                    tempSV = (SettingValue)e.nextElement();
                    if (!tempSV.getValue().equalsIgnoreCase(value)) continue;
                    return;
                }
                tempSV = new SettingValue(value);
                valuesVector.add(tempSV);
                tempSetting.setValues(valuesVector);
            }
        } else {
            this.setSetting(setting, value);
        }
    }

    @Override
    public void addSettingIntValue(String setting, int value) {
        if (setting == null) {
            return;
        }
        Setting tempSetting = (Setting)this.m_hmSettings.get(setting);
        if (tempSetting != null) {
            Vector valuesVector = tempSetting.getValues();
            if (valuesVector != null) {
                String tempString = String.valueOf(value);
                Enumeration e = valuesVector.elements();
                SettingValue tempSV = null;
                while (e.hasMoreElements()) {
                    tempSV = (SettingValue)e.nextElement();
                    if (!tempSV.getValue().equalsIgnoreCase(tempString)) continue;
                    return;
                }
                tempSV = new SettingValue(tempString);
                valuesVector.add(tempSV);
                tempSetting.setValues(valuesVector);
            }
        } else {
            this.setIntSetting(setting, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSetting(String setting) {
        if (setting == null) {
            return;
        }
        HashMap hashMap = this.m_hmSettings;
        synchronized (hashMap) {
            this.m_hmSettings.remove(setting);
        }
    }

    @Override
    public void removeSettingValue(String setting, String value) {
        Vector valuesVector;
        if (setting == null || value == null) {
            return;
        }
        Setting tempSetting = (Setting)this.m_hmSettings.get(setting);
        if (tempSetting != null && (valuesVector = tempSetting.getValues()) != null) {
            Enumeration e = valuesVector.elements();
            SettingValue tempSV = null;
            while (e.hasMoreElements()) {
                tempSV = (SettingValue)e.nextElement();
                if (!tempSV.getValue().equalsIgnoreCase(value)) continue;
                valuesVector.removeElement(tempSV);
                tempSetting.setValues(valuesVector);
                return;
            }
        }
    }

    @Override
    public void removeSettingIntValue(String setting, int value) {
        Vector valuesVector;
        if (setting == null) {
            return;
        }
        Setting tempSetting = (Setting)this.m_hmSettings.get(setting);
        if (tempSetting != null && (valuesVector = tempSetting.getValues()) != null) {
            String tempString = String.valueOf(value);
            Enumeration e = valuesVector.elements();
            SettingValue tempSV = null;
            while (e.hasMoreElements()) {
                tempSV = (SettingValue)e.nextElement();
                if (!tempSV.getValue().equalsIgnoreCase(tempString)) continue;
                valuesVector.removeElement(tempSV);
                tempSetting.setValues(valuesVector);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mergeConfig(ConfigData newConfig, boolean bSettingMustExist, boolean bAlwaysOverwrite) {
        if (newConfig != null && newConfig.getFileSystemPath() != null) {
            this.m_sPath = newConfig.getFileSystemPath();
        }
        if (newConfig == null || newConfig.isEmpty()) {
            return;
        }
        if (this.m_hmSettings == null || this.m_hmSettings.isEmpty()) {
            if (this.m_hmSettings == null) {
                this.m_hmSettings = new HashMap();
            }
            HashMap hashMap = this.m_hmSettings;
            synchronized (hashMap) {
                HashMap hm = newConfig.getSettingsHashMap();
                if (hm != null) {
                    this.m_hmSettings.putAll(hm);
                }
            }
            return;
        }
        HashMap newSettingHash = newConfig.getSettingsHashMap();
        Setting newSetting = null;
        Setting oldSetting = null;
        String sKey2 = null;
        Set s = newSettingHash.keySet();
        for (String sKey2 : s) {
            HashMap hashMap;
            newSetting = (Setting)newSettingHash.get(sKey2);
            oldSetting = (Setting)this.m_hmSettings.get(sKey2);
            if (oldSetting == null) {
                if (bSettingMustExist) continue;
                hashMap = this.m_hmSettings;
                synchronized (hashMap) {
                    this.m_hmSettings.put(sKey2, newSetting);
                    continue;
                }
            }
            if (oldSetting.getCumulative() && !bAlwaysOverwrite) {
                Vector<SettingValue> tempVector = oldSetting.getValues();
                if (tempVector == null) {
                    tempVector = new Vector<SettingValue>();
                }
                SettingValue tempSV = null;
                Hashtable<String, SettingValue> ht = new Hashtable<String, SettingValue>();
                Enumeration hte = tempVector.elements();
                while (hte.hasMoreElements()) {
                    tempSV = (SettingValue)hte.nextElement();
                    ht.put(tempSV.getValue(), tempSV);
                }
                Vector newConfigVector = newSetting.getValues();
                if (newConfigVector != null) {
                    hte = newConfigVector.elements();
                    while (hte.hasMoreElements()) {
                        tempSV = (SettingValue)hte.nextElement();
                        if (ht.get(tempSV.getValue()) != null) continue;
                        tempVector.add(tempSV);
                        ht.put(tempSV.getValue(), tempSV);
                    }
                }
                oldSetting.setValues(tempVector);
                oldSetting.setCumulative(newSetting.getCumulative());
                oldSetting.setOverwriteable(newSetting.getOverwriteable());
                HashMap hashMap2 = this.m_hmSettings;
                synchronized (hashMap2) {
                    this.m_hmSettings.put(sKey2, oldSetting);
                    continue;
                }
            }
            if (!bAlwaysOverwrite && !oldSetting.getOverwriteable()) continue;
            oldSetting.setValues(newSetting.getValues());
            oldSetting.setCumulative(newSetting.getCumulative());
            oldSetting.setOverwriteable(newSetting.getOverwriteable());
            hashMap = this.m_hmSettings;
            synchronized (hashMap) {
                this.m_hmSettings.put(sKey2, oldSetting);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAvailableSettingsTypes(GadgetConfig gadConfig, PortalSession session) {
        if (gadConfig == null) {
            return;
        }
        ConfigSettings availableSettings = gadConfig.getAvailableConfigSettings(session);
        if (availableSettings == null) {
            return;
        }
        HashMap availableSettingHash = availableSettings.getSettingsHashMap();
        Setting availableSetting = null;
        Setting oldSetting = null;
        String sKey2 = null;
        Set s = availableSettingHash.keySet();
        for (String sKey2 : s) {
            availableSetting = (Setting)availableSettingHash.get(sKey2);
            oldSetting = (Setting)this.m_hmSettings.get(sKey2);
            if (oldSetting == null) continue;
            oldSetting.setType(availableSetting.getType());
            oldSetting.setParseMacros(availableSetting.getParseMacros());
            HashMap hashMap = this.m_hmSettings;
            synchronized (hashMap) {
                this.m_hmSettings.put(sKey2, oldSetting);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Hashtable getSettingsHash() {
        Hashtable ht = null;
        HashMap hashMap = this.m_hmSettings;
        synchronized (hashMap) {
            ht = new Hashtable(this.m_hmSettings);
        }
        return ht;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap getSettingsHashMap() {
        HashMap hm = null;
        HashMap hashMap = this.m_hmSettings;
        synchronized (hashMap) {
            hm = new HashMap(this.m_hmSettings);
        }
        return hm;
    }

    @Override
    public boolean isEmpty() {
        boolean bRet = false;
        if (this.m_hmSettings.size() == 0) {
            bRet = true;
        }
        return bRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection getSettingsCollection() {
        Collection coRet = null;
        HashMap hashMap = this.m_hmSettings;
        synchronized (hashMap) {
            coRet = this.m_hmSettings.values();
        }
        return coRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSettingsHash(Hashtable settings) {
        HashMap hashMap = this.m_hmSettings;
        synchronized (hashMap) {
            this.m_hmSettings.clear();
            this.m_hmSettings.putAll(settings);
        }
    }

    @Override
    public Setting getSingleSettingObject(String setting) {
        if (setting == null) {
            return null;
        }
        return (Setting)this.m_hmSettings.get(setting);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSingleSettingObject(Setting tempSetting) {
        if (tempSetting != null && tempSetting.getName() != null && tempSetting.getName().length() != 0) {
            HashMap hashMap = this.m_hmSettings;
            synchronized (hashMap) {
                this.m_hmSettings.put(tempSetting.getName(), tempSetting);
            }
        }
    }

    @Override
    public void readSettings() {
        if (this.m_ocr == null) {
            return;
        }
        this.readSettings(this.m_ocr.findFirstElement(this.m_searchElement));
    }

    public void readSettings(Node tempNode) {
        if (this.m_ocr == null) {
            return;
        }
        this.readSettings(tempNode, this.m_ocr.getType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readSettings(Node tempNode, int iRecordType) {
        this.emptyData();
        if (tempNode != null) {
            String tempString = null;
            boolean bOverwriteable = true;
            boolean bCumulative = false;
            boolean bAllowMultipleValues = true;
            boolean bAdvanced = false;
            boolean bRequired = false;
            boolean bUserConfigurable = true;
            boolean bAdminConfigurable = true;
            boolean bHideFromUser = false;
            boolean bHideFromAdmin = false;
            boolean bParseMacros = true;
            boolean bTranslatableValues = false;
            Setting tempSetting = null;
            Vector vStr = null;
            Vector vSettingValues = null;
            Hashtable htSettings = null;
            int value = 0;
            while (tempNode != null) {
                htSettings = ObjectConfigRecord.getNodeSettingsTable(tempNode);
                vStr = (Vector)htSettings.get("name");
                if (vStr != null && vStr.size() != 0) {
                    tempSetting = new Setting();
                    tempSetting.setName((String)vStr.elementAt(0));
                    vSettingValues = this.getSettingValues(tempNode, "value");
                    if (vSettingValues != null && vSettingValues.size() != 0) {
                        tempSetting.setValues(vSettingValues);
                    }
                    bOverwriteable = true;
                    vStr = (Vector)htSettings.get("overwriteable");
                    if (vStr != null && (tempString = (String)vStr.elementAt(0)) != null) {
                        try {
                            value = Integer.parseInt(tempString);
                            bOverwriteable = value != 0;
                        }
                        catch (NumberFormatException nfe) {
                            bOverwriteable = true;
                        }
                    }
                    tempSetting.setOverwriteable(bOverwriteable);
                    bCumulative = false;
                    vStr = (Vector)htSettings.get("cumulative");
                    if (vStr != null && (tempString = (String)vStr.elementAt(0)) != null) {
                        try {
                            value = Integer.parseInt(tempString);
                            bCumulative = value != 0;
                        }
                        catch (NumberFormatException nfe) {
                            bCumulative = false;
                        }
                    }
                    tempSetting.setCumulative(bCumulative);
                    if (iRecordType == 6) {
                        vStr = (Vector)htSettings.get("displayname");
                        if (vStr != null) {
                            tempSetting.setDisplayName((String)vStr.elementAt(0));
                        }
                        if ((vSettingValues = this.getSettingValues(tempNode, "availablevalue")) != null && vSettingValues.size() != 0) {
                            tempSetting.setAvailableValues(vSettingValues);
                        }
                        if ((vStr = (Vector)htSettings.get("description")) != null) {
                            tempSetting.setDescription((String)vStr.elementAt(0));
                        }
                        if ((vStr = (Vector)htSettings.get("rangedescription")) != null) {
                            tempSetting.setRangeDescription((String)vStr.elementAt(0));
                        }
                        if ((vStr = (Vector)htSettings.get("minimumrange")) != null) {
                            tempString = (String)vStr.elementAt(0);
                            if (tempString != null && tempString.length() != 0) {
                                try {
                                    value = Integer.parseInt(tempString);
                                }
                                catch (NumberFormatException nfe) {
                                    value = 0;
                                }
                                tempSetting.setMinimumRange(value);
                            } else {
                                tempSetting.setMinimumRange(0);
                            }
                        }
                        if ((vStr = (Vector)htSettings.get("maximumrange")) != null) {
                            tempString = (String)vStr.elementAt(0);
                            if (tempString != null && tempString.length() != 0) {
                                try {
                                    value = Integer.parseInt(tempString);
                                }
                                catch (NumberFormatException nfe) {
                                    value = 0;
                                }
                                tempSetting.setMaximumRange(value);
                            } else {
                                tempSetting.setMaximumRange(0);
                            }
                        }
                        if ((vStr = (Vector)htSettings.get("type")) != null) {
                            tempString = (String)vStr.elementAt(0);
                            if (tempString != null && tempString.length() != 0) {
                                try {
                                    value = Integer.parseInt(tempString);
                                }
                                catch (NumberFormatException nfe) {
                                    value = 0;
                                }
                                tempSetting.setType(value);
                            } else {
                                tempSetting.setType(0);
                            }
                        }
                        if ((vStr = (Vector)htSettings.get("order")) != null) {
                            tempString = (String)vStr.elementAt(0);
                            if (tempString != null && tempString.length() != 0) {
                                try {
                                    value = Integer.parseInt(tempString);
                                }
                                catch (NumberFormatException nfe) {
                                    value = 0;
                                }
                                tempSetting.setOrder(value);
                            } else {
                                tempSetting.setOrder(0);
                            }
                        }
                        bAllowMultipleValues = true;
                        vStr = (Vector)htSettings.get("allowmultiplevalues");
                        if (vStr != null && (tempString = (String)vStr.elementAt(0)) != null) {
                            try {
                                value = Integer.parseInt(tempString);
                                bAllowMultipleValues = value != 0;
                            }
                            catch (NumberFormatException nfe) {
                                bAllowMultipleValues = true;
                            }
                        }
                        tempSetting.setAllowMultipleValues(bAllowMultipleValues);
                        bAdvanced = false;
                        vStr = (Vector)htSettings.get("advanced");
                        if (vStr != null && (tempString = (String)vStr.elementAt(0)) != null) {
                            try {
                                value = Integer.parseInt(tempString);
                                bAdvanced = value != 0;
                            }
                            catch (NumberFormatException nfe) {
                                bAdvanced = false;
                            }
                        }
                        tempSetting.setAdvanced(bAdvanced);
                        bRequired = false;
                        vStr = (Vector)htSettings.get("required");
                        if (vStr != null && (tempString = (String)vStr.elementAt(0)) != null) {
                            try {
                                value = Integer.parseInt(tempString);
                                bRequired = value != 0;
                            }
                            catch (NumberFormatException nfe) {
                                bRequired = false;
                            }
                        }
                        tempSetting.setRequired(bRequired);
                        bUserConfigurable = true;
                        vStr = (Vector)htSettings.get("userconfigurable");
                        if (vStr != null && (tempString = (String)vStr.elementAt(0)) != null) {
                            try {
                                value = Integer.parseInt(tempString);
                                bUserConfigurable = value != 0;
                            }
                            catch (NumberFormatException nfe) {
                                bUserConfigurable = true;
                            }
                        }
                        tempSetting.setUserConfigurable(bUserConfigurable);
                        bAdminConfigurable = true;
                        vStr = (Vector)htSettings.get("adminconfigurable");
                        if (vStr != null && (tempString = (String)vStr.elementAt(0)) != null) {
                            try {
                                value = Integer.parseInt(tempString);
                                bAdminConfigurable = value != 0;
                            }
                            catch (NumberFormatException nfe) {
                                bAdminConfigurable = true;
                            }
                        }
                        tempSetting.setAdminConfigurable(bAdminConfigurable);
                        bHideFromUser = false;
                        vStr = (Vector)htSettings.get("hidefromuser");
                        if (vStr != null && (tempString = (String)vStr.elementAt(0)) != null) {
                            try {
                                value = Integer.parseInt(tempString);
                                bHideFromUser = value != 0;
                            }
                            catch (NumberFormatException nfe) {
                                bHideFromUser = false;
                            }
                        }
                        tempSetting.setHideFromUser(bHideFromUser);
                        bHideFromAdmin = false;
                        vStr = (Vector)htSettings.get("hidefromadmin");
                        if (vStr != null && (tempString = (String)vStr.elementAt(0)) != null) {
                            try {
                                value = Integer.parseInt(tempString);
                                bHideFromAdmin = value != 0;
                            }
                            catch (NumberFormatException nfe) {
                                bHideFromAdmin = false;
                            }
                        }
                        tempSetting.setHideFromAdmin(bHideFromAdmin);
                        bParseMacros = true;
                        vStr = (Vector)htSettings.get("parsemacros");
                        if (vStr != null && (tempString = (String)vStr.elementAt(0)) != null) {
                            try {
                                value = Integer.parseInt(tempString);
                                bParseMacros = value != 0;
                            }
                            catch (NumberFormatException nfe) {
                                bParseMacros = true;
                            }
                        }
                        tempSetting.setParseMacros(bParseMacros);
                        bTranslatableValues = false;
                        vStr = (Vector)htSettings.get("translatablevalues");
                        if (vStr != null && (tempString = (String)vStr.elementAt(0)) != null) {
                            try {
                                value = Integer.parseInt(tempString);
                                bTranslatableValues = value != 0;
                            }
                            catch (NumberFormatException nfe) {
                                bTranslatableValues = false;
                            }
                        }
                        tempSetting.setTranslatableValues(bTranslatableValues);
                    }
                    HashMap hashMap = this.m_hmSettings;
                    synchronized (hashMap) {
                        this.m_hmSettings.put(tempSetting.getName(), tempSetting);
                    }
                }
                tempNode = ObjectConfigRecord.findNextElement(tempNode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigData copy() {
        ConfigSettings newSettings = null;
        newSettings = this.m_creationElement.equalsIgnoreCase(CONFIG) ? new ConfigSettings(this.m_ocr) : new ConfigSettings(this.m_ocr, this.m_creationElement);
        if (this.m_hmSettings != null) {
            Setting oldSetting2 = null;
            Setting copySetting = null;
            HashMap hashMap = this.m_hmSettings;
            synchronized (hashMap) {
                Collection co = this.m_hmSettings.values();
                if (co != null) {
                    for (Setting oldSetting2 : co) {
                        copySetting = oldSetting2.copy();
                        newSettings.setSingleSettingObject(copySetting);
                    }
                }
            }
        }
        if (this.m_sPath != null) {
            newSettings.setFileSystemPath(this.m_sPath);
        }
        return newSettings;
    }

    protected Object clone() throws CloneNotSupportedException {
        return this.copy();
    }

    @Override
    public boolean isSettingOverwriteable(String name) {
        boolean bReturn = true;
        Setting setting = this.getSingleSettingObject(name);
        if (setting != null) {
            bReturn = setting.getOverwriteable();
        }
        return bReturn;
    }

    @Override
    public boolean isSettingCumulative(String name) {
        boolean bReturn = false;
        Setting setting = this.getSingleSettingObject(name);
        if (setting != null) {
            bReturn = setting.getCumulative();
        }
        return bReturn;
    }

    @Override
    public void writeSettings(GadgetAssignment gadgetAssignment, PortalSession session) {
        block6: {
            if (this.m_sPath == null) {
                PortalConnection pc = AuthenticationManager.getConnection(session);
                try {
                    gadgetAssignment.writeUserRWConfigSettings(pc, session.getUserDN(), (FwSession)session);
                }
                catch (PortalDirectoryException pde) {
                    if (Debug.isLoggable(3)) {
                        Debug.log(DT, 3, pde);
                    }
                    break block6;
                }
            }
            ObjectConfigRecord ocr = new ObjectConfigRecord(this);
            try {
                ocr.writeDomData(new File(this.m_sPath));
            }
            catch (IOException ioe) {
                if (!Debug.isLoggable(3)) break block6;
                Debug.log(DT, 3, ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNewSetting(String name, Vector valuesVector, boolean bOverwrite, boolean bCumulative) {
        Setting tempSetting = this.getSingleSettingObject(name);
        if (tempSetting == null) {
            tempSetting = new Setting();
            tempSetting.setName(name);
            tempSetting.setValues(valuesVector);
            tempSetting.setOverwriteable(bOverwrite);
            tempSetting.setCumulative(bCumulative);
        } else {
            Vector vSettingValues = tempSetting.getValues();
            if (vSettingValues == null || vSettingValues.size() == 0) {
                tempSetting.setValues(valuesVector);
            } else if (tempSetting.getAllowMultipleValues() && valuesVector != null) {
                vSettingValues.addAll(valuesVector);
            }
        }
        HashMap hashMap = this.m_hmSettings;
        synchronized (hashMap) {
            this.m_hmSettings.put(name, tempSetting);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void emptyData() {
        HashMap hashMap = this.m_hmSettings;
        synchronized (hashMap) {
            this.m_hmSettings.clear();
        }
    }

    public ObjectConfigRecord getOCR() {
        return this.m_ocr;
    }

    public void setOCR(ObjectConfigRecord ocr) {
        this.m_ocr = ocr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getDOM() {
        Document dom = eMFrameUtils.newDocument();
        Element eRoot = dom.createElement(CONFIG);
        dom.appendChild(eRoot);
        HashMap hashMap = this.m_hmSettings;
        synchronized (hashMap) {
            Collection co = this.m_hmSettings.values();
            if (co != null) {
                Setting[] sa = new Setting[co.size()];
                co.toArray(sa);
                for (int i = 0; i < sa.length; ++i) {
                    this.addSettingNode(dom, eRoot, sa[i]);
                }
            }
        }
        return dom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSettingsToDOMAtNode(Document dom, Node node) {
        if (dom == null || node == null || !(node instanceof Element)) {
            return;
        }
        HashMap hashMap = this.m_hmSettings;
        synchronized (hashMap) {
            Collection co = this.m_hmSettings.values();
            if (co != null) {
                Setting[] sa = new Setting[co.size()];
                co.toArray(sa);
                for (int i = 0; i < sa.length; ++i) {
                    this.addSettingNode(dom, (Element)node, sa[i]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node addSettingsToDOM() {
        Node eConfig = this.m_ocr.findFirstElement(CONFIG);
        if (eConfig != null) {
            Document dom = this.m_ocr.getDOM();
            Element eCreationNode = dom.createElement(this.m_creationElement);
            eConfig.appendChild(eCreationNode);
            HashMap hashMap = this.m_hmSettings;
            synchronized (hashMap) {
                Collection co = this.m_hmSettings.values();
                if (co != null) {
                    Setting[] sa = new Setting[co.size()];
                    co.toArray(sa);
                    for (int i = 0; i < sa.length; ++i) {
                        this.addSettingNode(dom, eCreationNode, sa[i]);
                    }
                }
            }
            return eCreationNode;
        }
        return null;
    }

    private void addSettingNode(Document dom, Element eRoot, Setting setting) {
        String sName = setting.getName();
        Vector vValues = setting.getValues();
        if (vValues == null || vValues.isEmpty()) {
            return;
        }
        SettingValue tempSV = null;
        String sValue2 = null;
        String sLanguageValue = null;
        boolean bCum = setting.getCumulative();
        boolean bOver = setting.getOverwriteable();
        Element eSetting = dom.createElement(SETTING);
        eRoot.appendChild(eSetting);
        Text nText = null;
        CDATASection nCData = null;
        Element eNode = null;
        Element eActualValue = null;
        Element eDisplayValue = null;
        HashMap hmDisplayValues = null;
        eNode = dom.createElement("name");
        nCData = dom.createCDATASection(sName);
        eNode.appendChild(nCData);
        eSetting.appendChild(eNode);
        for (int i = 0; i < vValues.size(); ++i) {
            eNode = dom.createElement("value");
            eSetting.appendChild(eNode);
            tempSV = (SettingValue)vValues.elementAt(i);
            if (tempSV.areDisplayValuesPresent()) {
                eActualValue = dom.createElement("actualvalue");
                eNode.appendChild(eActualValue);
                sValue2 = tempSV.getValue();
                nCData = dom.createCDATASection(sValue2);
                eActualValue.appendChild(nCData);
                hmDisplayValues = tempSV.getDisplayValueMap();
                if (hmDisplayValues != null && hmDisplayValues.size() != 0) {
                    Set c = hmDisplayValues.keySet();
                    for (String sValue2 : c) {
                        if (hmDisplayValues.size() != 1 && (sValue2 == null || sValue2.length() == 0) || (sLanguageValue = (String)hmDisplayValues.get(sValue2)) == null || sLanguageValue.length() == 0) continue;
                        eDisplayValue = dom.createElement("displayvalue");
                        eNode.appendChild(eDisplayValue);
                        nCData = dom.createCDATASection(sLanguageValue);
                        eDisplayValue.appendChild(nCData);
                        if (sValue2 == null || sValue2.length() == 0) continue;
                        eDisplayValue.setAttribute("language", sValue2);
                    }
                    continue;
                }
                sLanguageValue = tempSV.getDisplayValue(null);
                if (sLanguageValue == null || sLanguageValue.length() == 0) continue;
                eDisplayValue = dom.createElement("displayvalue");
                eNode.appendChild(eDisplayValue);
                nCData = dom.createCDATASection(sLanguageValue);
                eDisplayValue.appendChild(nCData);
                continue;
            }
            sValue2 = tempSV.getValue();
            nCData = dom.createCDATASection(sValue2);
            eNode.appendChild(nCData);
        }
        eNode = dom.createElement("cumulative");
        eSetting.appendChild(eNode);
        nText = bCum ? dom.createTextNode("1") : dom.createTextNode("0");
        eNode.appendChild(nText);
        eNode = dom.createElement("overwriteable");
        eSetting.appendChild(eNode);
        nText = bOver ? dom.createTextNode("1") : dom.createTextNode("0");
        eNode.appendChild(nText);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markAllSettingsOverwriteable() {
        if (this.m_hmSettings == null) {
            return;
        }
        HashMap hashMap = this.m_hmSettings;
        synchronized (hashMap) {
            Collection co = this.m_hmSettings.values();
            if (co != null) {
                Setting[] sa = new Setting[co.size()];
                co.toArray(sa);
                for (int i = 0; i < sa.length; ++i) {
                    sa[i].setOverwriteable(true);
                }
            }
        }
    }

    public Vector getSettingValues(Node node, String sParentElement) {
        Node child = null;
        NodeList children = node.getChildNodes();
        Node grandchild = null;
        NodeList grandchildren = null;
        Node greatgrandchild = null;
        NodeList greatgrandchildren = null;
        Vector<SettingValue> vSettingValues = new Vector<SettingValue>();
        String sName = null;
        String sActualValue = null;
        String sDisplayValue = null;
        String sDisplayLanguage = null;
        String sReadDisplayValue = null;
        HashMap<String, String> hmDisplayValues = new HashMap<String, String>();
        SettingValue tempSV = null;
        Object tempObj = null;
        NodeList textElementList = null;
        Node textElement = null;
        if (children != null) {
            int len = children.getLength();
            for (int i = 0; i < len; ++i) {
                byte[] ba;
                child = children.item(i);
                if (child.getNodeType() != 1 || !(sName = child.getNodeName()).equalsIgnoreCase(sParentElement) || (grandchildren = child.getChildNodes()) == null || grandchildren.getLength() <= 0) continue;
                hmDisplayValues.clear();
                sActualValue = null;
                int glen = grandchildren.getLength();
                for (int j = 0; j < glen; ++j) {
                    grandchild = grandchildren.item(j);
                    if (grandchild.getNodeType() != 1) continue;
                    sName = grandchild.getNodeName();
                    if (sName.equalsIgnoreCase("actualvalue") && (sActualValue == null || sActualValue.length() == 0)) {
                        textElementList = grandchild.getChildNodes();
                        if (textElementList == null || textElementList.getLength() <= 0) continue;
                        textElement = textElementList.item(0);
                        sActualValue = textElement.getNodeValue();
                        continue;
                    }
                    if (!sName.equalsIgnoreCase("displayvalue")) continue;
                    sDisplayLanguage = XmlUtil.getNodeAttributeValue(grandchild, "language");
                    String sResourcePropertiesFile = null;
                    String sDisplayNameKey = null;
                    sDisplayValue = null;
                    greatgrandchildren = grandchild.getChildNodes();
                    if (greatgrandchildren != null && greatgrandchildren.getLength() > 0) {
                        for (int k = 0; k < greatgrandchildren.getLength(); ++k) {
                            greatgrandchild = greatgrandchildren.item(k);
                            if (greatgrandchild.getNodeType() == 1 && "resource-properties-file".equalsIgnoreCase(greatgrandchild.getNodeName())) {
                                textElementList = greatgrandchild.getChildNodes();
                                if (textElementList == null || textElementList.getLength() <= 0) continue;
                                textElement = textElementList.item(0);
                                sResourcePropertiesFile = textElement.getNodeValue();
                                continue;
                            }
                            if (greatgrandchild.getNodeType() != 1 || !"display-name-key".equalsIgnoreCase(greatgrandchild.getNodeName()) || (textElementList = greatgrandchild.getChildNodes()) == null || textElementList.getLength() <= 0) continue;
                            textElement = textElementList.item(0);
                            sDisplayNameKey = textElement.getNodeValue();
                        }
                        if (sDisplayNameKey != null && sDisplayNameKey.length() != 0 && sResourcePropertiesFile != null && sResourcePropertiesFile.length() != 0) {
                            sResourcePropertiesFile = sResourcePropertiesFile.substring(0, sResourcePropertiesFile.length() - EXT_PROPERTIES.length());
                            sResourcePropertiesFile = sResourcePropertiesFile.replace('.', '/') + EXT_PROPERTIES;
                            Properties props = new Properties();
                            InputStream inputStream = null;
                            try {
                                inputStream = ConfigSettings.class.getClassLoader().getResource(sResourcePropertiesFile).openStream();
                            }
                            catch (Throwable t) {
                                String sPath = "SYS:/tomcat/4/webapps/nps/WEB-INF/classes/" + sResourcePropertiesFile;
                                try {
                                    inputStream = new FileInputStream(sPath);
                                }
                                catch (FileNotFoundException e) {
                                    inputStream = null;
                                }
                            }
                            try {
                                if (inputStream != null) {
                                    int iSize = inputStream.available();
                                    byte[] ba2 = new byte[iSize];
                                    inputStream.read(ba2, 0, iSize);
                                    String sTemp = new String(ba2, 0, iSize);
                                    ByteArrayInputStream bais = new ByteArrayInputStream(sTemp.getBytes());
                                    props.load(bais);
                                    inputStream.close();
                                    sDisplayValue = props.getProperty(sDisplayNameKey);
                                } else {
                                    Debug.log(DT, 1, "Cannot find resource file " + sResourcePropertiesFile);
                                }
                            }
                            catch (Throwable t) {
                                Debug.log(DT, 1, "Cannot find resource file " + sResourcePropertiesFile);
                            }
                        }
                    }
                    if (sDisplayValue == null || sDisplayValue.length() == 0) {
                        textElementList = grandchild.getChildNodes();
                        sDisplayValue = null;
                        if (textElementList != null && textElementList.getLength() > 0 && (sDisplayValue = (textElement = textElementList.item(0)).getNodeValue()) != null && sDisplayValue.length() != 0) {
                            sDisplayValue = XmlUtil.stripWhiteSpace(sDisplayValue);
                        }
                    }
                    if (sDisplayLanguage != null && sDisplayLanguage.length() != 0 && sDisplayValue != null && sDisplayValue.length() != 0) {
                        hmDisplayValues.put(sDisplayLanguage, sDisplayValue);
                        continue;
                    }
                    if (sDisplayValue == null || sDisplayValue.length() == 0 || sDisplayLanguage != null && sDisplayLanguage.length() != 0) continue;
                    sReadDisplayValue = sDisplayValue;
                }
                if ((sActualValue == null || sActualValue.length() == 0) && (textElementList = child.getChildNodes()) != null && textElementList.getLength() > 0) {
                    textElement = textElementList.item(0);
                    sActualValue = textElement.getNodeValue();
                }
                if (sActualValue == null || sActualValue.length() == 0) continue;
                if (hmDisplayValues.size() == 0) {
                    if (sReadDisplayValue != null && sReadDisplayValue.length() != 0) {
                        tempSV = new SettingValue(sActualValue, sReadDisplayValue);
                        vSettingValues.add(tempSV);
                    } else {
                        tempSV = new SettingValue(sActualValue);
                        vSettingValues.add(tempSV);
                    }
                } else {
                    tempSV = new SettingValue(sActualValue, (HashMap)hmDisplayValues.clone());
                    vSettingValues.add(tempSV);
                }
                if (sActualValue == null || !sActualValue.startsWith(OBJECT_STRING_START) || (ba = GUID.HexStringAsByte(sActualValue)) == null || ba.length == 0) continue;
                ByteArrayInputStream bais = new ByteArrayInputStream(ba);
                try {
                    ObjectInputStream ois = new ObjectInputStream(bais);
                    tempObj = ois.readObject();
                    tempSV.setObjectValue(tempObj);
                    continue;
                }
                catch (IOException ioe) {
                    if (Debug.isLoggable(3)) {
                        Debug.log(DT, 3, ioe);
                    }
                    tempObj = null;
                    tempSV.setObjectValue(tempObj);
                    continue;
                }
                catch (ClassNotFoundException cnfe) {
                    if (Debug.isLoggable(3)) {
                        Debug.log(DT, 3, cnfe);
                    }
                    tempObj = null;
                    tempSV.setObjectValue(tempObj);
                }
            }
        }
        return vSettingValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeParentSettingsFromUserRWSettings() {
        Setting tempSetting2 = null;
        SettingValue tempSV = null;
        Vector<Setting> vRemove = new Vector<Setting>();
        HashMap hashMap = this.m_hmSettings;
        synchronized (hashMap) {
            Collection co = this.m_hmSettings.values();
            for (Setting tempSetting2 : co) {
                Vector vValues = tempSetting2.getValues();
                if (vValues == null || vValues.isEmpty()) {
                    vRemove.add(tempSetting2);
                    continue;
                }
                if (tempSetting2.getCumulative()) {
                    Enumeration ve = vValues.elements();
                    Vector<SettingValue> vRemoveValues = new Vector<SettingValue>();
                    while (ve.hasMoreElements()) {
                        tempSV = (SettingValue)ve.nextElement();
                        if (!tempSV.getInheritedFromParent()) continue;
                        vRemoveValues.add(tempSV);
                    }
                    if (vRemoveValues.isEmpty()) continue;
                    vValues.removeAll(vRemoveValues);
                    tempSetting2.setValues(vValues);
                    continue;
                }
                boolean bUserModified = false;
                Enumeration ve = vValues.elements();
                while (ve.hasMoreElements()) {
                    tempSV = (SettingValue)ve.nextElement();
                    if (tempSV.getInheritedFromParent()) continue;
                    bUserModified = true;
                    break;
                }
                if (bUserModified) continue;
                vRemove.add(tempSetting2);
            }
            if (!vRemove.isEmpty()) {
                Enumeration eRem = vRemove.elements();
                while (eRem.hasMoreElements()) {
                    tempSetting2 = (Setting)eRem.nextElement();
                    this.removeSetting(tempSetting2.getName());
                }
            }
        }
    }

    @Override
    public void setSettingOverwriteable(String name, boolean bOverwriteable) {
        Setting setting = this.getSingleSettingObject(name);
        if (setting != null) {
            setting.setOverwriteable(bOverwriteable);
        }
    }

    @Override
    public void setSettingCumulative(String name, boolean bCumulative) {
        Setting setting = this.getSingleSettingObject(name);
        if (setting != null) {
            setting.setCumulative(bCumulative);
        }
    }
}

