/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.configManager;

import com.novell.emframe.dev.XmlUtils;
import com.novell.nps.configManager.ConfigData;
import com.novell.nps.configManager.ConfigManager;
import com.novell.nps.configManager.ConfigSettings;
import com.novell.nps.configManager.Configurable;
import com.novell.nps.configManager.ConfigurationComplete;
import com.novell.nps.configManager.ConfigurationException;
import com.novell.nps.configManager.GadgetAssignment;
import com.novell.nps.configManager.Setting;
import com.novell.nps.configManager.SettingValue;
import com.novell.nps.debug.Debug;
import com.novell.nps.gadgetManager.GadgetInstance;
import com.novell.nps.gadgetManager.GadgetInstanceException;
import com.novell.nps.gadgetManager.ResourceSetMap;
import com.novell.nps.gadgetManager.StylesheetSetMap;
import com.novell.nps.sessionManager.PortalSession;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class Configuration
implements ConfigurationComplete,
Serializable {
    public static final String DT = "Configuration";
    private static final String WIZARD = "wizard:";
    private static final String NEW_TAG = "New:";
    private static final String RETYPE_TAG = "Retype:";
    private static final String LANGUAGES = "Languages:";
    private static final String NEW_SETTING_NAME = "NewSettingName";
    private static final String NEW_SETTING_VALUE = "NewSettingValue";
    private static final String USER_CONFIGURING = "UserConfiguring";
    private static final String SHOW_DESCRIPTIONS = "ShowDescriptions";
    private static final String SHOW_HEADERS = "ShowColumnHeaders";
    private static final String STATE_WIZARD = "StateWizard";
    private static final String STATE_LANGUAGES = "StateLanguages";
    private static final String STATE_NEW_LANGUAGE = "StateNewLanguage";
    private ConfigurationComplete m_configComplete;
    private ConfigData m_availableSettings;
    private ConfigData m_mergedConfig;
    private ConfigData m_currentConfig;
    private Hashtable m_numEntries;
    private Configurable m_configurableGadget;
    private boolean m_bAdminConfiguring;
    private boolean m_bAdvanced;
    private boolean m_bShowingOverwriteable;
    private boolean m_bShowingCumulative;
    private boolean m_bShowingHeaders;
    private boolean m_bShowingDescriptions;
    private transient ResourceBundle m_res;
    private PortalSession m_session;
    private String m_state;
    private Setting m_currentSetting;
    private SettingValue m_currentSettingValue;

    public Configuration(ConfigurationComplete configComplete, ConfigData availableSettings, ConfigData currentSettings, boolean bAdminConfiguring, PortalSession session) {
        this.m_configComplete = null;
        this.m_availableSettings = null;
        this.m_mergedConfig = null;
        this.m_currentConfig = null;
        this.m_numEntries = new Hashtable();
        this.m_configurableGadget = null;
        this.m_bAdminConfiguring = false;
        this.m_bAdvanced = false;
        this.m_bShowingOverwriteable = false;
        this.m_bShowingCumulative = false;
        this.m_bShowingHeaders = true;
        this.m_bShowingDescriptions = false;
        this.m_res = null;
        this.m_session = null;
        this.m_state = null;
        this.m_currentSetting = null;
        this.m_currentSettingValue = null;
        this.setupConfiguration(configComplete, availableSettings, currentSettings, bAdminConfiguring, session);
    }

    public Configuration(ConfigurationComplete configComplete, ConfigData availableSettings, ConfigData currentSettings, boolean bAdminConfiguring, Configurable configurableGadget, PortalSession session) {
        this.m_configComplete = null;
        this.m_availableSettings = null;
        this.m_mergedConfig = null;
        this.m_currentConfig = null;
        this.m_numEntries = new Hashtable();
        this.m_configurableGadget = null;
        this.m_bAdminConfiguring = false;
        this.m_bAdvanced = false;
        this.m_bShowingOverwriteable = false;
        this.m_bShowingCumulative = false;
        this.m_bShowingHeaders = true;
        this.m_bShowingDescriptions = false;
        this.m_res = null;
        this.m_session = null;
        this.m_state = null;
        this.m_currentSetting = null;
        this.m_currentSettingValue = null;
        this.setupConfiguration(configComplete, availableSettings, currentSettings, bAdminConfiguring, session);
        this.m_configurableGadget = configurableGadget;
    }

    public Configuration(ConfigurationComplete configComplete, ConfigData availableSettings, ConfigData currentSettings, boolean bAdminConfiguring, String sFormInstanceID, String gadgetInstanceClass, PortalSession session) {
        block9: {
            this.m_configComplete = null;
            this.m_availableSettings = null;
            this.m_mergedConfig = null;
            this.m_currentConfig = null;
            this.m_numEntries = new Hashtable();
            this.m_configurableGadget = null;
            this.m_bAdminConfiguring = false;
            this.m_bAdvanced = false;
            this.m_bShowingOverwriteable = false;
            this.m_bShowingCumulative = false;
            this.m_bShowingHeaders = true;
            this.m_bShowingDescriptions = false;
            this.m_res = null;
            this.m_session = null;
            this.m_state = null;
            this.m_currentSetting = null;
            this.m_currentSettingValue = null;
            this.setupConfiguration(configComplete, availableSettings, currentSettings, bAdminConfiguring, session);
            if (gadgetInstanceClass != null) {
                Class<?> newClass = null;
                try {
                    newClass = Class.forName(gadgetInstanceClass);
                    this.m_configurableGadget = (Configurable)newClass.newInstance();
                    GadgetInstance gi = (GadgetInstance)((Object)this.m_configurableGadget);
                    gi.setSession(this.m_session);
                    gi.setLocale(this.getLocale());
                    gi.setGadgetInstanceID(sFormInstanceID);
                    GadgetAssignment tempGA = new GadgetAssignment();
                    gi.setGadgetAssignment(tempGA);
                    gi.init(null);
                    gi.setState("ShowUserConfig");
                }
                catch (ClassNotFoundException cnfe) {
                    if (Debug.isLoggable(1)) {
                        Debug.log(DT, 1, cnfe);
                    }
                }
                catch (InstantiationException ie) {
                    if (Debug.isLoggable(1)) {
                        Debug.log(DT, 1, ie);
                    }
                }
                catch (IllegalAccessException iae) {
                    if (Debug.isLoggable(1)) {
                        Debug.log(DT, 1, iae);
                    }
                }
                catch (ClassCastException cce) {
                    if (!Debug.isLoggable(1)) break block9;
                    Debug.log(DT, 1, cce);
                }
            }
        }
    }

    private void setupConfiguration(ConfigurationComplete configComplete, ConfigData availableSettings, ConfigData currentSettings, boolean bAdminConfiguring, PortalSession session) {
        this.m_session = session;
        this.m_res = ConfigManager.getUserResourceBundle(session);
        this.m_configComplete = configComplete;
        this.m_availableSettings = availableSettings == null ? new ConfigSettings() : availableSettings;
        this.m_mergedConfig = this.m_availableSettings.copy();
        this.m_mergedConfig.mergeConfig(currentSettings, false, true);
        this.m_currentConfig = this.m_mergedConfig;
        this.m_bAdminConfiguring = bAdminConfiguring;
    }

    public void processRequest(HttpServletRequest req, HttpServletResponse resp) throws GadgetInstanceException {
        if (this.m_state != null && this.m_state.equals(STATE_WIZARD) && this.m_configurableGadget instanceof GadgetInstance) {
            GadgetInstance gi = (GadgetInstance)((Object)this.m_configurableGadget);
            gi.processRequest(req, resp);
        }
    }

    public void processRequest(HttpServletRequest req) throws GadgetInstanceException, ConfigurationException {
        String sTemp = null;
        String[] tempValues = null;
        String[] retypedPasswords = null;
        Integer tempNum = null;
        int tempInt = 0;
        if (!(this.m_state != null && this.m_state.equals(STATE_WIZARD) || req.getParameter("ConfigDataForm") == null)) {
            SettingValue tempSV;
            Vector vValues;
            this.m_state = null;
            ConfigSettings cs = new ConfigSettings();
            Setting tempSetting2 = null;
            Vector<SettingValue> vNewValues = null;
            Enumeration e = req.getParameterNames();
            while (e.hasMoreElements()) {
                sTemp = (String)e.nextElement();
                tempSetting2 = this.m_mergedConfig.getSingleSettingObject(sTemp);
                if (tempSetting2 == null || 6 == tempSetting2.getType()) continue;
                vNewValues = new Vector<SettingValue>();
                tempValues = req.getParameterValues(sTemp);
                if (tempValues == null || tempValues.length == 0) continue;
                if (tempValues.length == 1 && tempValues[0].length() == 0) {
                    tempSetting2.setValues(null);
                    cs.setSingleSettingObject(tempSetting2);
                    continue;
                }
                if (tempSetting2.getType() == 1 || tempSetting2.getType() == 8) {
                    retypedPasswords = req.getParameterValues(RETYPE_TAG + sTemp);
                }
                SettingValue tempSV2 = null;
                for (int i = 0; i < tempValues.length; ++i) {
                    if (tempValues[i] == null || tempValues[i].length() == 0) continue;
                    String sSettingValue = null;
                    if (tempSetting2.getType() == 1 || tempSetting2.getType() == 8) {
                        if (retypedPasswords != null && retypedPasswords.length == tempValues.length) {
                            if (retypedPasswords[i] == null || retypedPasswords[i].length() == 0) {
                                MessageFormat mf = new MessageFormat(this.m_res.getString("Retyped_password_doesnt_match_for_setting_0"));
                                String sName = tempSetting2.getDisplayName();
                                if (sName == null || sName.length() == 0) {
                                    sName = tempSetting2.getName();
                                }
                                throw new ConfigurationException(mf.format(new Object[]{sName}));
                            }
                            if (!tempValues[i].equals(retypedPasswords[i])) {
                                MessageFormat mf = new MessageFormat(this.m_res.getString("Retyped_password_doesnt_match_for_setting_0"));
                                String sName = tempSetting2.getDisplayName();
                                if (sName == null || sName.length() == 0) {
                                    sName = tempSetting2.getName();
                                }
                                throw new ConfigurationException(mf.format(new Object[]{sName}));
                            }
                        } else {
                            MessageFormat mf = new MessageFormat(this.m_res.getString("Retyped_password_doesnt_match_for_setting_0"));
                            String sName = tempSetting2.getDisplayName();
                            if (sName == null || sName.length() == 0) {
                                sName = tempSetting2.getName();
                            }
                            throw new ConfigurationException(mf.format(new Object[]{sName}));
                        }
                    }
                    if ((tempSV2 = tempSetting2.getSettingValue(sSettingValue = tempSetting2.getType() == 7 || tempSetting2.getType() == 8 ? XmlUtils.xmlEncode((String)tempValues[i]) : tempValues[i])) != null) {
                        vNewValues.add(tempSV2);
                        continue;
                    }
                    tempSV2 = new SettingValue(sSettingValue);
                    vNewValues.add(tempSV2);
                }
                tempSetting2.setValues(vNewValues);
                cs.setSingleSettingObject(tempSetting2);
            }
            Collection co = this.m_mergedConfig.getSettingsCollection();
            for (Setting tempSetting2 : co) {
                if (tempSetting2.getType() == 6) {
                    cs.addNewSetting(tempSetting2.getName(), tempSetting2.getValues(), tempSetting2.getOverwriteable(), tempSetting2.getCumulative());
                    continue;
                }
                if (!this.m_bAdminConfiguring && tempSetting2.getUserConfigurable()) {
                    cs.addNewSetting(tempSetting2.getName(), tempSetting2.getValues(), tempSetting2.getOverwriteable(), tempSetting2.getCumulative());
                    continue;
                }
                if (!this.m_bAdminConfiguring || !tempSetting2.getAdminConfigurable()) continue;
                cs.addNewSetting(tempSetting2.getName(), tempSetting2.getValues(), tempSetting2.getOverwriteable(), tempSetting2.getCumulative());
            }
            if (!this.m_bAdvanced) {
                for (Setting tempSetting2 : co) {
                    if (!tempSetting2.getAdvanced()) continue;
                    if (!this.m_bAdminConfiguring && tempSetting2.getUserConfigurable()) {
                        cs.addNewSetting(tempSetting2.getName(), tempSetting2.getValues(), tempSetting2.getOverwriteable(), tempSetting2.getCumulative());
                        continue;
                    }
                    if (!this.m_bAdminConfiguring || !tempSetting2.getAdminConfigurable()) continue;
                    cs.addNewSetting(tempSetting2.getName(), tempSetting2.getValues(), tempSetting2.getOverwriteable(), tempSetting2.getCumulative());
                }
            }
            if (this.m_bShowingOverwriteable || this.m_bShowingCumulative) {
                Enumeration oe = req.getParameterNames();
                while (oe.hasMoreElements()) {
                    String sValue;
                    String sSetting;
                    sTemp = (String)oe.nextElement();
                    if (sTemp.startsWith("overwriteable:")) {
                        sSetting = sTemp.substring("overwriteable".length() + 1);
                        tempSetting2 = cs.getSingleSettingObject(sSetting);
                        if (tempSetting2 == null || (tempValues = req.getParameterValues(sTemp)) == null || tempValues.length == 0 || tempValues[0].length() == 0) continue;
                        sValue = tempValues[0];
                        if (sValue.equalsIgnoreCase("true")) {
                            tempSetting2.setOverwriteable(true);
                            continue;
                        }
                        tempSetting2.setOverwriteable(false);
                        continue;
                    }
                    if (!sTemp.startsWith("cumulative:") || (tempSetting2 = cs.getSingleSettingObject(sSetting = sTemp.substring("cumulative".length() + 1))) == null || (tempValues = req.getParameterValues(sTemp)) == null || tempValues.length == 0 || tempValues[0].length() == 0) continue;
                    sValue = tempValues[0];
                    if (sValue.equalsIgnoreCase("true")) {
                        tempSetting2.setCumulative(true);
                        continue;
                    }
                    tempSetting2.setCumulative(false);
                }
            }
            String sNewSetting = req.getParameter(NEW_SETTING_NAME);
            String sNewSettingValue = req.getParameter(NEW_SETTING_VALUE);
            if (sNewSetting != null && sNewSetting.length() != 0 && sNewSettingValue != null && sNewSettingValue.length() != 0) {
                vValues = new Vector();
                tempSV = new SettingValue(sNewSettingValue);
                vValues.add(tempSV);
                this.m_mergedConfig.addNewSetting(sNewSetting, vValues, true, false);
            }
            this.m_mergedConfig.mergeConfig(cs, true, true);
            this.m_currentConfig = cs;
            if (req.getParameter("advanced") != null || req.getParameter("advanced.x") != null) {
                this.m_bAdvanced = true;
                return;
            }
            if (req.getParameter("basic") != null || req.getParameter("basic.x") != null) {
                this.m_bAdvanced = false;
                return;
            }
            if (req.getParameter("showdescriptions") != null || req.getParameter("showdescriptions.x") != null) {
                this.m_bShowingDescriptions = true;
                return;
            }
            if (req.getParameter("hidedescriptions") != null || req.getParameter("hidedescriptions.x") != null) {
                this.m_bShowingDescriptions = false;
                return;
            }
            if (req.getParameter("ConfigurableSubmit") != null || req.getParameter("ConfigurableSubmit.x") != null || req.getParameter("SaveScheme") != null || req.getParameter("SaveScheme.x") != null) {
                co = this.m_mergedConfig.getSettingsCollection();
                if (co != null) {
                    Iterator iter = co.iterator();
                    tempSetting2 = null;
                    while (iter.hasNext()) {
                        tempSetting2 = (Setting)iter.next();
                        if (tempSetting2.getRequired()) {
                            vValues = tempSetting2.getValues();
                            if (vValues == null || vValues.size() == 0) {
                                MessageFormat mf = new MessageFormat(this.m_res.getString("A_value_is_required_for_setting_0"));
                                String sName = tempSetting2.getDisplayName();
                                if (sName == null || sName.length() == 0) {
                                    sName = tempSetting2.getName();
                                }
                                throw new ConfigurationException(mf.format(new Object[]{sName}));
                            }
                            tempSV = (SettingValue)vValues.elementAt(0);
                            if (tempSV == null || tempSV.getValue() == null || tempSV.getValue().length() == 0) {
                                MessageFormat mf = new MessageFormat(this.m_res.getString("A_value_is_required_for_setting_0"));
                                String sName = tempSetting2.getDisplayName();
                                if (sName == null || sName.length() == 0) {
                                    sName = tempSetting2.getName();
                                }
                                throw new ConfigurationException(mf.format(new Object[]{sName}));
                            }
                        }
                        if (tempSetting2.getType() != 2 || (vValues = tempSetting2.getValues()) == null || vValues.size() == 0) continue;
                        tempSV = null;
                        Enumeration eSettingValue = vValues.elements();
                        while (eSettingValue.hasMoreElements()) {
                            int iMin;
                            tempSV = (SettingValue)eSettingValue.nextElement();
                            if (tempSV.getValue() == null) continue;
                            try {
                                tempInt = Integer.parseInt(tempSV.getValue());
                            }
                            catch (NumberFormatException nfe) {
                                MessageFormat mf = new MessageFormat(this.m_res.getString("Invalid_number"));
                                String sName = tempSetting2.getDisplayName();
                                if (sName == null || sName.length() == 0) {
                                    sName = tempSetting2.getName();
                                }
                                throw new ConfigurationException(mf.format(new Object[]{sName}));
                            }
                            int iMax = tempSetting2.getMaximumRange();
                            if (iMax == (iMin = tempSetting2.getMinimumRange()) || tempInt >= iMin && tempInt <= iMax) continue;
                            MessageFormat mf = new MessageFormat(this.m_res.getString("Number_out_of_range_for_setting_0"));
                            String sName = tempSetting2.getDisplayName();
                            if (sName == null || sName.length() == 0) {
                                sName = tempSetting2.getName();
                            }
                            throw new ConfigurationException(mf.format(new Object[]{sName, String.valueOf(iMin), String.valueOf(iMax)}));
                        }
                    }
                }
                cs.setFileSystemPath(this.m_mergedConfig.getFileSystemPath());
                this.m_configComplete.configureComplete(cs);
                return;
            }
            if (req.getParameter("NewSetting") == null && req.getParameter("NewSetting.x") == null) {
                Enumeration pe = req.getParameterNames();
                String sSetting = null;
                while (pe.hasMoreElements()) {
                    sTemp = (String)pe.nextElement();
                    if (sTemp.startsWith(NEW_TAG)) {
                        sSetting = sTemp.substring(NEW_TAG.length());
                        if (sSetting.endsWith(".x")) {
                            sSetting = sSetting.substring(0, sSetting.length() - 2);
                        }
                        if ((tempSetting2 = this.m_mergedConfig.getSingleSettingObject(sSetting)) == null) continue;
                        tempNum = (Integer)this.m_numEntries.get(tempSetting2.getName());
                        tempNum = tempNum == null ? new Integer(2) : new Integer(tempNum + 1);
                        this.m_numEntries.put(tempSetting2.getName(), tempNum);
                        continue;
                    }
                    if (sTemp.startsWith(WIZARD)) {
                        sSetting = sTemp.substring(WIZARD.length());
                        if (sSetting.endsWith(".x")) {
                            sSetting = sSetting.substring(0, sSetting.length() - 2);
                        }
                        if ((tempSetting2 = this.m_mergedConfig.getSingleSettingObject(sSetting)) == null) continue;
                        if (this.m_configurableGadget != null) {
                            this.m_state = STATE_WIZARD;
                            this.m_configurableGadget.configureSetting(sSetting, this.m_mergedConfig, this.m_bAdminConfiguring, this);
                            return;
                        }
                        throw new ConfigurationException(this.m_res.getString("Cannot_load_the"));
                    }
                    if (!sTemp.startsWith(LANGUAGES)) continue;
                    sSetting = sTemp.substring(LANGUAGES.length());
                    if (sSetting.endsWith(".x")) {
                        sSetting = sSetting.substring(0, sSetting.length() - 2);
                    }
                    if ((tempSetting2 = this.m_mergedConfig.getSingleSettingObject(sSetting)) == null) continue;
                    Vector vValues2 = tempSetting2.getValues();
                    if (vValues2 == null || vValues2.size() == 0 || vValues2.elementAt(0) == null) {
                        throw new ConfigurationException(this.m_res.getString("Cannot_translate_without_value"));
                    }
                    this.m_currentSetting = tempSetting2.copy();
                    this.m_state = STATE_LANGUAGES;
                    return;
                }
            }
        } else if (req.getParameter("ConfigDataLanaguageForm") != null) {
            if (req.getParameter("Cancel") != null || req.getParameter("Cancel.x") != null) {
                this.m_state = null;
                this.m_currentSetting = null;
                return;
            }
            Vector vValues = this.m_currentSetting.getValues();
            Enumeration eValues = vValues.elements();
            String[] sLanguages = null;
            String[] sTranslations = null;
            SettingValue tempSV = null;
            int iValue = 0;
            while (eValues.hasMoreElements()) {
                tempSV = (SettingValue)eValues.nextElement();
                sTemp = tempSV.getValue();
                sLanguages = req.getParameterValues(LANGUAGES + String.valueOf(iValue));
                sTranslations = req.getParameterValues("DisplayValue:" + String.valueOf(iValue));
                ++iValue;
                if (sLanguages == null || sTranslations == null || sTranslations.length != sLanguages.length) continue;
                HashMap<String, String> hmTranslations = new HashMap<String, String>();
                int len = sLanguages.length;
                for (int i = 0; i < len; ++i) {
                    if (sLanguages[i] == null || sTranslations[i] == null) continue;
                    hmTranslations.put(sLanguages[i], sTranslations[i]);
                }
                if (hmTranslations.size() != 0) {
                    tempSV.setDisplayValueMap(hmTranslations);
                    continue;
                }
                tempSV.setDisplayValueMap(null);
            }
            if (req.getParameter("OK") != null || req.getParameter("OK.x") != null) {
                this.m_mergedConfig.setSingleSettingObject(this.m_currentSetting);
                this.m_state = null;
                this.m_currentSetting = null;
                return;
            }
            Enumeration pe = req.getParameterNames();
            String sValueNumber = null;
            int iValueNumber = 0;
            while (pe.hasMoreElements()) {
                sTemp = (String)pe.nextElement();
                if (!sTemp.startsWith(NEW_TAG)) continue;
                sValueNumber = sTemp.substring(NEW_TAG.length());
                if (sValueNumber.endsWith(".x")) {
                    sValueNumber = sValueNumber.substring(0, sValueNumber.length() - 2);
                }
                try {
                    iValueNumber = Integer.parseInt(sValueNumber);
                }
                catch (NumberFormatException e) {
                    continue;
                }
                Vector vCurrentValues = this.m_currentSetting.getValues();
                tempSV = (SettingValue)vCurrentValues.elementAt(iValueNumber);
                if (tempSV == null) continue;
                this.m_currentSettingValue = tempSV;
                this.m_state = STATE_NEW_LANGUAGE;
                return;
            }
        } else if (req.getParameter("ConfigDataNewLanguageForm") != null) {
            if (req.getParameter("Cancel") != null || req.getParameter("Cancel.x") != null) {
                this.m_state = STATE_LANGUAGES;
                return;
            }
            if (req.getParameter("Add") != null || req.getParameter("Add.x") != null) {
                String sSelected = null;
                String[] saSelected = req.getParameterValues("AllLanguageSource");
                if (!(saSelected != null && saSelected.length != 0 && saSelected[0] != null && saSelected[0].length() != 0 || (sSelected = req.getParameter("NewLanguageCode")) != null && sSelected.length() != 0)) {
                    throw new ConfigurationException(this.m_res.getString("Nothing_is_selected_to_add"));
                }
                HashMap hm = this.m_currentSettingValue.getDisplayValueMap();
                if (sSelected != null) {
                    if (!hm.containsKey(sSelected)) {
                        hm.put(sSelected, null);
                    }
                } else {
                    for (int i = 0; i < saSelected.length; ++i) {
                        if (saSelected[i] == null || saSelected[i].length() == 0) continue;
                        hm.put(saSelected[i], null);
                    }
                }
                this.m_state = STATE_LANGUAGES;
                return;
            }
        } else if (this.m_state != null && this.m_state.equals(STATE_WIZARD) && this.m_configurableGadget != null) {
            this.m_configurableGadget.onConfigAction(req);
            return;
        }
    }

    @Override
    public void configureComplete(ConfigData allSettings) {
        this.m_mergedConfig = allSettings;
        this.m_state = null;
    }

    public void configureApply(ConfigData allSettings) {
        this.m_mergedConfig = allSettings;
    }

    @Override
    public void configureCancel() {
        this.m_state = null;
    }

    public boolean getUsingWizard() {
        return this.m_state != null && (this.m_state.equals(STATE_WIZARD) || this.m_state.equals(STATE_LANGUAGES) || this.m_state.equals(STATE_NEW_LANGUAGE));
    }

    public void getStylesheetAndResourceSets(HttpServletRequest req, StylesheetSetMap ssMap, ResourceSetMap rsMap) {
        if (this.m_configurableGadget != null && this.m_state != null && this.m_state.equals(STATE_WIZARD)) {
            ((GadgetInstance)((Object)this.m_configurableGadget)).getStylesheetAndResourceSets(req, ssMap, rsMap);
        }
    }

    @Override
    public Locale getLocale() {
        return this.m_configComplete.getLocale();
    }

    @Override
    public String getConfiguredUniqueID() {
        return this.m_configComplete.getConfiguredUniqueID();
    }
}

