/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.configManager;

import com.novell.emframe.dev.XmlUtils;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.legacySupport.LegacyTaskInfo;
import com.novell.emframe.fw.servlet.FwSession;
import com.novell.nps.authentication.PortalConnection;
import com.novell.nps.authentication.PortalDirectoryException;
import com.novell.nps.configManager.ConfigData;
import com.novell.nps.configManager.ConfigManager;
import com.novell.nps.configManager.ConfigSettings;
import com.novell.nps.configManager.ObjectConfig;
import com.novell.nps.configManager.ObjectConfigRecord;
import com.novell.nps.configManager.Scheme;
import com.novell.nps.configManager.Setting;
import com.novell.nps.configManager.SettingValue;
import com.novell.nps.serviceProviders.NPSMacroParser;
import com.novell.nps.sessionManager.PortalSession;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.http.HttpSession;
import org.w3c.dom.Node;

public class GadgetAssignment
implements LegacyTaskInfo,
Comparator,
Cloneable,
Serializable {
    public static final String GADGET_ASSIGNMENT_XML_TAG = "gadget_assignment";
    public static final String ASSIGNMENT_NAME = "Assignment Name";
    public static final String ASSIGNMENT_ID = "Assignment ID";
    public static final String SERVICE_NAME = "Service Name";
    public static final String GADGET_ID = "Gadget GUID";
    public static final String GADGET_DN = "Gadget DN";
    public static final String GADGET_INSTANCE_CLASS = "Gadget Instance Class";
    public static final String LOCATION = "Location";
    public static final String LOCATION_HEADER = "Header";
    public static final String LOCATION_BODY = "Body";
    public static final String LOCATION_FOOTER = "Footer";
    public static final String LOCATION_HIDDEN = "Hidden";
    public static final String COLUMN = "Column";
    public static final String COLUMN1 = "Column 1";
    public static final String COLUMN2 = "Column 2";
    public static final String COLUMN3 = "Column 3";
    public static final String PRIORITY = "Priority";
    public static final int PRIORITY_LENGTH = 10;
    public static final String HAS_FRAME = "Has Frame";
    public static final boolean HAS_FRAME_DEFAULT = true;
    public static final String ASSIGNMENT_OVERWRITEABLE = "Assignment Overwriteable";
    public static final boolean ASSIGNMENT_OVERWRITEABLE_DEFAULT = false;
    public static final String ASSIGNMENT_USER_CONFIGURABLE = "Assignment User Configurable";
    public static final boolean ASSIGNMENT_USER_CONFIGURABLE_DEFAULT = false;
    public static final String SERVICE_ASSIGNMENT = "Service Assignment";
    public static final boolean SERVICE_ASSIGNMENT_DEFAULT = true;
    public static final String MINIMIZED = "Minimized";
    public static final boolean MINIMIZED_DEFAULT = false;
    public static final String ALLOW_TEARAWAY = "AllowTearaway";
    public static final boolean ALLOW_TEARAWAY_DEFAULT = false;
    public static final String TEARAWAY_WIDTH = "TearawayWidth";
    public static final String TEARAWAY_HEIGHT = "TearawayHeight";
    public static final int UNLIMITED = 0;
    public static final int NO_GADGET_ID = 0;
    public static final int NO_ASSIGNMENT_ID = 0;
    public static final String PARENT_ASSIGNMENT_ID = "ParentAssignmentID";
    public static final String CUSTOM_CONFIG_XML_TAG = "custom_config";
    public static final String REGISTRATION_KEY = "RegistrationKey";
    private String m_szGadgetDN = null;
    private String m_gadgetID = null;
    private long m_gadgetAssignmentID = 0L;
    private String m_location = "Body";
    private String m_column = "Column 1";
    private int m_priority = Integer.MAX_VALUE;
    private ConfigData m_gadgetConfig = new ConfigSettings();
    private boolean m_bHasFrame = true;
    private Scheme m_parentScheme = null;
    private String m_assignmentName = null;
    private HashMap m_hmAssignmentDisplayValues = null;
    private String m_sProcessedAssignmentName = null;
    private String m_serviceName = null;
    private String m_originalServiceName = null;
    private boolean m_bGadgetAddedByUser = false;
    private boolean m_bAssignmentOverwriteable = false;
    private boolean m_bIsUserConfigurable = false;
    private boolean m_bServiceAssignment = true;
    private boolean m_bMinimized = false;
    private boolean m_bAllowTearaway = false;
    private int m_iTearawayWidth = 0;
    private int m_iTearawayHeight = 0;
    private String m_sParentAssignmentID = null;
    private ConfigData m_customAssignmentConfig = new ConfigSettings();
    private String m_bSupportsTableData = "true";
    private String m_bSupportsFullFrame = "false";
    private String m_gadgetInstanceClass = null;
    private String[] m_gadgetInstanceArgs = null;
    private String m_gadgetClass = null;
    private String[] m_gadgetArgs = null;
    private ArrayList m_supportedDevices = null;
    private String m_sRegistrationKey = null;
    private List m_chainedServices = null;
    private GadgetAssignment m_jobInitiatorAssignment = null;
    private GadgetAssignment m_jobAssignment = null;

    public int compare(Object o1, Object o2) {
        GadgetAssignment gao1 = (GadgetAssignment)o1;
        GadgetAssignment gao2 = (GadgetAssignment)o2;
        if (gao1.getIntPriority() < gao2.getIntPriority()) {
            return -1;
        }
        if (gao1.getIntPriority() == gao2.getIntPriority()) {
            return 0;
        }
        return 1;
    }

    @Override
    public boolean equals(Object obj) {
        GadgetAssignment tempGA = (GadgetAssignment)obj;
        String sUniqueObj = tempGA.getUniqueID();
        String sThisUnique = this.getUniqueID();
        if (sUniqueObj == null || sThisUnique == null) {
            return false;
        }
        return sThisUnique.equalsIgnoreCase(sUniqueObj);
    }

    public String getGadgetDN() {
        return this.m_szGadgetDN;
    }

    public void setGadgetDN(String szGadgetDN) {
        this.m_szGadgetDN = szGadgetDN;
    }

    public String getGadgetID() {
        return this.m_gadgetID;
    }

    public void setGadgetID(String gadgetID) {
        this.m_gadgetID = gadgetID;
    }

    public String getLocation() {
        return this.m_location;
    }

    public void setLocation(String location) {
        this.m_location = location;
    }

    public String getColumn() {
        return this.m_column;
    }

    public void setColumn(String column) {
        this.m_column = column;
    }

    public int getIntPriority() {
        return this.m_priority;
    }

    public void setIntPriority(int priority) {
        this.m_priority = priority;
    }

    public String getPriority() {
        String priority = String.valueOf(this.m_priority);
        return priority;
    }

    public void setPriority(String priority) {
        if (priority != null) {
            try {
                this.m_priority = Integer.parseInt(priority);
            }
            catch (NumberFormatException nfe) {
                this.m_priority = Integer.MAX_VALUE;
            }
        } else {
            this.m_priority = Integer.MAX_VALUE;
        }
    }

    public long getGadgetAssignmentID() {
        return this.m_gadgetAssignmentID;
    }

    public void setGadgetAssignmentID(long gadgetAssignmentID) {
        this.m_gadgetAssignmentID = gadgetAssignmentID;
    }

    public ConfigData getGadgetConfig() {
        return this.m_gadgetConfig;
    }

    public void setGadgetConfig(ConfigData gadgetConfig) {
        this.m_gadgetConfig = gadgetConfig;
    }

    public ConfigData getCustomAssignmentConfig() {
        return this.m_customAssignmentConfig;
    }

    public void setCustomAssignmentConfig(ConfigData customAssignmentConfig) {
        this.m_customAssignmentConfig = customAssignmentConfig;
    }

    public boolean hasFrame() {
        return this.m_bHasFrame;
    }

    public void setHasFrame(boolean bHasFrame) {
        this.m_bHasFrame = bHasFrame;
    }

    public boolean getMinimized() {
        return this.m_bMinimized;
    }

    public void setMinimized(boolean bMinimized) {
        this.m_bMinimized = bMinimized;
    }

    public boolean allowTearaway() {
        return this.m_bAllowTearaway;
    }

    public void setAllowTearaway(boolean bAllowTearaway) {
        this.m_bAllowTearaway = bAllowTearaway;
    }

    public int getTearawayWidth() {
        return this.m_iTearawayWidth;
    }

    public void setTearawayWidth(int iTearawayWidth) {
        this.m_iTearawayWidth = iTearawayWidth;
    }

    public int getTearawayHeight() {
        return this.m_iTearawayHeight;
    }

    public void setTearawayHeight(int iTearawayHeight) {
        this.m_iTearawayHeight = iTearawayHeight;
    }

    public Scheme getScheme() {
        return this.m_parentScheme;
    }

    public void setScheme(Scheme scheme) {
        this.m_parentScheme = scheme;
    }

    public String getGadgetInstanceClass() {
        return this.m_gadgetInstanceClass;
    }

    public void setGadgetInstanceClass(String sClass) {
        this.m_gadgetInstanceClass = sClass;
    }

    public String getGadgetClass() {
        return this.m_gadgetClass;
    }

    public void setGadgetClass(String sClass) {
        this.m_gadgetClass = sClass;
    }

    public String[] getGadgetInstanceArgs() {
        return this.m_gadgetInstanceArgs;
    }

    public void setGadgetInstanceArgs(String[] sArgs) {
        this.m_gadgetInstanceArgs = sArgs;
    }

    public String[] getGadgetArgs() {
        return this.m_gadgetArgs;
    }

    public void setGadgetArgs(String[] sArgs) {
        this.m_gadgetArgs = sArgs;
    }

    public String getAssignmentName() {
        return this.m_assignmentName;
    }

    public String getAssignmentDisplayName(FwSession session) {
        if (this.m_hmAssignmentDisplayValues == null || this.m_hmAssignmentDisplayValues.size() == 0) {
            return this.m_assignmentName;
        }
        Locale[] locs = null;
        if (session != null) {
            locs = FwUtils.getLocales((HttpSession)session);
        }
        if (locs == null || locs.length == 0) {
            return this.m_assignmentName;
        }
        String sDisplayValue = null;
        for (int i = 0; i < locs.length; ++i) {
            sDisplayValue = (String)this.m_hmAssignmentDisplayValues.get(ConfigManager.getLanguageCode(locs[i]));
            if (sDisplayValue == null || sDisplayValue.length() == 0) continue;
            return sDisplayValue;
        }
        return this.m_assignmentName;
    }

    public HashMap getAssignmentDisplayNameMap() {
        return this.m_hmAssignmentDisplayValues;
    }

    public String getProcessedAssignmentName(FwSession session) {
        String sName = null;
        if (this.m_sProcessedAssignmentName == null) {
            if (this.m_assignmentName != null) {
                sName = NPSMacroParser.parseMacroString(this.getAssignmentDisplayName(session), (PortalSession)session, false);
                this.m_sProcessedAssignmentName = sName = XmlUtils.xmlEncode((String)sName);
            }
        } else {
            sName = this.m_sProcessedAssignmentName;
        }
        return sName;
    }

    public void setAssignmentName(String assignmentName) {
        this.m_sProcessedAssignmentName = null;
        this.m_assignmentName = assignmentName;
    }

    public void setAssignmentDisplayNameMap(HashMap hmDisplayValues) {
        this.m_hmAssignmentDisplayValues = hmDisplayValues;
    }

    public String getServiceName() {
        if (this.m_serviceName != null && this.m_serviceName.length() != 0) {
            return this.m_serviceName;
        }
        return this.getUniqueID();
    }

    public void setServiceName(String serviceName) {
        this.m_serviceName = serviceName;
    }

    public String getOriginalServiceName() {
        return this.m_originalServiceName;
    }

    public void setOriginalServiceName(String orignalServiceName) {
        this.m_originalServiceName = orignalServiceName;
    }

    public boolean getGadgetAddedByUser() {
        return this.m_bGadgetAddedByUser;
    }

    public void setGadgetAddedByUser(boolean bGadgetAddedByUser) {
        this.m_bGadgetAddedByUser = bGadgetAddedByUser;
    }

    public boolean isAssignmentOverwriteable() {
        return this.m_bAssignmentOverwriteable;
    }

    public void setIsAssignmentOverwriteable(boolean bAssignmentOverwriteable) {
        this.m_bAssignmentOverwriteable = bAssignmentOverwriteable;
    }

    public boolean getIsUserConfigurable() {
        return this.m_bIsUserConfigurable;
    }

    public boolean getIsUserConfigurable(FwSession session) {
        boolean bRet = this.m_bIsUserConfigurable;
        return bRet;
    }

    public void setIsUserConfigurable(boolean bIsUserConfigurable) {
        this.m_bIsUserConfigurable = bIsUserConfigurable;
    }

    public boolean getIsServiceAssignment() {
        return this.m_bServiceAssignment;
    }

    public void setIsServiceAssignment(boolean bServiceAssignment) {
        this.m_bServiceAssignment = bServiceAssignment;
    }

    public boolean hasGadgetConfig() {
        boolean bRet = this.m_gadgetConfig != null && !this.m_gadgetConfig.isEmpty();
        return bRet;
    }

    public void writeConfigSettings(PortalConnection pc, String sPCOID) throws PortalDirectoryException {
        ConfigSettings cs = (ConfigSettings)this.m_gadgetConfig.copy();
        Setting tempSetting2 = null;
        Vector<Setting> vRemove = new Vector<Setting>();
        Collection co = cs.getSettingsCollection();
        for (Setting tempSetting2 : co) {
            Vector vValues = tempSetting2.getValues();
            if (vValues == null || !vValues.isEmpty()) continue;
            vRemove.add(tempSetting2);
        }
        if (!vRemove.isEmpty()) {
            Enumeration eRem = vRemove.elements();
            while (eRem.hasMoreElements()) {
                tempSetting2 = (Setting)eRem.nextElement();
                cs.removeSetting(tempSetting2.getName());
            }
        }
        ObjectConfigRecord ocr = new ObjectConfigRecord(cs);
        this.writeConfigSettings(cs, ocr, pc, this.m_parentScheme.getFDN(), sPCOID, "bhConfig");
    }

    public void writeUserRWConfigSettings(PortalConnection pc, String sObject, FwSession session) throws PortalDirectoryException {
        ConfigSettings cs = (ConfigSettings)this.m_gadgetConfig.copy();
        Setting tempSetting2 = null;
        SettingValue tempSV = null;
        Vector<Setting> vRemove = new Vector<Setting>();
        Collection co = cs.getSettingsCollection();
        for (Setting tempSetting2 : co) {
            Vector vValues = tempSetting2.getValues();
            if (vValues == null || vValues.isEmpty()) {
                vRemove.add(tempSetting2);
                continue;
            }
            if (tempSetting2.getCumulative()) {
                Enumeration ve = vValues.elements();
                Vector<SettingValue> vRemoveValues = new Vector<SettingValue>();
                while (ve.hasMoreElements()) {
                    tempSV = (SettingValue)ve.nextElement();
                    if (!tempSV.getInheritedFromParent()) continue;
                    vRemoveValues.add(tempSV);
                }
                if (vRemoveValues.isEmpty()) continue;
                vValues.removeAll(vRemoveValues);
                tempSetting2.setValues(vValues);
                continue;
            }
            boolean bUserModified = false;
            Enumeration ve = vValues.elements();
            while (ve.hasMoreElements()) {
                tempSV = (SettingValue)ve.nextElement();
                if (tempSV.getInheritedFromParent()) continue;
                bUserModified = true;
                break;
            }
            if (bUserModified) continue;
            vRemove.add(tempSetting2);
        }
        if (!vRemove.isEmpty()) {
            Enumeration eRem = vRemove.elements();
            while (eRem.hasMoreElements()) {
                tempSetting2 = (Setting)eRem.nextElement();
                cs.removeSetting(tempSetting2.getName());
            }
        }
        ObjectConfigRecord ocr = new ObjectConfigRecord(cs);
        this.writeConfigSettings(cs, ocr, pc, sObject, ConfigManager.getPCOID(), "bhConfigRW");
    }

    public void writeOtherObjectConfigSettings(PortalConnection pc, String sObject, String sPCOID) throws PortalDirectoryException {
        ObjectConfigRecord ocr = new ObjectConfigRecord((ConfigSettings)this.m_gadgetConfig);
        this.writeConfigSettings(ocr, pc, sObject, sPCOID, "bhConfig");
    }

    public void writeConfigSettings(ObjectConfigRecord ocr, PortalConnection pc, String sObject, String sPCOID, String sAttribute) throws PortalDirectoryException {
        this.writeConfigSettings((ConfigSettings)this.m_gadgetConfig, ocr, pc, sObject, sPCOID, sAttribute);
    }

    public void writeConfigSettings(ConfigSettings cs, ObjectConfigRecord ocr, PortalConnection pc, String sObject, String sPCOID, String sAttribute) throws PortalDirectoryException {
        ocr.setGadgetID((int)this.m_gadgetAssignmentID);
        ocr.setObjectGUID(this.m_parentScheme.getObjectID());
        ocr.setPCO(sPCOID);
        ocr.setSchemeID((int)this.m_parentScheme.getSchemeID());
        ocr.setType(3);
        ocr.convertDOMtoXML();
        ObjectConfig oc = new ObjectConfig(sPCOID, sObject, sAttribute);
        if (cs != null && !cs.isEmpty()) {
            oc.writeRecord(pc, ocr);
        } else {
            oc.deleteRecord(pc, ocr);
        }
    }

    public void deleteConfigSettings(PortalConnection pc, String sPCOID) throws PortalDirectoryException {
        this.deleteConfigSettings(pc, this.m_parentScheme.getFDN(), sPCOID, "bhConfig");
    }

    public void deleteUserRWConfigSettings(PortalConnection pc, String sObject) throws PortalDirectoryException {
        this.deleteConfigSettings(pc, sObject, ConfigManager.getPCOID(), "bhConfigRW");
    }

    public void deleteOtherObjectConfigSettings(PortalConnection pc, String sObject, String sPCOID) throws PortalDirectoryException {
        this.deleteConfigSettings(pc, sObject, sPCOID, "bhConfig");
    }

    public void deleteConfigSettings(PortalConnection pc, String sObject, String sPCOID, String sAttribute) throws PortalDirectoryException {
        ObjectConfigRecord ocr = new ObjectConfigRecord();
        ocr.setGadgetID((int)this.m_gadgetAssignmentID);
        ocr.setObjectGUID(this.m_parentScheme.getObjectID());
        ocr.setPCO(sPCOID);
        ocr.setSchemeID((int)this.m_parentScheme.getSchemeID());
        ocr.setType(3);
        ObjectConfig oc = new ObjectConfig(sPCOID, sObject, sAttribute);
        oc.deleteRecord(pc, ocr);
    }

    public ConfigData getAssignmentProperties() {
        ConfigSettings cd = new ConfigSettings();
        return this.getAssignmentProperties(cd);
    }

    public ConfigData getAssignmentProperties(ObjectConfigRecord ocr) {
        ConfigSettings cd = new ConfigSettings(ocr, GADGET_ASSIGNMENT_XML_TAG);
        return this.getAssignmentProperties(cd);
    }

    public ConfigData getAssignmentProperties(ConfigData cd) {
        if (this.m_hmAssignmentDisplayValues == null || this.m_hmAssignmentDisplayValues.size() == 0) {
            cd.addSettingValue(ASSIGNMENT_NAME, this.m_assignmentName);
        } else {
            Vector<SettingValue> vValues = new Vector<SettingValue>();
            SettingValue tempSV = new SettingValue(this.m_assignmentName, this.m_hmAssignmentDisplayValues);
            vValues.add(tempSV);
            cd.addNewSetting(ASSIGNMENT_NAME, vValues, true, false);
        }
        cd.addSettingValue(SERVICE_NAME, this.getServiceName());
        cd.addSettingIntValue(ASSIGNMENT_ID, (int)this.m_gadgetAssignmentID);
        if (this.m_szGadgetDN != null && this.m_szGadgetDN.length() != 0) {
            cd.addSettingValue(GADGET_DN, this.m_szGadgetDN);
            cd.addSettingValue(GADGET_ID, this.m_gadgetID);
        } else {
            cd.addSettingValue(GADGET_DN, "");
            cd.addSettingValue(GADGET_ID, String.valueOf(0));
            cd.addSettingValue(GADGET_INSTANCE_CLASS, this.m_gadgetInstanceClass);
            if (this.m_bSupportsFullFrame != null && this.m_bSupportsFullFrame.length() != 0) {
                cd.addSettingValue("SupportsFullFrame", this.m_bSupportsFullFrame);
            }
            if (this.m_bSupportsTableData != null && this.m_bSupportsTableData.length() != 0) {
                cd.addSettingValue("SupportsTableData", this.m_bSupportsTableData);
            }
        }
        cd.addSettingValue(LOCATION, this.m_location);
        cd.addSettingValue(COLUMN, this.m_column);
        cd.addSettingIntValue(PRIORITY, this.m_priority);
        if (this.m_bHasFrame) {
            cd.addSettingValue(HAS_FRAME, "1");
        } else {
            cd.addSettingValue(HAS_FRAME, "0");
        }
        if (this.m_bAssignmentOverwriteable) {
            cd.addSettingValue(ASSIGNMENT_OVERWRITEABLE, "1");
        } else {
            cd.addSettingValue(ASSIGNMENT_OVERWRITEABLE, "0");
        }
        if (this.m_bIsUserConfigurable) {
            cd.addSettingValue(ASSIGNMENT_USER_CONFIGURABLE, "1");
        } else {
            cd.addSettingValue(ASSIGNMENT_USER_CONFIGURABLE, "0");
        }
        if (this.m_bMinimized) {
            cd.addSettingValue(MINIMIZED, "1");
        } else {
            cd.addSettingValue(MINIMIZED, "0");
        }
        if (this.m_bAllowTearaway) {
            cd.addSettingValue(ALLOW_TEARAWAY, "1");
        } else {
            cd.addSettingValue(ALLOW_TEARAWAY, "0");
        }
        if (this.m_iTearawayWidth != 0) {
            cd.addSettingIntValue(TEARAWAY_WIDTH, this.m_iTearawayWidth);
        }
        if (this.m_iTearawayHeight != 0) {
            cd.addSettingIntValue(TEARAWAY_HEIGHT, this.m_iTearawayHeight);
        }
        if (this.m_sParentAssignmentID != null && this.m_sParentAssignmentID.length() != 0) {
            cd.addSettingValue(PARENT_ASSIGNMENT_ID, this.m_sParentAssignmentID);
        }
        if (this.m_sRegistrationKey != null && this.m_sRegistrationKey.length() != 0) {
            cd.addSettingValue(REGISTRATION_KEY, this.m_sRegistrationKey);
        }
        return cd;
    }

    public GadgetAssignment copy() {
        GadgetAssignment newGA = new GadgetAssignment();
        if (this.m_assignmentName != null) {
            newGA.setAssignmentName(this.m_assignmentName);
        }
        if (this.m_hmAssignmentDisplayValues != null) {
            newGA.setAssignmentDisplayNameMap(this.m_hmAssignmentDisplayValues);
        }
        if (this.m_serviceName != null) {
            newGA.setServiceName(this.m_serviceName);
        }
        if (this.m_column != null) {
            newGA.setColumn(this.m_column);
        }
        if (this.m_gadgetArgs != null) {
            newGA.setGadgetArgs((String[])this.m_gadgetArgs.clone());
        }
        newGA.setGadgetAssignmentID(this.m_gadgetAssignmentID);
        if (this.m_gadgetClass != null) {
            newGA.setGadgetClass(this.m_gadgetClass);
        }
        if (this.m_gadgetConfig != null) {
            newGA.setGadgetConfig(this.m_gadgetConfig.copy());
        }
        if (this.m_customAssignmentConfig != null) {
            newGA.setCustomAssignmentConfig(this.m_customAssignmentConfig.copy());
        }
        if (this.m_szGadgetDN != null) {
            newGA.setGadgetDN(this.m_szGadgetDN);
        }
        if (this.m_gadgetID != null) {
            newGA.setGadgetID(this.m_gadgetID);
        }
        if (this.m_gadgetInstanceArgs != null) {
            newGA.setGadgetInstanceArgs((String[])this.m_gadgetInstanceArgs.clone());
        }
        if (this.m_gadgetInstanceClass != null) {
            newGA.setGadgetInstanceClass(this.m_gadgetInstanceClass);
        }
        newGA.setHasFrame(this.m_bHasFrame);
        if (this.m_location != null) {
            newGA.setLocation(this.m_location);
        }
        newGA.setPriority(String.valueOf(this.m_priority));
        newGA.setScheme(this.m_parentScheme);
        newGA.setIsAssignmentOverwriteable(this.m_bAssignmentOverwriteable);
        newGA.setIsUserConfigurable(this.m_bIsUserConfigurable);
        newGA.setIsServiceAssignment(this.m_bServiceAssignment);
        newGA.setGadgetAddedByUser(this.m_bGadgetAddedByUser);
        newGA.setMinimized(this.m_bMinimized);
        newGA.setAllowTearaway(this.m_bAllowTearaway);
        newGA.setTearawayWidth(this.m_iTearawayWidth);
        newGA.setTearawayHeight(this.m_iTearawayHeight);
        if (this.m_sParentAssignmentID != null) {
            newGA.setParentAssignmentID(this.m_sParentAssignmentID);
        }
        newGA.setSupportsFullFrame(this.getSupportsFullFrame());
        newGA.setSupportsTableData(this.getSupportsTableData());
        if (this.m_originalServiceName != null) {
            newGA.setOriginalServiceName(this.m_originalServiceName);
        }
        if (this.m_supportedDevices != null) {
            newGA.setSupportedDevices((ArrayList)this.m_supportedDevices.clone());
        }
        newGA.setRegistrationKey(this.m_sRegistrationKey);
        if (this.m_chainedServices != null) {
            newGA.setChainedServices(this.m_chainedServices);
        }
        if (this.m_jobInitiatorAssignment != null) {
            newGA.setJobInitiatorAssignment(this.m_jobInitiatorAssignment);
        }
        if (this.m_jobAssignment != null) {
            newGA.setJobAssignment(this.m_jobAssignment);
        }
        return newGA;
    }

    protected Object clone() throws CloneNotSupportedException {
        return this.copy();
    }

    public String getUniqueID() {
        String sID = "Invalid";
        if (this.m_parentScheme != null) {
            StringBuffer sb = new StringBuffer(60);
            sb.append(this.m_parentScheme.getObjectID());
            sb.append(":");
            sb.append(this.m_parentScheme.getSchemeID());
            sb.append(":");
            sb.append(this.m_gadgetAssignmentID);
            sID = sb.toString();
        }
        return sID;
    }

    public void readSettings(Node GASettingNode) {
        Vector vValues;
        String tempString = null;
        int value = 0;
        ConfigSettings GASettings = new ConfigSettings();
        GASettings.readSettings(GASettingNode, 1);
        Setting tempSetting = GASettings.getSingleSettingObject(ASSIGNMENT_NAME);
        if (tempSetting != null && (vValues = tempSetting.getValues()) != null && vValues.size() != 0) {
            SettingValue tempSV = (SettingValue)vValues.elementAt(0);
            this.setAssignmentName(tempSV.getValue());
            this.setAssignmentDisplayNameMap(tempSV.getDisplayValueMap());
        }
        this.setServiceName(GASettings.getSingleSetting(SERVICE_NAME));
        tempString = GASettings.getSingleSetting(ASSIGNMENT_ID);
        if (tempString == null) {
            this.setGadgetAssignmentID(0L);
        } else {
            this.setGadgetAssignmentID(Long.parseLong(tempString));
        }
        this.setGadgetDN(GASettings.getSingleSetting(GADGET_DN));
        this.setGadgetID(GASettings.getSingleSetting(GADGET_ID));
        this.setGadgetInstanceClass(GASettings.getSingleSetting(GADGET_INSTANCE_CLASS));
        this.setLocation(GASettings.getSingleSetting(LOCATION, LOCATION_BODY));
        this.setColumn(GASettings.getSingleSetting(COLUMN, COLUMN1));
        this.setPriority(GASettings.getSingleSetting(PRIORITY));
        tempString = GASettings.getSingleSetting(HAS_FRAME);
        if (tempString == null) {
            this.setHasFrame(true);
        } else {
            try {
                value = Integer.parseInt(tempString);
                if (value == 0) {
                    this.setHasFrame(false);
                } else {
                    this.setHasFrame(true);
                }
            }
            catch (NumberFormatException nfe) {
                this.setHasFrame(true);
            }
        }
        tempString = GASettings.getSingleSetting(ASSIGNMENT_OVERWRITEABLE);
        if (tempString == null) {
            this.setIsAssignmentOverwriteable(false);
        } else {
            try {
                value = Integer.parseInt(tempString);
                if (value == 0) {
                    this.setIsAssignmentOverwriteable(false);
                } else {
                    this.setIsAssignmentOverwriteable(true);
                }
            }
            catch (NumberFormatException nfe) {
                this.setIsAssignmentOverwriteable(false);
            }
        }
        tempString = GASettings.getSingleSetting(ASSIGNMENT_USER_CONFIGURABLE);
        if (tempString == null) {
            this.setIsUserConfigurable(false);
        } else {
            try {
                value = Integer.parseInt(tempString);
                if (value == 0) {
                    this.setIsUserConfigurable(false);
                } else {
                    this.setIsUserConfigurable(true);
                }
            }
            catch (NumberFormatException nfe) {
                this.setIsUserConfigurable(false);
            }
        }
        tempString = GASettings.getSingleSetting(MINIMIZED);
        if (tempString == null) {
            this.setMinimized(false);
        } else {
            try {
                value = Integer.parseInt(tempString);
                if (value == 0) {
                    this.setMinimized(false);
                } else {
                    this.setMinimized(true);
                }
            }
            catch (NumberFormatException nfe) {
                this.setMinimized(false);
            }
        }
        tempString = GASettings.getSingleSetting(ALLOW_TEARAWAY);
        if (tempString == null) {
            this.setAllowTearaway(false);
        } else {
            try {
                value = Integer.parseInt(tempString);
                if (value == 0) {
                    this.setAllowTearaway(false);
                } else {
                    this.setAllowTearaway(true);
                }
            }
            catch (NumberFormatException nfe) {
                this.setAllowTearaway(false);
            }
        }
        this.setTearawayWidth(GASettings.getSingleIntSetting(TEARAWAY_WIDTH, 0));
        this.setTearawayHeight(GASettings.getSingleIntSetting(TEARAWAY_HEIGHT, 0));
        this.setParentAssignmentID(GASettings.getSingleSetting(PARENT_ASSIGNMENT_ID));
        this.setRegistrationKey(GASettings.getSingleSetting(REGISTRATION_KEY));
        tempString = GASettings.getSingleSetting("SupportsFullFrame");
        if (tempString != null && tempString.length() != 0) {
            if (tempString.equalsIgnoreCase("true")) {
                this.setSupportsFullFrame(true);
            } else {
                this.setSupportsFullFrame(false);
            }
        }
        if ((tempString = GASettings.getSingleSetting("SupportsTableData")) != null && tempString.length() != 0) {
            if (tempString.equalsIgnoreCase("true")) {
                this.setSupportsTableData(true);
            } else {
                this.setSupportsTableData(false);
            }
        }
    }

    public String getParentAssignmentID() {
        return this.m_sParentAssignmentID;
    }

    public void setParentAssignmentID(String sParentAssignmentID) {
        this.m_sParentAssignmentID = sParentAssignmentID;
    }

    public boolean getSupportsTableData() {
        if (this.m_bSupportsTableData == null) {
            this.m_bSupportsTableData = "true";
        }
        return !this.m_bSupportsTableData.equalsIgnoreCase("false");
    }

    public void setSupportsTableData(boolean bSupports) {
        this.m_bSupportsTableData = bSupports ? "true" : "false";
    }

    public boolean getSupportsFullFrame() {
        if (this.m_bSupportsTableData == null) {
            this.m_bSupportsTableData = "true";
        }
        if (this.m_bSupportsFullFrame == null) {
            this.m_bSupportsFullFrame = "false";
        }
        return !this.m_bSupportsFullFrame.equalsIgnoreCase("false");
    }

    public void setSupportsFullFrame(boolean bSupports) {
        this.m_bSupportsFullFrame = bSupports ? "true" : "false";
    }

    public void setSupportedDevices(ArrayList supportedDevices) {
        this.m_supportedDevices = supportedDevices;
    }

    public ArrayList getSupportedDevices() {
        return this.m_supportedDevices;
    }

    public String getRegistrationKey() {
        return this.m_sRegistrationKey;
    }

    public void setRegistrationKey(String sRegistrationKey) {
        this.m_sRegistrationKey = sRegistrationKey;
    }

    public List getChainedServices() {
        return this.m_chainedServices;
    }

    public void setChainedServices(List chainedServices) {
        this.m_chainedServices = chainedServices;
    }

    public GadgetAssignment getJobInitiatorAssignment() {
        return this.m_jobInitiatorAssignment;
    }

    public LegacyTaskInfo getChainInitiatorInfo() {
        return this.m_jobInitiatorAssignment;
    }

    public void setJobInitiatorAssignment(GadgetAssignment jobInitiatorAssignment) {
        this.m_jobInitiatorAssignment = jobInitiatorAssignment;
    }

    public GadgetAssignment getJobAssignment() {
        return this.m_jobAssignment;
    }

    public LegacyTaskInfo getChainInfo() {
        return this.m_jobAssignment;
    }

    public void setJobAssignment(GadgetAssignment jobAssignment) {
        this.m_jobAssignment = jobAssignment;
    }
}

