/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.configManager;

import com.novell.emframe.fw.FwUtils;
import com.novell.nps.authentication.PortalDirectoryException;
import com.novell.nps.configManager.ConfigManager;
import com.novell.nps.configManager.ConfigSettings;
import com.novell.nps.debug.Debug;
import com.novell.nps.utils.DOMUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ObjectConfigRecord
implements Serializable {
    private static final String DT = "ObjectConfigRecord";
    public static final int GUID_LEN = 38;
    private int m_iType;
    private String m_sPortalGUID = null;
    private String m_sObjectGUID = null;
    private int m_iSchemeID;
    private int m_iGadgetID;
    private int m_iLength;
    private byte[] m_bRecordData = null;
    private File m_File = null;
    private boolean m_bIsValid = false;
    private transient Document m_dom = null;

    public ObjectConfigRecord() {
    }

    public ObjectConfigRecord(ConfigSettings settings) {
        if (settings != null) {
            this.m_dom = settings.getDOM();
            if (this.m_dom != null) {
                this.m_bIsValid = true;
            }
        }
    }

    public ObjectConfigRecord(StringReader sr) {
        this.readInput(sr);
    }

    public ObjectConfigRecord(InputStream is) {
        this.readInputStream(is);
    }

    public ObjectConfigRecord(Document dom) {
        this.m_dom = dom;
        if (this.m_dom != null) {
            this.m_bIsValid = true;
        }
    }

    public ObjectConfigRecord(String sObjectGUID, int schemeID, int gadgetID, int length) {
        this.m_sPortalGUID = ConfigManager.getPCOID();
        this.m_sObjectGUID = sObjectGUID;
        this.m_iSchemeID = schemeID;
        this.m_iGadgetID = gadgetID;
        this.m_iLength = length;
    }

    public void readInputStream(InputStream is) {
        block6: {
            if (is == null) {
                this.m_dom = null;
                return;
            }
            InputStreamReader newInput = null;
            try {
                newInput = new InputStreamReader(is, "UTF8");
            }
            catch (UnsupportedEncodingException uee) {
                if (Debug.isLoggable(1)) {
                    Debug.log("Unsupported Encoding", uee);
                }
                return;
            }
            this.readInput(newInput);
            try {
                ((Reader)newInput).close();
            }
            catch (IOException e) {
                if (!Debug.isLoggable(1)) break block6;
                Debug.log("IOException closing reader" + e);
            }
        }
    }

    public void readInput(Reader r) {
        try {
            this.m_dom = DOMUtil.XMLToDOM(r);
        }
        catch (Exception ex) {
            if (Debug.isLoggable(3)) {
                Debug.log(DT, 3, ex);
            }
            this.m_dom = null;
        }
        if (this.m_dom != null) {
            this.m_bIsValid = true;
        }
    }

    public void setType(int iType) {
        this.m_iType = iType;
    }

    public int getType() {
        return this.m_iType;
    }

    public void setPCO(String sPortalGUID) {
        this.m_sPortalGUID = sPortalGUID;
    }

    public String getPCO() {
        return this.m_sPortalGUID;
    }

    public void setObjectGUID(String sObjectGUID) {
        this.m_sObjectGUID = sObjectGUID;
    }

    public String getObjectGUID() {
        return this.m_sObjectGUID;
    }

    public void setSchemeID(int iSchemeID) {
        this.m_iSchemeID = iSchemeID;
    }

    public int getSchemeID() {
        return this.m_iSchemeID;
    }

    public void setGadgetID(int iGadgetID) {
        this.m_iGadgetID = iGadgetID;
    }

    public int getGadgetID() {
        return this.m_iGadgetID;
    }

    public File getFileName() {
        return this.m_File;
    }

    public int getSize() {
        int iSize = 0;
        String sMaxInt = String.valueOf(Integer.MAX_VALUE);
        int iMaxIntSize = sMaxInt.length();
        iSize += iMaxIntSize;
        iSize += 38;
        iSize += 38;
        iSize += iMaxIntSize;
        iSize += iMaxIntSize;
        iSize += iMaxIntSize;
        if (this.m_bRecordData != null) {
            iSize += this.m_bRecordData.length;
        }
        return iSize;
    }

    public void setRecordData(byte[] bRecordData) {
        this.m_iLength = bRecordData.length;
        this.m_bRecordData = new byte[this.m_iLength];
        Arrays.fill(this.m_bRecordData, (byte)0);
        System.arraycopy(bRecordData, 0, this.m_bRecordData, 0, this.m_iLength);
    }

    public byte[] getRecordData() {
        return this.m_bRecordData;
    }

    public void read(byte[] ba) {
        BufferedInputStream s = new BufferedInputStream(new ByteArrayInputStream(ba));
        this.read(s);
    }

    public void read(File f) {
        try {
            BufferedInputStream s = new BufferedInputStream(new FileInputStream(f.getPath()));
            this.read(s);
            this.m_File = f;
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public void read(BufferedInputStream s) {
        String sTemp = null;
        this.m_bIsValid = false;
        try {
            DataInputStream d = new DataInputStream(s);
            this.m_iType = d.readInt();
            byte[] bPortalGUID = new byte[38];
            int iRet = d.read(bPortalGUID);
            if (iRet == -1) {
                d.close();
                return;
            }
            sTemp = new String(bPortalGUID);
            int iIndex = sTemp.indexOf(0);
            this.m_sPortalGUID = iIndex != -1 ? sTemp.substring(0, iIndex) : sTemp;
            byte[] bObjectGUID = new byte[38];
            iRet = d.read(bObjectGUID);
            if (iRet == -1) {
                d.close();
                return;
            }
            sTemp = new String(bObjectGUID);
            iIndex = sTemp.indexOf(0);
            this.m_sObjectGUID = iIndex != -1 ? sTemp.substring(0, iIndex) : sTemp;
            this.m_iSchemeID = d.readInt();
            this.m_iGadgetID = d.readInt();
            this.m_iLength = d.readInt();
            if (this.m_iLength > 65536) {
                d.close();
                return;
            }
            if (this.m_iLength < 0) {
                d.close();
                return;
            }
            this.m_bRecordData = new byte[this.m_iLength];
            iRet = d.read(this.m_bRecordData);
            if (iRet == -1) {
                d.close();
                return;
            }
            d.close();
            this.m_bIsValid = true;
        }
        catch (IOException e) {
            this.m_bIsValid = false;
        }
    }

    public byte[] write() throws PortalDirectoryException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedOutputStream s = new BufferedOutputStream(baos);
        this.write(s);
        return baos.toByteArray();
    }

    public void write(File f) throws PortalDirectoryException {
        try {
            BufferedOutputStream s = new BufferedOutputStream(new FileOutputStream(f.getPath()));
            this.write(s);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public void write(BufferedOutputStream s) throws PortalDirectoryException {
        if (this.m_sPortalGUID == null) {
            ResourceBundle res = ConfigManager.getResourceBundle();
            throw new PortalDirectoryException(res.getString("Portal_GUID_is_not"));
        }
        if (this.m_sObjectGUID == null) {
            ResourceBundle res = ConfigManager.getResourceBundle();
            throw new PortalDirectoryException(res.getString("Object_GUID_is_not"));
        }
        if (this.m_bRecordData == null) {
            ResourceBundle res = ConfigManager.getResourceBundle();
            throw new PortalDirectoryException(res.getString("Record_data_is_not"));
        }
        try {
            DataOutputStream d = new DataOutputStream(s);
            d.writeInt(this.m_iType);
            byte[] bPortalGUID = new byte[38];
            int iLen = Math.min(38, this.m_sPortalGUID.length());
            Arrays.fill(bPortalGUID, (byte)0);
            System.arraycopy(this.m_sPortalGUID.getBytes(), 0, bPortalGUID, 0, iLen);
            d.write(bPortalGUID);
            byte[] bObjectGUID = new byte[38];
            iLen = Math.min(38, this.m_sObjectGUID.length());
            Arrays.fill(bObjectGUID, (byte)0);
            System.arraycopy(this.m_sObjectGUID.getBytes(), 0, bObjectGUID, 0, iLen);
            d.write(bObjectGUID);
            d.writeInt(this.m_iSchemeID);
            d.writeInt(this.m_iGadgetID);
            d.writeInt(this.m_iLength);
            d.write(this.m_bRecordData);
            d.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void writeDomData(File f) throws FileNotFoundException, IOException {
        if (this.m_dom == null) {
            return;
        }
        FileOutputStream fos = new FileOutputStream(f.getPath());
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "UTF8"));
        String str = FwUtils.getDocStr((Document)this.m_dom);
        out.write(str);
        ((Writer)out).close();
    }

    public Node findFirstElement(String sElementPath) {
        Node retNode = null;
        Document node = null;
        if (this.m_dom != null) {
            node = this.m_dom;
        } else if (this.m_bRecordData != null && this.m_bRecordData.length > 0) {
            ByteArrayInputStream bais = new ByteArrayInputStream(this.m_bRecordData);
            InputStreamReader newInput = null;
            try {
                newInput = new InputStreamReader((InputStream)bais, "UTF8");
            }
            catch (UnsupportedEncodingException uee) {
                if (Debug.isLoggable(1)) {
                    Debug.log("Unsupported Encoding - findFirstElement", uee);
                }
                return null;
            }
            try {
                this.m_dom = DOMUtil.XMLToDOM(newInput);
            }
            catch (Exception ex) {
                if (Debug.isLoggable(3)) {
                    Debug.log(DT, 3, ex);
                }
                this.m_dom = null;
            }
            node = this.m_dom;
        }
        if (this.m_dom != null) {
            retNode = ObjectConfigRecord.findNode(node, sElementPath);
        }
        return retNode;
    }

    public Node findFirstElement(Node node, String sElementPath) {
        Node retNode = null;
        StringBuffer sb = new StringBuffer(node.getNodeName().length() + sElementPath.length() + 2);
        sb.append(node.getNodeName());
        sb.append("\\");
        sb.append(sElementPath);
        String sPath = sb.toString();
        retNode = ObjectConfigRecord.findNode(node, sPath);
        return retNode;
    }

    public static Node findNextElement(Node node) {
        Node retNode = node;
        while (!((retNode = retNode.getNextSibling()) == null || retNode.getNodeType() == 1 && retNode.getNodeName().equals(node.getNodeName()))) {
        }
        return retNode;
    }

    private static String getNodeFullName(Node node) {
        Node nodeParent = node.getParentNode();
        if (nodeParent != null && nodeParent.getNodeType() == 1) {
            String sNodePath = ObjectConfigRecord.getNodeFullName(nodeParent);
            StringBuffer sb = new StringBuffer(node.getNodeName().length() + sNodePath.length() + 2);
            sb.append(sNodePath);
            sb.append("\\");
            sb.append(node.getNodeName());
            return sb.toString();
        }
        return node.getNodeName();
    }

    public static Hashtable getNodeSettingsTable(Node node) {
        Hashtable<String, Vector<String>> ht = new Hashtable<String, Vector<String>>();
        String sName = null;
        String sValue = null;
        Vector<String> v = null;
        Node child = null;
        Node baby = null;
        NodeList babylist = null;
        NodeList children = node.getChildNodes();
        if (children != null) {
            int lenChildren = children.getLength();
            for (int i = 0; i < lenChildren; ++i) {
                child = children.item(i);
                if (child.getNodeType() != 1 || null == (sName = child.getNodeName()) || (babylist = child.getChildNodes()) == null) continue;
                int lenBabies = babylist.getLength();
                for (int j = 0; j < lenBabies; ++j) {
                    baby = babylist.item(j);
                    sValue = baby.getNodeValue();
                    if (sValue == null || 0 >= sValue.trim().length()) continue;
                    v = (Vector<String>)ht.get(sName);
                    if (v != null) {
                        v.add(sValue);
                        continue;
                    }
                    v = new Vector<String>();
                    v.add(sValue);
                    ht.put(sName, v);
                }
            }
        }
        return ht;
    }

    public static String getNodeValue(Node node, String sValueName) {
        NodeList babylist;
        String sStr = null;
        StringBuffer sb = new StringBuffer(node.getNodeName().length() + sValueName.length() + 2);
        sb.append(node.getNodeName());
        sb.append("\\");
        sb.append(sValueName);
        String sPath = sb.toString();
        Node child = ObjectConfigRecord.findNode(node, sPath);
        Node baby = null;
        if (child != null && (babylist = child.getChildNodes()) != null && babylist.getLength() > 0) {
            baby = babylist.item(0);
            sStr = new String(baby.getNodeValue());
        }
        return sStr;
    }

    public static Vector getNodeValues(Node node, String sValueName) {
        Vector<String> vStr = new Vector<String>();
        StringBuffer sb = new StringBuffer(node.getNodeName().length() + sValueName.length() + 2);
        sb.append(node.getNodeName());
        sb.append("\\");
        sb.append(sValueName);
        String sPath = sb.toString();
        Node child = ObjectConfigRecord.findNode(node, sPath);
        Node baby = null;
        while (child != null) {
            NodeList babylist = child.getChildNodes();
            if (babylist != null && babylist.getLength() > 0) {
                baby = babylist.item(0);
                vStr.addElement(new String(baby.getNodeValue()));
            }
            child = ObjectConfigRecord.findNextElement(child);
        }
        return vStr;
    }

    private static Node findNode(Node node, String sPath) {
        Node retNode = null;
        short type = node.getNodeType();
        if (type == 9 ? (retNode = ObjectConfigRecord.traverseFind(((Document)node).getDocumentElement(), sPath, 0)) != null : type != 1 || (retNode = ObjectConfigRecord.traverseFind(node, sPath, 0)) != null) {
            // empty if block
        }
        return retNode;
    }

    private static Node traverseFind(Node node, String sPath, int indent) {
        Node retNode = null;
        if (node == null) {
            return retNode;
        }
        if (node.getNodeType() == 1) {
            String sElement = null;
            String sRemainder = null;
            int index = sPath.indexOf(92);
            if (index != -1) {
                sElement = sPath.substring(0, index);
                sRemainder = sPath.substring(index + 1, sPath.length());
            } else {
                sElement = new String(sPath);
            }
            if (node.getNodeName().equals(sElement)) {
                if (sRemainder == null) {
                    retNode = node;
                } else {
                    NodeList children = node.getChildNodes();
                    if (children != null) {
                        int len = children.getLength();
                        for (int i = 0; i < len && retNode == null; ++i) {
                            retNode = ObjectConfigRecord.traverseFind(children.item(i), sRemainder, indent + 1);
                        }
                    }
                }
            }
        }
        return retNode;
    }

    public void convertDOMtoXML() {
        if (this.m_dom == null) {
            return;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)baos, "UTF8"));
        }
        catch (UnsupportedEncodingException uee) {
            if (Debug.isLoggable(1)) {
                Debug.log("Unsupported Encoding", uee);
            }
            return;
        }
        try {
            String str = FwUtils.getDocStr((Document)this.m_dom);
            this.setRecordData(str.getBytes("utf8"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isValid() {
        return this.m_bIsValid;
    }

    public Document getDOM() {
        return this.m_dom;
    }
}

