/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.configManager;

import com.novell.nps.authentication.PortalConnection;
import com.novell.nps.authentication.PortalDirectoryException;
import com.novell.nps.configManager.ConfigData;
import com.novell.nps.configManager.ConfigManager;
import com.novell.nps.configManager.ConfigSettings;
import com.novell.nps.configManager.GadgetAssignment;
import com.novell.nps.configManager.ObjectConfig;
import com.novell.nps.configManager.ObjectConfigRecord;
import com.novell.nps.sessionManager.PortalSession;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Scheme
implements Cloneable,
Comparator,
Serializable {
    public static final String OBJECT_FDN = "Object FDN";
    public static final String PORTAL_TITLE = "Portal Title";
    public static final String BA_SCHEME_TYPE = "Scheme Type";
    public static final String SCHEME_TYPE_1_COL = "1 Column";
    public static final String SCHEME_TYPE_2_COL = "2 Column";
    public static final String SCHEME_TYPE_3_COL = "3 Column";
    public static final String SCHEME_TYPE_PAGED = "Paged";
    public static final String BRANDING_AREA_XSL_FILE = "Branding Area XSL File";
    public static final String SKIN_NAME = "Skin Name";
    public static final String DEFAULT_BRANDING_AREA_XSL_FILE = "default/main.xsl";
    public static final String DEFAULT_SKIN_NAME = "default";
    public static final String IA_SCHEME_TYPE = "Inherited Area Scheme Type";
    public static final String IA_DEFAULT_OBJECT_SCHEME = "Default Scheme";
    public static final String IA_POSITION = "Inherited Area Scheme Position";
    public static final String IA_POSITION_HEADER = "Header";
    public static final String IA_POSITION_COL1 = "Column 1";
    public static final String IA_POSITION_COL2 = "Column 2";
    public static final String IA_POSITION_COL3 = "Column 3";
    public static final String IA_POSITION_FOOTER = "Footer";
    public static final String IA_PRIORITY = "Inherited Area Priority";
    public static final String SCHEME_PRIORITY = "Scheme Priority";
    public static final String SCHEME_NAME = "Name";
    public static final String SCHEME_DESCRIPTION = "Description";
    public static final String SERVICE_NAME = "ServiceName";
    public static final String SCHEME_PATH = "Path";
    public static final String SCHEME_TYPE = "Scheme Type";
    public static final String USERS_CAN_ADD_GADGETS = "Users Can Add Gadgets";
    public static final String USERS_CAN_ADD_GADGETS_DEFAULT = "false";
    public static final String DEFAULT_GADGET_ASSIGNMENT = "Scheme Default Gadget Assignment";
    public static final String SCHEME_USER_FILTER_STRING = "User Filter String";
    public static final String SCHEME_ADMIN_FILTER_STRING = "Admin Filter String";
    protected String m_szFDN = null;
    protected String m_szSettingsFDN = null;
    protected Vector m_gadgetAssignments = null;
    protected ConfigData m_settings = null;
    protected ConfigData m_CustomConfigSettings = null;
    protected long m_schemeID = 0L;
    protected String m_objectID = null;
    protected String m_portalID = null;
    protected int m_schemeType = 0;
    protected boolean m_bUserAddedScheme = false;
    protected GadgetAssignment defaultGadgetAssignment = null;
    protected String defaultGadgetAssignmentName = null;
    protected boolean bReadDefaultGadgetAssignmentName = true;
    protected boolean bDefaultGadgetAssignmentNameUsed = false;

    public String getFDN() {
        return this.m_szFDN;
    }

    public String getSettingsFDN() {
        return this.m_szSettingsFDN;
    }

    public void setFDN(String szFDN) {
        this.m_szFDN = szFDN;
    }

    public void setSettingsFDN(String szFDN) {
        this.m_szSettingsFDN = szFDN;
    }

    public ConfigData getSettings() {
        return this.m_settings;
    }

    public void setSettings(ConfigData settings) {
        this.m_settings = settings;
    }

    public ConfigData getCustomConfigSettings() {
        return this.m_CustomConfigSettings;
    }

    public void setCustomConfigSettings(ConfigData customConfigsettings) {
        this.m_CustomConfigSettings = customConfigsettings;
    }

    public Vector getGadgetAssignments() {
        return this.m_gadgetAssignments;
    }

    public void setGadgetAssignments(Vector gadgetAssignments) {
        this.m_gadgetAssignments = gadgetAssignments;
    }

    public long getSchemeID() {
        return this.m_schemeID;
    }

    public void setSchemeID(long schemeID) {
        this.m_schemeID = schemeID;
    }

    public int getSchemeType() {
        return this.m_schemeType;
    }

    public void setSchemeType(int schemeType) {
        this.m_schemeType = schemeType;
    }

    public String getPortalID() {
        return this.m_portalID;
    }

    public void setPortalID(String portalID) {
        this.m_portalID = portalID;
    }

    public String getObjectID() {
        return this.m_objectID;
    }

    public void setObjectID(String objectID) {
        this.m_objectID = objectID;
    }

    public void setData(ObjectConfigRecord ocr) {
        Node GACustomConfigSettingNode;
        this.emptySchemeData();
        this.m_settings = new ConfigSettings(ocr);
        this.m_settings.readSettings();
        String sFDN = this.m_settings.getSingleSetting(OBJECT_FDN);
        if (sFDN != null) {
            this.m_szFDN = sFDN;
            this.m_szSettingsFDN = sFDN;
            this.m_settings.removeSetting(OBJECT_FDN);
        }
        Document dom = ocr.getDOM();
        StringBuffer sb = new StringBuffer(25);
        sb.append("config");
        sb.append("\\");
        sb.append("custom_config");
        Node customConfigNode = ocr.findFirstElement(sb.toString());
        if (customConfigNode != null && (GACustomConfigSettingNode = ocr.findFirstElement(customConfigNode, "setting")) != null) {
            this.readCustomConfigSettings(GACustomConfigSettingNode, 1);
        }
        this.readGadgetAssignments(ocr);
    }

    public void readSettings(Node tempNode, int iRecordType) {
        this.m_settings = new ConfigSettings();
        ((ConfigSettings)this.m_settings).readSettings(tempNode, iRecordType);
        String sFDN = this.m_settings.getSingleSetting(OBJECT_FDN);
        if (sFDN != null) {
            this.m_szFDN = sFDN;
            this.m_szSettingsFDN = sFDN;
            this.m_settings.removeSetting(OBJECT_FDN);
        }
    }

    public void readCustomConfigSettings(Node tempNode, int iRecordType) {
        if (tempNode != null) {
            this.m_CustomConfigSettings = new ConfigSettings();
            ((ConfigSettings)this.m_CustomConfigSettings).readSettings(tempNode, 1);
        }
    }

    public void readGadgetAssignments(ObjectConfigRecord ocr) {
        boolean bValidAssignment = false;
        StringBuffer sb = new StringBuffer(25);
        sb.append("config");
        sb.append("\\");
        sb.append("gadget_assignment");
        Node GANode = ocr.findFirstElement(sb.toString());
        Node GASettingNode = null;
        Node GACustomConfigNode = null;
        Node GACustomConfigSettingNode = null;
        GadgetAssignment tempGA = null;
        this.m_gadgetAssignments = new Vector();
        Object tempGCObject = null;
        while (GANode != null) {
            GASettingNode = ocr.findFirstElement(GANode, "setting");
            tempGA = new GadgetAssignment();
            tempGA.readSettings(GASettingNode);
            tempGA.setScheme(this);
            bValidAssignment = false;
            if (tempGA.getGadgetAssignmentID() == 0L) {
                bValidAssignment = false;
            } else if (tempGA.getGadgetDN() == null || tempGA.getGadgetID() == null) {
                String sInstanceClass = tempGA.getGadgetInstanceClass();
                bValidAssignment = sInstanceClass != null && sInstanceClass.length() != 0;
            } else {
                tempGA.setGadgetInstanceClass("");
                tempGA.setGadgetClass("");
                bValidAssignment = true;
            }
            if (bValidAssignment) {
                this.m_gadgetAssignments.addElement(tempGA);
                if (this.bReadDefaultGadgetAssignmentName) {
                    this.bReadDefaultGadgetAssignmentName = false;
                    this.defaultGadgetAssignmentName = this.m_settings.getSingleSetting(DEFAULT_GADGET_ASSIGNMENT);
                }
                if (!this.bDefaultGadgetAssignmentNameUsed) {
                    if (this.defaultGadgetAssignmentName != null && this.defaultGadgetAssignmentName.equalsIgnoreCase(tempGA.getAssignmentName())) {
                        this.defaultGadgetAssignment = tempGA;
                        this.bDefaultGadgetAssignmentNameUsed = true;
                    } else if (this.isDefaultGadget(tempGA)) {
                        this.defaultGadgetAssignment = tempGA;
                    }
                }
            }
            if ((GACustomConfigNode = ocr.findFirstElement(GANode, "custom_config")) != null && (GACustomConfigSettingNode = ocr.findFirstElement(GACustomConfigNode, "setting")) != null) {
                ConfigSettings GACustomAssignmentConfig = new ConfigSettings();
                GACustomAssignmentConfig.readSettings(GACustomConfigSettingNode, 1);
                tempGA.setCustomAssignmentConfig(GACustomAssignmentConfig);
            }
            GANode = ObjectConfigRecord.findNextElement(GANode);
        }
    }

    protected boolean isDefaultGadget(GadgetAssignment gadgetAssignment) {
        boolean isDefault = false;
        if (this.defaultGadgetAssignment == null) {
            isDefault = true;
        } else {
            int position = this.comparePosition(gadgetAssignment.getLocation());
            if (position < 0) {
                isDefault = true;
            } else if (position == 0) {
                int defPriority;
                int newPriority = Integer.parseInt(gadgetAssignment.getPriority());
                if (newPriority < (defPriority = Integer.parseInt(this.defaultGadgetAssignment.getPriority()))) {
                    isDefault = true;
                } else if (newPriority == defPriority && gadgetAssignment.getAssignmentName().compareTo(this.defaultGadgetAssignment.getAssignmentName()) < 0) {
                    isDefault = true;
                }
            }
        }
        return isDefault;
    }

    protected int comparePosition(String gadgetPosition) {
        int defaultPosition;
        if (gadgetPosition == null) {
            return 0;
        }
        if (this.defaultGadgetAssignment == null) {
            return -1;
        }
        int specifiedPosition = this.getPositionNumber(gadgetPosition);
        if (specifiedPosition < (defaultPosition = this.getPositionNumber(this.defaultGadgetAssignment.getLocation()))) {
            return -1;
        }
        if (specifiedPosition > defaultPosition) {
            return 1;
        }
        return 0;
    }

    protected int getPositionNumber(String gadgetPosition) {
        if (gadgetPosition.equalsIgnoreCase(IA_POSITION_HEADER)) {
            return 0;
        }
        if (gadgetPosition.equalsIgnoreCase(IA_POSITION_COL1)) {
            return 1;
        }
        if (gadgetPosition.equalsIgnoreCase(IA_POSITION_COL2)) {
            return 2;
        }
        if (gadgetPosition.equalsIgnoreCase(IA_POSITION_COL3)) {
            return 3;
        }
        return 4;
    }

    public void emptySchemeData() {
        this.m_szFDN = null;
        this.m_szSettingsFDN = null;
        this.m_gadgetAssignments = null;
        this.m_settings = null;
        this.m_CustomConfigSettings = null;
        this.m_schemeID = 0L;
        this.m_bUserAddedScheme = false;
    }

    public void writeUserRWSchemeSettings(PortalConnection pc, String sObject, int iType) throws PortalDirectoryException {
        ConfigSettings allcs = (ConfigSettings)this.m_settings;
        ConfigSettings cs = new ConfigSettings(allcs.getOCR());
        if (allcs.isSettingOverwriteable("Scheme Type")) {
            cs.setSetting("Scheme Type", allcs.getSetting("Scheme Type"));
        }
        if (iType == 2) {
            cs.setSetting(IA_DEFAULT_OBJECT_SCHEME, allcs.getSetting(IA_DEFAULT_OBJECT_SCHEME));
        }
        cs.setSetting(OBJECT_FDN, this.m_szSettingsFDN);
        ObjectConfigRecord ocr = new ObjectConfigRecord(cs);
        ocr.setGadgetID(0);
        ocr.setObjectGUID(this.m_objectID);
        ocr.setPCO(ConfigManager.getPCOID());
        ocr.setSchemeID((int)this.m_schemeID);
        ocr.setType(iType);
        Document dom = ocr.getDOM();
        if (this.m_gadgetAssignments != null && !this.m_gadgetAssignments.isEmpty()) {
            Enumeration e = this.m_gadgetAssignments.elements();
            ConfigSettings csAssign = null;
            while (e.hasMoreElements()) {
                GadgetAssignment tempGA = (GadgetAssignment)e.nextElement();
                if (!tempGA.isAssignmentOverwriteable()) continue;
                csAssign = (ConfigSettings)tempGA.getAssignmentProperties(ocr);
                csAssign.addSettingsToDOM();
            }
        }
        ocr.convertDOMtoXML();
        if (ocr.getSize() > 64512) {
            ResourceBundle res = ConfigManager.getResourceBundle();
            throw new PortalDirectoryException(res.getString("Too_much_content_on_page"));
        }
        ObjectConfig oc = new ObjectConfig(ConfigManager.getPCOID(), sObject, "bhConfigRW");
        oc.writeRecord(pc, ocr);
    }

    public void writeSchemeSettings(PortalConnection pc, String sPCOID, int iType) throws PortalDirectoryException {
        this.writeSchemeSettings(pc, this.m_szFDN, sPCOID, iType, "bhConfig");
    }

    public void writeSchemeSettings(PortalConnection pc, String sObject, String sPCOGuid, int iType, String sAttribute) throws PortalDirectoryException {
        ConfigSettings cs = (ConfigSettings)this.m_settings.copy();
        if (iType == 5) {
            cs.setSetting(OBJECT_FDN, this.m_szSettingsFDN);
        }
        ObjectConfigRecord ocr = new ObjectConfigRecord(cs);
        ocr.setGadgetID(0);
        ocr.setObjectGUID(this.m_objectID);
        ocr.setPCO(sPCOGuid);
        ocr.setSchemeID((int)this.m_schemeID);
        ocr.setType(iType);
        Document dom = ocr.getDOM();
        if ((!"bhConfigRW".equalsIgnoreCase(sAttribute) || "bhConfigRW".equalsIgnoreCase(sAttribute) && iType != 5) && this.m_CustomConfigSettings != null && !this.m_CustomConfigSettings.isEmpty()) {
            Node configNode = ocr.findFirstElement("config");
            Element eCustomPageConfigNode = dom.createElement("custom_config");
            configNode.appendChild(eCustomPageConfigNode);
            ((ConfigSettings)this.m_CustomConfigSettings).addSettingsToDOMAtNode(dom, eCustomPageConfigNode);
        }
        if (this.m_gadgetAssignments != null && !this.m_gadgetAssignments.isEmpty()) {
            Enumeration e = this.m_gadgetAssignments.elements();
            ConfigSettings csAssign = null;
            ConfigSettings csCustomAssignConfig = null;
            Node node = null;
            while (e.hasMoreElements()) {
                GadgetAssignment tempGA = (GadgetAssignment)e.nextElement();
                csAssign = (ConfigSettings)tempGA.getAssignmentProperties(ocr);
                node = csAssign.addSettingsToDOM();
                if (node == null || "bhConfigRW".equalsIgnoreCase(sAttribute) || (csCustomAssignConfig = (ConfigSettings)tempGA.getCustomAssignmentConfig()) == null || csCustomAssignConfig.isEmpty()) continue;
                Element eCustomAssignmentConfigNode = dom.createElement("custom_config");
                node.appendChild(eCustomAssignmentConfigNode);
                csCustomAssignConfig.addSettingsToDOMAtNode(dom, eCustomAssignmentConfigNode);
            }
        }
        ocr.convertDOMtoXML();
        if (ocr.getSize() > 64512) {
            ResourceBundle res = ConfigManager.getResourceBundle();
            throw new PortalDirectoryException(res.getString("Too_much_content_on_page"));
        }
        ObjectConfig oc = new ObjectConfig(sPCOGuid, sObject, sAttribute);
        oc.writeRecord(pc, ocr);
    }

    public Scheme copy() {
        Scheme newScheme = new Scheme();
        if (this.m_szFDN != null) {
            newScheme.setFDN(this.m_szFDN);
        }
        if (this.m_szSettingsFDN != null) {
            newScheme.setSettingsFDN(this.m_szSettingsFDN);
        }
        if (this.m_objectID != null) {
            newScheme.setObjectID(this.m_objectID);
        }
        newScheme.setSchemeID(this.m_schemeID);
        newScheme.setSchemeType(this.m_schemeType);
        newScheme.setPortalID(this.m_portalID);
        if (this.m_settings != null) {
            newScheme.setSettings(this.m_settings.copy());
        }
        if (this.m_CustomConfigSettings != null) {
            newScheme.setCustomConfigSettings(this.m_CustomConfigSettings.copy());
        }
        if (this.m_gadgetAssignments != null) {
            GadgetAssignment oldGA = null;
            GadgetAssignment newGA = null;
            Enumeration e = this.m_gadgetAssignments.elements();
            Vector<GadgetAssignment> newGAList = new Vector<GadgetAssignment>();
            while (e.hasMoreElements()) {
                oldGA = (GadgetAssignment)e.nextElement();
                newGA = oldGA.copy();
                newGA.setScheme(newScheme);
                newGAList.addElement(newGA);
            }
            newScheme.setGadgetAssignments(newGAList);
        }
        newScheme.setUserAddedScheme(this.m_bUserAddedScheme);
        return newScheme;
    }

    protected Object clone() throws CloneNotSupportedException {
        return this.copy();
    }

    public GadgetAssignment getDefaultGadgetAssignment() {
        return this.defaultGadgetAssignment;
    }

    public String getName() {
        String sName = null;
        if (this.m_settings != null) {
            sName = this.m_settings.getSingleSetting(SCHEME_NAME);
        }
        return sName;
    }

    public String getName(PortalSession session) {
        String sName = null;
        if (this.m_settings != null) {
            sName = this.m_settings.getSingleSettingDisplayValue(SCHEME_NAME, session);
        }
        return sName;
    }

    public String getDescription() {
        String sDescription = null;
        if (this.m_settings != null) {
            sDescription = this.m_settings.getSingleSetting(SCHEME_DESCRIPTION);
        }
        return sDescription;
    }

    public String getDescription(PortalSession session) {
        String sDescription = null;
        if (this.m_settings != null) {
            sDescription = this.m_settings.getSingleSettingDisplayValue(SCHEME_DESCRIPTION, session);
        }
        return sDescription;
    }

    public String getServiceName() {
        String sName = null;
        if (this.m_settings != null && ((sName = this.m_settings.getSingleSetting(SERVICE_NAME)) == null || sName.length() == 0)) {
            return this.getUniqueID();
        }
        return sName;
    }

    public String getPriority() {
        String sPriority = null;
        if (this.m_settings != null) {
            sPriority = this.m_settings.getSingleSetting(SCHEME_PRIORITY, "0");
        }
        return sPriority;
    }

    public String getUniqueID() {
        if (this.getObjectID() == null || this.getObjectID().length() == 0) {
            return null;
        }
        String sID = null;
        StringBuffer sb = new StringBuffer(60);
        sb.append(this.getObjectID());
        sb.append(":");
        sb.append(this.getSchemeID());
        sID = sb.toString();
        return sID;
    }

    public String getUserFilterString() {
        String sName = null;
        if (this.m_settings != null) {
            sName = this.m_settings.getSingleSetting(SCHEME_USER_FILTER_STRING);
        }
        return sName;
    }

    public void setUserFilterString(String sUserFilterString) {
        if (this.m_settings == null) {
            this.m_settings = new ConfigSettings();
        }
        if (sUserFilterString != null && sUserFilterString.length() != 0) {
            this.m_settings.setSetting(SCHEME_USER_FILTER_STRING, sUserFilterString);
        } else {
            this.m_settings.removeSetting(SCHEME_USER_FILTER_STRING);
        }
    }

    public String getAdminFilterString() {
        String sName = null;
        if (this.m_settings != null) {
            sName = this.m_settings.getSingleSetting(SCHEME_ADMIN_FILTER_STRING);
        }
        return sName;
    }

    public void setAdminFilterString(String sAdminFilterString) {
        if (this.m_settings == null) {
            this.m_settings = new ConfigSettings();
        }
        if (sAdminFilterString != null && sAdminFilterString.length() != 0) {
            this.m_settings.setSetting(SCHEME_ADMIN_FILTER_STRING, sAdminFilterString);
        } else {
            this.m_settings.removeSetting(SCHEME_ADMIN_FILTER_STRING);
        }
    }

    public int compare(Object o1, Object o2) {
        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        Scheme tempScheme = (Scheme)obj;
        return this.getUniqueID().equalsIgnoreCase(tempScheme.getUniqueID());
    }

    public void setUserAddedScheme(boolean bUserAddedScheme) {
        this.m_bUserAddedScheme = bUserAddedScheme;
    }
}

