/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.configManager;

import com.novell.nps.configManager.SettingValue;
import com.novell.nps.serviceProviders.NPSMacroParser;
import com.novell.nps.sessionManager.PortalSession;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Setting
implements Comparator,
Cloneable,
Serializable {
    public static final int TYPE_STRING = 0;
    public static final int TYPE_STRING_PASSWORD = 1;
    public static final int TYPE_INT = 2;
    public static final int TYPE_BOOLEAN = 3;
    public static final int TYPE_ON_OFF = 4;
    public static final int TYPE_SELECT = 5;
    public static final int TYPE_WIZARD = 6;
    public static final int TYPE_ESCAPED_STRING = 7;
    public static final int TYPE_ESCAPED_STRING_PASSWORD = 8;
    public static final int TYPE_MULTIPLE_LINE_STRING = 9;
    public static final int NO_ORDER = Integer.MAX_VALUE;
    public static final String NAME = "name";
    public static final String DISPLAY_NAME = "displayname";
    public static final String VALUE = "value";
    public static final String DISPLAY_VALUE = "displayvalue";
    public static final String DISPLAY_LANGUAGE = "language";
    public static final String ACTUAL_VALUE = "actualvalue";
    public static final String OVERWRITEABLE = "overwriteable";
    public static final String CUMULATIVE = "cumulative";
    public static final String DESCRIPTION = "description";
    public static final String RANGE_DESCRIPTION = "rangedescription";
    public static final String MINIMUM_RANGE = "minimumrange";
    public static final String MAXIMUM_RANGE = "maximumrange";
    public static final String TYPE = "type";
    public static final String AVAILABLE_VALUE = "availablevalue";
    public static final String ALLOW_MULTIPLE_VALUES = "allowmultiplevalues";
    public static final String ORDER = "order";
    public static final String ADVANCED = "advanced";
    public static final String BASIC = "basic";
    public static final String REQUIRED = "required";
    public static final String USER_CONFIGURABLE = "userconfigurable";
    public static final String ADMIN_CONFIGURABLE = "adminconfigurable";
    public static final String HIDE_FROM_USER = "hidefromuser";
    public static final String HIDE_FROM_ADMIN = "hidefromadmin";
    public static final String PARSE_MACROS = "parsemacros";
    public static final String TRANSLATABLE_VALUES = "translatablevalues";
    public static final String USER_CHANGED = "userchanged";
    public static final String DISPLAY_NAME_KEY = "display-name-key";
    public static final String RESOURCE_PROPERTIES_FILE = "resource-properties-file";
    public static final boolean OVERWRITEABLE_DEFAULT = true;
    public static final boolean CUMULATIVE_DEFAULT = false;
    public static final boolean MULTIPLE_VALUES_DEFAULT = true;
    public static final boolean ADVANCED_DEFAULT = false;
    public static final boolean REQUIRED_DEFAULT = false;
    public static final boolean USER_CONFIGURABLE_DEFAULT = true;
    public static final boolean ADMIN_CONFIGURABLE_DEFAULT = true;
    public static final boolean USER_CHANGED_DEFAULT = false;
    public static final boolean HIDE_FROM_USER_DEFAULT = false;
    public static final boolean HIDE_FROM_ADMIN_DEFAULT = false;
    public static final boolean PARSE_MACROS_DEFAULT = true;
    public static final boolean TRANSLATABLE_VALUES_DEFAULT = false;
    private String m_szName = null;
    private String m_szDisplayName = null;
    private Vector m_values = null;
    private boolean m_bOverwriteable = true;
    private boolean m_bCumulative = false;
    private boolean m_bAllowMultipleValues = true;
    private String m_szRangeDescription = null;
    private int m_maxrange = 0;
    private int m_minrange = 0;
    private String m_szDescription = null;
    private int m_type = 0;
    private Vector m_availableValues = null;
    private int m_order = Integer.MAX_VALUE;
    private boolean m_bAdvanced = false;
    private boolean m_bRequired = false;
    private boolean m_bUserConfigurable = true;
    private boolean m_bAdminConfigurable = true;
    private boolean m_bUserChanged = false;
    private boolean m_bHideFromUser = false;
    private boolean m_bHideFromAdmin = false;
    private boolean m_bParseMacros = true;
    private boolean m_bTranslatableValues = false;

    public int compare(Object o1, Object o2) {
        Setting so1 = (Setting)o1;
        Setting so2 = (Setting)o2;
        if (so1.getOrder() < so2.getOrder()) {
            return -1;
        }
        if (so1.getOrder() == so2.getOrder()) {
            return 0;
        }
        return 1;
    }

    @Override
    public boolean equals(Object obj) {
        return false;
    }

    public String getName() {
        return this.m_szName;
    }

    public void setName(String szName) {
        this.m_szName = szName;
    }

    public String getDisplayName() {
        return this.m_szDisplayName;
    }

    public void setDisplayName(String szDisplayName) {
        this.m_szDisplayName = szDisplayName;
    }

    public Vector getValues() {
        return this.m_values;
    }

    public void setValues(Vector values) {
        if (values == null) {
            this.m_values = values;
            return;
        }
        Hashtable<String, SettingValue> ht = new Hashtable<String, SettingValue>();
        Vector<SettingValue> vNoDuplicates = new Vector<SettingValue>();
        Enumeration e = values.elements();
        SettingValue tempSV = null;
        while (e.hasMoreElements()) {
            tempSV = (SettingValue)e.nextElement();
            if (tempSV.getValue() == null || ht.get(tempSV.getValue()) != null) continue;
            vNoDuplicates.add(tempSV);
            ht.put(tempSV.getValue(), tempSV);
        }
        this.m_values = vNoDuplicates;
    }

    public SettingValue getSettingValue(String sValue) {
        SettingValue tempSV = null;
        if (sValue == null || sValue.length() == 0) {
            return null;
        }
        if (this.m_values == null || this.m_values.isEmpty()) {
            return null;
        }
        Enumeration e = this.m_values.elements();
        while (e.hasMoreElements()) {
            tempSV = (SettingValue)e.nextElement();
            if (!sValue.equals(tempSV.getValue())) continue;
            return tempSV;
        }
        return null;
    }

    public boolean getOverwriteable() {
        return this.m_bOverwriteable;
    }

    public void setOverwriteable(boolean bOverwriteable) {
        this.m_bOverwriteable = bOverwriteable;
    }

    public boolean getCumulative() {
        return this.m_bCumulative;
    }

    public void setCumulative(boolean bCumulative) {
        this.m_bCumulative = bCumulative;
    }

    public boolean getAllowMultipleValues() {
        return this.m_bAllowMultipleValues;
    }

    public void setAllowMultipleValues(boolean bAllowMultipleValues) {
        this.m_bAllowMultipleValues = bAllowMultipleValues;
    }

    public int getMaximumRange() {
        return this.m_maxrange;
    }

    public void setMaximumRange(int maxrange) {
        this.m_maxrange = maxrange;
    }

    public int getMinimumRange() {
        return this.m_minrange;
    }

    public void setMinimumRange(int minrange) {
        this.m_minrange = minrange;
    }

    public String getRangeDescription() {
        return this.m_szRangeDescription;
    }

    public void setRangeDescription(String szRangeDescription) {
        this.m_szRangeDescription = szRangeDescription;
    }

    public String getDescription() {
        return this.m_szDescription;
    }

    public void setDescription(String szDescription) {
        this.m_szDescription = szDescription;
    }

    public int getType() {
        return this.m_type;
    }

    public void setType(int type) {
        this.m_type = type;
    }

    public Vector getAvailableValues() {
        return this.m_availableValues;
    }

    public void setAvailableValues(Vector availableValues) {
        this.m_availableValues = availableValues;
    }

    public int getOrder() {
        return this.m_order;
    }

    public void setOrder(int order) {
        this.m_order = order;
    }

    public boolean getAdvanced() {
        return this.m_bAdvanced;
    }

    public void setAdvanced(boolean bAdvanced) {
        this.m_bAdvanced = bAdvanced;
    }

    public boolean getRequired() {
        return this.m_bRequired;
    }

    public void setRequired(boolean bRequired) {
        this.m_bRequired = bRequired;
    }

    public boolean getUserConfigurable() {
        return this.m_bUserConfigurable;
    }

    public void setUserConfigurable(boolean bUserConfigurable) {
        this.m_bUserConfigurable = bUserConfigurable;
    }

    public boolean getAdminConfigurable() {
        return this.m_bAdminConfigurable;
    }

    public void setAdminConfigurable(boolean bAdminConfigurable) {
        this.m_bAdminConfigurable = bAdminConfigurable;
    }

    public void setUserChanged(boolean bUserChanged) {
        this.m_bUserChanged = bUserChanged;
    }

    public boolean getHideFromUser() {
        return this.m_bHideFromUser;
    }

    public void setHideFromUser(boolean bHideFromUser) {
        this.m_bHideFromUser = bHideFromUser;
    }

    public boolean getHideFromAdmin() {
        return this.m_bHideFromAdmin;
    }

    public void setHideFromAdmin(boolean bHideFromAdmin) {
        this.m_bHideFromAdmin = bHideFromAdmin;
    }

    public boolean getUserChanged() {
        return this.m_bUserChanged;
    }

    public void setFromParent(boolean bInherited) {
        SettingValue tempSV = null;
        if (this.m_values != null && !this.m_values.isEmpty()) {
            Enumeration e = this.m_values.elements();
            while (e.hasMoreElements()) {
                tempSV = (SettingValue)e.nextElement();
                tempSV.setInheritedFromParent(bInherited);
            }
        }
    }

    public boolean getParseMacros() {
        return this.m_bParseMacros;
    }

    public void setParseMacros(boolean bParseMacros) {
        this.m_bParseMacros = bParseMacros;
    }

    public boolean getTranslatableValues() {
        return this.m_bTranslatableValues;
    }

    public void setTranslatableValues(boolean bTranslatableValues) {
        this.m_bTranslatableValues = bTranslatableValues;
    }

    public void empty() {
        this.m_szName = null;
        this.m_szDisplayName = null;
        this.m_values = null;
        this.m_bOverwriteable = true;
        this.m_bCumulative = false;
        this.m_bAllowMultipleValues = true;
        this.m_szRangeDescription = null;
        this.m_maxrange = 0;
        this.m_minrange = 0;
        this.m_szDescription = null;
        this.m_type = 0;
        this.m_order = Integer.MAX_VALUE;
        this.m_bAdvanced = false;
        this.m_bRequired = false;
        this.m_bUserConfigurable = true;
        this.m_bAdminConfigurable = true;
        this.m_bUserChanged = false;
        this.m_bHideFromUser = false;
        this.m_bHideFromAdmin = false;
        this.m_bParseMacros = true;
        this.m_bTranslatableValues = false;
    }

    public Setting copy() {
        Enumeration e;
        Setting newSetting = new Setting();
        newSetting.setAllowMultipleValues(this.m_bAllowMultipleValues);
        if (this.m_availableValues != null) {
            SettingValue oldAvailSV = null;
            SettingValue newAvailSV = null;
            e = this.m_availableValues.elements();
            Vector<SettingValue> newAvailSVList = new Vector<SettingValue>();
            while (e.hasMoreElements()) {
                oldAvailSV = (SettingValue)e.nextElement();
                newAvailSV = oldAvailSV.copy();
                newAvailSVList.addElement(newAvailSV);
            }
            newSetting.setAvailableValues(newAvailSVList);
        }
        newSetting.setCumulative(this.m_bCumulative);
        if (this.m_szDescription != null) {
            newSetting.setDescription(this.m_szDescription);
        }
        newSetting.setMaximumRange(this.m_maxrange);
        newSetting.setMinimumRange(this.m_minrange);
        if (this.m_szName != null) {
            newSetting.setName(this.m_szName);
        }
        if (this.m_szDisplayName != null) {
            newSetting.setDisplayName(this.m_szDisplayName);
        }
        newSetting.setOverwriteable(this.m_bOverwriteable);
        if (this.m_szRangeDescription != null) {
            newSetting.setRangeDescription(this.m_szRangeDescription);
        }
        newSetting.setType(this.m_type);
        if (this.m_values != null) {
            SettingValue oldSV = null;
            SettingValue newSV = null;
            e = this.m_values.elements();
            Vector<SettingValue> newSVList = new Vector<SettingValue>();
            while (e.hasMoreElements()) {
                oldSV = (SettingValue)e.nextElement();
                newSV = oldSV.copy();
                newSVList.addElement(newSV);
            }
            newSetting.setValues(newSVList);
        }
        newSetting.setOrder(this.m_order);
        newSetting.setAdvanced(this.m_bAdvanced);
        newSetting.setRequired(this.m_bRequired);
        newSetting.setUserConfigurable(this.m_bUserConfigurable);
        newSetting.setAdminConfigurable(this.m_bAdminConfigurable);
        newSetting.setUserChanged(this.m_bUserChanged);
        newSetting.setHideFromUser(this.m_bHideFromUser);
        newSetting.setHideFromAdmin(this.m_bHideFromAdmin);
        newSetting.setParseMacros(this.m_bParseMacros);
        newSetting.setTranslatableValues(this.m_bTranslatableValues);
        return newSetting;
    }

    protected Object clone() throws CloneNotSupportedException {
        return this.copy();
    }

    public void parsePortalMacros(PortalSession session) {
        if (!this.m_bParseMacros) {
            return;
        }
        if (this.m_type == 3 || this.m_type == 2 || this.m_type == 4) {
            return;
        }
        if (this.m_values != null && this.m_values.size() != 0) {
            SettingValue tempSV = null;
            String tempStr = null;
            Enumeration esv = this.m_values.elements();
            while (esv.hasMoreElements()) {
                tempSV = (SettingValue)esv.nextElement();
                tempStr = tempSV.getValue();
                if (tempStr == null || tempStr.length() == 0 || tempStr.startsWith("ACED00057372")) continue;
                tempSV.setValue(NPSMacroParser.parseMacroString(tempStr, session, true));
            }
        }
    }

    public void removeSettingValue(String sValue) {
        if (sValue == null || sValue.length() == 0) {
            return;
        }
        if (this.m_values == null || this.m_values.isEmpty()) {
            return;
        }
        SettingValue tempSV = this.getSettingValue(sValue);
        if (tempSV != null) {
            this.m_values.remove(tempSV);
        }
    }

    public String getSettingValueDisplayValue(String value, PortalSession session) {
        String sDisplayValue = value;
        String sTemp = null;
        SettingValue tempSV = null;
        if (this.m_values == null || this.m_values.isEmpty() || value == null || value.length() == 0) {
            return sDisplayValue;
        }
        Enumeration e = this.m_values.elements();
        while (e.hasMoreElements()) {
            tempSV = (SettingValue)e.nextElement();
            sTemp = tempSV.getValue();
            if (sTemp == null || sTemp.length() == 0 || !sTemp.equalsIgnoreCase(value)) continue;
            sDisplayValue = tempSV.getDisplayValue(session);
        }
        return sDisplayValue;
    }
}

