/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.debug;

import com.novell.nps.event.DefaultPortalEventImpl;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DebugLogEvent
extends DefaultPortalEventImpl {
    protected int debugLevel = 2;
    protected String sourceTag = "Unknown";
    protected String debugMessage = null;
    protected Throwable exception = null;
    public static final String XML_TAG = "DebugLogEvent";

    public DebugLogEvent(int debugLevel, String sourceTag, String debugMessage, Throwable exception) {
        this.setDebugLevel(debugLevel);
        this.setSourceTag(sourceTag);
        this.setDebugMessage(debugMessage);
        this.setException(exception);
    }

    public void setDebugLevel(int debugLevel) {
        this.debugLevel = debugLevel;
    }

    public void setSourceTag(String sourceTag) {
        if (sourceTag != null) {
            this.sourceTag = sourceTag;
        }
    }

    public void setDebugMessage(String debugMessage) {
        if (debugMessage != null) {
            this.debugMessage = debugMessage;
        }
    }

    public void setException(Throwable exception) {
        if (exception != null) {
            this.exception = exception;
        }
    }

    public int getDebugLevel() {
        return this.debugLevel;
    }

    public String getSourceTag() {
        return this.sourceTag;
    }

    public String getTimeTag() {
        Date dt = new Date(this.getTimeStamp());
        SimpleDateFormat df = new SimpleDateFormat("MM/dd/yy [HH:mm:ss.SSS]  ");
        return df.format(dt);
    }

    public String getDebugMessage() {
        return this.debugMessage;
    }

    public Throwable getException() {
        return this.exception;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.debugMessage != null) {
            sb.append(this.debugMessage);
        }
        if (this.exception != null) {
            sb.append(this.exception.getLocalizedMessage());
        }
        return sb.toString();
    }

    public String toXML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<");
        sb.append(XML_TAG);
        sb.append(">");
        sb.append(" sourceTag=\"");
        sb.append(this.sourceTag);
        sb.append("\"><![CDATA[");
        sb.append(this.toString());
        sb.append("]]>");
        sb.append("</");
        sb.append(XML_TAG);
        sb.append(">");
        return sb.toString();
    }
}

