/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.file;

import com.novell.nps.debug.Debug;
import com.novell.nps.file.CIFSFileInputStream;
import com.novell.nps.file.CIFSFileOutputStream;
import com.novell.nps.file.NPSFileResource;
import com.novell.nps.file.NPSFileResourceInputStream;
import com.novell.nps.file.NPSFileResourceOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;

public class CIFSFileResource
implements NPSFileResource {
    static final String DT = "CIFSFileResource";
    static final char separatorChar = '/';
    static final String separator = "/";
    SmbFile m_smbFile;
    String m_path;
    String m_resourceBase;
    String m_parent;
    String m_child;

    public CIFSFileResource(String resourceBase, String parent, String child, boolean makeDirs) {
        try {
            SmbFile base = new SmbFile(resourceBase);
            if (makeDirs && !base.exists()) {
                base.mkdir();
            }
            this.m_smbFile = new SmbFile(resourceBase + parent + child);
            this.m_resourceBase = resourceBase;
            if (parent != null) {
                this.m_parent = parent;
            } else {
                parent = separator;
            }
            if (child == null) {
                throw new NullPointerException();
            }
            this.m_child = child;
            this.m_path = parent + separator + child;
        }
        catch (Exception ex) {
            Debug.log(DT, ex);
        }
    }

    public CIFSFileResource(String resourceBase, String path, boolean makeDirs) {
        try {
            SmbFile base = new SmbFile(resourceBase);
            if (makeDirs && !base.exists()) {
                base.mkdir();
            }
            this.m_smbFile = path != null ? new SmbFile(base, path.substring(1)) : base;
            this.m_resourceBase = resourceBase;
            this.m_path = path != null ? path : separator;
            int index = path.lastIndexOf(47);
            this.m_parent = path.substring(0, index);
            this.m_child = this.m_smbFile.getName();
        }
        catch (Exception ex) {
            Debug.log(DT, ex);
        }
    }

    public CIFSFileResource(CIFSFileResource parent, String child) {
        try {
            this.m_smbFile = new SmbFile(parent.getSmbFile(), child);
            this.m_resourceBase = parent.getResourceBase();
            this.m_parent = parent.getPath();
            this.m_child = child;
            this.m_path = this.m_parent + separator + this.m_child;
        }
        catch (IOException ex) {
            Debug.log(DT, ex);
        }
    }

    public SmbFile getSmbFile() {
        return this.m_smbFile;
    }

    @Override
    public NPSFileResource getChildResource(String path) {
        CIFSFileResource newResource = new CIFSFileResource(this, path);
        return newResource;
    }

    @Override
    public String getName() {
        return this.m_smbFile.getName();
    }

    @Override
    public String getParent() {
        return this.m_parent;
    }

    @Override
    public String getPath() {
        return this.m_path;
    }

    @Override
    public String getCanonicalPath() {
        return this.m_smbFile.getCanonicalPath();
    }

    @Override
    public boolean exists() {
        try {
            return this.m_smbFile.exists();
        }
        catch (SmbException smbe) {
            return false;
        }
    }

    @Override
    public boolean canRead() {
        try {
            return this.m_smbFile.canRead();
        }
        catch (SmbException smbe) {
            return false;
        }
    }

    @Override
    public boolean canWrite() {
        try {
            return this.m_smbFile.canWrite();
        }
        catch (SmbException smbe) {
            return false;
        }
    }

    @Override
    public boolean isDirectory() {
        try {
            return this.m_smbFile.isDirectory();
        }
        catch (SmbException smbe) {
            this.log(smbe);
            return false;
        }
    }

    @Override
    public boolean isFile() {
        try {
            return this.m_smbFile.isFile();
        }
        catch (SmbException smbe) {
            this.log(smbe);
            return false;
        }
    }

    @Override
    public boolean isHidden() {
        try {
            return this.m_smbFile.isHidden();
        }
        catch (SmbException smbe) {
            this.log(smbe);
            return false;
        }
    }

    @Override
    public long lastModified() {
        try {
            return this.m_smbFile.lastModified();
        }
        catch (SmbException smbe) {
            this.log(smbe);
            return 0L;
        }
    }

    @Override
    public String[] list() {
        try {
            return this.m_smbFile.list();
        }
        catch (SmbException smbe) {
            return null;
        }
    }

    @Override
    public boolean renameTo(NPSFileResource dest) {
        if (dest instanceof CIFSFileResource) {
            SmbFile file = ((CIFSFileResource)dest).getSmbFile();
            try {
                this.m_smbFile.renameTo(file);
                return true;
            }
            catch (SmbException smbe) {
                this.log(smbe);
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean delete() {
        try {
            if (this.m_smbFile.isDirectory()) {
                try {
                    SmbFile[] files = this.m_smbFile.listFiles();
                    if (files != null && files.length > 0) {
                        return false;
                    }
                }
                catch (SmbException smbe) {
                    this.log(smbe);
                    return false;
                }
            }
            this.m_smbFile.delete();
            return true;
        }
        catch (SmbException smbe) {
            this.log(smbe);
            return false;
        }
    }

    @Override
    public long length() {
        try {
            return this.m_smbFile.length();
        }
        catch (SmbException smbe) {
            this.log(smbe);
            return 0L;
        }
    }

    @Override
    public boolean mkdir() {
        try {
            this.m_smbFile.mkdir();
            return true;
        }
        catch (SmbException smbe) {
            this.log(smbe);
            return false;
        }
    }

    @Override
    public boolean mkdirs() {
        if (this.exists()) {
            return false;
        }
        if (this.mkdir()) {
            return true;
        }
        String parent = this.getParent();
        return parent != null && new CIFSFileResource(this.getResourceBase(), this.getParent(), true).mkdirs() && this.mkdir();
    }

    public String getResourceBase() {
        return this.m_resourceBase;
    }

    @Override
    public URL toURL() throws MalformedURLException {
        return this.m_smbFile.toURL();
    }

    @Override
    public int hashCode() {
        return this.m_smbFile.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return this.m_smbFile.equals(obj);
    }

    @Override
    public String toString() {
        return this.m_smbFile.toString();
    }

    @Override
    public NPSFileResourceInputStream getInputStream() throws IOException {
        return new CIFSFileInputStream(this);
    }

    @Override
    public NPSFileResourceOutputStream getOutputStream() throws IOException {
        return new CIFSFileOutputStream(this);
    }

    @Override
    public NPSFileResourceOutputStream getOutputStream(boolean append) throws IOException {
        return new CIFSFileOutputStream(this, append);
    }

    private String getSmbURL() {
        StringBuffer buff = new StringBuffer();
        buff.append("smb:\\");
        return buff.toString();
    }

    private void log(SmbException smbe) {
        if (Debug.isLoggable(3)) {
            Debug.log(DT, 3, (Exception)((Object)smbe));
        }
    }
}

