/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.file;

import com.novell.nps.debug.Debug;
import com.novell.nps.file.LocalFileInputStream;
import com.novell.nps.file.LocalFileOutputStream;
import com.novell.nps.file.NPSFileResource;
import com.novell.nps.file.NPSFileResourceInputStream;
import com.novell.nps.file.NPSFileResourceOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class LocalFileResource
implements NPSFileResource {
    static final String DT = "LocalFileResource";
    static final char separatorChar = '/';
    static final String separator = "/";
    File m_file;
    String m_path;
    String m_resourceBase;
    String m_parent;
    String m_child;

    public LocalFileResource(String resourceBase, String parent, String child, boolean makeDirs) {
        try {
            File base = new File(resourceBase);
            if (makeDirs) {
                base.mkdirs();
            }
            this.m_file = new File(resourceBase + parent + child);
            this.m_resourceBase = resourceBase;
            if (parent != null) {
                this.m_parent = parent;
            } else {
                parent = separator;
            }
            if (child == null) {
                throw new NullPointerException();
            }
            this.m_child = child;
            this.m_path = parent + separator + child;
        }
        catch (Exception ex) {
            Debug.log(DT, ex);
        }
    }

    public LocalFileResource(String resourceBase, String path, boolean makeDirs) {
        try {
            File base = new File(resourceBase);
            if (makeDirs) {
                base.mkdirs();
            }
            this.m_file = path != null && path.length() > 1 ? new File(base, path.substring(1)) : base;
            this.m_resourceBase = resourceBase;
            this.m_path = path != null ? path : separator;
            int index = path.lastIndexOf(47);
            this.m_parent = path.substring(0, index);
            this.m_child = this.m_file.getName();
        }
        catch (Exception ex) {
            Debug.log(DT, ex);
        }
    }

    public LocalFileResource(LocalFileResource parent, String child) {
        this.m_file = new File(parent.getFile(), child);
        this.m_resourceBase = parent.getResourceBase();
        this.m_parent = parent.getPath();
        this.m_child = child;
        this.m_path = this.m_parent + separator + this.m_child;
    }

    public File getFile() {
        return this.m_file;
    }

    @Override
    public NPSFileResource getChildResource(String path) {
        return new LocalFileResource(this, path);
    }

    @Override
    public String getName() {
        return this.m_file.getName();
    }

    @Override
    public String getParent() {
        return this.m_parent;
    }

    @Override
    public String getPath() {
        return this.m_path;
    }

    @Override
    public String getCanonicalPath() {
        try {
            return this.m_file.getCanonicalPath();
        }
        catch (IOException e) {
            Debug.log(DT, e);
            return null;
        }
    }

    @Override
    public boolean exists() {
        return this.m_file.exists();
    }

    @Override
    public boolean canRead() {
        return this.m_file.canRead();
    }

    @Override
    public boolean canWrite() {
        return this.m_file.canWrite();
    }

    @Override
    public boolean isDirectory() {
        return this.m_file.isDirectory();
    }

    @Override
    public boolean isFile() {
        return this.m_file.isFile();
    }

    @Override
    public boolean isHidden() {
        return this.m_file.isHidden();
    }

    @Override
    public long lastModified() {
        return this.m_file.lastModified();
    }

    @Override
    public String[] list() {
        return this.m_file.list();
    }

    @Override
    public boolean renameTo(NPSFileResource dest) {
        if (dest instanceof LocalFileResource) {
            File destFile = ((LocalFileResource)dest).getFile();
            return this.m_file.renameTo(destFile);
        }
        return false;
    }

    @Override
    public boolean delete() {
        return this.m_file.delete();
    }

    @Override
    public long length() {
        return this.m_file.length();
    }

    @Override
    public boolean mkdir() {
        return this.m_file.mkdir();
    }

    @Override
    public boolean mkdirs() {
        return this.m_file.mkdirs();
    }

    public String getResourceBase() {
        return this.m_resourceBase;
    }

    @Override
    public URL toURL() throws MalformedURLException {
        return this.m_file.toURL();
    }

    @Override
    public int hashCode() {
        return this.m_file.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return this.m_file.equals(obj);
    }

    @Override
    public String toString() {
        return this.m_file.toString();
    }

    @Override
    public NPSFileResourceInputStream getInputStream() throws IOException {
        return new LocalFileInputStream(this);
    }

    @Override
    public NPSFileResourceOutputStream getOutputStream() throws IOException {
        return new LocalFileOutputStream(this);
    }

    @Override
    public NPSFileResourceOutputStream getOutputStream(boolean append) throws IOException {
        return new LocalFileOutputStream(this, append);
    }
}

