/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.file;

import com.novell.nps.file.NPSFileManager;
import com.novell.nps.file.NPSFileResource;
import com.novell.nps.gadgetManager.GadgetInstance;
import java.net.MalformedURLException;
import java.net.URL;

public class NPSFile {
    NPSFileResource resource;
    GadgetInstance gadget;
    String path;

    public NPSFile(String username, String password, String parent, String child) {
        this.resource = NPSFileManager.getNPSFileResource(username, password, parent, child);
        this.path = parent + "/" + child;
    }

    public NPSFile(String username, String password, String pathname) {
        this.resource = NPSFileManager.getNPSFileResource(username, password, pathname);
        this.path = pathname;
    }

    public NPSFile(NPSFile npsCmFile, String pathname) {
        this.resource = npsCmFile.getResource().getChildResource(pathname);
        this.gadget = npsCmFile.getGadget();
        this.path = this.resource.getPath();
    }

    public NPSFile(GadgetInstance cmGadget, String parent, String child) {
        this.gadget = cmGadget;
        this.resource = NPSFileManager.getNPSFileResource(this.gadget);
        this.path = this.resource.getPath();
    }

    public String getName() {
        return this.resource.getName();
    }

    public String getParent() {
        return this.resource.getParent();
    }

    public String getPath() {
        return this.resource.getPath();
    }

    public String getCanonicalPath() {
        return this.resource.getCanonicalPath();
    }

    public boolean exists() {
        return this.resource.exists();
    }

    public boolean canRead() {
        return this.resource.canRead();
    }

    public boolean canWrite() {
        return this.resource.canWrite();
    }

    public boolean isDirectory() {
        return this.resource.isDirectory();
    }

    public boolean isFile() {
        return this.resource.isFile();
    }

    public boolean isHidden() {
        return this.resource.isHidden();
    }

    public long lastModified() {
        return this.resource.lastModified();
    }

    public String[] list() {
        return this.resource.list();
    }

    public NPSFile[] listFiles() {
        String[] fileNames = this.list();
        if (fileNames != null) {
            NPSFile[] files = new NPSFile[fileNames.length];
            for (int i = 0; i < fileNames.length; ++i) {
                files[i] = new NPSFile(this, fileNames[i]);
            }
            return files;
        }
        return null;
    }

    public boolean renameTo(NPSFile dest) {
        return this.resource.renameTo(dest.getResource());
    }

    public boolean delete() {
        return this.resource.delete();
    }

    public long length() {
        return this.resource.length();
    }

    public boolean mkdir() {
        return this.resource.mkdir();
    }

    public boolean mkdirs() {
        return this.resource.mkdirs();
    }

    public URL toURL() throws MalformedURLException {
        return this.resource.toURL();
    }

    public int hashCode() {
        return this.resource.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof NPSFile) {
            NPSFile file = (NPSFile)obj;
            return this.resource.equals(file.getResource());
        }
        return false;
    }

    public String toString() {
        return this.resource.toString();
    }

    public NPSFileResource getResource() {
        return this.resource;
    }

    public GadgetInstance getGadget() {
        return this.gadget;
    }
}

