/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.file;

import com.novell.nps.file.NPSFile;
import com.novell.nps.file.NPSFileResource;
import com.novell.nps.file.NPSFileResourceOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class NPSFileOutputStream
extends OutputStream {
    NPSFile file;
    NPSFileResource resource;
    NPSFileResourceOutputStream outStream;

    public NPSFileOutputStream(NPSFile file) throws IOException {
        this.file = file;
        this.resource = file.getResource();
        this.outStream = this.resource.getOutputStream();
    }

    public NPSFileOutputStream(NPSFile file, boolean append) throws IOException {
        this.file = file;
        this.resource = file.getResource();
        this.outStream = this.resource.getOutputStream(append);
    }

    public NPSFileOutputStream(String username, String password, String url) throws IOException {
        this.file = new NPSFile(username, password, url);
        this.resource = this.file.getResource();
        this.outStream = this.resource.getOutputStream();
    }

    public NPSFileOutputStream(String username, String password, String url, boolean append) throws IOException {
        this.file = new NPSFile(username, password, url);
        this.resource = this.file.getResource();
        this.outStream = this.resource.getOutputStream(append);
    }

    @Override
    public void close() throws IOException {
        this.outStream.close();
    }

    @Override
    public void write(int b) throws IOException {
        this.outStream.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.outStream.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.outStream.write(b, off, len);
    }
}

