/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.gadgetManager;

import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.ManagementServiceSet;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.XmlUtils;
import com.novell.emframe.dev.config.ConfigException;
import com.novell.emframe.dev.config.UserConfig;
import com.novell.emframe.dev.eMFrameFactory;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.FwAttr;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.legacySupport.LegacyTask;
import com.novell.emframe.fw.legacySupport.LegacyTaskInfo;
import com.novell.emframe.fw.servlet.AuthenticatorServlet;
import com.novell.emframe.fw.servlet.FwRequest;
import com.novell.nps.WebappUtil;
import com.novell.nps.authentication.AuthenticationManager;
import com.novell.nps.authentication.LDAPCredentials;
import com.novell.nps.authentication.PortalConnection;
import com.novell.nps.authentication.PortalDirectoryException;
import com.novell.nps.configManager.ConfigData;
import com.novell.nps.configManager.ConfigManager;
import com.novell.nps.configManager.ConfigSettings;
import com.novell.nps.configManager.Configuration;
import com.novell.nps.configManager.ConfigurationComplete;
import com.novell.nps.configManager.ConfigurationException;
import com.novell.nps.configManager.GadgetAssignment;
import com.novell.nps.configManager.GadgetConfig;
import com.novell.nps.configManager.SettingValue;
import com.novell.nps.debug.Debug;
import com.novell.nps.gadgetManager.GadgetInstance;
import com.novell.nps.gadgetManager.GadgetInstanceActionIcon;
import com.novell.nps.gadgetManager.GadgetInstanceException;
import com.novell.nps.gadgetManager.GadgetManager;
import com.novell.nps.gadgetManager.LaunchService;
import com.novell.nps.gadgetManager.ResourceSetMap;
import com.novell.nps.gadgetManager.StylesheetSet;
import com.novell.nps.gadgetManager.StylesheetSetMap;
import com.novell.nps.i18n.ResourceFileManager;
import com.novell.nps.serviceProviders.web.PortalURL;
import com.novell.nps.sessionManager.PortalResponseWrapper;
import com.novell.nps.sessionManager.PortalSession;
import com.novell.nps.utils.Utils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public class BaseGadgetInstance
implements LegacyTask,
ConfigurationComplete,
Serializable {
    public static final String CONFIGURABLE = "Configurable";
    public static final String STATE_SHOW_USER_CONFIG = "ShowUserConfig";
    public static final String STATE_USER_CONFIG_COMPLETE = "UserConfigComplete";
    public static final String HANDLE_ACTION_ERROR_STATE = "HandleActionErrorState";
    int m_lifeCycleType = 4;
    int m_launchType = 1;
    private Map m_repeatParams;
    GadgetInstance m_primary;
    String m_rootDelegatorID;
    GadgetInstance m_redirectionOrSelf = this;
    protected String state;
    StylesheetSetMap stylesheetSets;
    protected String m_moduleStylesheet = null;
    GadgetInstance m_parent;
    private Hashtable actionsMethodNames = new Hashtable(10);
    private Hashtable regActions = new Hashtable(10);
    static Class[] actionListenerParameterClasses = new Class[1];
    protected String helpURL;
    private boolean m_processRequestAsync = false;
    protected Locale myLocale = new Locale("en", "");
    protected String gadgetAssignmentDN = null;
    protected String gadgetInstanceID = null;
    protected String gadgetCode = "default";
    static Properties gadgetStylesheetMappings;
    public static final int GETDATA = 1;
    public static final int PROCESSREQUEST = 2;
    protected GadgetAssignment gadgetAssignment;
    protected String windowState = "max";
    protected PortalSession session;
    protected ResourceBundle resBundle;
    protected Document m_doc = null;
    private ConfigData m_mergedConfig = null;
    private boolean m_bUserWizardConfig = false;
    private Configuration m_userConfiguration = null;
    protected String m_previousState = null;
    private boolean forceRead = false;
    private boolean timedOut = false;
    private boolean getLastData = false;
    private static String DT;
    private String m_sRequestedDataType = "text/xml";
    protected Properties m_JSPDataObject = null;
    public boolean repeatable = true;
    private static String JSPDT;
    private Throwable m_tError = null;
    private UserConfig m_uc = null;

    public void onPortalInit(GadgetConfig cd) {
    }

    public PortalSession getSession() {
        return this.session;
    }

    public void setSession(PortalSession session) {
        this.session = session;
    }

    public LegacyTaskInfo getLegacyTaskInfo() {
        return this.getGadgetAssignment();
    }

    public GadgetAssignment getGadgetAssignment() {
        return this.gadgetAssignment;
    }

    public void setGadgetAssignmentDN(String gadgetAssignmentDN) {
        this.gadgetAssignmentDN = gadgetAssignmentDN;
    }

    public String getGadgetAssignmentDN() {
        return this.gadgetAssignmentDN;
    }

    private UserConfig getUserConfig() {
        if (this.m_uc == null) {
            String sModule = "NoTaskClass";
            String sTask = "NoServiceName";
            if (this.gadgetAssignment != null) {
                sModule = this.gadgetAssignment.getGadgetInstanceClass();
                sTask = this.gadgetAssignment.getServiceName();
            }
            TaskContext tc = eMFrameFactory.getTaskContext((HttpServletRequest)AuthenticatorServlet.currentRequest());
            this.m_uc = UserConfig.getUserConfig((String)(sModule + "::" + sTask), (MContext)tc);
        }
        return this.m_uc;
    }

    public ConfigData getConfig() {
        ConfigSettings cs = new ConfigSettings();
        UserConfig uc = this.getUserConfig();
        String[] saNames = uc.getSettingNames();
        if (saNames != null) {
            String[] saTemp = null;
            for (int i = 0; i < saNames.length; ++i) {
                saTemp = uc.getSettings(saNames[i]);
                if (saTemp == null) continue;
                cs.setSetting(saNames[i], saTemp);
            }
        }
        return cs;
    }

    public void getData(HttpServletRequest req, BufferedWriter out, Document domDocument) throws GadgetInstanceException {
        if (null != this.m_doc && this.getJSPPage(req) == null) {
            try {
                TransformerFactory tFactory = TransformerFactory.newInstance();
                Transformer transformer = tFactory.newTransformer();
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                DOMSource source = new DOMSource(this.m_doc);
                StreamResult result = new StreamResult(out);
                transformer.transform(source, result);
            }
            catch (TransformerException ex) {
                D.log((Throwable)ex);
            }
            catch (TransformerFactoryConfigurationError ex) {
                D.log((String)ex.getMessage());
            }
        }
    }

    public void reset() {
        this.m_redirectionOrSelf = this;
    }

    public void release() {
    }

    public int getLifeCycleType() {
        return this.m_lifeCycleType;
    }

    public void setLifeCycleType(int iType) {
        this.m_lifeCycleType = iType;
    }

    public int getLaunchType() {
        return this.m_launchType;
    }

    public void setLaunchType(int launchType) {
        this.m_launchType = launchType;
    }

    public void returnToPrimary(HttpServletRequest req, Object results) throws GadgetInstanceException {
        GadgetInstance primary = this.getPrimary();
        if (primary == null) {
            return;
        }
        String sStatus = this.getReturnStatus(req);
        if (this.getLaunchType() == 2) {
            GadgetManager.returnToDelegator((GadgetInstance)((Object)this), sStatus, results, req);
        } else {
            GadgetManager.returnToLauncher((GadgetInstance)((Object)this), sStatus, results, req);
        }
        String sLevels = req.getParameter("Task.frameLevel");
        if (sLevels == null || sLevels.length() == 0) {
            sLevels = (String)req.getAttribute("Task.frameLevel");
        }
        if (sLevels != null && sLevels.length() != 0) {
            LaunchService.redirectForFrameLevel(req, this, primary.getGadgetInstanceID());
            this.setRedirectionOrSelf((GadgetInstance)((Object)this));
        }
        primary.processRequest(req);
    }

    public Map getRepeatParams() {
        return this.m_repeatParams;
    }

    public void setRepeatParams(Map m_repeatParams) {
        this.m_repeatParams = m_repeatParams;
    }

    public String getReturnStatus(HttpServletRequest req) {
        String sStatus = (String)req.getAttribute("return");
        if (!(sStatus != null && sStatus.length() != 0 || (sStatus = req.getParameter("return")) != null && sStatus.length() != 0)) {
            sStatus = "finished";
        }
        return sStatus;
    }

    public GadgetInstance getPrimary() {
        return this.m_primary;
    }

    public void setPrimary(GadgetInstance primary) {
        this.m_primary = primary;
    }

    public void setRootDelegator(String rootDelegatorID) {
        this.m_rootDelegatorID = rootDelegatorID;
    }

    public String getRootDelegator() {
        if (this.m_rootDelegatorID == null) {
            return this.getGadgetInstanceID();
        }
        return this.m_rootDelegatorID;
    }

    public GadgetInstance getRedirectionOrSelf() {
        if (this.m_redirectionOrSelf == null) {
            return this;
        }
        if (this.m_redirectionOrSelf.equals(this)) {
            return this.m_redirectionOrSelf;
        }
        return this.m_redirectionOrSelf.getRedirectionOrSelf();
    }

    public void setRedirectionOrSelf(GadgetInstance gadgetInstance) {
        this.m_redirectionOrSelf = gadgetInstance;
    }

    public void processSecondaryGadgetResults(HttpServletRequest req, GadgetInstance secondaryGadgetInstance, String status, Object results) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void dispatchJSP(HttpServletRequest req, BufferedWriter out, String sJSPPage) throws GadgetInstanceException {
        if (this.m_JSPDataObject != null) {
            ((FwRequest)req).getResultStrings().putAll((Map<?, ?>)this.m_JSPDataObject);
            this.m_JSPDataObject = null;
        }
        if (this.m_doc != null) {
            req.setAttribute("PORTLET_JSP_DOC", (Object)this.m_doc);
        }
        req.setAttribute("GI_ID", (Object)this.getGadgetInstanceID());
        String taskIdParam = req.getParameter("taskId");
        if (taskIdParam == null) {
            req.setAttribute("taskId", (Object)this.getGadgetInstanceID());
        }
        String sModule = BaseGadgetInstance.getModuleFromModuleStylesheet(sJSPPage);
        String sStylesheet = BaseGadgetInstance.getStylesheetFromModuleStylesheet(sJSPPage);
        if (sModule != null && sModule.length() != 0) {
            FwAttr.setFwRequestAttribute((String)"MODULE_NAME", (Object)sModule, (HttpServletRequest)req);
        }
        if (sStylesheet != null && sStylesheet.length() != 0) {
            FwAttr.setFwRequestAttribute((String)"JSP_FILE", (Object)sStylesheet, (HttpServletRequest)req);
        }
        int iMajorVersion = WebappUtil.getStaticServletContext().getMajorVersion();
        int iMinorVersion = WebappUtil.getStaticServletContext().getMinorVersion();
        if (iMajorVersion > 2 || iMajorVersion >= 2 && iMinorVersion >= 3) {
            try {
                if (this.m_sRequestedDataType == null || this.m_sRequestedDataType.equalsIgnoreCase("text/xml")) {
                    XmlUtils.writeStartTag((String)"JSPData", (BufferedWriter)out);
                    XmlUtils.writeStartTag((String)"TheData", (BufferedWriter)out);
                }
                String resourceURI = ResourceFileManager.getModuleResourceFile(req, sJSPPage);
                D.log((String)("JSP: " + sJSPPage + " -> " + resourceURI));
                if (resourceURI == null) {
                    D.log((String)("Warning: Could not resolve JSP name; setting URI: " + sJSPPage));
                    if (sJSPPage.toUpperCase().indexOf("<SCRIPT>") != -1) {
                        sJSPPage = sJSPPage.replace("<", "&lt;");
                        sJSPPage = sJSPPage.replace(">", "&gt;");
                    }
                    resourceURI = sJSPPage;
                }
                RequestDispatcher rd = resourceURI.startsWith("/") ? req.getRequestDispatcher(resourceURI) : req.getRequestDispatcher("/" + resourceURI);
                PortalResponseWrapper respWrapper = null;
                HttpServletResponse resp = null;
                if (this.m_sRequestedDataType != null && this.m_sRequestedDataType.equalsIgnoreCase("text/html")) {
                    try {
                        resp = ((FwRequest)req).getInstanceResponse();
                        resp.setContentType(this.session.getContentType());
                        rd.include((ServletRequest)req, (ServletResponse)resp);
                        try {
                            resp.flushBuffer();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        if (req.getAttribute("SaveTaskURL") == null) return;
                        FwUtils.saveOSRequest((HttpServletRequest)req);
                        return;
                    }
                    catch (Exception ex) {
                        Throwable t = eMFrameUtils.discoverRootException((Throwable)ex);
                        t.printStackTrace();
                        GadgetInstanceException gie = new GadgetInstanceException(t.getMessage());
                        gie.setStackTrace(t.getStackTrace());
                        Debug.log("BaseGadgetInstance: ", gie);
                        this.outputHTMLError(req, out, gie);
                        return;
                    }
                }
                try {
                    respWrapper = ((FwRequest)req).getInstanceResponseWrapper();
                    respWrapper.setContentType(this.session.getContentType());
                    rd.forward((ServletRequest)req, (ServletResponse)respWrapper);
                    respWrapper.flushBuffer();
                    if (req.getAttribute("SaveTaskURL") != null) {
                        WebappUtil.saveOSRequest(req, this.session);
                    }
                    String sFlushedStream = respWrapper.getFlushedStream();
                    out.write(XmlUtils.xmlEncode((String)sFlushedStream));
                }
                catch (Exception ex) {
                    Throwable t = eMFrameUtils.discoverRootException((Throwable)ex);
                    t.printStackTrace();
                    GadgetInstanceException gie = new GadgetInstanceException(ex.getMessage());
                    gie.setStackTrace(ex.getStackTrace());
                    D.log((Throwable)gie);
                    this.outputHTMLError(req, out, gie);
                    return;
                }
                if (this.m_sRequestedDataType != null && !this.m_sRequestedDataType.equalsIgnoreCase("text/xml")) return;
                XmlUtils.writeEndTag((String)"TheData", (BufferedWriter)out);
                XmlUtils.writeEndTag((String)"JSPData", (BufferedWriter)out);
                return;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                GadgetInstanceException gie = new GadgetInstanceException(ex.getMessage());
                gie.setStackTrace(ex.getStackTrace());
                D.log((Throwable)gie);
                this.outputHTMLError(req, out, gie);
                return;
            }
        }
        this.dispatchJspLegacy(req, sJSPPage, out);
    }

    private void dispatchJspLegacy(HttpServletRequest req, String sJSPPage, BufferedWriter out) {
        Properties props = new Properties();
        String sAttribKey = this.saveRequestAttributes(req);
        if (sAttribKey != null) {
            props.put("ReqAttributeKey", sAttribKey);
        }
        props.put("JSPURL", sJSPPage);
        Properties headers = new Properties();
        Enumeration myenum = req.getHeaderNames();
        while (myenum.hasMoreElements()) {
            String name = (String)myenum.nextElement();
            headers.put(name, req.getHeader(name));
        }
        try {
            int iPort = req.getServerPort();
            String sPort = String.valueOf(iPort);
            PortalURL theURL = new PortalURL(this.session, "http://localhost:" + sPort + "/nps/servlet/jspservice");
            HttpURLConnection uc = (HttpURLConnection)theURL.openPost(props, headers);
            BufferedReader br = new BufferedReader(new InputStreamReader(uc.getInputStream()));
            String line = br.readLine();
            if (this.m_sRequestedDataType == null || this.m_sRequestedDataType.equalsIgnoreCase("text/xml")) {
                XmlUtils.writeStartTag((String)"JSPData", (BufferedWriter)out);
                XmlUtils.writeStartTag((String)"TheData", (BufferedWriter)out);
            }
            while (line != null) {
                if (this.m_sRequestedDataType != null && this.m_sRequestedDataType.equalsIgnoreCase("text/html")) {
                    out.write(line);
                } else {
                    out.write(XmlUtils.xmlEncode((String)line));
                }
                line = br.readLine();
            }
            if (this.m_sRequestedDataType == null || this.m_sRequestedDataType.equalsIgnoreCase("text/xml")) {
                XmlUtils.writeEndTag((String)"TheData", (BufferedWriter)out);
                XmlUtils.writeEndTag((String)"JSPData", (BufferedWriter)out);
            }
        }
        catch (Exception ex1) {
            ex1.printStackTrace();
            GadgetInstanceException gie = new GadgetInstanceException(ex1.getMessage());
            gie.setStackTrace(ex1.getStackTrace());
            D.log((Throwable)gie);
            this.outputHTMLError(req, out, gie);
            return;
        }
    }

    private String saveRequestAttributes(HttpServletRequest req) {
        Properties reqAttribs = new Properties();
        Enumeration myenum = req.getAttributeNames();
        while (myenum.hasMoreElements()) {
            String name = (String)myenum.nextElement();
            reqAttribs.put(name, req.getAttribute(name));
        }
        if (reqAttribs.isEmpty()) {
            return null;
        }
        long lKey = System.currentTimeMillis();
        String sKey = String.valueOf(lKey);
        this.session.setAttribute(sKey, reqAttribs);
        return sKey;
    }

    public void processRequest(HttpServletRequest req) throws GadgetInstanceException {
        this.execute(req);
    }

    public void processRequest(HttpServletRequest req, HttpServletResponse resp) throws GadgetInstanceException {
        this.execute(req, resp);
    }

    public void execute(HttpServletRequest req, HttpServletResponse resp) {
    }

    public void execute(HttpServletRequest req) {
    }

    public boolean handlePostRequestActions(HttpServletRequest req, HttpServletResponse resp) throws GadgetInstanceException {
        return false;
    }

    public void prepare(HttpServletRequest req, HttpServletResponse resp) throws GadgetInstanceException {
    }

    public void onShowUserConfigAction(HttpServletRequest req) throws GadgetInstanceException {
        if (req.getParameter("ConfigurableCancel") != null || req.getParameter("ConfigurableCancel.x") != null) {
            this.m_userConfiguration = null;
            this.setState(this.m_previousState);
        }
        if (this.m_userConfiguration != null) {
            try {
                this.m_userConfiguration.processRequest(req);
            }
            catch (ConfigurationException ce) {
                return;
            }
        }
    }

    public void getUserConfigCompleteData(HttpServletRequest req, BufferedWriter out, Document domDocument) throws GadgetInstanceException {
        PrintWriter p = new PrintWriter(out);
        p.println("\t<UserConfigComplete>");
        p.println("\t</UserConfigComplete>");
    }

    public void onUserConfigCompleteAction(HttpServletRequest req) throws GadgetInstanceException {
        if (req.getParameter("Submit") != null || req.getParameter("Submit.x") != null) {
            this.m_userConfiguration = null;
            this.setState(this.m_previousState);
        }
    }

    public void getHandleActionErrorStateData(HttpServletRequest req, BufferedWriter out, Document domDocument) throws GadgetInstanceException {
        try {
            XmlUtils.writeStartTag((String)HANDLE_ACTION_ERROR_STATE, (BufferedWriter)out);
            if (this.m_tError != null) {
                XmlUtils.writeCDataTag((String)"ThrownError", (String)this.m_tError.getLocalizedMessage(), (BufferedWriter)out);
                XmlUtils.writeStartTag((String)"StackTrace", (BufferedWriter)out);
                PrintWriter p = new PrintWriter(out);
                p.println("<![CDATA[");
                this.m_tError.printStackTrace(p);
                p.println("]]>");
                XmlUtils.writeEndTag((String)"StackTrace", (BufferedWriter)out);
            }
            XmlUtils.writeEndTag((String)HANDLE_ACTION_ERROR_STATE, (BufferedWriter)out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void outputHTMLError(HttpServletRequest req, BufferedWriter out, Exception e) {
        if (e != null) {
            PrintWriter p = new PrintWriter(out);
            p.println("<html><body>");
            p.println("<table border='0' cellpadding='3' cellspacing='0'>");
            p.println("<tr>");
            p.println("<div>");
            p.println("<td>");
            p.println("<img ALIGN='absmiddle' alt='");
            e.printStackTrace(p);
            p.println("' border='0' src='" + WebappUtil.getContext() + "/portal/stylesheets/skins/default/images/Error32.gif'/>");
            p.println("</td>");
            p.println("<td>");
            p.println(e.getLocalizedMessage());
            p.println("</td>");
            p.println("</div>");
            p.println("</tr>");
            p.println("</table>");
            p.println("</body></html>");
        }
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public String getAction(HttpServletRequest req) {
        return null;
    }

    public String getFullPageMode(HttpServletRequest req) {
        if (this.getState() != null && this.getState().equalsIgnoreCase(STATE_SHOW_USER_CONFIG)) {
            return "branding";
        }
        return null;
    }

    public String getCustomizeQueryString() {
        return null;
    }

    public String getResourcePathBase() {
        StringBuffer basePath = new StringBuffer(60);
        basePath.append(GadgetManager.getPublishedResourcePathRelToCX());
        basePath.append("/gadgets");
        basePath.append("/");
        basePath.append(this.getClass().getName());
        return basePath.toString();
    }

    public String getStyleSheetName(HttpServletRequest req) {
        return null;
    }

    public HashSet getContainedGadgetInstanceStylesheets(HttpServletRequest req) {
        HashSet<String> containedGadgetInstanceStylesheets = new HashSet<String>();
        String sOldStylesheet = this.getStyleSheetName(req);
        if (sOldStylesheet == null || sOldStylesheet.length() == 0) {
            return null;
        }
        containedGadgetInstanceStylesheets.add(sOldStylesheet);
        return containedGadgetInstanceStylesheets;
    }

    public void getStylesheetAndResourceSets(HttpServletRequest req, StylesheetSetMap ssMap, ResourceSetMap rsMap) {
        String sJSPPage = this.getJSPPage(req);
        if (null != sJSPPage) {
            StylesheetSet stylesheetSet = new StylesheetSet("com.novell.nps.gadgetManager.BaseJSPGadgetInstance");
            stylesheetSet.add("mainJSP.xsl");
            this.stylesheetSets = new StylesheetSetMap();
            this.stylesheetSets.put(stylesheetSet);
            ssMap.putAll((Map)this.stylesheetSets);
            return;
        }
        HashSet ssHashSet = this.getContainedGadgetInstanceStylesheets(req);
        if (ssHashSet != null && !ssHashSet.isEmpty()) {
            StylesheetSet stylesheetSet = new StylesheetSet(this.getClass().getName(), ssHashSet);
            ssMap.put(stylesheetSet);
        } else {
            if (null == this.stylesheetSets || null != this.m_moduleStylesheet) {
                this.stylesheetSets = new StylesheetSetMap();
                if (null == this.m_moduleStylesheet) {
                    StylesheetSet stylesheetSet = new StylesheetSet(this.getClass().getName());
                    stylesheetSet.add("main.xsl");
                    stylesheetSet.add("main_lang.xsl");
                    this.stylesheetSets.put(stylesheetSet);
                } else {
                    StylesheetSet stylesheetSet;
                    String sModule = BaseGadgetInstance.getModuleFromModuleStylesheet(this.m_moduleStylesheet);
                    String sStylesheet = BaseGadgetInstance.getStylesheetFromModuleStylesheet(this.m_moduleStylesheet);
                    if (sModule != null && sStylesheet != null) {
                        stylesheetSet = new StylesheetSet(sModule);
                        stylesheetSet.add(sStylesheet);
                        stylesheetSet.add("main_lang.xsl");
                        stylesheetSet.add("include.xsl");
                        this.stylesheetSets.put(stylesheetSet);
                    }
                    stylesheetSet = new StylesheetSet("dev");
                    stylesheetSet.add("main_lang.xsl");
                    stylesheetSet.add("include.xsl");
                    this.stylesheetSets.put(stylesheetSet);
                }
            }
            ssMap.putAll((Map)this.stylesheetSets);
        }
    }

    public String getJSPPage(HttpServletRequest req) {
        if (this.m_moduleStylesheet != null && this.m_moduleStylesheet.length() != 0 && !this.m_moduleStylesheet.toLowerCase().endsWith(".xsl")) {
            if (!this.m_moduleStylesheet.toLowerCase().endsWith(".jsp")) {
                this.m_moduleStylesheet = this.m_moduleStylesheet.replace('.', '/');
                this.m_moduleStylesheet = this.m_moduleStylesheet + ".jsp";
            }
            String sModule = BaseGadgetInstance.getModuleFromModuleStylesheet(this.m_moduleStylesheet);
            String sStylesheet = BaseGadgetInstance.getStylesheetFromModuleStylesheet(this.m_moduleStylesheet);
            if (sModule == null || sModule.length() == 0 || sStylesheet == null || sStylesheet.length() == 0) {
                this.m_moduleStylesheet = "fw/HomePage.jsp";
            }
            return this.m_moduleStylesheet;
        }
        return null;
    }

    void combineStylesheetSets(HashMap oldStylesheetSets, HashMap newStylesheetSets) {
        if (null != newStylesheetSets) {
            for (String currentSetLocator : newStylesheetSets.keySet()) {
                StylesheetSet preExistingSet = (StylesheetSet)oldStylesheetSets.get(currentSetLocator);
                if (null == preExistingSet) continue;
                StylesheetSet currentSet = (StylesheetSet)newStylesheetSets.get(currentSetLocator);
                currentSet.addAll(preExistingSet);
            }
            oldStylesheetSets.putAll(newStylesheetSets);
        }
    }

    public void setModuleStylesheet(String moduleStylesheet) {
        this.m_moduleStylesheet = moduleStylesheet != null && moduleStylesheet.length() != 0 ? (moduleStylesheet.startsWith("/") ? moduleStylesheet.substring(1) : moduleStylesheet) : null;
    }

    static String getModuleFromModuleStylesheet(String moduleStylesheet) {
        if (moduleStylesheet == null || moduleStylesheet.length() == 0) {
            return null;
        }
        String module = null;
        try {
            module = moduleStylesheet.substring(0, moduleStylesheet.indexOf(47));
        }
        catch (StringIndexOutOfBoundsException sioobe) {
            D.log((String)("moduleStylesheet invalid: " + moduleStylesheet), (int)1);
        }
        return module;
    }

    static String getStylesheetFromModuleStylesheet(String moduleStylesheet) {
        if (moduleStylesheet == null || moduleStylesheet.length() == 0) {
            return null;
        }
        String stylesheet = null;
        try {
            stylesheet = moduleStylesheet.substring(moduleStylesheet.indexOf(47) + 1);
        }
        catch (StringIndexOutOfBoundsException sioobe) {
            D.log((String)("moduleStylesheet invalid: " + moduleStylesheet), (int)1);
        }
        return stylesheet;
    }

    public String getGadgetXMLStartTag() {
        StringBuffer xmlTag = new StringBuffer(this.getRootNodeName().length() + 3);
        xmlTag.append("<");
        xmlTag.append(this.getRootNodeName());
        xmlTag.append(">");
        return xmlTag.toString();
    }

    public String getRootNodeName() {
        return this.getClass().getName();
    }

    public String getGadgetXMLEndTag() {
        StringBuffer xmlTag = new StringBuffer(this.getClass().getName().length() + 4);
        xmlTag.append("</");
        xmlTag.append(this.getClass().getName());
        xmlTag.append(">");
        return xmlTag.toString();
    }

    public void writeGadgetXMLStartTag(BufferedWriter out) throws IOException {
        out.write(this.getGadgetXMLStartTag());
    }

    public void writeGadgetXMLEndTag(BufferedWriter out) throws IOException {
        out.write(this.getGadgetXMLEndTag());
    }

    public SettingValue getConfigSettingValue(String prop) {
        if (prop == null) {
            return null;
        }
        String sTemp = this.getUserConfig().getSetting(prop);
        if (sTemp != null) {
            return new SettingValue(sTemp);
        }
        return null;
    }

    public SettingValue[] getConfigSettingValues(String prop) {
        if (prop == null) {
            return null;
        }
        String[] saTemp = this.getUserConfig().getSettings(prop);
        if (saTemp != null) {
            Vector<SettingValue> vTemp = new Vector<SettingValue>();
            for (int i = 0; i < saTemp.length; ++i) {
                vTemp.add(new SettingValue(saTemp[i]));
            }
            SettingValue[] sva = new SettingValue[vTemp.size()];
            vTemp.toArray(sva);
            return sva;
        }
        return null;
    }

    public String getConfigSetting(String prop, String defaultValue) {
        return this.getUserConfig().getSetting(prop, defaultValue);
    }

    public String[] getConfigSettings(String prop) {
        return this.getUserConfig().getSettings(prop);
    }

    public Object getConfigObjectSetting(String prop) {
        return this.getUserConfig().getObjectSetting(prop);
    }

    public Object[] getConfigObjectSettings(String prop) {
        return this.getUserConfig().getObjectSettings(prop);
    }

    public boolean isConfigSettingOverwriteable(String name) {
        return true;
    }

    public boolean isConfigSettingCumulative(String name) {
        return false;
    }

    public void setConfigSetting(String prop, String value) {
        try {
            this.getUserConfig().setSetting(prop, value);
        }
        catch (ConfigException e) {
            D.log((Throwable)e);
        }
    }

    public void setConfigSetting(String prop, String[] values) {
        try {
            this.getUserConfig().setSetting(prop, values);
        }
        catch (ConfigException e) {
            D.log((Throwable)e);
        }
    }

    public int getIntConfigSetting(String prop, int defaultValue) {
        int iRet = defaultValue;
        String sTemp = this.getUserConfig().getSetting(prop);
        if (sTemp != null) {
            try {
                iRet = Integer.parseInt(sTemp);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return iRet;
    }

    public String getConfigSetting(String prop) {
        return this.getUserConfig().getSetting(prop);
    }

    public String getProxyServer() {
        String proxy = ConfigManager.getSingleSetting("ProxyServer");
        if (null != proxy && proxy.length() > 0) {
            return proxy;
        }
        return "";
    }

    public void init(String[] initArgs) {
        this.execute(null);
    }

    public void setGadgetAssignment(GadgetAssignment gadgetAssign) {
        this.gadgetAssignment = gadgetAssign;
    }

    public String getGadgetInstanceID() {
        return this.gadgetInstanceID;
    }

    public void setGadgetInstanceID(String gadgetInstID) {
        this.gadgetInstanceID = gadgetInstID;
    }

    public GadgetInstance getParentInstance() {
        return this.m_parent;
    }

    public void setParentInstance(GadgetInstance parentContainer) {
        this.m_parent = parentContainer;
    }

    public void writeConfig() throws GadgetInstanceException {
        try {
            this.getUserConfig().writeSettings();
        }
        catch (ConfigException e) {
            D.log((Throwable)e);
        }
    }

    public void setWindowState(String wndState) {
        if (wndState.equals("max") || wndState.equals("min")) {
            this.windowState = wndState;
        }
    }

    public String getWindowState() {
        return this.windowState;
    }

    public boolean isTimedOut() {
        return this.timedOut;
    }

    public void setTimedOut(boolean timedout) {
        this.timedOut = timedout;
    }

    public boolean isForceRead() {
        return this.forceRead;
    }

    public void setForceRead(boolean forceRead) {
        this.forceRead = forceRead;
    }

    public boolean getDataFromLastTry() {
        return this.getLastData;
    }

    public void setGetDataFromLastTry(boolean getLastData) {
        this.getLastData = getLastData;
    }

    public void callGetData(GadgetInstance gInst, HttpServletRequest instRequest, BufferedWriter out, Document dom) throws GadgetInstanceException {
        try {
            String sJSPPage;
            String state;
            String tmp;
            if (this.getJSPPage(instRequest) == null && (tmp = instRequest.getParameter("OS.ReturningToAnchor")) != null && tmp.equalsIgnoreCase("true")) {
                this.outputOSReturnParameters(instRequest, out);
            }
            FwUtils.setBGI((HttpServletRequest)instRequest, (LegacyTask)this);
            GadgetInstance primaryInstance = this.getPrimary();
            if (primaryInstance != null) {
                instRequest.setAttribute("launcherId", (Object)primaryInstance.getGadgetInstanceID());
            }
            if ((state = GadgetManager.getState(gInst, instRequest)) == null) {
                state = gInst.getState();
            }
            Method getDataMethod = null;
            if (state != null) {
                getDataMethod = GadgetManager.getGetDataMethod(gInst, state);
            }
            if (getDataMethod == null) {
                gInst.getData(instRequest, out, dom);
            } else {
                Object[] params = new Object[]{instRequest, out, dom};
                try {
                    getDataMethod.invoke((Object)gInst, params);
                }
                catch (InvocationTargetException e) {
                    String gName = gInst.getGadgetAssignment().getAssignmentName();
                    GadgetInstanceException gie = new GadgetInstanceException("Exception thrown in call to get" + state + "Data method on " + gName);
                    this.m_tError = gie;
                    this.getHandleActionErrorStateData(instRequest, out, dom);
                    return;
                }
                catch (IllegalAccessException e) {
                    String gName = gInst.getGadgetAssignment().getAssignmentName();
                    GadgetInstanceException gie = new GadgetInstanceException("Unable to call get" + state + "Data method on " + gName);
                    D.log((Throwable)gie);
                    this.m_tError = gie;
                    this.getHandleActionErrorStateData(instRequest, out, dom);
                    return;
                }
            }
            if (instRequest.getAttribute("SaveTaskURL") != null) {
                FwUtils.saveOSRequest((HttpServletRequest)instRequest);
            }
            if (!(state != null && state.equalsIgnoreCase(STATE_SHOW_USER_CONFIG) || null == (sJSPPage = this.getJSPPage(instRequest)))) {
                this.dispatchJSP(instRequest, out, sJSPPage);
            }
        }
        catch (Throwable t) {
            D.log((Throwable)t);
            this.m_tError = t;
            this.getHandleActionErrorStateData(instRequest, out, dom);
            return;
        }
    }

    private void outputOSReturnParameters(HttpServletRequest instRequest, BufferedWriter out) {
        try {
            XmlUtils.writeStartTag((String)"OS.ReturnedData", (BufferedWriter)out);
            String sReturningToAnchor = Utils.toScript(instRequest.getParameter("OS.ReturningToAnchor"));
            String sCallBack = Utils.toScript(instRequest.getParameter("OS.CallBack"));
            String sControl = Utils.toScript(instRequest.getParameter("OS.Control"));
            String sResults = Utils.toScript(instRequest.getParameter("OS.Results"));
            String sAnchorDocState = Utils.toScript(instRequest.getParameter("OS.AnchorDocState"));
            if (sReturningToAnchor != null && sReturningToAnchor.length() != 0) {
                XmlUtils.writeCDataTag((String)"OS.ReturningToAnchor", (String)sReturningToAnchor, (BufferedWriter)out);
            } else {
                XmlUtils.writeTag((String)"OS.ReturningToAnchor", (String)"", (BufferedWriter)out);
            }
            if (sCallBack != null && sCallBack.length() != 0) {
                XmlUtils.writeCDataTag((String)"OS.CallBack", (String)sCallBack, (BufferedWriter)out);
            } else {
                XmlUtils.writeTag((String)"OS.CallBack", (String)"", (BufferedWriter)out);
            }
            if (sControl != null && sControl.length() != 0) {
                XmlUtils.writeCDataTag((String)"OS.Control", (String)sControl, (BufferedWriter)out);
            } else {
                XmlUtils.writeTag((String)"OS.Control", (String)"", (BufferedWriter)out);
            }
            if (sResults != null && sResults.length() != 0) {
                XmlUtils.writeCDataTag((String)"OS.Results", (String)sResults, (BufferedWriter)out);
            } else {
                XmlUtils.writeTag((String)"OS.Results", (String)"", (BufferedWriter)out);
            }
            if (sAnchorDocState != null && sAnchorDocState.length() != 0) {
                XmlUtils.writeCDataTag((String)"OS.AnchorDocState", (String)sAnchorDocState, (BufferedWriter)out);
            } else {
                XmlUtils.writeTag((String)"OS.AnchorDocState", (String)"", (BufferedWriter)out);
            }
            XmlUtils.writeEndTag((String)"OS.ReturnedData", (BufferedWriter)out);
        }
        catch (IOException e) {
            D.log((Throwable)e);
        }
    }

    public void handleAction(String action, HttpServletRequest req) throws GadgetInstanceException {
        String sMergePage;
        FwUtils.setBGI((HttpServletRequest)req, (LegacyTask)this);
        GadgetInstance primaryInstance = this.getPrimary();
        if (primaryInstance != null) {
            req.setAttribute("launcherId", (Object)primaryInstance.getGadgetInstanceID());
        }
        if (null != (sMergePage = req.getParameter("use"))) {
            this.setModuleStylesheet(sMergePage);
        }
        if (action != null && action.length() != 0) {
            Vector listeners = (Vector)this.regActions.get(action);
            if (listeners == null || listeners.size() == 0) {
                try {
                    this.processRequest(req);
                }
                catch (Throwable t) {
                    D.log((Throwable)t);
                    this.setState(HANDLE_ACTION_ERROR_STATE);
                    this.setModuleStylesheet(null);
                    this.m_tError = t;
                }
                return;
            }
            String listenerMethodName = (String)this.actionsMethodNames.get(action);
            if (listenerMethodName == null) {
                String sFixedActionName = Character.toUpperCase(action.charAt(0)) + action.substring(1);
                listenerMethodName = "on" + sFixedActionName + "Action";
                this.actionsMethodNames.put(action, listenerMethodName);
            }
            for (int i = 0; i < listeners.size(); ++i) {
                Object listener = listeners.elementAt(i);
                Class<?> listenerClass = listener.getClass();
                try {
                    Method actionListenerMethod = listenerClass.getMethod(listenerMethodName, actionListenerParameterClasses);
                    actionListenerMethod.invoke(listener, req);
                    continue;
                }
                catch (Exception e) {
                    D.log((String)("actionHandler: " + listener.getClass().getName()));
                    D.log((Throwable)e);
                }
            }
        } else {
            try {
                this.processRequest(req);
            }
            catch (Throwable t) {
                D.log((Throwable)t);
                this.setState(HANDLE_ACTION_ERROR_STATE);
                this.setModuleStylesheet(null);
                this.m_tError = t;
            }
            return;
        }
    }

    public void addActionListener(Object listener, String action) {
        Vector<Object> listeners = (Vector<Object>)this.regActions.get(action);
        if (listeners == null) {
            listeners = new Vector<Object>();
            this.regActions.put(action, listeners);
        }
        listeners.add(listener);
    }

    public void removeActionListener(Object listener, String action) {
        Vector listeners = (Vector)this.regActions.get(action);
        if (listeners != null) {
            listeners.remove(listener);
        }
    }

    public GadgetInstanceActionIcon[] getActionIcons(HttpServletRequest req) {
        return null;
    }

    public boolean hasHelp() {
        return "true".equals(this.getConfigSetting("Has Help"));
    }

    public String getLocHelpURL(HttpServletRequest req) throws MissingResourceException {
        String helpFileNameBase = "MainHelp";
        if (null == this.helpURL) {
            int beginIndex;
            String contentType = this.session.getContentType();
            int endIndex = contentType.indexOf(";", beginIndex = contentType.indexOf("/") + 1);
            if (endIndex < beginIndex) {
                endIndex = contentType.length();
            }
            String extension = contentType.substring(beginIndex, endIndex);
            this.helpURL = GadgetManager.getGadgetResourceFileMap((GadgetInstance)((Object)this)).getLocalizedPath(helpFileNameBase + "." + extension, this.session, (GadgetInstance)((Object)this));
        }
        return this.helpURL;
    }

    Enumeration getLanguages(HttpServletRequest req) {
        return req.getLocales();
    }

    public String findURIForLocFile(HttpServletRequest req, String fileName, String ext) throws MissingResourceException {
        String path = this.getResourcePathBase() + "/lang";
        String dirName = WebappUtil.getRealPath(path);
        File dir = new File(dirName);
        if (!dir.isDirectory()) {
            String message = "Localized resource directory (" + dirName + ") not found";
            D.log((String)message, (int)1);
            throw new MissingResourceException(message, this.getClass().getName(), dirName);
        }
        Object[] files = dir.list(new ResourceFilenameFilter(fileName));
        if (files.length == 1) {
            if (files[0].endsWith(ext)) {
                return path + "/" + (String)files[0];
            }
            String message = "No form of resource " + fileName + " found in directory (" + dirName + ") not found";
            throw new MissingResourceException(message, this.getClass().getName(), dirName);
        }
        if (files.length < 1) {
            String message = "No form of resource " + fileName + " found in directory (" + dirName + ") not found";
            throw new MissingResourceException(message, this.getClass().getName(), dirName);
        }
        Arrays.sort(files);
        Enumeration languages = this.getLanguages(req);
        while (languages.hasMoreElements()) {
            Locale locale = (Locale)languages.nextElement();
            String lang = locale.getLanguage();
            String country = locale.getCountry();
            int foundIndex = Arrays.binarySearch(files, fileName + lang + country + ext);
            if (foundIndex >= 0) {
                return path + "/" + (String)files[foundIndex];
            }
            foundIndex = Arrays.binarySearch(files, fileName + lang + ext);
            if (foundIndex >= 0) {
                return path + "/" + (String)files[foundIndex];
            }
            int insertPoint = -(foundIndex + 1);
            if (!((String)files[insertPoint]).startsWith(fileName + lang)) continue;
            return path + "/" + (String)files[-foundIndex];
        }
        int indexOfSimpleFile = Arrays.binarySearch(files, fileName + ext);
        if (indexOfSimpleFile >= 0) {
            return path + "/" + fileName + ext;
        }
        throw new MissingResourceException("Unable to find a localized version of " + fileName, this.getClass().getName(), fileName);
    }

    public String getLocResourceURI(HttpServletRequest req) throws MissingResourceException {
        String locResURI = null;
        String ssName = this.getStyleSheetName(req);
        int extensionIndex = ssName.lastIndexOf(46);
        String ext = "";
        if (extensionIndex > 0) {
            ext = ssName.substring(extensionIndex);
        }
        ssName = ssName.substring(0, extensionIndex > 0 ? extensionIndex : ssName.length());
        locResURI = this.findURIForLocFile(req, ssName, ext);
        return locResURI;
    }

    public String getLangResourceURI(HttpServletRequest req) throws MissingResourceException {
        String locResURI = null;
        return locResURI;
    }

    public void setResourceBundle(ResourceBundle bundle) {
        this.resBundle = bundle;
    }

    public ResourceBundle getResourceBundle() {
        return this.resBundle;
    }

    @Override
    public void configureComplete(ConfigData allSettings) {
        this.configureWriteConfig(allSettings, true);
    }

    public void configureApply(ConfigData allSettings) {
        this.configureWriteConfig(allSettings, false);
    }

    @Override
    public void configureCancel() {
        this.m_userConfiguration = null;
        this.setState(this.m_previousState);
    }

    private void configureWriteConfig(ConfigData allSettings, boolean bConfigComplete) {
        ConfigData oldcd = this.getConfig();
        oldcd.mergeConfig(allSettings, false, false);
        this.gadgetAssignment.setGadgetConfig(oldcd);
        if (bConfigComplete) {
            this.m_userConfiguration = null;
            this.setState(this.m_previousState);
        }
        try {
            this.writeConfig();
        }
        catch (GadgetInstanceException gie) {
            D.log((Throwable)gie);
        }
    }

    @Override
    public String getConfiguredUniqueID() {
        if (this.gadgetAssignment != null) {
            return this.gadgetAssignment.getUniqueID();
        }
        return null;
    }

    public String getParam(HttpServletRequest req, String sParam) {
        String sTemp = req.getParameter(sParam);
        if (sTemp == null) {
            StringBuffer sb = new StringBuffer(sParam);
            sb.append(".x");
            sTemp = req.getParameter(sb.toString());
        }
        return sTemp;
    }

    public void setLocale(Locale locale) {
        this.myLocale = locale;
    }

    public Properties getJSPDataObject() {
        if (this.m_JSPDataObject == null) {
            this.m_JSPDataObject = new Properties();
        }
        return this.m_JSPDataObject;
    }

    @Override
    public Locale getLocale() {
        return this.myLocale;
    }

    public Document getDocument() {
        if (null == this.m_doc) {
            this.createDocument(this.getRootNodeName());
        }
        return this.m_doc;
    }

    public Document createDocument(String sRootNodeName) {
        Document document = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.newDocument();
            document.appendChild(document.createElement(sRootNodeName));
            this.m_doc = document;
        }
        catch (ParserConfigurationException pce) {
            D.log((Throwable)pce);
        }
        return this.m_doc;
    }

    public void clearDocument() {
        this.m_doc = null;
    }

    public String getPreferredName() {
        String userDN = this.session.getUserDN();
        return this.getPreferredName(userDN);
    }

    public String getPreferredName(String userDN) {
        String preferredName = new String("");
        String surname = null;
        PortalConnection pc = AuthenticationManager.getConnection(this.session);
        try {
            surname = pc.readStringAttribute(userDN, "sn");
        }
        catch (PortalDirectoryException portalDirectoryException) {
            // empty catch block
        }
        if (surname != null && surname.length() > 0) {
            String firstName = null;
            try {
                firstName = pc.readStringAttribute(userDN, "preferredName");
            }
            catch (PortalDirectoryException portalDirectoryException) {
                // empty catch block
            }
            if (firstName != null && firstName.length() > 0) {
                return firstName + " " + surname;
            }
            try {
                firstName = pc.readStringAttribute(userDN, "givenName");
            }
            catch (PortalDirectoryException portalDirectoryException) {
                // empty catch block
            }
            if (firstName != null && firstName.length() > 0) {
                return firstName + " " + surname;
            }
        }
        try {
            preferredName = pc.readStringAttribute(userDN, "fullName");
        }
        catch (PortalDirectoryException firstName) {
            // empty catch block
        }
        if (preferredName != null && preferredName.length() > 0) {
            return preferredName;
        }
        try {
            preferredName = pc.readStringAttribute(userDN, "cn");
        }
        catch (PortalDirectoryException firstName) {
            // empty catch block
        }
        if (preferredName != null && preferredName.length() > 0) {
            return preferredName;
        }
        if (userDN.equalsIgnoreCase(this.session.getUserDN())) {
            LDAPCredentials theUser = AuthenticationManager.getCurrentCredentials(this.session);
            return theUser.getUserName();
        }
        return "";
    }

    public void onPageMaximize() {
    }

    public void onPageMinimize() {
    }

    public final void parseMultipartFormData(HttpServletRequest req, String saveDirectory) {
        ((FwRequest)req).parseMultipartRequest(saveDirectory);
    }

    public String getOriginalServiceName() {
        if (this.gadgetAssignment != null) {
            return this.gadgetAssignment.getOriginalServiceName();
        }
        return null;
    }

    public String getPreferredDataType() {
        if (this.m_moduleStylesheet != null && this.m_moduleStylesheet.length() != 0 && !this.m_moduleStylesheet.toLowerCase().endsWith(".xsl")) {
            return "text/html";
        }
        return "text/xml";
    }

    public void setRequestedDataType(String sDataType) {
        this.m_sRequestedDataType = sDataType;
    }

    public ManagementServiceSet getManagementServiceSet() {
        return AuthenticationManager.getManagementServiceSet(this.session, 3);
    }

    public static void shouldRun(HttpServletRequest req, String sServiceName) throws Exception {
        FwUtils.taskShouldRunImpl((HttpServletRequest)req, (String)sServiceName);
    }

    public static void supportsDeviceCharacteristics(HttpServletRequest req, String sServiceName) throws Exception {
        FwUtils.taskShouldRunImpl((HttpServletRequest)req, (String)sServiceName);
    }

    public PortalConnection getPortalConnection() {
        AuthenticationBroker ab;
        PortalConnection pc = null;
        String sKey = this.getGadgetAssignment().getRegistrationKey();
        if (sKey == null) {
            pc = AuthenticationManager.getConnection(this.session);
            return pc;
        }
        ManagementServiceSet mms = this.getManagementServiceSet();
        if (mms != null && (ab = mms.getAuthenticationBroker()) != null && (pc = (PortalConnection)ab.getAPIObject("PortalConnection")) != null) {
            return pc;
        }
        pc = AuthenticationManager.getConnection(this.session);
        return pc;
    }

    public boolean getAllowProcessRequestAsync() {
        return this.m_processRequestAsync;
    }

    public void setAllowProcessRequestAsync(boolean allowAsync) {
        this.m_processRequestAsync = allowAsync;
    }

    public void setUIPage(String uiPage) {
        this.setModuleStylesheet(uiPage);
    }

    public String getTaskId() {
        return this.getGadgetInstanceID();
    }

    public String getUIPage() {
        return this.getJSPPage(FwUtils.getRequest((HttpSession)this.session));
    }

    static {
        try {
            BaseGadgetInstance.actionListenerParameterClasses[0] = Class.forName("javax.servlet.http.HttpServletRequest");
        }
        catch (Exception e) {
            D.log((String)"Error initializing action handling", (int)1);
            D.log((Throwable)e);
        }
        DT = "BaseGadgetInstance";
        JSPDT = "JSPDispatch";
    }

    class ResourceFilenameFilter
    implements FilenameFilter {
        String resourceName;

        ResourceFilenameFilter(String name) {
            this.resourceName = name;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.startsWith(this.resourceName);
        }
    }
}

