/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.gadgetManager;

import com.novell.nps.authentication.AuthenticationManager;
import com.novell.nps.authentication.BasicCredentials;
import com.novell.nps.authentication.SecretStoreGadget;
import com.novell.nps.debug.Debug;
import com.novell.nps.gadgetManager.BaseGadgetInstance;
import com.novell.nps.gadgetManager.GadgetInstanceException;
import com.novell.nps.serviceProviders.CustomSSProvider;
import com.novell.nps.sessionManager.PortalSession;
import java.io.BufferedWriter;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;

public class BaseSSGadgetInstance
extends BaseGadgetInstance
implements SecretStoreGadget {
    boolean usesSecretStore = false;
    String currentSecretSite;
    Hashtable secrets = new Hashtable();
    static final String RESET_GADGETSS = "ResetGadgetSS";
    static final String SS_USERNAME = "PresetUsername";
    static final String SS_PASSWORD = "PresetPassword";
    protected static String SHARED_SECRET_NAME = "SharedSecretName";
    private static Hashtable m_htCustomInstances = new Hashtable();
    private static String DT = "BaseSSGadgetInstance";
    private static String CUSTOM_SS_PROVIDER = "CustomSSClass";

    public BaseSSGadgetInstance() {
        this.addActionListener(this, RESET_GADGETSS);
    }

    public String getSSUsername() {
        if (this.getConfigSetting(SS_USERNAME) == null) {
            return "";
        }
        return this.getConfigSetting(SS_USERNAME);
    }

    public String getSSPassword() {
        if (this.getConfigSetting(SS_PASSWORD) == null) {
            return "";
        }
        return this.getConfigSetting(SS_PASSWORD);
    }

    public void setUserInformation(String userName, String password, String lookupTag) throws GadgetInstanceException {
        this.setUserInformation(userName, password, lookupTag, false, true, null);
    }

    public void setUserInformation(String userName, String password, String lookupTag, boolean basic, boolean saveCredentials, String encryptTag) throws GadgetInstanceException {
        BasicCredentials creds = new BasicCredentials(userName, password);
        String sSharedSecretName = this.getConfigSetting(SHARED_SECRET_NAME, "");
        try {
            if (saveCredentials) {
                String sCustomProvider = this.getConfigSetting(CUSTOM_SS_PROVIDER);
                if (null != sCustomProvider) {
                    CustomSSProvider provider = this.getCustomClass(sCustomProvider);
                    if (null != provider) {
                        provider.setCredentials(this.session.getUserDN(), this.session.getUserCN(), creds, lookupTag, encryptTag);
                        this.usesSecretStore = true;
                    }
                    return;
                }
                if (sSharedSecretName.length() > 0) {
                    AuthenticationManager.setSharedCredentials(this.session, sSharedSecretName, creds, encryptTag);
                    this.currentSecretSite = sSharedSecretName;
                    this.usesSecretStore = true;
                } else if (basic) {
                    AuthenticationManager.setCredentials(this.session, "Basic", lookupTag, (Object)creds);
                } else {
                    AuthenticationManager.setCredentials(this.session, this, lookupTag, (Object)creds, encryptTag);
                    this.currentSecretSite = lookupTag;
                    this.usesSecretStore = true;
                }
            } else {
                this.secrets.put(lookupTag, creds);
                this.session.setAttribute("BasicInfo", creds);
                this.currentSecretSite = lookupTag;
            }
        }
        catch (Exception e) {
            throw new GadgetInstanceException();
        }
    }

    public void setUserInformation(HttpServletRequest req, String lookupTag, String encryptTag) throws GadgetInstanceException {
        String gadgetID;
        String Login;
        boolean basic = false;
        if (req != null && (Login = this.getParam(req, "SSLogin")) != null && (gadgetID = req.getParameter("GADGETINSTANCE")) != null && gadgetID.equals(this.getGadgetInstanceID())) {
            String userParam;
            String basicString;
            String entryName = req.getParameter("ENTRY");
            if (entryName == null) {
                entryName = lookupTag;
            }
            if ((basicString = req.getParameter("BASIC")).equals("true")) {
                basic = true;
            }
            String savePassword = req.getParameter("savePWD");
            boolean saveCredentials = false;
            if (savePassword != null) {
                saveCredentials = true;
            }
            if ((userParam = req.getParameter("username")) != null && userParam.length() > 0) {
                this.setUserInformation(req.getParameter("username"), req.getParameter("password"), entryName, basic, saveCredentials, encryptTag);
            }
        }
    }

    public BasicCredentials getUserInformation(String lookupTag) throws GadgetInstanceException {
        return this.getUserInformation(null, lookupTag, null);
    }

    @Override
    public BasicCredentials getUserInformation(HttpServletRequest req, String lookupTag, String encryptTag) throws GadgetInstanceException {
        BasicCredentials returnInfo;
        block12: {
            this.setUserInformation(req, lookupTag, encryptTag);
            String sSharedSecretName = this.getConfigSetting(SHARED_SECRET_NAME, "");
            returnInfo = null;
            returnInfo = (BasicCredentials)this.secrets.get(lookupTag);
            this.currentSecretSite = lookupTag;
            if (returnInfo == null) {
                try {
                    URL theURL = new URL(lookupTag);
                    returnInfo = (BasicCredentials)this.secrets.get(theURL.getHost());
                }
                catch (Exception theURL) {
                    // empty catch block
                }
            }
            if (returnInfo == null) {
                try {
                    returnInfo = sSharedSecretName.length() > 0 ? AuthenticationManager.getSharedCredentials(this.session, sSharedSecretName, encryptTag) : (BasicCredentials)AuthenticationManager.getCredentials(this.session, this, lookupTag, encryptTag);
                    this.usesSecretStore = true;
                }
                catch (Exception e) {
                    try {
                        returnInfo = (BasicCredentials)AuthenticationManager.getCredentials(this.session, "Basic", lookupTag, encryptTag);
                        this.usesSecretStore = true;
                    }
                    catch (Exception e1) {
                        try {
                            URL theURL = new URL(lookupTag);
                            returnInfo = (BasicCredentials)AuthenticationManager.getCredentials(this.session, "Basic", theURL.getHost(), encryptTag);
                            this.usesSecretStore = true;
                        }
                        catch (Exception e2) {
                            String sClassName = null;
                            sClassName = this.getConfigSetting(CUSTOM_SS_PROVIDER);
                            if (sClassName != null) {
                                returnInfo = this.getCustomCredentials(this.session, sClassName, lookupTag, encryptTag);
                                this.setUserInformation(returnInfo.getUserName(), returnInfo.getPassword(), lookupTag, false, true, encryptTag);
                                break block12;
                            }
                            throw new GadgetInstanceException();
                        }
                    }
                }
            }
        }
        if (returnInfo != null) {
            return returnInfo;
        }
        throw new GadgetInstanceException();
    }

    private BasicCredentials getCustomCredentials(PortalSession session, String sClassName, String lookupTag, String encryptTag) {
        Debug.log(DT, "GetCustomCredentials");
        CustomSSProvider provider = this.getCustomClass(sClassName);
        if (provider != null) {
            return provider.getCredentials(session.getUserDN(), session.getUserCN(), lookupTag, encryptTag);
        }
        return null;
    }

    private CustomSSProvider getCustomClass(String sClassName) {
        CustomSSProvider provider = (CustomSSProvider)m_htCustomInstances.get(sClassName);
        if (provider == null) {
            try {
                Class<?> newClass = Class.forName(sClassName);
                CustomSSProvider newInstance = (CustomSSProvider)newClass.newInstance();
                m_htCustomInstances.put(sClassName, newInstance);
            }
            catch (ClassNotFoundException ex) {
                Debug.log(DT, 1, ex);
            }
            catch (Exception e) {
                Debug.log(DT, 1, e);
            }
        }
        return provider;
    }

    @Override
    public void displayGetCredentials(BufferedWriter out, String message) {
        this.displayGetCredentials(out, message, null, false, false);
    }

    @Override
    public void displayGetCredentials(BufferedWriter out, String message, String entryTag, boolean doBasic, boolean doFullPage) {
        this.displayGetCredentials(out, message, entryTag, doBasic, doFullPage, null, null);
    }

    public void displayGetCredentials(BufferedWriter out, String message, String entryTag, boolean doBasic, boolean doFullPage, Properties params) {
        this.displayGetCredentials(out, message, entryTag, doBasic, doFullPage, null, null);
    }

    public void displayGetCredentials(BufferedWriter out, String message, String entryTag, boolean doBasic, boolean doFullPage, BasicCredentials user, Properties params) {
        try {
            out.write("<DISPLAY_LOGIN>");
            out.write("<GADGET_INSTANCE>" + this.getGadgetInstanceID() + "</GADGET_INSTANCE>");
            if (entryTag != null) {
                out.write("<ENTRYTAG><![CDATA[" + entryTag + "]]></ENTRYTAG>");
            }
            out.write("<PROMPT><![CDATA[" + message + "]]></PROMPT>");
            out.write("<BASIC>" + doBasic + "</BASIC>");
            if (doFullPage) {
                out.write("<FULLPAGE>yes</FULLPAGE>");
            }
            if (user != null) {
                if (user.getUserName() != null) {
                    out.write("<USERNAME>" + user.getUserName() + "</USERNAME>");
                }
                if (user.getPassword() != null) {
                    out.write("<PASSWORD>" + user.getPassword() + "</PASSWORD>");
                }
            } else {
                out.write("<USERNAME>" + this.getSSUsername() + "</USERNAME>");
                out.write("<PASSWORD>" + this.getSSPassword() + "</PASSWORD>");
            }
            if (params != null) {
                Enumeration<Object> names = params.keys();
                out.write("<PARAMS>");
                while (names.hasMoreElements()) {
                    String currentName = (String)names.nextElement();
                    out.write("<PARAM>");
                    out.write("<NAME>" + currentName + "</NAME>");
                    out.write("<VALUE>" + params.get(currentName) + "</VALUE>");
                    out.write("</PARAM>");
                }
                out.write("</PARAMS>");
            }
            out.write("</DISPLAY_LOGIN>");
        }
        catch (IOException io) {
            Debug.log(DT, io);
        }
    }

    @Override
    public void removeSecret(String lookupTag) throws GadgetInstanceException {
        String sSharedSecretName;
        String sCustomProvider = this.getConfigSetting(CUSTOM_SS_PROVIDER);
        if (sCustomProvider != null) {
            CustomSSProvider provider = this.getCustomClass(sCustomProvider);
            provider.resetSecret(this.session.getUserDN(), this.session.getUserCN(), lookupTag);
        }
        if ((sSharedSecretName = this.getConfigSetting(SHARED_SECRET_NAME, "")).length() > 0) {
            AuthenticationManager.removeSharedSecretStore(this.session, sSharedSecretName);
        } else {
            AuthenticationManager.removeSecretStore(this.session, this, lookupTag);
        }
        if (lookupTag.startsWith("http")) {
            try {
                URL theURL = new URL(lookupTag);
                AuthenticationManager.removeSecretStore(this.session, "Basic", theURL.toString());
                AuthenticationManager.removeSecretStore(this.session, "Basic", theURL.getHost());
            }
            catch (Exception e) {
                Debug.log("Reset Secrets", e);
            }
        }
        this.secrets = new Hashtable();
        this.session.removeAttribute("BasicInfo");
        this.usesSecretStore = false;
    }

    public void removeSecret() throws GadgetInstanceException {
        if (this.currentSecretSite != null) {
            this.removeSecret(this.currentSecretSite);
        }
        this.secrets = new Hashtable();
    }

    public void onResetGadgetSSAction(HttpServletRequest req) throws GadgetInstanceException {
        this.removeSecret();
    }

    @Override
    public boolean usesSecretStore() {
        return this.usesSecretStore;
    }
}

