/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.gadgetManager;

import com.novell.nps.debug.Debug;
import com.novell.nps.gadgetManager.BaseSSGadgetInstance;
import com.novell.nps.gadgetManager.GadgetInstance;
import com.novell.nps.gadgetManager.GadgetInstanceException;
import com.novell.nps.gadgetManager.GadgetParamInfo;
import com.novell.nps.gadgetManager.GadgetTabInfo;
import com.novell.nps.gadgetManager.ResourceSetMap;
import com.novell.nps.gadgetManager.StylesheetSet;
import com.novell.nps.gadgetManager.StylesheetSetMap;
import com.novell.nps.gadgetManager.XmlUtil;
import java.io.BufferedWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.w3c.dom.Document;

public abstract class BaseTabGadgetInstance
extends BaseSSGadgetInstance {
    private static final String BASE_TAG = "com.novell.nps.gadgetManager.BaseTabGadgetInstance.BaseItem";
    private static final String CONTENT_TAG = "com.novell.nps.gadgetManager.BaseTabGadgetInstance.Content";
    private static final String FOOTER_TAG = "com.novell.nps.gadgetManager.BaseTabGadgetInstance.FOOTER";
    private static final String HEADER_TAG = "com.novell.nps.gadgetManager.BaseTabGadgetInstance.HEADER";
    private int currentSelection = 0;
    private String width = "";
    private String height = "";
    private Hashtable m_htTabState = new Hashtable();

    public BaseTabGadgetInstance() {
        this.addActionListener(this, "DOTAB");
    }

    @Override
    public synchronized void init(String[] args) {
        super.init(args);
    }

    public void getTabData(HttpServletRequest req, BufferedWriter out, Document domTree) throws GadgetInstanceException {
        this.printTabStartXML(req, out, domTree);
        this.getCurrentData(req, out, domTree);
        this.printTabEndXML(req, out, domTree);
    }

    @Override
    public void getData(HttpServletRequest req, BufferedWriter out, Document domTree) throws GadgetInstanceException {
        this.getTabData(req, out, domTree);
    }

    @Override
    public void processRequest(HttpServletRequest req) throws GadgetInstanceException {
        try {
            if (req.getParameter("WIDTH") != null) {
                this.width = req.getParameter("WIDTH");
            }
            if (req.getParameter("HEIGHT") != null) {
                this.height = req.getParameter("HEIGHT");
            }
            this.setCurrentTab(req);
            this.processCurrentTabAction(req);
            this.formPostProcessing(req);
        }
        catch (Exception e) {
            throw new GadgetInstanceException("I/O Error");
        }
    }

    @Override
    public void getStylesheetAndResourceSets(HttpServletRequest req, StylesheetSetMap ssMap, ResourceSetMap rsMap) {
        super.getStylesheetAndResourceSets(req, ssMap, rsMap);
        StylesheetSet stylesheetSet = new StylesheetSet("com.novell.nps.gadgetManager.BaseTabGadgetInstance");
        stylesheetSet.add("tabGadget.xsl");
        stylesheetSet.add("tabGadget_lang.xsl");
        ssMap.put(stylesheetSet.getLocator(), stylesheetSet);
    }

    public void onDOTABAction(HttpServletRequest req) throws GadgetInstanceException {
        this.processRequest(req);
    }

    public void printTabStartXML(HttpServletRequest req, BufferedWriter out, Document domTree) throws GadgetInstanceException {
        try {
            String sHeader;
            GadgetTabInfo currentTab = this.getTabInfo(this.getCurrentTab());
            XmlUtil.writeTag("ITEMNAME", this.getItemName(req), out);
            XmlUtil.writeStartTag(BASE_TAG, out);
            String gid = this.getGadgetInstanceID();
            XmlUtil.writeTag("FORMID", "formItem" + gid.substring(gid.length() - 8), out);
            XmlUtil.writeTag("HEIGHT", this.height, out);
            XmlUtil.writeTag("WIDTH", this.width, out);
            boolean bDisplayTabs = this.displayTabs(req);
            if (bDisplayTabs) {
                this.writeTabs(out);
                XmlUtil.writeTag("SHOWTABS", "true", out);
            }
            XmlUtil.writeStartTag("CURRENTPAGE", out);
            this.writeTabTag(this.getTabInfo(this.getCurrentTab()), this.getCurrentTab(), out, false);
            XmlUtil.writeEndTag("CURRENTPAGE", out);
            XmlUtil.writeTag("FULLPAGE", new Boolean(this.isFullPage()).toString(), out);
            if (currentTab.usesHeader && bDisplayTabs && (sHeader = this.getHeaderXML(req)) != null) {
                XmlUtil.writeTag(HEADER_TAG, sHeader, out);
            }
            if (currentTab.usesFooter && bDisplayTabs) {
                XmlUtil.writeTag(FOOTER_TAG, this.getFooterXML(req), out);
            }
            XmlUtil.writeStartTag(CONTENT_TAG, out);
        }
        catch (IOException io) {
            throw new GadgetInstanceException("I/O Error");
        }
    }

    public void getCurrentData(HttpServletRequest req, BufferedWriter out, Document domTree) throws GadgetInstanceException {
        GadgetTabInfo currentTab = this.getTabInfo(this.getCurrentTab());
        String tabState = this.getTabState(currentTab.functionName);
        String function = "get" + currentTab.functionName + tabState + "DataXML";
        GadgetParamInfo[] params = new GadgetParamInfo[]{new GadgetParamInfo("javax.servlet.http.HttpServletRequest", req), new GadgetParamInfo("java.io.BufferedWriter", out), new GadgetParamInfo("org.w3c.dom.Document", domTree)};
        BaseTabGadgetInstance.invokeMethod(this, function, params);
    }

    public void processCurrentTabAction(HttpServletRequest req) throws GadgetInstanceException {
        String action = req.getParameter("TABACTION");
        if (action != null) {
            String function = "process" + action + "TabAction";
            GadgetParamInfo[] params = new GadgetParamInfo[]{new GadgetParamInfo("javax.servlet.http.HttpServletRequest", req)};
            BaseTabGadgetInstance.invokeMethod(this, function, params);
        }
    }

    public void printTabEndXML(HttpServletRequest req, BufferedWriter out, Document domTree) throws GadgetInstanceException {
        try {
            XmlUtil.writeEndTag(CONTENT_TAG, out);
            XmlUtil.writeEndTag(BASE_TAG, out);
        }
        catch (IOException io) {
            throw new GadgetInstanceException("I/O Error");
        }
    }

    protected static Object invokeMethod(GadgetInstance gInst, String functionName, GadgetParamInfo[] params) {
        Method method = null;
        Class[] args = new Class[params.length];
        try {
            for (int i = 0; i < params.length; ++i) {
                args[i] = Class.forName(params[i].paramName);
            }
            method = gInst.getClass().getMethod(functionName, args);
            Object[] objects = new Object[params.length];
            for (int i = 0; i < params.length; ++i) {
                objects[i] = params[i].param;
            }
            return method.invoke((Object)gInst, objects);
        }
        catch (Exception e) {
            Debug.log("TabGadget: Couldn't get " + functionName + " for " + gInst.getGadgetAssignment().getAssignmentName() + "because of excecption:" + e.getLocalizedMessage(), 2, e);
            return null;
        }
    }

    public void setCurrentTab(HttpServletRequest req) {
        String tabID = req.getParameter("TabGadgetState");
        if (tabID != null && !tabID.equals("")) {
            this.currentSelection = new Integer(tabID);
        }
    }

    public void setCurrentTab(String tabName) {
        if (tabName == null) {
            return;
        }
        Vector tabInfos = this.getTabList();
        for (int i = 0; i < tabInfos.size(); ++i) {
            GadgetTabInfo tempTab = (GadgetTabInfo)tabInfos.elementAt(i);
            if (!tempTab.viewName.equals(tabName)) continue;
            this.currentSelection = i;
            break;
        }
    }

    public void setCurrentTab(int tab) {
        this.currentSelection = tab;
    }

    public int getCurrentTab() {
        return this.currentSelection;
    }

    public String getCurrentTabName() {
        GadgetTabInfo currentTab = this.getTabInfo(this.getCurrentTab());
        return currentTab.viewName;
    }

    public void writeTabs(BufferedWriter out) throws GadgetInstanceException {
        int i;
        int totalTabs;
        Vector tablist = this.getTabList();
        int currentSize = totalTabs = tablist.size();
        int firstSkip = 0;
        int lastSkip = 0;
        for (i = 0; i < totalTabs; ++i) {
            ((GadgetTabInfo)tablist.elementAt((int)i)).colspan = 1;
        }
        if (totalTabs > 5) {
            currentSize = totalTabs % 5;
            if (currentSize == 0) {
                currentSize = 5;
            } else if (currentSize == 1) {
                currentSize = 6;
            }
            if (currentSize > 5) {
                for (int j = totalTabs - currentSize; j > 0; j -= 5) {
                    ((GadgetTabInfo)tablist.elementAt((int)(j - 1))).colspan = 3;
                }
            } else if (currentSize == 4) {
                ((GadgetTabInfo)tablist.elementAt((int)(totalTabs - 1))).colspan = 3;
            } else if (currentSize == 3) {
                ((GadgetTabInfo)tablist.elementAt((int)(totalTabs - 1))).colspan = 3;
                ((GadgetTabInfo)tablist.elementAt((int)(totalTabs - 2))).colspan = 3;
            } else if (currentSize == 2) {
                ((GadgetTabInfo)tablist.elementAt((int)(totalTabs - 1))).colspan = 5;
                ((GadgetTabInfo)tablist.elementAt((int)(totalTabs - 2))).colspan = 3;
            }
        }
        try {
            while (totalTabs > 0) {
                int firstTab = totalTabs - currentSize;
                int lastTab = totalTabs;
                if (tablist.size() > 5 && firstTab > 0 && this.currentSelection >= firstTab && this.currentSelection < lastTab) {
                    firstSkip = firstTab;
                    lastSkip = lastTab;
                    totalTabs -= currentSize;
                    currentSize = 5;
                    continue;
                }
                out.write("<TABROW>");
                for (int i2 = firstTab; i2 < lastTab; ++i2) {
                    if (!this.showTab(i2)) continue;
                    boolean bNewRow = false;
                    if (i2 == firstTab && tablist.size() > 5) {
                        bNewRow = true;
                    }
                    this.writeTabTag((GadgetTabInfo)tablist.elementAt(i2), i2, out, bNewRow);
                }
                out.write("</TABROW>");
                totalTabs -= currentSize;
                currentSize = 5;
            }
            if (firstSkip != 0) {
                out.write("<TABROW>");
                for (i = firstSkip; i < lastSkip; ++i) {
                    if (!this.showTab(i)) continue;
                    this.writeTabTag((GadgetTabInfo)tablist.elementAt(i), i, out, false);
                }
                out.write("</TABROW>");
            }
        }
        catch (IOException io) {
            Debug.log("BaseTabGadgetInstance", io);
        }
    }

    public void writeTabTag(GadgetTabInfo currentTab, int position, BufferedWriter out, boolean bNewRow) {
        try {
            out.write("<TAB>");
            out.write("<NAME>" + currentTab.viewName + "</NAME>");
            out.write("<STATE>" + position + "</STATE>");
            out.write("<VISIBLE>" + this.showTab(position) + "</VISIBLE>");
            out.write("<COLS>" + currentTab.colspan + "</COLS>");
            if (bNewRow) {
                out.write("<NEWROW>y</NEWROW>");
            }
            if (position == this.currentSelection) {
                out.write("<SELECTED>y</SELECTED>");
                out.write("<ACTION>" + currentTab.functionName + "</ACTION>");
            }
            out.write("</TAB>");
        }
        catch (IOException io) {
            Debug.log("BaseTabGadgetInstance", io);
        }
    }

    public GadgetTabInfo getTabInfo(int tabID) {
        Vector tablist = this.getTabList();
        return (GadgetTabInfo)tablist.elementAt(tabID);
    }

    public Vector getTabList() {
        Vector<GadgetTabInfo> vTabs = new Vector<GadgetTabInfo>();
        vTabs.add(new GadgetTabInfo("General", "General"));
        return vTabs;
    }

    public boolean showTab(int tabNumber) {
        GadgetTabInfo currentTab = this.getTabInfo(tabNumber);
        return currentTab.isVisibleAsTab;
    }

    protected String getHeaderXML(HttpServletRequest req) {
        StringBuffer out = new StringBuffer();
        String itemName = this.getItemName(req);
        if (itemName != null && itemName.length() > 0) {
            XmlUtil.writeStartTag("com.novell.nps.gadgetManager.BaseTabGadgetInstance.HeaderXML", out);
            XmlUtil.writeCDataTag("ItemName", itemName, out);
            XmlUtil.writeEndTag("com.novell.nps.gadgetManager.BaseTabGadgetInstance.HeaderXML", out);
            return out.toString();
        }
        return null;
    }

    protected String getFooterXML(HttpServletRequest req) {
        StringBuffer out = new StringBuffer();
        XmlUtil.writeTag("com.novell.nps.gadgetManager.BaseTabGadgetInstance.FooterXML", "", out);
        return out.toString();
    }

    public boolean isFullPage() {
        return true;
    }

    protected void formPostProcessing(HttpServletRequest req) {
    }

    public boolean displayTabs(HttpServletRequest req) {
        GadgetTabInfo currentTab = this.getTabInfo(this.getCurrentTab());
        return currentTab.showTabs;
    }

    public String getItemName(HttpServletRequest req) {
        return "Base Item";
    }

    public void setTabState(String tabName, String tabState) {
        if (tabName != null && tabState != null) {
            this.m_htTabState.put(tabName, tabState);
        }
    }

    public String getTabState(String tabName) {
        if (this.m_htTabState.get(tabName) != null) {
            return (String)this.m_htTabState.get(tabName);
        }
        return "";
    }
}

