/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.gadgetManager;

import com.novell.emframe.dev.MTask;
import com.novell.emframe.fw.MTaskWrapper;
import com.novell.nps.configManager.ConfigManager;
import com.novell.nps.configManager.GadgetAssignment;
import com.novell.nps.configManager.GadgetConfig;
import com.novell.nps.debug.Debug;
import com.novell.nps.event.GadgetCreateFailureClassNotFoundEvent;
import com.novell.nps.event.GadgetCreateFailureIllegalAccessEvent;
import com.novell.nps.event.GadgetCreateFailureInstantiationEvent;
import com.novell.nps.event.PortalEventManager;
import com.novell.nps.gadgetManager.Gadget;
import com.novell.nps.gadgetManager.GadgetInstance;
import com.novell.nps.gadgetManager.GadgetManager;
import com.novell.nps.i18n.ResourceFileMap;
import com.novell.nps.sessionManager.PortalSession;
import java.util.Collection;
import java.util.Locale;

public class DefaultGadgetImpl
implements Gadget {
    private String theGadgetDN = null;

    @Override
    public GadgetInstance createGadgetInstance(GadgetAssignment gadgetAssign, PortalSession session) {
        GadgetInstance gadgetInstance = null;
        String gadgetInstanceClass = gadgetAssign.getGadgetInstanceClass();
        String[] gadgetInstanceArgs = gadgetAssign.getGadgetInstanceArgs();
        String dn = gadgetAssign.getGadgetDN();
        if (null == gadgetInstanceClass) {
            if (dn != null) {
                if (dn.equals("System.GadgetManagerMainPageGadgetInstanceClass")) {
                    gadgetInstanceClass = ConfigManager.getSingleSetting("System.GadgetManagerMainPageGadgetInstanceClass", "com.novell.emframe.fw.Startup");
                    gadgetInstanceArgs = ConfigManager.getSetting("System.GadgetManagerMainPageGadgetInstanceArgs");
                } else if (dn.equals("System.GadgetManagerInheritableAreaGadgetInstanceClass")) {
                    gadgetInstanceClass = ConfigManager.getSingleSetting("System.GadgetManagerInheritableAreaGadgetInstanceClass", "com.novell.nps.gadgetManager.InheritableAreaGadget");
                    gadgetInstanceArgs = ConfigManager.getSetting("System.GadgetManagerInheritableAreaGadgetInstanceArgs");
                } else if (dn.equals("System.ObjectSchemeGadgetInstanceClass")) {
                    gadgetInstanceClass = ConfigManager.getSingleSetting("System.ObjectSchemeGadgetInstanceClass", "com.novell.nps.gadgetManager.ObjectSchemeGadget");
                    gadgetInstanceArgs = gadgetAssign.getGadgetInstanceArgs();
                } else {
                    gadgetInstanceClass = gadgetAssign.getGadgetInstanceClass();
                    gadgetInstanceArgs = gadgetAssign.getGadgetInstanceArgs();
                }
            } else {
                gadgetInstanceClass = gadgetAssign.getGadgetInstanceClass();
                gadgetInstanceArgs = gadgetAssign.getGadgetInstanceArgs();
            }
        }
        if (null != gadgetInstanceClass) {
            try {
                gadgetInstance = DefaultGadgetImpl.createGadgetInstance(gadgetInstanceClass);
                if (gadgetInstance != null) {
                    gadgetInstance.setGadgetAssignment(gadgetAssign);
                    gadgetInstance.setSession(session);
                    this.setupLocale(gadgetInstance);
                    String gadgetInstanceID = GadgetManager.createGadgetInstanceID(gadgetInstance, session);
                    gadgetInstance.setGadgetInstanceID(gadgetInstanceID);
                    gadgetInstance.init(gadgetInstanceArgs);
                    gadgetInstance.addActionListener(gadgetInstance, "Configurable");
                    gadgetInstance.addActionListener(gadgetInstance, "ShowUserConfig");
                    gadgetInstance.addActionListener(gadgetInstance, "UserConfigComplete");
                }
            }
            catch (ClassNotFoundException e) {
                Debug.log(1, "DefaultGadgetImpl", e.getLocalizedMessage());
                PortalEventManager.postEvent(new GadgetCreateFailureClassNotFoundEvent(dn));
            }
            catch (InstantiationException e) {
                Debug.log(1, "DefaultGadgetImpl", e.getLocalizedMessage());
                PortalEventManager.postEvent(new GadgetCreateFailureInstantiationEvent(dn));
            }
            catch (IllegalAccessException e) {
                Debug.log(1, "DefaultGadgetImpl", e.getLocalizedMessage());
                PortalEventManager.postEvent(new GadgetCreateFailureIllegalAccessEvent(dn));
            }
            catch (Exception e) {
                Debug.log("DefaultGadgetImpl", 1, e);
            }
            catch (Throwable e) {
                Debug.log("DefaultGadgetImpl", 1, e);
            }
        }
        return gadgetInstance;
    }

    private void setupLocale(GadgetInstance gadgetInstance) {
        Locale[] userLocales;
        PortalSession session;
        boolean bLocaleSet = false;
        if (gadgetInstance != null && (session = gadgetInstance.getSession()) != null && (userLocales = session.getLocales()) != null && userLocales.length > 0) {
            ResourceFileMap rfm = null;
            rfm = GadgetManager.getGadgetResourceFileMap(gadgetInstance);
            if (rfm == null) {
                rfm = GadgetManager.getSystemResourceFileMap();
            }
            if (rfm != null) {
                Collection availableLocales = rfm.getAvailableLocales();
                for (int i = 0; i < userLocales.length; ++i) {
                    Locale tempLocale;
                    if (availableLocales.contains(userLocales[i])) {
                        gadgetInstance.setLocale(userLocales[i]);
                        bLocaleSet = true;
                        break;
                    }
                    String countryStr = userLocales[i].getCountry();
                    if (countryStr == null || countryStr.length() <= 0 || !availableLocales.contains(tempLocale = new Locale(userLocales[i].getLanguage(), ""))) continue;
                    gadgetInstance.setLocale(tempLocale);
                    bLocaleSet = true;
                    break;
                }
            }
        }
        if (!bLocaleSet) {
            gadgetInstance.setLocale(new Locale("en", ""));
        }
    }

    @Override
    public void init(GadgetConfig gadgetConfig) {
    }

    @Override
    public String getGadgetDN() {
        return this.theGadgetDN;
    }

    @Override
    public void setGadgetDN(String gadgetDN) {
        this.theGadgetDN = gadgetDN;
    }

    private static GadgetInstance createGadgetInstance(String gadgetInstanceClass) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> newClass = null;
        try {
            newClass = DefaultGadgetImpl.class.getClassLoader().loadClass(gadgetInstanceClass);
        }
        catch (ClassNotFoundException ex) {
            throw new ClassNotFoundException(gadgetInstanceClass);
        }
        Object object = newClass.newInstance();
        if (object instanceof MTask) {
            return new MTaskWrapper((MTask)object);
        }
        return (GadgetInstance)object;
    }
}

