/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.gadgetManager;

import com.novell.nps.debug.Debug;
import com.novell.nps.gadgetManager.BaseGadgetInstance;
import com.novell.nps.gadgetManager.GadgetInstanceException;
import com.novell.nps.i18n.ResourceFileManager;
import com.novell.nps.i18n.ResourceFileMap;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.w3c.dom.Document;

public class DeviceSwitcher
extends BaseGadgetInstance {
    public static final String DT = "DeviceSwitcher";
    public static final String PARAM_DEVICE_NAME = "name";
    public static final String ACTION_SET_DEVICE = "setDevice";
    public static final String STATE_NORMAL = "normal";

    @Override
    public void init(String[] initArgs) {
        this.setState(STATE_NORMAL);
        this.addActionListener(this, ACTION_SET_DEVICE);
    }

    public void getNormalData(HttpServletRequest req, BufferedWriter out, Document domDocument) throws GadgetInstanceException {
        this.getData(req, out, domDocument);
    }

    public void getnormalData(HttpServletRequest req, BufferedWriter out, Document domDocument) throws GadgetInstanceException {
        this.getData(req, out, domDocument);
    }

    @Override
    public void getData(HttpServletRequest req, BufferedWriter out, Document domDocument) throws GadgetInstanceException {
        try {
            this.writeGadgetXMLStartTagWithState(out);
            this.writeGadgetXMLEndTag(out);
        }
        catch (IOException e) {
            throw new GadgetInstanceException(e.getLocalizedMessage());
        }
    }

    public void writeGadgetXMLStartTagWithState(BufferedWriter out) throws IOException {
        StringBuffer xmlTag = new StringBuffer();
        xmlTag.append("<");
        xmlTag.append(this.getClass().getName());
        String state = this.getState();
        if (state != null) {
            xmlTag.append(" state=\"");
            xmlTag.append(state);
            xmlTag.append("\"");
        }
        xmlTag.append(">");
        out.write(xmlTag.toString());
    }

    public void onSetDevice(HttpServletRequest req) throws GadgetInstanceException {
        String deviceName = req.getParameter(PARAM_DEVICE_NAME);
        if (deviceName != null && deviceName.equalsIgnoreCase("RESETDEVICESETTINGS")) {
            this.session.setAttribute("DEVICE_TYPE", "default");
            this.session.setAttribute("DeviceType", "default");
            String value = req.getHeader("User-Agent");
            if (value == null) {
                value = req.getHeader("user-agent");
            }
            if (value != null) {
                this.session.setAttribute("Browser.id", value);
                this.session.setDeviceType(value);
            }
        } else if (deviceName != null && this.isValidDevice(deviceName)) {
            this.session.setAttribute("DEVICE_TYPE", deviceName);
            this.session.setAttribute("DeviceType", deviceName);
        } else if (Debug.isLoggable(1)) {
            Debug.log(DT, "The device specified (" + deviceName + ") is not a valid device available to the portal.");
        }
    }

    @Override
    public void processRequest(HttpServletRequest req) throws GadgetInstanceException {
        this.onSetDevice(req);
    }

    private boolean isValidDevice(String deviceName) {
        Collection systemDevices;
        ResourceFileMap rfm = ResourceFileManager.getSystemResourceFileMap();
        return rfm != null && (systemDevices = rfm.getAvailableDevices()) != null && systemDevices.contains(deviceName);
    }
}

