/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.gadgetManager;

import com.novell.emframe.dev.D;
import com.novell.emframe.fw.CloseWindowTask;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.legacySupport.LegacyTask;
import com.novell.emframe.fw.legacySupport.LegacyTaskImpl;
import com.novell.nps.PortalException;
import com.novell.nps.configManager.GadgetAssignment;
import com.novell.nps.gadgetManager.BaseGadgetInstance;
import com.novell.nps.gadgetManager.GadgetInstance;
import com.novell.nps.gadgetManager.GadgetInstanceException;
import com.novell.nps.gadgetManager.GadgetManager;
import com.novell.nps.gadgetManager.ResourceSetMap;
import com.novell.nps.gadgetManager.StylesheetSetMap;
import com.novell.nps.gadgetManager.XmlUtil;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.w3c.dom.Document;

public class LaunchService
extends LegacyTaskImpl {
    private boolean m_bReturnFrameLevelsURL = false;
    GadgetInstance m_proxyRedirect = null;

    public void init(String[] args) {
        super.init(args);
        this.addActionListener((Object)this, "Launch");
        this.addActionListener((Object)this, "Delegate");
        this.addActionListener((Object)this, "ReturnFromDelegate");
        this.addActionListener((Object)this, "ReturnFromLaunch");
        this.addActionListener((Object)this, "Return");
        this.addActionListener((Object)this, "CompleteReturn");
    }

    public void onDelegateAction(HttpServletRequest req) {
        GadgetInstance delegator = null;
        String delegateID = req.getParameter("delegate");
        String delegatorID = req.getParameter("launcher");
        String lifecycleMode = req.getParameter("lifecycle");
        String repeatable = req.getParameter("repeatable");
        int iLifecycleMode = this.getLifecycleTypeFromString(lifecycleMode);
        delegator = GadgetManager.getExactGadgetInstance(delegatorID, this.session);
        if (delegator != null) {
            if (!delegatorID.equalsIgnoreCase(delegator.getGadgetInstanceID())) {
                delegator = this.iterativeReturnToPrimary(req, delegator, delegatorID);
            }
            try {
                this.setProxyRedirect(GadgetManager.delegateToGadget(delegator, this.session, req, delegateID, iLifecycleMode), req);
                if (repeatable != null && repeatable.equals("true")) {
                    Map repeatParams = req.getParameterMap();
                    if (req.getParameter("OS.ReturningToAnchor") != null) {
                        this.removeOSParams(repeatParams);
                    }
                    this.m_proxyRedirect.setRepeatParams(repeatParams);
                }
            }
            catch (PortalException ex) {
                D.log((Throwable)ex);
            }
            catch (Throwable t) {
                D.log((Throwable)t);
            }
        } else {
            delegator = GadgetManager.getErrorService(this.session, delegatorID);
            this.setProxyRedirect(delegator, req);
        }
    }

    private GadgetInstance iterativeReturnToPrimary(HttpServletRequest req, GadgetInstance secondary, String returnID) {
        do {
            if (secondary.getLaunchType() != 2) {
                GadgetManager.returnToLauncher(secondary, "cancel_abort", null, req);
            } else {
                GadgetManager.returnToDelegator(secondary, "cancel_abort", null, req, true);
            }
            if (returnID.equalsIgnoreCase(secondary.getGadgetInstanceID()) || secondary.getPrimary() == null) break;
            if ((secondary = secondary.getPrimary()).getPrimary() == null) {
                this.setProxyRedirect(secondary, req);
                continue;
            }
            this.setProxyRedirect(secondary.getPrimary(), req);
        } while (!returnID.equalsIgnoreCase(secondary.getGadgetInstanceID()));
        return secondary;
    }

    public void onLaunchAction(HttpServletRequest req) {
        GadgetInstance launcher = null;
        String launchID = req.getParameter("launch");
        String launcherID = req.getParameter("launcher");
        String lifecycleMode = req.getParameter("lifecycle");
        String returnUrl = req.getParameter("returnUrl");
        int iLifecycleMode = this.getLifecycleTypeFromString(lifecycleMode);
        launcher = GadgetManager.getExactGadgetInstance(launcherID, this.session);
        if (launcher != null && returnUrl != null && launcher instanceof CloseWindowTask) {
            ((CloseWindowTask)launcher).setReturnUrl(returnUrl);
        }
        if (!launcherID.equalsIgnoreCase(launcher.getGadgetInstanceID())) {
            launcher = this.iterativeReturnToPrimary(req, launcher, launcherID);
        }
        String repeatable = req.getParameter("repeatable");
        if (launcher != null) {
            try {
                this.setProxyRedirect(GadgetManager.launchGadget(launcher, this.session, req, launchID, iLifecycleMode), req);
                if (repeatable != null && repeatable.equals("true")) {
                    Map repeatParams = req.getParameterMap();
                    if (req.getParameter("OS.ReturningToAnchor") != null) {
                        this.removeOSParams(repeatParams);
                    }
                    this.m_proxyRedirect.setRepeatParams(repeatParams);
                }
            }
            catch (PortalException ex) {
                D.log((Throwable)ex);
            }
        } else {
            launcher = GadgetManager.getErrorService(this.session, launcherID);
            this.setProxyRedirect(launcher, req);
        }
    }

    private void removeOSParams(Map repeatParams) {
        Set paramNames = repeatParams.keySet();
        ArrayList<String> osParamsList = new ArrayList<String>();
        for (String paramName : paramNames) {
            if (paramName == null || !paramName.startsWith("OS.")) continue;
            osParamsList.add(paramName);
        }
        for (String paramName : osParamsList) {
            repeatParams.remove(paramName);
        }
    }

    int getLifecycleTypeFromString(String lifecycleType) {
        if (lifecycleType == null || lifecycleType.length() == 0) {
            return 5;
        }
        if (lifecycleType.equals("New")) {
            return 1;
        }
        if (lifecycleType.equals("Reuse")) {
            return 2;
        }
        if (lifecycleType.equals("Reset")) {
            return 3;
        }
        if (lifecycleType.equals("Existing")) {
            return 4;
        }
        return 5;
    }

    public void onReturnFromDelegateAction(HttpServletRequest req) throws GadgetInstanceException {
        String sLevels;
        String returnID = req.getParameter("returnID");
        GadgetInstance secondary = GadgetManager.getExactGadgetInstance(returnID, this.session);
        if (secondary != null) {
            this.setProxyRedirect(secondary.getPrimary(), req);
            if (this.m_proxyRedirect != null) {
                GadgetManager.returnToDelegator(secondary, req.getParameter("return"), null, req);
            } else {
                this.setProxyRedirect(secondary, req);
            }
        }
        if ((sLevels = req.getParameter("Task.frameLevel")) != null && sLevels.length() != 0) {
            LaunchService.redirectForFrameLevel(req, (BaseGadgetInstance)((Object)this), this.m_proxyRedirect.getGadgetInstanceID());
            this.m_bReturnFrameLevelsURL = true;
            this.setProxyRedirect(null, req);
        }
        if (this.m_proxyRedirect != null) {
            this.m_proxyRedirect.getRedirectionOrSelf().processRequest(req);
        }
    }

    static void redirectForFrameLevel(HttpServletRequest req, BaseGadgetInstance gadgetInstance, String taskId) {
        StringBuffer sb = new StringBuffer(200);
        sb.append(req.getContextPath());
        sb.append(req.getServletPath());
        sb.append("?");
        sb.append("taskId");
        sb.append("=");
        sb.append(taskId);
        req.setAttribute("GoPostUrl_action", (Object)sb.toString());
        Properties params = new Properties();
        Enumeration myenum = req.getParameterNames();
        String sParameterName = null;
        if (myenum != null) {
            while (myenum.hasMoreElements()) {
                String[] saValues;
                sParameterName = (String)myenum.nextElement();
                if (sParameterName.equalsIgnoreCase("GI_ID") || sParameterName.equalsIgnoreCase("NPService") || sParameterName.equalsIgnoreCase("taskId") || sParameterName.equalsIgnoreCase("NPAction") || sParameterName.equalsIgnoreCase("NPState") || sParameterName.equalsIgnoreCase("returnID") || (saValues = req.getParameterValues(sParameterName)) == null || saValues.length <= 0) continue;
                params.put(sParameterName, saValues);
            }
        }
        gadgetInstance.setModuleStylesheet("fw/GoPostUrl.jsp");
        req.setAttribute("GoPostUrl_params", (Object)params);
        req.setAttribute("GoPostUrl_keys", params.keys());
    }

    public void onReturnFromLaunchAction(HttpServletRequest req) throws GadgetInstanceException {
        String returnID = req.getParameter("returnID");
        GadgetInstance secondary = GadgetManager.getExactGadgetInstance(returnID, this.session);
        if (secondary != null) {
            this.setProxyRedirect(secondary.getPrimary(), req);
            if (this.m_proxyRedirect != null) {
                GadgetManager.returnToLauncher(secondary, req.getParameter("return"), null, req);
            } else {
                this.setProxyRedirect(secondary, req);
                this.m_proxyRedirect.getRedirectionOrSelf().processRequest(req);
            }
        }
    }

    public void onReturnAction(HttpServletRequest req) throws GadgetInstanceException {
        String returnID = req.getParameter("returnID");
        GadgetInstance secondary = GadgetManager.getExactGadgetInstance(returnID, this.session);
        if (secondary != null) {
            if (secondary.getLaunchType() == 2) {
                this.onReturnFromDelegateAction(req);
            } else {
                this.onReturnFromLaunchAction(req);
            }
            secondary.setRepeatParams(null);
        }
        if (!this.m_bReturnFrameLevelsURL) {
            this.setModuleStylesheet("fw/Close.jsp");
        }
    }

    public void onRepeatAction(HttpServletRequest req) throws GadgetInstanceException {
        String returnID = req.getParameter("returnID");
        GadgetInstance secondary = GadgetManager.getExactGadgetInstance(returnID, this.session);
        this.onReturnAction(req);
        if (secondary.getLaunchType() == 2) {
            this.onDelegateAction(req);
        } else {
            this.onLaunchAction(req);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onCompleteReturnAction(HttpServletRequest req) throws GadgetInstanceException {
        block6: {
            GadgetInstance secondary;
            block11: {
                String returnID;
                block10: {
                    String sLevels;
                    block9: {
                        block8: {
                            block7: {
                                returnID = req.getParameter("returnID");
                                secondary = GadgetManager.getExactGadgetInstance(returnID, this.session);
                                if (secondary == null) break block6;
                                if (secondary.getLaunchType() != 2) break block7;
                                this.setProxyRedirect(secondary.getPrimary(), req);
                                if (this.m_proxyRedirect != null) break block8;
                                this.setProxyRedirect(secondary, req);
                                break block9;
                            }
                            this.setProxyRedirect(secondary.getPrimary(), req);
                            if (this.m_proxyRedirect != null) break block10;
                            this.setProxyRedirect(secondary, req);
                            this.m_proxyRedirect.getRedirectionOrSelf().processRequest(req);
                            break block11;
                        }
                        do {
                            GadgetManager.returnToDelegator(secondary, req.getParameter("return"), null, req);
                            if (returnID.equalsIgnoreCase(secondary.getGadgetInstanceID()) || secondary.getPrimary() == null) break;
                            if ((secondary = secondary.getPrimary()).getPrimary() == null) {
                                this.setProxyRedirect(secondary, req);
                                continue;
                            }
                            this.setProxyRedirect(secondary.getPrimary(), req);
                        } while (!returnID.equalsIgnoreCase(secondary.getGadgetInstanceID()));
                    }
                    if ((sLevels = req.getParameter("Task.frameLevel")) != null && sLevels.length() != 0) {
                        LaunchService.redirectForFrameLevel(req, (BaseGadgetInstance)((Object)this), this.m_proxyRedirect.getGadgetInstanceID());
                        this.m_bReturnFrameLevelsURL = true;
                        this.setProxyRedirect(null, req);
                    }
                    if (this.m_proxyRedirect != null) {
                        this.m_proxyRedirect.getRedirectionOrSelf().processRequest(req);
                    }
                    break block11;
                }
                do {
                    GadgetManager.returnToLauncher(secondary, req.getParameter("return"), null, req);
                    if (returnID.equalsIgnoreCase(secondary.getGadgetInstanceID()) || secondary.getPrimary() == null) break;
                    if ((secondary = secondary.getPrimary()).getPrimary() == null) {
                        this.setProxyRedirect(secondary, req);
                        continue;
                    }
                    this.setProxyRedirect(secondary.getPrimary(), req);
                } while (!returnID.equalsIgnoreCase(secondary.getGadgetInstanceID()));
            }
            secondary.setRepeatParams(null);
        }
    }

    public void callGetData(GadgetInstance gInst, HttpServletRequest instRequest, BufferedWriter out, Document dom) throws GadgetInstanceException {
        if (this.m_proxyRedirect != null && this.m_proxyRedirect != this) {
            GadgetInstance gdgInstance = this.m_proxyRedirect.getRedirectionOrSelf();
            if (gdgInstance instanceof LaunchService && (LaunchService)((Object)gdgInstance) == this) {
                super.callGetData(gInst, instRequest, out, dom);
            } else {
                this.m_proxyRedirect.getRedirectionOrSelf().callGetData(this.m_proxyRedirect.getRedirectionOrSelf(), instRequest, out, dom);
            }
        } else {
            super.callGetData(gInst, instRequest, out, dom);
        }
        this.setProxyRedirect(null, instRequest);
        this.m_bReturnFrameLevelsURL = false;
        this.m_moduleStylesheet = null;
    }

    public void getStylesheetAndResourceSets(HttpServletRequest req, StylesheetSetMap ssMap, ResourceSetMap rsMap) {
        if (this.m_proxyRedirect != null && this.m_proxyRedirect != this) {
            GadgetInstance gdgInstance = this.m_proxyRedirect.getRedirectionOrSelf();
            if (gdgInstance instanceof LaunchService && (LaunchService)((Object)gdgInstance) == this) {
                super.getStylesheetAndResourceSets(req, ssMap, rsMap);
            } else {
                this.m_proxyRedirect.getRedirectionOrSelf().getStylesheetAndResourceSets(req, ssMap, rsMap);
            }
        } else {
            super.getStylesheetAndResourceSets(req, ssMap, rsMap);
        }
    }

    public String getRootDelegator() {
        if (this.m_proxyRedirect != null && this.m_proxyRedirect != this) {
            return this.m_proxyRedirect.getRootDelegator();
        }
        return super.getRootDelegator();
    }

    public void getData(HttpServletRequest req, BufferedWriter out, Document domDocument) throws GadgetInstanceException {
        try {
            if (!this.m_bReturnFrameLevelsURL) {
                XmlUtil.WriteCloseMyWindowTag(out);
            }
        }
        catch (IOException e) {
            throw new GadgetInstanceException(e.getLocalizedMessage());
        }
    }

    public String getPreferredDataType() {
        if (this.m_proxyRedirect != null && this.m_proxyRedirect != this) {
            GadgetInstance gdgInstance = this.m_proxyRedirect.getRedirectionOrSelf();
            if (gdgInstance instanceof LaunchService && (LaunchService)((Object)gdgInstance) == this) {
                return super.getPreferredDataType();
            }
            return this.m_proxyRedirect.getRedirectionOrSelf().getPreferredDataType();
        }
        return super.getPreferredDataType();
    }

    public void setRequestedDataType(String sDataType) {
        if (this.m_proxyRedirect != null && this.m_proxyRedirect != this) {
            GadgetInstance gdgInstance = this.m_proxyRedirect.getRedirectionOrSelf();
            if (gdgInstance instanceof LaunchService && (LaunchService)((Object)gdgInstance) == this) {
                super.setRequestedDataType(sDataType);
            } else {
                this.m_proxyRedirect.getRedirectionOrSelf().setRequestedDataType(sDataType);
            }
        } else {
            super.setRequestedDataType(sDataType);
        }
    }

    public GadgetAssignment getGadgetAssignment() {
        if (this.m_proxyRedirect != null && this.m_proxyRedirect != this) {
            GadgetInstance gdgInstance = this.m_proxyRedirect.getRedirectionOrSelf();
            if (gdgInstance instanceof LaunchService && (LaunchService)((Object)gdgInstance) == this) {
                return this.gadgetAssignment;
            }
            return this.m_proxyRedirect.getRedirectionOrSelf().getGadgetAssignment();
        }
        return this.gadgetAssignment;
    }

    private void setProxyRedirect(GadgetInstance task, HttpServletRequest req) {
        this.m_proxyRedirect = task;
        FwUtils.resetBGI((LegacyTask)((LegacyTask)task), (HttpServletRequest)req);
    }
}

