/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.logging.logBeans;

import com.novell.emframe.fw.FwUtils;
import com.novell.nps.event.PortalEvent;
import com.novell.nps.event.PortalEventListener;
import com.novell.nps.event.PortalEventManager;
import com.novell.nps.event.PortalLoginEvent;
import com.novell.nps.event.PortalLogoutEvent;
import com.novell.nps.logging.logBeans.PortalLogBean;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import java.util.Hashtable;
import javax.servlet.http.HttpSession;

public class PortalLoggingLogLoginBean
extends PortalLogBean
implements Serializable {
    private transient Hashtable loggedInUsers;
    private static String m_sFile = "PortalLog.xml";
    private static File m_fLog = null;
    private static PrintWriter m_p = null;
    private static String[] PortalLoginEvents = new String[]{"com.novell.nps.event.PortalLoginEvent", "com.novell.nps.event.PortalLogoutEvent"};

    public PortalLoggingLogLoginBean() {
        this.init();
    }

    @Override
    public void init() {
        PortalEventManager.registerEventListener((PortalEventListener)this, PortalLoginEvents);
        this.loggedInUsers = new Hashtable();
        super.init();
        m_sFile = this.getLogFile();
        m_p = PortalLoggingLogLoginBean.getPrintWriter(m_sFile);
    }

    @Override
    public void refreshSettings() {
        super.init();
        m_sFile = this.getLogFile();
        m_p = PortalLoggingLogLoginBean.getPrintWriter(m_sFile);
    }

    @Override
    public void shutdown() {
        PortalEventManager.unRegisterEventListener((PortalEventListener)this, PortalLoginEvents);
    }

    protected void writeLoginEvent(PortalLoginEvent loginEvent) {
        Date dt = new Date();
        Long currentDate = new Long(dt.getTime());
        String currentDateString = currentDate.toString();
        DateFormat df = DateFormat.getDateTimeInstance(3, 2);
        if (m_p != null) {
            StringBuffer sb = new StringBuffer();
            sb.append("<LogEntry>");
            sb.append("<DateString>");
            sb.append(df.format(dt));
            sb.append("</DateString>");
            sb.append("<DateLong>");
            sb.append(currentDateString);
            sb.append("</DateLong>");
            sb.append("<UserName>");
            sb.append(loginEvent.getUserName());
            sb.append("</UserName>");
            sb.append("<Event>");
            sb.append("PortalLoginEvent");
            sb.append("</Event>");
            sb.append("</LogEntry>");
            PortalLoggingLogLoginBean.writeToPrintWriter(m_p, sb.toString());
            m_p.flush();
        }
    }

    protected void writeLogoutEvent(PortalLogoutEvent logoutEvent) {
        String userName;
        long timeLoggedIn;
        Date dt = new Date();
        Long currentDate = new Long(dt.getTime());
        String currentDateString = currentDate.toString();
        DateFormat df = DateFormat.getDateTimeInstance(3, 2);
        UserInfo usrinf = (UserInfo)this.loggedInUsers.get(logoutEvent.getPortalSession().getId());
        if (usrinf != null) {
            Date logindt = usrinf.loginTime;
            long loginDate = logindt.getTime();
            timeLoggedIn = currentDate - loginDate;
            userName = usrinf.userName;
        } else {
            timeLoggedIn = 0L;
            userName = "unknown";
        }
        if (m_p != null) {
            StringBuffer sb = new StringBuffer();
            sb.append("<LogEntry>");
            sb.append("<DateString>");
            sb.append(df.format(dt));
            sb.append("</DateString>");
            sb.append("<DateLong>");
            sb.append(currentDateString);
            sb.append("</DateLong>");
            sb.append("<UserName>");
            sb.append(userName);
            sb.append("</UserName>");
            sb.append("<Event>");
            sb.append("PortalLogoutEvent");
            sb.append("</Event>");
            sb.append("<LoginDuration>");
            sb.append(timeLoggedIn);
            sb.append("</LoginDuration>");
            sb.append("</LogEntry>");
            PortalLoggingLogLoginBean.writeToPrintWriter(m_p, sb.toString());
            m_p.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recordUserLogin(PortalLoginEvent loginEvent) {
        Hashtable hashtable = this.loggedInUsers;
        synchronized (hashtable) {
            this.loggedInUsers.put(loginEvent.getPortalSession().getId(), new UserInfo(loginEvent.getUserName(), FwUtils.getLoginTime((HttpSession)loginEvent.getPortalSession())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recordUserLogout(PortalLogoutEvent logoutEvent) {
        Hashtable hashtable = this.loggedInUsers;
        synchronized (hashtable) {
            this.loggedInUsers.remove(logoutEvent.getPortalSession().getId());
        }
    }

    @Override
    public void onPortalEvent(PortalEvent event) {
        if (event instanceof PortalLoginEvent) {
            this.recordUserLogin((PortalLoginEvent)event);
            this.writeLoginEvent((PortalLoginEvent)event);
        } else if (event instanceof PortalLogoutEvent) {
            this.writeLogoutEvent((PortalLogoutEvent)event);
            this.recordUserLogout((PortalLogoutEvent)event);
        }
    }

    class UserInfo {
        Date loginTime;
        String userName;

        UserInfo(String user, Date lgnTime) {
            this.userName = user;
            this.loginTime = lgnTime;
        }
    }
}

