/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.rendering;

import com.novell.nps.configManager.ConfigManager;
import com.novell.nps.debug.Debug;
import com.novell.nps.rendering.Renderer;
import com.novell.nps.sessionManager.PortalSession;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Stack;
import javax.servlet.http.HttpServletRequest;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class JaxpRendererImpl
implements Renderer {
    private static final int TIMES_SOURCE_PARSE = 0;
    private static final int TIMES_XSL_PARSE = 1;
    private static final int TIMES_COMPILE = 2;
    private static final int TIMES_PROCESS = 3;
    private static final int TIMES_TOTAL = 4;
    private static final int TIMES_ARRAY_SIZE = 5;
    private static final String DONT_CACHE_STYLESHEETS = "System.renderer.DontCacheStylesheets";
    private static final String DT = "JAXP-Renderer";
    private boolean dontCacheStylesheets = false;
    private static final String TIMER_HEADER = "tm1";
    private static final String TIMER_PARSE = "tm2";
    private static final String TIMER_COMPILE = "tm3";
    private static final String TIMER_PROCESS = "tm4";
    private static final String TIMER_TOTAL = "tm5";
    long[] times = new long[5];
    boolean printTimes = true;
    static HashMap stylesheets = new HashMap();

    @Override
    public void resetCacheStylesheets() {
        String dontCacheStylesheetsSetting = ConfigManager.getPortalSetting(DONT_CACHE_STYLESHEETS, "false");
        this.dontCacheStylesheets = "true".equalsIgnoreCase(dontCacheStylesheetsSetting);
    }

    @Override
    public void setPrintTimes(boolean printTimes) {
        this.printTimes = printTimes;
    }

    @Override
    public void clearStylesheetCache() {
        stylesheets.clear();
    }

    public TransformerPool getTransformerPool(String xslFileRelPath, String servletContext) throws IOException, TransformerConfigurationException {
        TransformerPool pool = (TransformerPool)stylesheets.get(xslFileRelPath);
        if (null == pool) {
            pool = this.constructTransformerPool(xslFileRelPath, servletContext);
        }
        return pool;
    }

    @Override
    public void applyStyleSheet(String xmlBuffer, String stylesheetRelPath, String servletContext, OutputStream out, PortalSession session, HttpServletRequest req) {
        String stylesheetURI = servletContext + stylesheetRelPath;
        try {
            if (this.printTimes) {
                for (int i = 0; i < this.times.length; ++i) {
                    this.times[i] = 0L;
                }
            }
            StreamSource source = new StreamSource(servletContext + stylesheetRelPath);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer stylesheet = tf.newTransformer(source);
            StringReader xmlReader = new StringReader(xmlBuffer);
            StreamSource xmlSource = new StreamSource(xmlReader);
            StreamResult outResult = new StreamResult(out);
            stylesheet.transform(xmlSource, outResult);
        }
        catch (TransformerException e) {
            Debug.log(DT, 1, e);
        }
    }

    public void applyStyleSheet(Reader xml, Reader xsl, Writer out) {
    }

    private synchronized TransformerPool constructTransformerPool(String xslFileRelPath, String servletContext) throws IOException, TransformerConfigurationException {
        TransformerPool pool = (TransformerPool)stylesheets.get(xslFileRelPath);
        if (null == pool) {
            StreamSource source = new StreamSource(servletContext + xslFileRelPath);
            TransformerFactory tf = TransformerFactory.newInstance();
            Templates templates = tf.newTemplates(source);
            pool = new TransformerPool(templates, 10, 20);
            if (!this.dontCacheStylesheets) {
                stylesheets.put(xslFileRelPath, pool);
            }
        }
        return pool;
    }

    public static void showMessage(String key, Object[] parms) {
        Debug.log(DT, 3, JaxpRendererImpl.constructMessage(key, parms));
    }

    public static String constructMessage(String key, Object[] parms) {
        ResourceBundle bundle = ResourceBundle.getBundle("com.novell.xsl.nxsl_messages");
        try {
            key = bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
        return parms == null ? key : MessageFormat.format(key, parms);
    }

    class TransformerPool {
        Stack pool = new Stack();
        Templates templates;
        int total;
        int max;

        TransformerPool(Templates templates, int initialSize, int maxSize) throws TransformerConfigurationException {
            this.templates = templates;
            this.max = maxSize;
            for (int i = 0; i < initialSize; ++i) {
                this.pool.push(templates.newTransformer());
                ++this.total;
            }
        }

        Transformer getTransformer() throws TransformerConfigurationException {
            Transformer trans = null;
            while (null == trans) {
                if (!this.pool.isEmpty()) {
                    try {
                        trans = (Transformer)this.pool.pop();
                    }
                    catch (EmptyStackException emptyStackException) {}
                    continue;
                }
                trans = this.templates.newTransformer();
                ++this.total;
            }
            return trans;
        }

        void releaseTransformer(Transformer transformer) {
            this.pool.push(transformer);
        }
    }
}

