/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.runtime.http;

import com.novell.nps.gadgetManager.GadgetManager;
import com.novell.nps.runtime.http.RemoteProvider;
import com.novell.nps.runtime.http.TibcoProvider;
import com.novell.nps.sessionManager.PortalSession;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RemoteManager {
    public static final String REMOTE_PROVIDER = "REMOTE_PROVIDER";

    public static RemoteProvider getRemoteProvider(HttpServletRequest req, PortalSession session) {
        String providerString = req.getParameter(REMOTE_PROVIDER);
        RemoteProvider provider = null;
        if (providerString != null && providerString.equals("TIBCO")) {
            provider = new TibcoProvider();
        }
        if (provider != null) {
            provider.init(session, req);
        }
        return provider;
    }

    public void setSessionProvider(HttpServletRequest req, HttpServletResponse resp, PortalSession session) {
        String providerString = req.getParameter(REMOTE_PROVIDER);
        RemoteProvider provider = null;
        provider = RemoteManager.getRemoteProvider(req, session);
        if (provider != null) {
            session.setAttribute(REMOTE_PROVIDER, new TibcoProvider());
        }
    }

    public void processRequest(HttpServletRequest req, HttpServletResponse resp, PortalSession session, GadgetManager gadgetMan) throws ServletException, IOException {
        this.setSessionProvider(req, resp, session);
        gadgetMan.processRequest(req, resp, session);
    }
}

