/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.runtime.http;

import com.novell.nps.runtime.http.BaseRemoteProvider;
import com.novell.nps.runtime.http.RemoteProvider;
import com.novell.nps.sessionManager.PortalSession;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;

public class TibcoProvider
extends BaseRemoteProvider
implements RemoteProvider {
    public String tunnelURL = null;
    public String thisURL = null;
    public String imageURL = null;
    public String portalProtocol = null;
    public String portalHostname = null;
    public String portalPath = null;
    public String portalQuery = null;
    public int portalPort = 80;
    public String tibcoProtocol = null;
    public String tibcoHostname = null;
    public String tibcoPath = null;
    public String tibcoQuery = null;
    public int tibcoPort = 80;

    @Override
    public void init(PortalSession session, HttpServletRequest req) {
        this.tunnelURL = req.getParameter("TUNNELURL");
        this.portalProtocol = "http";
        this.portalHostname = req.getServerName();
        this.portalPath = req.getContextPath() + req.getServletPath();
        this.portalPort = req.getServerPort();
        this.portalQuery = req.getQueryString();
        if (this.tunnelURL != null) {
            try {
                URL newURL = new URL(this.tunnelURL);
                this.tibcoProtocol = newURL.getProtocol();
                this.tibcoHostname = newURL.getHost();
                this.tibcoPath = newURL.getPath();
                this.tibcoPort = newURL.getPort();
                this.tibcoQuery = newURL.getQuery();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.imageURL = this.portalProtocol + "://" + req.getServerName() + ":" + this.portalPort;
        this.thisURL = this.imageURL + this.portalPath + "?" + "PORTAL_SESSION" + "=" + session.getId();
        if (this.tunnelURL == null) {
            this.tunnelURL = this.thisURL;
            this.tibcoProtocol = this.portalProtocol;
            this.tibcoHostname = this.portalHostname;
            this.tibcoPath = this.portalPath;
            this.tibcoPort = this.portalPort;
        }
    }

    @Override
    public String getImagePath() {
        return this.imageURL;
    }

    @Override
    public String getReturnPath() {
        return this.tunnelURL;
    }

    public String getCustomContentURL() {
        return this.thisURL;
    }

    @Override
    public String getProviderName() {
        return "TIBCO";
    }

    @Override
    public String getPortalPath() {
        return this.portalPath;
    }

    @Override
    public int getPortalPort() {
        return this.portalPort;
    }

    @Override
    public String getPortalHostname() {
        return this.portalHostname;
    }

    @Override
    public String getPortalProtocol() {
        return this.portalProtocol;
    }

    @Override
    public String getRemotePath() {
        return this.tibcoPath;
    }

    @Override
    public int getRemotePort() {
        return this.tibcoPort;
    }

    @Override
    public String getRemoteHostname() {
        return this.tibcoHostname;
    }

    @Override
    public String getRemoteProtocol() {
        return this.tibcoProtocol;
    }

    @Override
    public String getPortalQueryString() {
        return this.portalQuery;
    }

    @Override
    public String getRemoteQueryString() {
        return this.tibcoQuery;
    }
}

