/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.serviceProviders;

import com.novell.emframe.dev.D;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.VersionInfo;
import com.novell.emframe.fw.config.ModuleInfo;
import com.novell.emframe.fw.config.ModuleManager;
import com.novell.nps.serviceProviders.GetManifest;
import com.novell.nps.serviceProviders.ShellCommand;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FwZipOps {
    private static final String SHARED_LIB_DIR = "WEB-INF/lib";
    private static final String SHARED_BIN_DIR = "WEB-INF/bin/windows";
    private static final String SHARED_BIN_PATH = File.separator + "WEB-INF" + File.separator + "bin";
    private static final String DEFAULT_INSTALLER_PATH = SHARED_BIN_PATH + File.separator + "iManagerModuleInstall.jar";
    private static final String DEFAULT_UNINSTALLER = File.separator + "uninstaller.jar";
    private static final String SHARED_LIB_PATH = SHARED_BIN_PATH + File.separator + "ProtectedJarsList";
    private static final String BINARIES_PATH = SHARED_BIN_PATH + File.separator + "ProtectedBinaries";
    private static final String CUSTOM_CONTENT = "portal/modules/custom";
    private static final String JAVA_EXECUTABLE = File.separator + "bin" + File.separator + "java";
    private static final String CUSTOM_PREFIX = "custom";
    private static final String QUOTES = "\"";
    private static final String NO_COMMON_PATH = "no common path for installing NPMs";
    private static final String MIN_IMAN_VERSION = "2.7.0";
    private static final String DT = "FwZipOps";
    private static final char COMMENT_CHAR = '#';
    private static final String COMMAND_CTRLPLATFORM = "Platform:";
    private static final String COMMAND_DEFAULTPLATFORMS = "aix hpux linux netware solaris windows";
    private static final DocumentBuilderFactory BUILDER_FACTORY = DocumentBuilderFactory.newInstance();
    private static DocumentBuilder builder = null;
    private static boolean canReuseBuilders = false;
    private static final TransformerFactory transformerFactory = TransformerFactory.newInstance();
    private static Transformer transformer = null;
    private static boolean canReuseTransformer = false;

    private static DocumentBuilder getBuilder() throws ParserConfigurationException {
        if (canReuseBuilders) {
            builder.reset();
        } else {
            builder = BUILDER_FACTORY.newDocumentBuilder();
            canReuseBuilders = true;
        }
        return builder;
    }

    private static Transformer getTransformer() throws TransformerConfigurationException {
        if (canReuseTransformer) {
            transformer.reset();
        } else {
            transformer = transformerFactory.newTransformer();
            canReuseTransformer = true;
        }
        return transformer;
    }

    public static void installZip(ZipOut zipOut, String installDest, String servletRoot) throws ModuleInstallException, Exception {
        String propFilePath = "";
        String quotes = FwZipOps.isWindows() ? QUOTES : "";
        String zipPath = zipOut.getFileName();
        String custom = zipOut.isCustom() ? "true" : "false";
        File zipFile = new File(zipPath);
        if (zipFile.exists()) {
            try {
                String javaHome = System.getProperty("java.home");
                int inx = zipPath.lastIndexOf(46);
                String zipName = inx > 0 ? zipPath.substring(0, inx) : zipPath;
                inx = zipName.lastIndexOf(File.separator);
                String productName = inx > 0 ? zipName.substring(inx + 1) : zipName;
                ModuleInfo mInfo = new ModuleInfo();
                ModuleManager.getNPMInfo((String)(zipName + ".npm"), (ModuleInfo)mInfo);
                String productName1 = mInfo.getModuleID();
                inx = zipName.lastIndexOf(File.separator);
                zipName = inx > 0 ? zipName.substring(0, inx) : zipName;
                zipName = zipName + File.separator + productName;
                Properties prop = new Properties();
                prop.setProperty("$ZIP_FILE$", zipName);
                prop.setProperty("$USER_INSTALL_DIR$", installDest);
                prop.setProperty("$PRODUCT_NAME$", productName1);
                prop.setProperty("$SERVLET_ROOT$", servletRoot);
                prop.setProperty("$CUSTOM$", custom);
                prop.setProperty("INSTALLER_UI", "SILENT");
                prop.setProperty("InstallAnywhere.installer.interface", "silent");
                propFilePath = servletRoot + File.separator + "WEB-INF" + File.separator + "bin" + File.separator + "install.properties";
                FileOutputStream out = new FileOutputStream(propFilePath);
                prop.store(out, "");
                out.close();
                String command = quotes + javaHome + JAVA_EXECUTABLE + quotes + " -Djava.awt.headless=true -jar " + quotes + servletRoot + DEFAULT_INSTALLER_PATH + quotes + " -f " + quotes + propFilePath + quotes + " -i silent";
                System.out.println("installing " + productName + ".npm...");
                String launchReturn = FwZipOps.launchExec(command);
                if (!launchReturn.equals("")) {
                    String logPath = servletRoot + File.separator + "WEB-INF" + File.separator + "logs" + File.separator + "install" + File.separator + productName + "_InstallLog.log";
                    String msg = new File(logPath).exists() ? " please see " + logPath : launchReturn;
                    throw new ModuleInstallException(productName + " install failure: " + msg);
                }
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                File f = new File(propFilePath);
                if (f.exists()) {
                    f.delete();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean installModuleSync(String npmPath, Hashtable hash, String servletRoot) throws ModuleInstallException, Exception {
        boolean rVal = true;
        try {
            FwZipOps.saveRegistry();
            rVal = FwZipOps.installModule(npmPath, hash, servletRoot);
        }
        catch (Exception exception) {
        }
        finally {
            FwZipOps.restoreRegistry();
        }
        return rVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean protectBinaries(String productName, String servletRoot) {
        boolean bCheck = true;
        try {
            FwZipOps.saveNPMUninstallRegistry(productName, servletRoot);
            String xmlFile = null;
            xmlFile = servletRoot + "UninstallerData" + File.separator + "Uninstall_" + productName + File.separator + ".com.zerog.registry.xml";
            if (FwZipOps.ModifyRegistryFile(xmlFile, servletRoot)) {
                FwZipOps.removeUninstallRegistry(productName, servletRoot);
            } else {
                FwZipOps.restoreNPMUninstallRegistry(productName, servletRoot);
            }
        }
        catch (Exception exception) {
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        return bCheck;
    }

    private static synchronized boolean ModifyRegistryFile(String xmlFile, String servletRoot) {
        boolean sXml = true;
        try {
            Document doc = FwZipOps.getBuilder().parse(xmlFile);
            Node components = doc.getElementsByTagName("components").item(0);
            NodeList component = components.getChildNodes();
            NodeList resources = component.item(1).getChildNodes();
            for (int i = 0; i < resources.getLength(); ++i) {
                Node node = resources.item(i);
                if (node.getNodeType() != 1) continue;
                NamedNodeMap attr = node.getAttributes();
                for (Map.Entry<String, List<String>> binlistToProtect : FwZipOps.loadBinaryFile(servletRoot).entrySet()) {
                    for (String binary : binlistToProtect.getValue()) {
                        if (!attr.getNamedItem("name").getTextContent().trim().contains(binary.trim())) continue;
                        attr.getNamedItem("uninstall").setTextContent("false");
                    }
                }
            }
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(new File(xmlFile).getAbsolutePath());
            FwZipOps.getTransformer().transform(source, result);
        }
        catch (ParserConfigurationException pce) {
            System.out.println(pce);
            sXml = false;
        }
        catch (TransformerException tfe) {
            tfe.printStackTrace();
            System.out.println(tfe);
            sXml = false;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.out.println(ioe);
            sXml = false;
        }
        catch (SAXException sae) {
            sae.printStackTrace();
            System.out.println(sae);
            sXml = false;
        }
        return sXml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, List<String>> loadBinaryFile(String servletRoot) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        BufferedReader bufReader = null;
        try {
            bufReader = new BufferedReader(new FileReader(servletRoot + BINARIES_PATH));
            String platformCheck = null;
            String previousPlatform = null;
            String comLine = bufReader.readLine();
            while (comLine != null) {
                if (comLine.length() != 0 && comLine.charAt(0) != '#') {
                    if (comLine.regionMatches(true, 0, COMMAND_CTRLPLATFORM, 0, COMMAND_CTRLPLATFORM.length())) {
                        String subStr = comLine.substring(comLine.indexOf(":") + 1);
                        if (null != subStr) {
                            platformCheck = subStr.toLowerCase().trim();
                        }
                    } else if (platformCheck.equalsIgnoreCase(previousPlatform)) {
                        ((List)map.get(platformCheck)).add(comLine.trim());
                    } else {
                        previousPlatform = platformCheck;
                        map.put(platformCheck, new ArrayList());
                        ((List)map.get(platformCheck)).add(comLine.trim());
                    }
                }
                comLine = bufReader.readLine();
            }
        }
        catch (Exception e) {
            System.out.println(" Execption while laoding Binary Protected file");
        }
        finally {
            try {
                bufReader.close();
            }
            catch (IOException iOException) {}
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean installModule(String npmPath, Hashtable hash, String root) throws ModuleInstallException, Exception {
        ZipFile zipFile;
        boolean rVal = true;
        if (hash.isEmpty()) {
            throw new ModuleInstallException("no entries in prefix hash table");
        }
        Exception saveEx = null;
        String servletRoot = root;
        if (servletRoot.endsWith(File.separator)) {
            servletRoot = servletRoot.substring(0, servletRoot.length() - 1);
        }
        if (FwZipOps.shouldInstallModule((zipFile = new ZipFile(npmPath)).getName())) {
            String zipName = zipFile.getName();
            int inx = zipName.lastIndexOf(File.separator);
            String zipDest = inx > 0 ? zipName.substring(0, inx + 1) : zipName;
            Hashtable protectedJars = FwZipOps.getProtectedJars(servletRoot);
            ZipOut[] zo = FwZipOps.createZip(zipFile, hash, protectedJars, zipDest, servletRoot);
            String installDest = FwZipOps.getCommonDest(hash);
            for (int i = 0; i < zo.length; ++i) {
                try {
                    FwZipOps.installZip(zo[i], installDest, servletRoot);
                    continue;
                }
                catch (Exception e) {
                    saveEx = e;
                    continue;
                }
                finally {
                    zo[i].deleteFile();
                }
            }
            FwZipOps.deleteDirectory(new File(servletRoot + File.separator + "packages" + File.separator + "temp"));
            if (saveEx != null) {
                throw saveEx;
            }
        } else {
            rVal = false;
        }
        return rVal;
    }

    private static boolean shouldInstallModule(String npmFile) {
        boolean bOktoInstall = false;
        try {
            GetManifest manifest = new GetManifest(npmFile);
            VersionInfo iManVersionInfo = new VersionInfo(FwZipOps.getiManagerVersion());
            ModuleInfo mInfo = new ModuleInfo();
            ModuleManager.getNPMInfo((String)npmFile, (ModuleInfo)mInfo);
            String osName = System.getProperty("os.name").toLowerCase();
            String platform = FwUtils.getiManagerPlatform();
            bOktoInstall = FwUtils.doesModuleMeetCriteria((ModuleInfo)mInfo, (VersionInfo)iManVersionInfo, (String)osName, (String)platform);
        }
        catch (Exception e) {
            D.log((String)("Warning: The plug-in: " + npmFile + " manifest file cannot be read."));
            System.out.println("Warning: The plug-in: " + npmFile + " manifest file cannot be read.");
            bOktoInstall = false;
        }
        return bOktoInstall;
    }

    private static boolean filterModule(File npmFile) {
        try {
            VersionInfo reqVersionInfo;
            GetManifest manifest = new GetManifest(npmFile);
            VersionInfo iManVersionInfo = new VersionInfo(FwZipOps.getiManagerVersion());
            String reqVersion = manifest.getModuleRequiredVersion();
            if (!reqVersion.equals("") && iManVersionInfo.compareTo(reqVersionInfo = new VersionInfo(manifest.getModuleRequiredVersion())) != 0) {
                System.out.println("Warning: The plug-in: " + npmFile.getName() + "  will not install.");
                System.out.println("Warning: The Required-Version of this plug-in " + npmFile.getName() + " does not match this version of iManager.");
                return true;
            }
            String reqOS = manifest.getModuleSupportedOS();
            String reqMaxImanVersion = manifest.getModuleMaxImanagerVersion();
            VersionInfo reqMaxImanVersionInfo = new VersionInfo(reqMaxImanVersion);
            if (!reqMaxImanVersion.equals("") && iManVersionInfo.compareTo(reqMaxImanVersionInfo) > 0) {
                D.log((String)("Warning: The plug-in: " + npmFile.getName() + " will not install."));
                D.log((String)("Warning: The current version of iManager is greater than the maximum iManager version allowed by this plug-in " + npmFile.getName() + "."));
                System.out.println("Warning: The plug-in: " + npmFile.getName() + "  will not install.");
                System.out.println("Warning: The current version of iManager is greater than the maximum iManager version allowed by this plug-in " + npmFile.getName() + ".");
                return true;
            }
        }
        catch (Exception e) {
            D.log((String)("Warning: The plug-in: " + npmFile.getName() + " manifest file cannot be read."));
            System.out.println("Warning: The plug-in: " + npmFile.getName() + " manifest file cannot be read.");
            return true;
        }
        return false;
    }

    public static String getiManagerVersion() {
        String strImanVer;
        block3: {
            strImanVer = MIN_IMAN_VERSION;
            ResourceBundle rb = null;
            try {
                rb = ResourceBundle.getBundle("com.novell.emframe.version");
                if (rb != null) {
                    strImanVer = rb.getString("version");
                }
            }
            catch (Exception e) {
                if (!(e instanceof MissingResourceException)) break block3;
                strImanVer = MIN_IMAN_VERSION;
            }
        }
        return strImanVer;
    }

    private static boolean saveNPMUninstallRegistry(String npmName, String servletRoot) {
        boolean cRet = false;
        try {
            String regPath = FwZipOps.isWindows() ? servletRoot + "UninstallerData\\Uninstall_" + npmName + "\\.com.zerog.registry.xml" : servletRoot + "UninstallerData/Uninstall_" + npmName + "/.com.zerog.registry.xml";
            File iaRegistry = new File(regPath);
            if (iaRegistry.isFile() && iaRegistry.canWrite()) {
                cRet = FwZipOps.copyFile(iaRegistry, new File(regPath + ".save"));
            }
        }
        catch (Exception ex) {
            cRet = false;
        }
        return cRet;
    }

    private static boolean restoreNPMUninstallRegistry(String npmName, String servletRoot) {
        boolean bRet = false;
        try {
            String regPath = FwZipOps.isWindows() ? servletRoot + "UninstallerData\\Uninstall_" + npmName + "\\.com.zerog.registry.xml" : servletRoot + "UninstallerData/Uninstall_" + npmName + "/.com.zerog.registry.xml";
            String saveRegPath = regPath + ".save";
            File iaRegistry = new File(regPath);
            File saveRegistry = new File(saveRegPath);
            if (iaRegistry.isFile() && saveRegistry.isFile()) {
                iaRegistry.delete();
                saveRegistry.renameTo(iaRegistry);
                if (iaRegistry.isFile()) {
                    bRet = true;
                }
            }
        }
        catch (Exception ex) {
            bRet = false;
        }
        return bRet;
    }

    private static boolean removeUninstallRegistry(String npmName, String servletRoot) {
        boolean bRet = false;
        String regPath = FwZipOps.isWindows() ? servletRoot + "UninstallerData\\Uninstall_" + npmName + "\\.com.zerog.registry.xml.save" : servletRoot + "UninstallerData/Uninstall_" + npmName + "/.com.zerog.registry.xml.save";
        File iaRegistry = new File(regPath);
        if (iaRegistry.isFile()) {
            try {
                bRet = iaRegistry.delete();
            }
            catch (Exception ex) {
                bRet = false;
            }
        }
        return bRet;
    }

    private static boolean saveRegistry() {
        boolean bRet = false;
        try {
            String regPath;
            if (FwZipOps.isWindows()) {
                regPath = FwZipOps.launchExecReturnResult("cmd /c echo %ProgramFiles%") + "\\Zero G Registry\\.com.zerog.registry.xml";
            } else {
                regPath = "/var/.com.zerog.registry.xml";
                File varPathFile = new File(regPath);
                if (!varPathFile.exists()) {
                    regPath = System.getProperty("user.home") + "/.com.zerog.registry.xml";
                }
            }
            File iaRegistry = new File(regPath);
            if (iaRegistry.isFile() && iaRegistry.canWrite()) {
                bRet = FwZipOps.copyFile(iaRegistry, new File(regPath + ".save"));
            }
        }
        catch (Exception ex) {
            bRet = false;
        }
        return bRet;
    }

    private static boolean restoreRegistry() {
        boolean bRet = false;
        try {
            String regPath;
            if (FwZipOps.isWindows()) {
                regPath = FwZipOps.launchExecReturnResult("cmd /c echo %ProgramFiles%") + "\\Zero G Registry\\.com.zerog.registry.xml";
            } else {
                regPath = "/var/.com.zerog.registry.xml";
                File varPathFile = new File(regPath);
                if (!varPathFile.exists()) {
                    regPath = System.getProperty("user.home") + "/.com.zerog.registry.xml";
                }
            }
            String saveRegPath = regPath + ".save";
            File iaRegistry = new File(regPath);
            File saveRegistry = new File(saveRegPath);
            if (iaRegistry.isFile() && saveRegistry.isFile()) {
                iaRegistry.delete();
                saveRegistry.renameTo(iaRegistry);
                if (iaRegistry.isFile()) {
                    bRet = true;
                }
            }
        }
        catch (Exception ex) {
            bRet = false;
        }
        return bRet;
    }

    private static boolean removeRegistry() {
        String regPath;
        boolean bRet = false;
        if (FwZipOps.isWindows()) {
            regPath = FwZipOps.launchExecReturnResult("cmd /c echo %ProgramFiles%") + "\\Zero G Registry\\.com.zerog.registry.xml";
        } else {
            regPath = "/var/.com.zerog.registry.xml";
            File varPathFile = new File(regPath);
            if (!varPathFile.exists()) {
                regPath = System.getProperty("user.home") + "/.com.zerog.registry.xml";
            }
        }
        File iaRegistry = new File(regPath);
        if (iaRegistry.isFile()) {
            try {
                bRet = iaRegistry.delete();
            }
            catch (Exception ex) {
                bRet = false;
            }
        }
        return bRet;
    }

    public static ZipOut[] createZip(ZipFile zipFile, Hashtable hash, Hashtable protectedJars, String zipDest, String servletRoot) throws ModuleInstallException, Exception {
        boolean isWin = FwZipOps.isWindows();
        String modulePath = zipFile.getName();
        String tempPath = new File(modulePath).getParent() + File.separator + "temp";
        File tempDir = new File(tempPath);
        ZipOut[] zo = new ZipOut[]{new ZipOut(zipFile, FwZipOps.zipOutName(modulePath, "", zipDest)), new ZipOut(zipFile, FwZipOps.zipOutName(modulePath, "jar", zipDest))};
        String previousPrefix = " ";
        String commonDest = FwZipOps.getCommonDest(hash);
        String dest = "";
        try {
            zo[0].setLevel(0);
            Enumeration<? extends ZipEntry> zipEnum = zipFile.entries();
            while (zipEnum.hasMoreElements()) {
                String name;
                int j;
                ZipEntry zeIn = zipEnum.nextElement();
                String zipEntryName = zeIn.getName();
                String prefixFolder = FwZipOps.getPrefix(previousPrefix, hash, zipEntryName);
                if (prefixFolder.equals("")) continue;
                if (!previousPrefix.equals(prefixFolder)) {
                    previousPrefix = prefixFolder;
                    dest = ((String)hash.get(prefixFolder)).substring(commonDest.length()) + File.separator;
                }
                if (zipEntryName.indexOf(SHARED_LIB_DIR) >= 0) {
                    j = zipEntryName.lastIndexOf(47);
                    String string = name = j >= 0 ? zipEntryName.substring(j + 1) : zipEntryName;
                    if (protectedJars.get(name) == null) {
                        if (name.length() <= 0) continue;
                        zo[1].writeZipOut(zeIn, dest, prefixFolder);
                        continue;
                    }
                    File newFile = new File(tempDir, name);
                    File oldFile = new File(servletRoot + File.separator + SHARED_LIB_DIR, name);
                    String newVer = "";
                    String oldVer = "";
                    long installVer = 0L;
                    GetManifest oldManifest = null;
                    GetManifest newManifest = null;
                    if (!oldFile.exists()) {
                        installVer = 1L;
                    } else {
                        FwZipOps.extractFile(zipFile, zeIn, newFile);
                        try {
                            newManifest = new GetManifest(newFile);
                            newVer = newManifest.moduleVersion;
                        }
                        catch (Exception e) {
                            newVer = "";
                        }
                        try {
                            oldManifest = new GetManifest(oldFile);
                            oldVer = oldManifest.moduleVersion;
                        }
                        catch (Exception e) {
                            oldVer = "";
                        }
                        installVer = !newVer.equals("") && !oldVer.equals("") ? (long)FwZipOps.compareVersions(newVer, oldVer) : 1L;
                    }
                    if (installVer < 0L) {
                        System.out.println("Warning: will not install older version: " + name);
                        continue;
                    }
                    if (installVer == 0L) {
                        zo[1].writeZipOut(zeIn, dest, prefixFolder);
                        continue;
                    }
                    zo[1].writeZipOut(zeIn, dest, prefixFolder);
                    continue;
                }
                if (isWin && zipEntryName.indexOf(SHARED_BIN_DIR) >= 0) {
                    j = zipEntryName.lastIndexOf(47);
                    name = j >= 0 ? zipEntryName.substring(j + 1) : zipEntryName;
                    String winPath = servletRoot + SHARED_BIN_PATH + File.separator + "windows";
                    File saveFile = new File(winPath, name + ".save");
                    File oldFile = new File(winPath, name);
                    String newVer = "";
                    String oldVer = "";
                    long installVer = 1L;
                    if (name.length() <= 0) continue;
                    if (oldFile.exists()) {
                        if (saveFile.exists()) {
                            saveFile.delete();
                        }
                        oldFile.renameTo(saveFile);
                    }
                    if (installVer < 0L) {
                        System.out.println("Warning: will not install older version: " + name);
                        continue;
                    }
                    if (installVer == 0L) continue;
                    zo[1].writeZipOut(zeIn, dest, prefixFolder);
                    continue;
                }
                zo[0].writeZipOut(zeIn, dest, prefixFolder);
            }
            zo[0].checkNumEntries();
            zo[1].checkNumEntries();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            zipFile.close();
            zo[0].closeZipOut();
            zo[1].closeZipOut();
        }
        return zo;
    }

    private static String zipOutName(String modulePath, String suffix, String zipDest) {
        String zipFileName = modulePath.lastIndexOf(File.separator) > 0 ? modulePath.substring(modulePath.lastIndexOf(File.separator) + 1) : modulePath;
        int index = zipFileName.lastIndexOf(".npm");
        zipFileName = index != -1 ? zipDest + zipFileName.substring(0, index) + suffix + ".zip" : zipDest + zipFileName + suffix + ".zip";
        return zipFileName;
    }

    public static void uninstallModule(String sFilePath, String servletRoot) throws Exception {
        ZipFile zipFile = new ZipFile(sFilePath);
        FwZipOps.uninstallModule(zipFile, servletRoot);
        zipFile.close();
    }

    public static synchronized void uninstallModuleSync(String sFilePath, String servletRoot) throws ModuleInstallException, Exception {
        try {
            FwZipOps.saveRegistry();
            boolean bRet = FwZipOps.removeRegistry();
            if (!bRet) {
                System.out.println("FwZipOps: unable to remove the ZeroG registry file. Continuing with uninstall of plug-in");
            }
        }
        catch (Exception bRet) {
            // empty catch block
        }
        try {
            FwZipOps.uninstallModule(sFilePath, servletRoot);
            FwZipOps.restoreRegistry();
        }
        catch (ModuleInstallException me) {
            D.log((String)("Warning: Uninstall of the plug-in " + sFilePath + " - failed."));
            System.out.println("FwZipOps: Warning: Uninstall of the plug-in " + sFilePath + " - failed.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void uninstallModule(ZipFile zipFile, String servletRoot) throws Exception {
        String zipName = zipFile.getName();
        HashSet hash = FwZipOps.getZipRoots(zipFile);
        if (!hash.isEmpty()) {
            FwZipOps.uninstallZip(zipName, hash, servletRoot);
        }
    }

    private static String launchExec(String command) {
        String returnString = "";
        try {
            System.out.println("launchExec command: " + command);
            ShellCommand cmd = new ShellCommand(command);
            cmd.eatOutput();
            cmd.eatErrorOutput();
            cmd.stdin.close();
            cmd.waitFor();
            int retCode = cmd.exitValue();
            if (retCode != 0) {
                returnString = "Error installing NPM. Return code = " + retCode + returnString;
                System.out.println(returnString);
            }
        }
        catch (Exception t) {
            returnString = "launchExec failed: " + t.getMessage();
        }
        return returnString;
    }

    public static String launchExecReturnResult(String command) {
        String out = "";
        int retCode = -1;
        try {
            ShellCommand cmd = new ShellCommand(command);
            cmd.stdin.close();
            cmd.waitFor();
            retCode = cmd.exitValue();
            if (retCode != 0) {
                System.out.println("error=" + retCode);
                return out;
            }
            out = cmd.stdout.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(File source, File destination) {
        FileInputStream in = null;
        FileOutputStream out = null;
        long lastModified = source.lastModified();
        boolean bRet = true;
        try {
            int bytes_read;
            in = new FileInputStream(source);
            out = new FileOutputStream(destination);
            byte[] buffer = new byte[4096];
            while ((bytes_read = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytes_read);
            }
        }
        catch (Exception e) {
            bRet = false;
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            destination.setLastModified(lastModified);
        }
        return bRet;
    }

    public static HashSet getZipRoots(ZipFile zipFile) {
        String modulePath = zipFile.getName();
        HashSet<String> hash = new HashSet<String>();
        boolean custom = false;
        Enumeration<? extends ZipEntry> zipEnum = zipFile.entries();
        while (zipEnum.hasMoreElements()) {
            ZipEntry ze = zipEnum.nextElement();
            String zipEntryName = ze.getName();
            if (!custom && zipEntryName.indexOf(CUSTOM_CONTENT) >= 0) {
                hash.clear();
                break;
            }
            int inx = zipEntryName.indexOf(47);
            String prefix = inx > 0 ? zipEntryName.substring(0, inx) : zipEntryName;
            hash.add(prefix);
        }
        return hash;
    }

    public static void uninstallZip(String zipName, HashSet hash, String servletRoot) throws ModuleInstallException, Exception {
        File d;
        String uninstallHome;
        boolean errCode = false;
        String javaHome = System.getProperty("java.home");
        System.out.println("java.home is" + System.getProperty("java.home"));
        System.out.println("os.name is" + System.getProperty("os.name"));
        String quotes = FwZipOps.isWindows() ? QUOTES : "";
        String moduleName = zipName.lastIndexOf(File.separator) > 0 ? zipName.substring(zipName.lastIndexOf(File.separator) + 1) : zipName;
        moduleName = moduleName.lastIndexOf(46) > 0 ? moduleName.substring(0, moduleName.lastIndexOf(46)) : moduleName;
        ModuleInfo mInfo = new ModuleInfo();
        ModuleManager.getNPMInfo((String)zipName, (ModuleInfo)mInfo);
        moduleName = mInfo.getModuleID();
        if (hash.contains(CUSTOM_PREFIX)) {
            uninstallHome = "CustomUninstallerData";
            hash.remove(CUSTOM_PREFIX);
        } else {
            uninstallHome = "UninstallerData";
        }
        String uninstallRoot = servletRoot + File.separator + uninstallHome + File.separator;
        String uninstallDir = uninstallRoot + "Uninstall_" + moduleName;
        String workstationPath = eMFrameUtils.getRealPath((String)"/") + "WEB-INF" + File.separator + "workstation.txt";
        File workstationFile = new File(workstationPath);
        if (workstationFile.exists() && System.getProperty("os.name").toLowerCase().contains("windows")) {
            try {
                File inputFile = new File(uninstallDir + File.separator + ".com.zerog.registry.xml");
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                Document doc = dBuilder.parse(inputFile);
                doc.getDocumentElement().normalize();
                NodeList nList = doc.getElementsByTagName("resource");
                for (int temp = 0; temp < nList.getLength(); ++temp) {
                    Element eElement;
                    Node nNode = nList.item(temp);
                    if (nNode.getNodeType() != 1 || !(eElement = (Element)nNode).getAttribute("uninstall").toString().equalsIgnoreCase("true") || !eElement.getAttribute("keyfile").toString().equalsIgnoreCase("false") || eElement.getAttribute("location").toString().contains("UninstallerData")) continue;
                    File f = null;
                    try {
                        f = new File(eElement.getAttribute("location"));
                        if (!f.exists()) continue;
                        if (eElement.getAttribute("type").toString().equalsIgnoreCase("directory")) {
                            FwZipOps.deleteDirectory(f);
                            continue;
                        }
                        f.delete();
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((d = new File(uninstallDir)).isDirectory()) {
            String command = quotes + javaHome + JAVA_EXECUTABLE + quotes + " -Djava.awt.headless=true -jar " + quotes + uninstallDir + DEFAULT_UNINSTALLER + quotes + " -i silent";
            String launchReturn = FwZipOps.launchExec(command);
            if (!launchReturn.equals("")) {
                throw new ModuleInstallException(moduleName + " uninstall failure: " + launchReturn);
            }
            FwZipOps.deleteDirectory(d);
        }
    }

    private static void deleteDirectory(File d) {
        if (d.exists()) {
            String[] files = d.list();
            String path = d.getPath() + "/";
            for (int i = 0; i < files.length; ++i) {
                File f = new File(path + files[i]);
                if (f.isDirectory()) {
                    FwZipOps.deleteDirectory(f);
                    continue;
                }
                f.delete();
            }
            d.delete();
        }
    }

    private static String getPrefix(String previousPrefix, Hashtable hash, String zipEntryName) {
        if (zipEntryName.startsWith(previousPrefix)) {
            return previousPrefix;
        }
        Enumeration hashEnum = hash.keys();
        while (hashEnum.hasMoreElements()) {
            Object prefix = hashEnum.nextElement();
            if (!zipEntryName.startsWith((String)prefix)) continue;
            return (String)prefix;
        }
        return "";
    }

    private static String getCommonDest(Hashtable hash) throws ModuleInstallException {
        if (FwZipOps.isWindows()) {
            return FwZipOps.winGetCommonDest(hash);
        }
        Object[] values = hash.values().toArray();
        String commonDest = (String)values[0];
        block0: for (int i = 1; i < values.length; ++i) {
            String dest = (String)values[i];
            int len = Math.min(commonDest.length(), dest.length());
            for (int j = 0; j < len; ++j) {
                int k;
                if (commonDest.charAt(j) == dest.charAt(j)) continue;
                if (0 == j || (k = commonDest.substring(0, j).lastIndexOf(File.separator)) < 0) {
                    throw new ModuleInstallException(NO_COMMON_PATH);
                }
                commonDest = commonDest.substring(0, Math.min(j, k + 1));
                continue block0;
            }
        }
        return commonDest;
    }

    private static String winGetCommonDest(Hashtable hash) throws ModuleInstallException {
        Object[] values = hash.values().toArray();
        String commonDest = values[0].toString().toLowerCase();
        block0: for (int i = 1; i < values.length; ++i) {
            String dest = values[i].toString().toLowerCase();
            int len = Math.min(commonDest.length(), dest.length());
            for (int j = 0; j < len; ++j) {
                int k;
                if (commonDest.charAt(j) == dest.charAt(j)) continue;
                if (0 == j || (k = commonDest.substring(0, j).lastIndexOf(File.separator)) < 0) {
                    throw new ModuleInstallException(NO_COMMON_PATH);
                }
                commonDest = commonDest.substring(0, Math.min(j, k + 1));
                continue block0;
            }
        }
        return 0 == commonDest.length() ? commonDest : values[0].toString().substring(0, commonDest.length());
    }

    public static File extractFile(ZipFile zipFile, String sSrcFile, File fDestFile) throws IOException {
        return FwZipOps.extractFile(zipFile, zipFile.getEntry(sSrcFile), fDestFile);
    }

    public static File extractFile(ZipFile zipFile, ZipEntry ze, File fDestFile) throws IOException {
        File file = FwZipOps.writeFile(zipFile.getInputStream(ze), fDestFile);
        file.setLastModified(ze.getTime());
        return file;
    }

    private static File writeFile(InputStream inputStream, File fDestFile) throws IOException {
        File rFile = null;
        if (!fDestFile.getParentFile().exists()) {
            fDestFile.getParentFile().mkdirs();
        }
        FileOutputStream outputStream = new FileOutputStream(fDestFile);
        byte[] buf = new byte[4096];
        int i = inputStream.read(buf);
        while (i != -1) {
            outputStream.write(buf, 0, i);
            i = inputStream.read(buf);
        }
        outputStream.flush();
        outputStream.close();
        inputStream.close();
        rFile = fDestFile;
        return rFile;
    }

    public static void extract(ZipFile zipFile, File fDest) throws IOException {
        Enumeration<? extends ZipEntry> zipEnum = zipFile.entries();
        while (zipEnum.hasMoreElements()) {
            ZipEntry ze = zipEnum.nextElement();
            if (ze.isDirectory()) {
                new File(fDest, ze.getName()).mkdirs();
                continue;
            }
            FwZipOps.extractFile(zipFile, ze, new File(fDest, ze.getName()));
        }
    }

    private static boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Hashtable getProtectedJars(String servletRoot) {
        Hashtable<String, String> protectedJars = new Hashtable<String, String>(31);
        String listPath = servletRoot + SHARED_LIB_PATH;
        String libsPath = servletRoot + File.separator + SHARED_LIB_DIR;
        String warPath = new File(servletRoot).getParent() + File.separator + "nps.war";
        FilenameFilter filter = null;
        File listFile = new File(listPath);
        File libsFile = new File(libsPath);
        File warFile = new File(warPath);
        FileOutputStream fos = null;
        ZipFile jarFile = null;
        PrintStream ps = null;
        if (listFile.exists()) {
            listFile.delete();
        }
        if (!listFile.isFile()) {
            try {
                fos = new FileOutputStream(listPath);
                ps = new PrintStream(fos);
                filter = new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith(".jar") && !name.equals("nxsl.jar") && !name.equals("xp.jar");
                    }
                };
                String[] files = libsFile.list(filter);
                for (int i = 0; i < files.length; ++i) {
                    ps.println(files[i]);
                }
            }
            catch (Exception e) {
                System.out.println("Error creating: " + listPath);
                e.printStackTrace();
            }
            finally {
                try {
                    if (jarFile != null) {
                        jarFile.close();
                    }
                }
                catch (Exception e) {}
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (Exception e) {}
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (Exception e) {}
            }
        }
        BufferedReader input = null;
        try {
            String name;
            input = new BufferedReader(new FileReader(listPath));
            while ((name = input.readLine()) != null) {
                protectedJars.put(name, "");
            }
        }
        catch (IOException e) {
            System.out.println("Error reading: " + listPath);
            e.printStackTrace();
        }
        finally {
            try {
                input.close();
            }
            catch (Exception exception) {}
        }
        return protectedJars;
    }

    public static int compareVersions(String v1, String v2) {
        StringTokenizer t1 = new StringTokenizer(v1, ".-_/");
        StringTokenizer t2 = new StringTokenizer(v2, ".-_/");
        while (t1.hasMoreTokens() && t2.hasMoreTokens()) {
            int cmp = FwZipOps.compareTokens(t1.nextToken(), t2.nextToken());
            if (cmp == 0) continue;
            return cmp;
        }
        return v1.compareTo(v2);
    }

    private static int compareTokens(String t1, String t2) {
        try {
            int i1 = new Integer(t1);
            int i2 = new Integer(t2);
            return i1 - i2;
        }
        catch (NumberFormatException ex) {
            System.out.println("NumberFormatException: " + t1 + " or " + t2);
            return t1.compareTo(t2);
        }
    }

    private static class ZipOut
    extends ZipOutputStream {
        ZipFile zipFile;
        String zipFileName;
        int numEntries = 0;
        boolean custom = false;

        public ZipOut(ZipFile zipFile, String zipFileName) throws Exception {
            super(new FileOutputStream(zipFileName));
            this.zipFile = zipFile;
            this.zipFileName = zipFileName;
        }

        private String getFileName() {
            return this.zipFileName;
        }

        private void checkNumEntries() throws Exception {
            boolean inx = false;
            if (this.numEntries == 0) {
                this.putNextEntry(new ZipEntry("junk"));
                this.close();
                this.deleteFile();
                this.zipFileName = "";
            } else {
                this.close();
            }
        }

        private boolean isCustom() {
            return this.custom;
        }

        private void writeZipOut(ZipEntry zeIn, String dest, String prefixFolder) throws Exception {
            String zipEntryName = zeIn.getName();
            String name = zipEntryName.substring(prefixFolder.length());
            if (name.length() > 0) {
                ZipEntry zeOut = new ZipEntry(dest + name);
                zeOut.setTime(zeIn.getTime());
                this.putNextEntry(zeOut);
                if (!zeIn.isDirectory()) {
                    int bytesRead;
                    InputStream inputStream = this.zipFile.getInputStream(zeIn);
                    byte[] byteBuf = new byte[4096];
                    while (-1 != (bytesRead = inputStream.read(byteBuf))) {
                        this.write(byteBuf, 0, bytesRead);
                    }
                    inputStream.close();
                }
                this.closeEntry();
                ++this.numEntries;
                if (!this.custom && zipEntryName.indexOf(FwZipOps.CUSTOM_CONTENT) >= 0) {
                    this.custom = true;
                }
            }
        }

        private void deleteFile() {
            new File(this.zipFileName).delete();
        }

        private void closeZipOut() {
            try {
                this.closeEntry();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static class ModuleInstallException
    extends Exception {
        public ModuleInstallException() {
        }

        public ModuleInstallException(String message) {
            super(message);
        }
    }
}

