/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.serviceProviders;

import com.novell.nps.debug.Debug;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class LookupArray {
    int LOOKUP_SIZE;
    private BufferedReader in;
    public int lookupCount;
    public int value;
    public char[] lookupValues;
    int bufferSize;
    byte[] origData;
    String currentEncoding;
    int currentPosition;

    public LookupArray(InputStream theInput, String encoding) {
        this.lookupCount = this.LOOKUP_SIZE = 100;
        this.lookupValues = new char[this.LOOKUP_SIZE];
        this.bufferSize = 100;
        this.currentPosition = 0;
        byte[] lookup = new byte[1024];
        int result = 0;
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        try {
            result = theInput.read(lookup);
            while (result != -1) {
                bytesOut.write(lookup, 0, result);
                result = theInput.read(lookup);
            }
        }
        catch (Exception e) {
            Debug.log("Parser Error", e);
        }
        this.origData = bytesOut.toByteArray();
        try {
            this.in = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(this.origData), encoding));
            this.currentEncoding = encoding;
        }
        catch (Exception e) {
            this.in = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(this.origData)));
        }
    }

    public int getNextValue() throws IOException {
        if (this.lookupCount < this.bufferSize) {
            this.value = this.lookupValues[this.lookupCount];
            ++this.lookupCount;
        } else {
            this.value = this.in.read();
        }
        if (this.value == 0) {
            this.value = this.getNextValue();
        }
        ++this.currentPosition;
        return this.value;
    }

    public String getLookupString() {
        String testString = null;
        int oldSize = this.bufferSize;
        try {
            int size;
            int i;
            if (this.lookupCount < this.LOOKUP_SIZE && this.lookupCount < this.bufferSize) {
                int count = this.lookupCount;
                i = 0;
                while (count < this.bufferSize) {
                    this.lookupValues[i] = this.lookupValues[count];
                    ++count;
                    ++i;
                }
            } else {
                this.bufferSize = this.LOOKUP_SIZE;
                this.lookupCount = this.LOOKUP_SIZE;
            }
            if ((size = this.in.read(this.lookupValues, this.bufferSize - this.lookupCount, this.LOOKUP_SIZE - (this.bufferSize - this.lookupCount))) != -1) {
                this.bufferSize = size + this.bufferSize - this.lookupCount;
            } else {
                this.bufferSize -= this.lookupCount;
                for (i = this.bufferSize; i < this.LOOKUP_SIZE; ++i) {
                    this.lookupValues[i] = '\u0000';
                }
            }
            this.lookupCount = 0;
            testString = new String(this.lookupValues);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return testString;
    }

    public boolean resetEncoding(String encoding) {
        if (encoding != null && !encoding.equals(this.currentEncoding)) {
            try {
                this.in = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(this.origData), encoding));
                for (int i = 0; i < this.currentPosition; ++i) {
                    this.in.read();
                }
                this.lookupCount = this.LOOKUP_SIZE;
                this.currentEncoding = encoding;
                return true;
            }
            catch (Exception e) {
                Debug.log("Parser error", e);
            }
        }
        return false;
    }
}

