/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.serviceProviders;

import com.novell.nps.authentication.AuthenticationManager;
import com.novell.nps.authentication.LDAPCredentials;
import com.novell.nps.authentication.PortalConnection;
import com.novell.nps.authentication.PortalDirectoryException;
import com.novell.nps.configManager.ConfigManager;
import com.novell.nps.configManager.NPSVersion;
import com.novell.nps.debug.Debug;
import com.novell.nps.gadgetManager.GadgetManager;
import com.novell.nps.serviceProviders.NPSMacroLogoutMethod;
import com.novell.nps.sessionManager.PortalSession;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Hashtable;

public class NPSMacroParser {
    static NPSMacroLogoutMethod logout = null;
    static Hashtable publicUserHash = new Hashtable();

    public static String parseMacroString(String macroString, PortalSession session, boolean passwordAvailable) {
        String result = macroString;
        if (macroString != null) {
            int index = macroString.indexOf("%");
            while (index != -1) {
                String sMacroValue;
                String newValue;
                int endIndex = macroString.indexOf("%", index + 1);
                if (endIndex != -1 && (newValue = NPSMacroParser.getMacroValue(sMacroValue = macroString.substring(index + 1, endIndex), session, passwordAvailable)) != null) {
                    result = endIndex < macroString.length() ? macroString.substring(0, index) + newValue + macroString.substring(endIndex + 1) : macroString.substring(0, index) + newValue;
                }
                if (index + 1 < (macroString = result).length()) {
                    index = macroString.indexOf("%", index + 1);
                    continue;
                }
                index = -1;
            }
        }
        return result;
    }

    private static String getMacroValue(String macroValue, PortalSession session, boolean passwordAvailable) {
        String result = null;
        if (macroValue.length() == 0) {
            result = "%";
        } else if (macroValue.substring(0, 1).equals("*")) {
            result = NPSMacroParser.getPortalMacro(macroValue.substring(1), session, passwordAvailable);
        } else {
            String currentState = null;
            if (session != null) {
                currentState = (String)session.getAttribute("System.CurrentState");
            }
            Hashtable<String, String> macroCache = null;
            if (currentState != null && !currentState.equals("StateLoggedIn")) {
                macroCache = publicUserHash;
            } else if (session != null) {
                macroCache = (Hashtable)session.getAttribute("NPSMACROCACHE");
            }
            if (macroCache != null) {
                result = (String)macroCache.get(macroValue);
            }
            if (result == null) {
                int index = macroValue.indexOf(";");
                result = index != -1 ? NPSMacroParser.getMacroAttribute(macroValue.substring(0, index), macroValue.substring(index + 1), session) : NPSMacroParser.getMacroAttribute(null, macroValue.substring(index + 1), session);
                if (session != null) {
                    if (macroCache == null) {
                        macroCache = new Hashtable<String, String>();
                    }
                    if (result != null) {
                        macroCache.put(macroValue, result);
                    } else {
                        macroCache.put(macroValue, "%" + macroValue + "%");
                    }
                    session.setAttribute("NPSMACROCACHE", macroCache);
                }
            }
        }
        return result;
    }

    private static String getPortalMacro(String value, PortalSession session, boolean passwordAvailable) {
        String sValue;
        PortalConnection pc;
        if (session != null && (value.equals("portaluser") || value.equals("portalpass"))) {
            LDAPCredentials theUser = AuthenticationManager.getCurrentCredentials(session);
            if (theUser == null) {
                return null;
            }
            if (value.equals("portalpass") && passwordAvailable) {
                return theUser.getPassword();
            }
            if (value.equals("portaluser")) {
                return theUser.getUserName();
            }
        }
        if (value.equals("systemtime")) {
            return new Date().toString();
        }
        if ((value.equals("userdn") || value.equals("fullldapuserdn")) && (pc = AuthenticationManager.getConnection(session)) != null) {
            return pc.getUsername();
        }
        if (value.equals("fullndsuserdn") && (pc = AuthenticationManager.getConnection(session)) != null) {
            String fullLdapName = pc.getUsername();
            String fullNdsName = fullLdapName.replace(',', '.');
            return fullNdsName;
        }
        if (value.equals("ndsuserdn") || value.equals("ldapuserdn")) {
            String sUserDN;
            String sSeperator = ".";
            if (value.equals("ldapuserdn")) {
                sSeperator = ",";
            }
            if ((sUserDN = NPSMacroParser.getPortalMacro("userdn", session, false)) == null) {
                return value;
            }
            int equalPosition = sUserDN.indexOf("=");
            int commaPosition = sUserDN.indexOf(",");
            String sShortDN = sUserDN.substring(equalPosition + 1, commaPosition);
            while (true) {
                if ((commaPosition = sUserDN.indexOf(",", equalPosition = sUserDN.indexOf("=", commaPosition))) == -1) break;
                sShortDN = sShortDN + sSeperator + sUserDN.substring(equalPosition + 1, commaPosition);
            }
            sShortDN = sShortDN + sSeperator + sUserDN.substring(equalPosition + 1, sUserDN.length());
            return sShortDN;
        }
        if (value.equals("versionmajor")) {
            return String.valueOf(NPSVersion.getPortalVersion().getMajor());
        }
        if (value.equals("versionminor")) {
            return String.valueOf(NPSVersion.getPortalVersion().getMinor());
        }
        if (value.equals("versionrevision")) {
            return String.valueOf(NPSVersion.getPortalVersion().getRevision());
        }
        if (value.equals("versioninfo")) {
            return NPSVersion.getPortalVersion().getInformation();
        }
        if (value.equals("portalversion")) {
            return NPSVersion.getPortalVersion().toString();
        }
        if (value.equals("serverdns")) {
            return GadgetManager.getPortalHostname(session);
        }
        if (value.equals("serverdnsnoport") || value.equals("reqservername")) {
            return NPSMacroParser.getServerName(session);
        }
        if (value.equals("serverip")) {
            try {
                InetAddress inet = InetAddress.getLocalHost();
                String myIP = inet.getHostAddress();
                if (myIP != null && !myIP.equalsIgnoreCase("127.0.0.1")) {
                    return myIP;
                }
            }
            catch (UnknownHostException inet) {
                // empty catch block
            }
            try {
                return InetAddress.getByName(NPSMacroParser.getServerName(session)).getHostAddress();
            }
            catch (UnknownHostException e) {
                Debug.log("NPSMacroParser", e);
            }
        }
        if ((sValue = ConfigManager.getPortalSetting(value)) != null) {
            return sValue;
        }
        return null;
    }

    private static String getServerName(PortalSession session) {
        String sTemp = GadgetManager.getPortalHostname(session);
        if (sTemp != null && sTemp.indexOf(":") > 0) {
            sTemp = sTemp.substring(0, sTemp.indexOf(":"));
        }
        return sTemp;
    }

    private static String getMacroAttribute(String dn, String attribute, PortalSession session) {
        if (session == null) {
            return null;
        }
        String userDN = dn;
        if (userDN == null) {
            userDN = session.getUserDN();
        }
        String newValue = null;
        PortalConnection pc = AuthenticationManager.getConnection(session);
        try {
            newValue = pc.readStringAttribute(userDN, attribute);
        }
        catch (PortalDirectoryException e) {
            Debug.log("NPSMacroParser - failed to find attribute", e);
        }
        return newValue;
    }

    public static void resetPublicCache() {
        publicUserHash = new Hashtable();
    }

    static {
        logout = new NPSMacroLogoutMethod();
        AuthenticationManager.addAuthenticationListener(logout);
    }
}

