/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.serviceProviders;

import com.novell.nps.authentication.PortalConnection;
import com.novell.nps.authentication.PortalDirectoryException;
import com.novell.nps.debug.Debug;
import com.novell.nps.gadgetManager.GadgetInstall;
import com.novell.nps.utils.DOMUtil;
import com.novell.nps.utils.NPSClassLoader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class UnZipGadget {
    String currentPackage;
    Properties setupConfig;
    ZipFile zipFile;
    String m_webAppBase = "";
    Vector m_vPaths = new Vector();
    public static int STYLESHEETFILE = 1;
    public static int GADGETFILE = 2;
    public static int JARFILE = 3;
    public static final String PACKAGES_DIR = "packages";

    public UnZipGadget(String packagePath) throws IOException {
        this.currentPackage = packagePath;
        this.setupConfig = this.getGadgetSetupConfig();
    }

    public void addAdditionalPaths(String sPaths) {
        this.m_vPaths.add(sPaths);
    }

    public Enumeration getAdditionalPaths() {
        return this.m_vPaths.elements();
    }

    public void extractFile(ZipEntry ze, String filePath) {
        block8: {
            try {
                File newFile = null;
                try {
                    newFile = new File(filePath);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                if (filePath.lastIndexOf("/") == filePath.length() - 1) {
                    newFile.mkdirs();
                    break block8;
                }
                FileOutputStream out = null;
                try {
                    out = new FileOutputStream(newFile);
                }
                catch (Exception e) {
                    File dirFile = new File(newFile.getParent());
                    dirFile.mkdirs();
                    out = new FileOutputStream(newFile);
                }
                InputStream in = this.zipFile.getInputStream(ze);
                byte[] buf = new byte[10240];
                int i = in.read(buf);
                while (i != -1) {
                    out.write(buf, 0, i);
                    i = in.read(buf);
                }
                out.close();
                out.flush();
            }
            catch (Exception e) {
                Debug.log("UnZipGadget", 1, e);
            }
        }
    }

    public void extractGadget(ZipEntry ze, String gadgetPath) {
        String newGadgetPath = ze.getName();
        newGadgetPath = gadgetPath + "/" + newGadgetPath.substring(4);
        newGadgetPath = newGadgetPath.replace('\\', '/');
        this.extractFile(ze, newGadgetPath);
    }

    public void extractJar(ZipEntry ze, String jarPath) {
        String newJarPath = ze.getName();
        newJarPath = jarPath + newJarPath.substring(7);
        newJarPath = newJarPath.replace('\\', '/');
        this.extractFile(ze, newJarPath);
    }

    public void extractStylesheet(ZipEntry ze, String stylesheetPath) throws Exception {
        String newPath = ze.getName();
        newPath = newPath.indexOf("bin/resources") != -1 ? (newPath.charAt(0) == '/' ? stylesheetPath + "/" + this.getGadgetCode() + newPath.substring(14) : stylesheetPath + "/" + this.getGadgetCode() + newPath.substring(13)) : stylesheetPath + "/" + this.getGadgetCode() + "/" + newPath;
        newPath = newPath.replace('\\', '/');
        this.extractFile(ze, newPath);
    }

    public void extractEntry(ZipEntry ze, String gadgetPath, String stylesheetPath, String jarPath) throws Exception {
        String name = ze.getName();
        if (name.substring(0, 4).equals("src/")) {
            this.extractGadget(ze, gadgetPath);
        } else if (name.indexOf("bin/lib/") != -1) {
            this.extractJar(ze, jarPath);
        } else {
            this.extractStylesheet(ze, stylesheetPath);
        }
    }

    public void unZip(String gadgetRootPath, String stylesheetRootPath, String jarRootPath, int overWrite) throws Exception {
        this.zipFile = null;
        try {
            File fZip = new File(this.currentPackage);
            if (fZip.canRead()) {
                this.zipFile = new ZipFile(fZip);
                Enumeration<? extends ZipEntry> zipEnum = this.zipFile.entries();
                while (zipEnum.hasMoreElements()) {
                    ZipEntry ze = zipEnum.nextElement();
                    this.extractEntry(ze, gadgetRootPath, stylesheetRootPath, jarRootPath);
                }
            }
        }
        catch (IOException io) {
            Debug.log("UnZipGadget", 1, io);
        }
        if (this.zipFile != null) {
            try {
                this.zipFile.close();
            }
            catch (IOException io) {
                Debug.log("UnZipGadget", 1, io);
            }
        }
    }

    public String getGadgetCode() {
        return this.setupConfig.getProperty("GADGETCODE");
    }

    public String getGadgetName() {
        return this.setupConfig.getProperty("GADGETNAME");
    }

    public Vector getGadgetCategories() {
        Vector<String> vList = new Vector<String>();
        String sTemp = this.setupConfig.getProperty("GADGETCATEGORIES");
        if (sTemp != null) {
            StringTokenizer st = new StringTokenizer(sTemp, ",;");
            while (st != null && st.hasMoreElements()) {
                vList.add(st.nextToken());
            }
        }
        return vList;
    }

    public String getGadgetVersion() {
        return this.setupConfig.getProperty("GADGETVERSION");
    }

    public String getGadgetInstallClass() {
        return this.setupConfig.getProperty("GADGETINSTALLCLASS");
    }

    public boolean getGadgetIsUsingInit() {
        boolean isUsingInit = false;
        String sTemp = this.setupConfig.getProperty("GADGETUSINGINIT");
        if (sTemp != null && sTemp.equalsIgnoreCase("true")) {
            isUsingInit = true;
        }
        return isUsingInit;
    }

    public InputStream getAvailableSettingsStream() {
        this.zipFile = null;
        try {
            File fZip = new File(this.currentPackage);
            if (fZip.canRead()) {
                this.zipFile = new ZipFile(fZip);
                ZipEntry ze = this.zipFile.getEntry("AvailableSettings.xml");
                return this.zipFile.getInputStream(ze);
            }
        }
        catch (Exception fZip) {
            // empty catch block
        }
        if (this.zipFile != null) {
            try {
                this.zipFile.close();
            }
            catch (IOException io) {
                Debug.log("UnZipGadget", 1, io);
            }
        }
        return null;
    }

    public String getSupportsFullFrame() {
        return this.setupConfig.getProperty("SUPPORTSFULLFRAME");
    }

    public String getSupportsTableData() {
        return this.setupConfig.getProperty("SUPPORTSTABLEDATA");
    }

    public String getAssignableGadget() {
        return this.setupConfig.getProperty("ASSIGNABLEGADGET");
    }

    public InputStream getSettingsStream() {
        this.zipFile = null;
        try {
            File fZip = new File(this.currentPackage);
            if (fZip.canRead()) {
                this.zipFile = new ZipFile(fZip);
                ZipEntry ze = this.zipFile.getEntry("/bin/resources/GadgetSettings.xml");
                if (ze == null) {
                    ze = this.zipFile.getEntry("bin/resources/GadgetSettings.xml");
                }
                return this.zipFile.getInputStream(ze);
            }
        }
        catch (Exception fZip) {
            // empty catch block
        }
        if (this.zipFile != null) {
            try {
                this.zipFile.close();
            }
            catch (IOException io) {
                Debug.log("UnZipGadget", 1, io);
            }
        }
        return null;
    }

    public Properties getGadgetSetupConfig() throws IOException {
        Document m_dom = null;
        this.zipFile = null;
        if (this.currentPackage == null) {
            throw new IOException("Package is null.");
        }
        File fTemp = new File(this.currentPackage);
        if (fTemp == null || !fTemp.exists()) {
            throw new IOException("Package does not exist.");
        }
        File fZip = new File(this.currentPackage);
        if (fZip.canRead()) {
            this.zipFile = new ZipFile(fZip);
            ZipEntry ze = this.zipFile.getEntry("GadgetSetup.xml");
            try {
                m_dom = DOMUtil.XMLToDOM(this.zipFile.getInputStream(ze), "UTF8");
                this.zipFile.close();
            }
            catch (IOException io) {
                Debug.log("UnZipGadget", 1, io);
            }
            catch (Exception ex) {
                Debug.log("UnZipGadget", 1, ex);
            }
        }
        return this.domToProperties(m_dom);
    }

    public Properties domToProperties(Document myDom) {
        Document node = myDom;
        Properties setup = new Properties();
        for (Node currentNode = node.getFirstChild().getFirstChild(); currentNode != null; currentNode = currentNode.getNextSibling()) {
            Node firstChild = currentNode.getFirstChild();
            if (firstChild == null) continue;
            setup.setProperty(currentNode.getNodeName(), firstChild.getNodeValue());
        }
        return setup;
    }

    public boolean installGadget(PortalConnection connection, String webAppBase, String contextPath, String gadgetDN, String PCO2) throws PortalDirectoryException, Exception {
        return this.installGadget(connection, webAppBase, contextPath, gadgetDN, PCO2, true, true);
    }

    public boolean installGadget(PortalConnection connection, String webAppBase, String contextPath, String gadgetDN, String PCO2, boolean isAdmin) throws PortalDirectoryException, Exception {
        return this.installGadget(connection, webAppBase, contextPath, gadgetDN, PCO2, true, true);
    }

    public boolean installGadget(PortalConnection connection, String webAppBase, String contextPath, String gadgetDN, String PCO2, boolean isAdmin, boolean bWriteLocation) throws PortalDirectoryException, Exception {
        return this.installGadget(webAppBase, contextPath);
    }

    public boolean installGadget(String webAppBase, String contextPath) throws PortalDirectoryException, Exception {
        String installClass;
        Object gadConfig = null;
        if (!webAppBase.endsWith("\\") && !webAppBase.endsWith("/")) {
            webAppBase = webAppBase + "/";
        }
        this.m_webAppBase = webAppBase;
        if (null != this.currentPackage) {
            this.unZip(webAppBase + "WEB-INF/classes", webAppBase + "portal/gadgets", webAppBase + "WEB-INF/lib", 1);
        }
        if (null != (installClass = this.getGadgetInstallClass())) {
            GadgetInstall gi = null;
            try {
                Class<?> newClass = null;
                if (0 == this.m_vPaths.size()) {
                    newClass = Class.forName(installClass);
                } else {
                    NPSClassLoader loader = new NPSClassLoader(this.m_vPaths, this.getClass().getClassLoader());
                    newClass = loader.loadClass(installClass);
                }
                gi = (GadgetInstall)newClass.newInstance();
                gi.installGadget(null, webAppBase, contextPath, null, null, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }
}

