/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.serviceProviders.web;

import com.novell.nps.configManager.ConfigManager;
import com.novell.nps.debug.Debug;
import java.net.InetAddress;
import java.util.StringTokenizer;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import javax.security.cert.X509Certificate;

public class PortalHostnameVerifier
implements HostnameVerifier {
    private static String DT = "PortalHostNameVerifier";

    @Override
    public boolean verify(String urlHostName, SSLSession sslSession) {
        try {
            X509Certificate[] certs = sslSession.getPeerCertificateChain();
            String sIssuedName = certs[0].getSubjectDN().getName();
            return this.verify(urlHostName, sIssuedName);
        }
        catch (Exception e) {
            Debug.log(DT, e);
            return false;
        }
    }

    public boolean verify(String urlHostname, String certHostname) {
        if (ConfigManager.getPortalSetting("System.OverrideHostNameVerifier", "false").equalsIgnoreCase("true")) {
            return true;
        }
        int iCN = certHostname.indexOf("CN=");
        if (iCN > -1) {
            int iEnd = certHostname.indexOf(",", iCN);
            if (iEnd == -1) {
                iEnd = certHostname.length();
            }
            certHostname = certHostname.substring(iCN + 3, iEnd);
        }
        if (certHostname.equalsIgnoreCase(urlHostname)) {
            return true;
        }
        try {
            byte[] bAddr = new byte[4];
            StringTokenizer st = new StringTokenizer(urlHostname, ".");
            int i = 0;
            while (st.hasMoreElements()) {
                String s = (String)st.nextElement();
                bAddr[i++] = (byte)Integer.parseInt(s);
            }
            InetAddress requestedAddress = InetAddress.getByAddress(bAddr);
            InetAddress[] aInetAddrCert = InetAddress.getAllByName(certHostname);
            for (int j = 0; j < aInetAddrCert.length; ++j) {
                InetAddress certAddr = aInetAddrCert[j];
                if (!requestedAddress.equals(certAddr)) continue;
                return true;
            }
        }
        catch (Exception e) {
            Debug.log(DT, e);
        }
        return false;
    }
}

